"""Stub file for the '_codecs' module."""

import sys
from typing import Any, Callable, Tuple, Optional, Dict, Text, Union

import codecs

# For convenience:
_Handler = Callable[[Exception], Tuple[Text, int]]
_String = Union[bytes, str]
_Errors = Union[str, Text, None]
if sys.version_info < (3, 0):
    _Decodable = Union[bytes, Text]
    _Encodable = Union[bytes, Text]
else:
    _Decodable = bytes
    _Encodable = str

# This type is not exposed; it is defined in unicodeobject.c
class _EncodingMap(object):
    def size(self) -> int: ...
_MapT = Union[Dict[int, int], _EncodingMap]

def register(search_function: Callable[[str], Any]) -> None: ...
def register_error(errors: Union[str, Text], handler: _Handler) -> None: ...
def lookup(encoding: Union[str, Text]) -> codecs.CodecInfo: ...
def lookup_error(name: Union[str, Text]) -> _Handler: ...
def decode(obj: Any, encoding: Union[str, Text] = ..., errors: _Errors = ...) -> Any: ...
def encode(obj: Any, encoding: Union[str, Text] = ..., errors: _Errors = ...) -> Any: ...
def charmap_build(map: Text) -> _MapT: ...

def ascii_decode(data: _Decodable, errors: _Errors = ...) -> Tuple[Text, int]: ...
def ascii_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def charbuffer_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def charmap_decode(data: _Decodable, errors: _Errors = ..., mapping: Optional[_MapT] = ...) -> Tuple[Text, int]: ...
def charmap_encode(data: _Encodable, errors: _Errors, mapping: Optional[_MapT] = ...) -> Tuple[bytes, int]: ...
def escape_decode(data: _String, errors: _Errors = ...) -> Tuple[str, int]: ...
def escape_encode(data: bytes, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def latin_1_decode(data: _Decodable, errors: _Errors = ...) -> Tuple[Text, int]: ...
def latin_1_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def raw_unicode_escape_decode(data: _String, errors: _Errors = ...) -> Tuple[Text, int]: ...
def raw_unicode_escape_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def readbuffer_encode(data: _String, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def unicode_escape_decode(data: _String, errors: _Errors = ...) -> Tuple[Text, int]: ...
def unicode_escape_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
if sys.version_info < (3, 8):
    def unicode_internal_decode(data: _String, errors: _Errors = ...) -> Tuple[Text, int]: ...
    def unicode_internal_encode(data: _String, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def utf_16_be_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_16_be_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def utf_16_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_16_encode(data: _Encodable, errors: _Errors = ..., byteorder: int = ...) -> Tuple[bytes, int]: ...
def utf_16_ex_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int, int]: ...
def utf_16_le_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_16_le_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def utf_32_be_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_32_be_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def utf_32_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_32_encode(data: _Encodable, errors: _Errors = ..., byteorder: int = ...) -> Tuple[bytes, int]: ...
def utf_32_ex_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int, int]: ...
def utf_32_le_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_32_le_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def utf_7_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_7_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
def utf_8_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
def utf_8_encode(data: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...

if sys.platform == 'win32':
    def mbcs_decode(data: _Decodable, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
    def mbcs_encode(str: _Encodable, errors: _Errors = ...) -> Tuple[bytes, int]: ...
    if sys.version_info >= (3, 0):
        def oem_decode(data: bytes, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
        def code_page_decode(codepage: int, data: bytes, errors: _Errors = ..., final: int = ...) -> Tuple[Text, int]: ...
        def oem_encode(str: Text, errors: _Errors = ...) -> Tuple[bytes, int]: ...
        def code_page_encode(code_page: int, str: Text, errors: _Errors = ...) -> Tuple[bytes, int]: ...
