/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.QFAUserSettings;
import ca.sqlpower.util.ExceptionReport;
import java.util.Collection;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(ExceptionHandler.class);
    public static final String DEFAULT_REPORT_URL = "http://bugs.sqlpower.ca/architect/postReport";
    protected final ArchitectSwingSessionContext context;

    public ExceptionHandler(ArchitectSwingSessionContext context) {
        this.context = context;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            logger.error((Object)"Uncaught exception", e);
            this.handleAndReport(e);
        }
        catch (Throwable doubleTrouble) {
            doubleTrouble.printStackTrace();
        }
    }

    private void handleAndReport(Throwable e) {
        ASUtils.showExceptionDialogNoReport("An unexpected exception has occured: ", e);
        QFAUserSettings settings = this.context.getUserSettings().getQfaUserSettings();
        if (!settings.getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true)) {
            return;
        }
        ExceptionReport report = new ExceptionReport(e, DEFAULT_REPORT_URL, ArchitectVersion.APP_FULL_VERSION.toString(), "Architect");
        StringBuffer remarks = new StringBuffer();
        Collection<ArchitectSession> sessions = this.context.getSessions();
        for (ArchitectSession s : sessions) {
            ArchitectSwingSession session = (ArchitectSwingSession)s;
            if (session != null) {
                PlayPen pp = session.getPlayPen();
                if (pp != null) {
                    report.addAdditionalInfo("Number of objects in the play pen", "" + pp.getPPComponentCount());
                } else {
                    remarks.append("[playpen was null]");
                }
                DBTree dbt = session.getDBTree();
                if (dbt != null) {
                    TreeModel dbtm = dbt.getModel();
                    if (dbtm != null) {
                        report.addAdditionalInfo("Number of source connections", "" + dbtm.getChildCount(dbtm.getRoot()));
                        continue;
                    }
                    remarks.append("[dbtree's model was null]");
                    continue;
                }
                remarks.append("[dbtree was null]");
                continue;
            }
            remarks.append("[architect session instance was null]");
        }
        report.setRemarks(remarks.toString());
        report.send();
    }
}

