/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.collection.PdfCollectionItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PdfFileSpecification
extends PdfDictionary {
    protected PdfWriter writer;
    protected PdfIndirectReference ref;

    public PdfFileSpecification() {
        super(PdfName.FILESPEC);
    }

    public static PdfFileSpecification url(PdfWriter pdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = pdfWriter;
        pdfFileSpecification.put(PdfName.FS, PdfName.URL);
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray) throws IOException {
        return PdfFileSpecification.fileEmbedded(pdfWriter, string, string2, byArray, true);
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray, boolean bl) throws IOException {
        return PdfFileSpecification.fileEmbedded(pdfWriter, string, string2, byArray, bl, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray, boolean bl, String string3, PdfDictionary pdfDictionary) throws IOException {
        PdfIndirectReference pdfIndirectReference;
        Object object;
        PdfFileSpecification pdfFileSpecification;
        block16: {
            pdfFileSpecification = new PdfFileSpecification();
            pdfFileSpecification.writer = pdfWriter;
            pdfFileSpecification.put(PdfName.F, new PdfString(string2));
            pdfFileSpecification.setUnicodeFileName(string2, false);
            InputStream inputStream = null;
            try {
                PdfStream pdfStream;
                PdfIndirectReference pdfIndirectReference2 = pdfWriter.getPdfIndirectReference();
                if (byArray == null) {
                    object = new File(string);
                    if (((File)object).canRead()) {
                        inputStream = new FileInputStream(string);
                    } else if (string.startsWith("file:/") || string.startsWith("http://") || string.startsWith("https://") || string.startsWith("jar:")) {
                        inputStream = new URL(string).openStream();
                    } else {
                        inputStream = BaseFont.getResourceStream(string);
                        if (inputStream == null) {
                            throw new IOException(string + " not found as file or resource.");
                        }
                    }
                    pdfStream = new PdfStream(inputStream, pdfWriter);
                } else {
                    pdfStream = new PdfStream(byArray);
                }
                pdfStream.put(PdfName.TYPE, PdfName.EMBEDDEDFILE);
                if (bl) {
                    pdfStream.flateCompress();
                }
                pdfStream.put(PdfName.PARAMS, pdfIndirectReference2);
                if (string3 != null) {
                    pdfStream.put(PdfName.SUBTYPE, new PdfName(string3));
                }
                pdfIndirectReference = pdfWriter.addToBody(pdfStream).getIndirectReference();
                if (byArray == null) {
                    pdfStream.writeLength();
                }
                object = new PdfDictionary();
                if (pdfDictionary != null) {
                    ((PdfDictionary)object).merge(pdfDictionary);
                }
                ((PdfDictionary)object).put(PdfName.SIZE, new PdfNumber(pdfStream.getRawLength()));
                pdfWriter.addToBody((PdfObject)object, pdfIndirectReference2);
                Object var14_13 = null;
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            inputStream.close();
        }
        object = new PdfDictionary();
        ((PdfDictionary)object).put(PdfName.F, pdfIndirectReference);
        ((PdfDictionary)object).put(PdfName.UF, pdfIndirectReference);
        pdfFileSpecification.put(PdfName.EF, (PdfObject)object);
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileExtern(PdfWriter pdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        pdfFileSpecification.writer = pdfWriter;
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        pdfFileSpecification.setUnicodeFileName(string, false);
        return pdfFileSpecification;
    }

    public PdfIndirectReference getReference() throws IOException {
        if (this.ref != null) {
            return this.ref;
        }
        this.ref = this.writer.addToBody(this).getIndirectReference();
        return this.ref;
    }

    public void setMultiByteFileName(byte[] byArray) {
        this.put(PdfName.F, new PdfString(byArray).setHexWriting(true));
    }

    public void setUnicodeFileName(String string, boolean bl) {
        this.put(PdfName.UF, new PdfString(string, bl ? "UnicodeBig" : "PDF"));
    }

    public void setVolatile(boolean bl) {
        this.put(PdfName.V, new PdfBoolean(bl));
    }

    public void addDescription(String string, boolean bl) {
        this.put(PdfName.DESC, new PdfString(string, bl ? "UnicodeBig" : "PDF"));
    }

    public void addCollectionItem(PdfCollectionItem pdfCollectionItem) {
        this.put(PdfName.CI, pdfCollectionItem);
    }
}

