/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.writetolog;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.writetolog.Messages;
import org.pentaho.di.trans.steps.writetolog.WriteToLog;
import org.pentaho.di.trans.steps.writetolog.WriteToLogData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteToLogMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fieldName;
    public static String[] logLevelCodes = new String[]{"log_level_nothing", "log_level_error", "log_level_minimal", "log_level_basic", "log_level_detailed", "log_level_debug", "log_level_rowlevel"};
    private boolean displayHeader;
    private String loglevel;

    public void setLogLevel(int i) {
        this.loglevel = logLevelCodes[i];
    }

    public int getLogLevelByDesc() {
        if (this.loglevel == null) {
            return 3;
        }
        int retval = this.loglevel.equals(logLevelCodes[0]) ? 0 : (this.loglevel.equals(logLevelCodes[1]) ? 1 : (this.loglevel.equals(logLevelCodes[2]) ? 2 : (this.loglevel.equals(logLevelCodes[3]) ? 3 : (this.loglevel.equals(logLevelCodes[4]) ? 4 : (this.loglevel.equals(logLevelCodes[5]) ? 5 : 6)))));
        return retval;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        WriteToLogMeta retval = (WriteToLogMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isdisplayHeader() {
        return this.displayHeader;
    }

    public void setdisplayHeader(boolean displayheader) {
        this.displayHeader = displayheader;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.loglevel = XMLHandler.getTagValue((Node)stepnode, (String)"loglevel");
            this.displayHeader = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"displayHeader"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      " + XMLHandler.addTagValue((String)"loglevel", (String)this.loglevel));
        retval.append("      " + XMLHandler.addTagValue((String)"displayHeader", (boolean)this.displayHeader));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        this.loglevel = logLevelCodes[3];
        this.displayHeader = true;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.loglevel = rep.getStepAttributeString(id_step, "loglevel");
            this.displayHeader = rep.getStepAttributeBoolean(id_step, "displayHeader");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "loglevel", this.loglevel);
            rep.saveStepAttribute(id_transformation, id_step, "displayHeader", this.displayHeader);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("WriteToLogMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("WriteToLogMeta.CheckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("WriteToLogMeta.CheckResult.FieldsFound", error_message);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, Messages.getString("WriteToLogMeta.CheckResult.AllFieldsFound"), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(3, Messages.getString("WriteToLogMeta.CheckResult.NoFieldsEntered"), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("WriteToLogMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("WriteToLogMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new WriteToLog(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new WriteToLogData();
    }
}

