/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.table.TableModelWrapper;
import ca.sqlpower.swingui.table.TableUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableModelColumnAutofit
extends AbstractTableModel
implements TableModelWrapper {
    private TableModel tableModel;
    private MouseListener mouseListener;
    private JTable table;
    private JTableHeader tableHeader;

    public TableModelColumnAutofit(TableModel tableModel, JTable table) {
        this.tableModel = tableModel;
        this.table = table;
        this.tableHeader = table.getTableHeader();
        this.mouseListener = new MouseListener();
        this.tableHeader.addMouseListener(this.mouseListener);
    }

    @Override
    public int getRowCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getRowCount();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getColumnName(column);
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.tableHeader.removeMouseListener(this.mouseListener);
        this.tableHeader = tableHeader;
        this.tableHeader.addMouseListener(this.mouseListener);
    }

    public void initColumnSizes() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.initSingleColumnSize(i);
        }
    }

    public void initSingleColumnSize(int colIndex) {
        TableUtils.fitColumnWidth(this.table, colIndex, 0);
    }

    @Override
    public TableModel getWrappedModel() {
        return this.tableModel;
    }

    @Override
    public void setWrappedModel(TableModel model) {
        throw new UnsupportedOperationException("Up until now, there was no use for this. Please implement carefully!");
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (e.isControlDown()) {
                TableModelColumnAutofit.this.initSingleColumnSize(viewColumn);
            }
        }
    }
}

