/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.PositionedCursor;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ServerFetchBuffer;

final class KeysetServerCursor
extends PositionedCursor {
    private int rowCount;
    private ServerFetchBuffer fetchBuffer;
    private SQLServerStatement stmt;

    KeysetServerCursor(SQLServerResultSet sQLServerResultSet) {
        super(new ServerFetchBuffer(sQLServerResultSet));
        this.fetchBuffer = (ServerFetchBuffer)((PositionedCursor)this).fetchBuffer;
        this.rowCount = sQLServerResultSet.stmt.getServerCursorRowCount();
        this.stmt = sQLServerResultSet.stmt;
    }

    final int getRowCount() throws SQLServerException {
        return this.rowCount;
    }

    final boolean isResultSetEmpty() throws SQLServerException {
        return 0 == this.getRowCount();
    }

    final void refreshRow() throws SQLServerException {
        this.fetchBuffer.refresh();
    }

    final boolean rowDeleted() throws SQLServerException {
        return this.fetchBuffer.rowDeleted();
    }

    final void insertRow() throws SQLServerException {
        this.fetchBuffer.insertRow();
        ++this.rowCount;
    }

    final void updateRow() throws SQLServerException {
        this.fetchBuffer.updateRow();
    }

    final void deleteRow() throws SQLServerException {
        this.fetchBuffer.deleteRow();
    }
}

