/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classviewer.plaf.basic;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicTOCCellRenderer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import sunw.demo.classviewer.ClassViewerNavigator;

public class BasicClassViewerNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
ParserListener,
PropertyChangeListener {
    protected ClassViewerNavigator treenav;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected JTree classtree;
    protected JScrollPane sp;
    protected boolean startedtoc;
    protected boolean startedfields;
    protected boolean startedmethods;
    protected boolean startedconstructors;
    protected boolean startedclass;
    protected Stack nodeStack;
    protected Stack itemStack;
    protected Stack tagStack;
    private Locale defaultLocale;
    private Locale lastLocale;
    private HelpSet currentParseHS;
    private static final boolean debug = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicClassViewerNavigatorUI((ClassViewerNavigator)((Object)jComponent));
    }

    public BasicClassViewerNavigatorUI(ClassViewerNavigator classViewerNavigator) {
        this.setIcon(UIManager.getIcon("TOCNav.icon"));
    }

    public void installUI(JComponent jComponent) {
        BasicClassViewerNavigatorUI.debug("BasicClassViewerNavigatorUI.installUI(" + jComponent + ")-begin");
        this.treenav = (ClassViewerNavigator)((Object)jComponent);
        HelpModel helpModel = this.treenav.getModel();
        this.treenav.setLayout(new GridLayout(2, 1));
        this.treenav.addPropertyChangeListener(this);
        if (helpModel != null) {
            helpModel.addHelpModelListener((HelpModelListener)this);
        }
        this.topNode = new DefaultMutableTreeNode();
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.treenav.add(this.sp);
        this.classtree = new JTree();
        this.classtree.setModel(null);
        TreeSelectionModel treeSelectionModel2 = this.classtree.getSelectionModel();
        treeSelectionModel2.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.classtree);
        this.treenav.add(jScrollPane);
        this.classtree.setShowsRootHandles(true);
        this.classtree.setRootVisible(false);
        this.reloadData();
        BasicClassViewerNavigatorUI.debug("BasicClassViewerNavigatorUI.installUI(" + jComponent + ")-end");
    }

    public void uninstallUI(JComponent jComponent) {
        HelpModel helpModel = this.treenav.getModel();
        this.treenav.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.treenav.setLayout(null);
        this.treenav.removeAll();
        if (helpModel != null) {
            helpModel.removeHelpModelListener((HelpModelListener)this);
        }
        this.treenav = null;
    }

    public void merge(NavigatorView navigatorView) {
        BasicClassViewerNavigatorUI.debug("merging " + navigatorView);
    }

    public void remove(NavigatorView navigatorView) {
        BasicClassViewerNavigatorUI.debug("removing " + navigatorView);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void reloadData() {
        BasicClassViewerNavigatorUI.debug("reloadData");
        this.topNode.removeAllChildren();
        this.parseTOC();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.reload();
        this.setVisibility(this.topNode);
        Map map = this.treenav.getModel().getHelpSet().getCombinedMap();
        this.tree.setCellRenderer((TreeCellRenderer)new BasicTOCCellRenderer(map));
        this.classtree.setCellRenderer((TreeCellRenderer)new BasicTOCCellRenderer(map));
    }

    private void setVisibility(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    public void changeClass(Map.ID iD) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        HelpModel helpModel = this.treenav.getModel();
        this.nodeStack = new Stack();
        this.nodeStack.push(defaultMutableTreeNode);
        this.itemStack = new Stack();
        this.tagStack = new Stack();
        this.defaultLocale = null;
        this.lastLocale = null;
        try {
            HelpSet helpSet = helpModel.getHelpSet();
            URL uRL = helpSet.getCombinedMap().getURLFromID(iD);
            URLConnection uRLConnection = uRL.openConnection();
            Reader reader = XmlReader.createReader((URLConnection)uRLConnection);
            Parser parser = new Parser(reader);
            parser.addParserListener((ParserListener)this);
            parser.parse();
            reader.close();
        }
        catch (Exception exception) {
            BasicClassViewerNavigatorUI.debug("exception thrown" + exception.toString());
            exception.printStackTrace();
            return;
        }
        this.tagStack = null;
        this.itemStack = null;
        this.classtree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.classtree.expandRow(0);
        this.classtree.setSelectionRow(1);
    }

    public void fillFields(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Field1"));
    }

    public void fillConstructors(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Constructor1"));
    }

    public void fillMethods(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Method1"));
    }

    private void parseTOC() {
        URL uRL;
        HelpModel helpModel = this.treenav.getModel();
        if (helpModel == null) {
            return;
        }
        HelpSet helpSet = helpModel.getHelpSet();
        NavigatorView navigatorView = this.treenav.getNavigatorView();
        BasicClassViewerNavigatorUI.debug("parseTOC - " + navigatorView.getName());
        Hashtable hashtable = navigatorView.getParameters();
        try {
            uRL = new URL(helpSet.getHelpSetURL(), (String)hashtable.get("data"));
        }
        catch (Exception exception) {
            throw new Error("Trouble getting URL to TOC data; " + exception);
        }
        this.nodeStack = new Stack();
        this.nodeStack.push(this.topNode);
        this.tagStack = new Stack();
        this.itemStack = new Stack();
        this.defaultLocale = null;
        this.lastLocale = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            Reader reader = XmlReader.createReader((URLConnection)uRLConnection);
            Parser parser = new Parser(reader);
            this.currentParseHS = helpSet;
            parser.addParserListener((ParserListener)this);
            parser.parse();
            reader.close();
        }
        catch (Exception exception) {
            BasicClassViewerNavigatorUI.debug("exception thrown" + exception.toString());
            exception.printStackTrace();
            return;
        }
        this.tagStack = null;
        this.itemStack = null;
    }

    public void piFound(ParserEvent parserEvent) {
    }

    public void doctypeFound(ParserEvent parserEvent) {
    }

    public void tagFound(ParserEvent parserEvent) {
        String string;
        Locale locale = null;
        Tag tag = parserEvent.getTag();
        TagProperties tagProperties = tag.atts;
        if (tagProperties != null) {
            string = tagProperties.getProperty("xml:lang");
            locale = HelpUtilities.localeFromLang((String)string);
        }
        if (locale == null) {
            locale = this.lastLocale;
        }
        if (tag.name.equals("tocitem")) {
            if (!this.startedtoc) {
                BasicClassViewerNavigatorUI.debug("TOC data incorrect");
            }
            if (tag.isEnd && !tag.isEmpty) {
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
                return;
            }
            string = null;
            String string2 = null;
            String string3 = null;
            if (tagProperties != null) {
                string = tagProperties.getProperty("target");
                string2 = tagProperties.getProperty("image");
                string3 = tagProperties.getProperty("text");
            }
            TOCItem tOCItem = null;
            try {
                tOCItem = new TOCItem(Map.ID.create((String)string, (HelpSet)this.currentParseHS), Map.ID.create((String)string2, (HelpSet)this.currentParseHS), locale);
                if (string3 != null) {
                    tOCItem.setName(string3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOCItem);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.nodeStack.peek();
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            if (!tag.isEmpty) {
                this.itemStack.push(tOCItem);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            }
            return;
        }
        if (tag.name.equals("toc")) {
            if (!tag.isEnd) {
                if (this.startedtoc) {
                    System.out.println("TOC data incorrect");
                }
                this.startedtoc = true;
                this.addTag(tag, locale);
            } else {
                if (this.startedtoc) {
                    this.startedtoc = false;
                }
                this.removeTag(tag);
            }
            return;
        }
        if (tag.name.equals("field")) {
            if (!this.startedfields) {
                BasicClassViewerNavigatorUI.debug("Class field data incorrect");
            }
            if (tag.isEnd && !tag.isEmpty) {
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
                return;
            }
            string = null;
            String string4 = null;
            if (tagProperties != null) {
                string = tagProperties.getProperty("target");
                string4 = tagProperties.getProperty("text");
            }
            TOCItem tOCItem = null;
            try {
                tOCItem = new TOCItem(Map.ID.create((String)string, (HelpSet)this.currentParseHS), null, locale);
                if (string4 != null) {
                    tOCItem.setName(string4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOCItem);
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.nodeStack.peek();
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
            if (!tag.isEmpty) {
                this.itemStack.push(tOCItem);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            }
            return;
        }
        if (tag.name.equals("fields")) {
            if (!tag.isEnd) {
                if (this.startedfields && !this.startedclass) {
                    System.out.println("Class fields data incorrect");
                }
                this.startedfields = true;
                string = new TOCItem(null, null, locale);
                string.setName("Fields");
                this.itemStack.push(string);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)this.nodeStack.peek();
                defaultMutableTreeNode4.add(defaultMutableTreeNode);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            } else {
                if (this.startedfields) {
                    this.startedfields = false;
                }
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
            }
            return;
        }
        if (tag.name.equals("constructor")) {
            if (!this.startedconstructors) {
                BasicClassViewerNavigatorUI.debug("Class constructor data incorrect");
            }
            if (tag.isEnd && !tag.isEmpty) {
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
                return;
            }
            string = null;
            String string5 = null;
            if (tagProperties != null) {
                string = tagProperties.getProperty("target");
                string5 = tagProperties.getProperty("text");
            }
            TOCItem tOCItem = null;
            try {
                tOCItem = new TOCItem(Map.ID.create((String)string, (HelpSet)this.currentParseHS), null, locale);
                if (string5 != null) {
                    tOCItem.setName(string5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOCItem);
            DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)this.nodeStack.peek();
            defaultMutableTreeNode5.add(defaultMutableTreeNode);
            if (!tag.isEmpty) {
                this.itemStack.push(tOCItem);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            }
            return;
        }
        if (tag.name.equals("constructors")) {
            if (!tag.isEnd) {
                if (this.startedconstructors && !this.startedclass) {
                    System.out.println("Class constructors data incorrect");
                }
                this.startedconstructors = true;
                string = new TOCItem(null, null, locale);
                string.setName("Constructors");
                this.itemStack.push(string);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)this.nodeStack.peek();
                defaultMutableTreeNode6.add(defaultMutableTreeNode);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            } else {
                if (this.startedconstructors) {
                    this.startedconstructors = false;
                }
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
            }
            return;
        }
        if (tag.name.equals("method")) {
            if (!this.startedmethods) {
                System.out.println("Class method data incorrect");
            }
            if (tag.isEnd && !tag.isEmpty) {
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
                return;
            }
            string = null;
            String string6 = null;
            if (tagProperties != null) {
                string = tagProperties.getProperty("target");
                string6 = tagProperties.getProperty("text");
            }
            TOCItem tOCItem = null;
            try {
                tOCItem = new TOCItem(Map.ID.create((String)string, (HelpSet)this.currentParseHS), null, locale);
                if (tOCItem != null) {
                    tOCItem.setName(string6);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOCItem);
            DefaultMutableTreeNode defaultMutableTreeNode7 = (DefaultMutableTreeNode)this.nodeStack.peek();
            defaultMutableTreeNode7.add(defaultMutableTreeNode);
            if (!tag.isEmpty) {
                this.itemStack.push(tOCItem);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            }
            return;
        }
        if (tag.name.equals("methods")) {
            if (!tag.isEnd) {
                if (this.startedmethods && !this.startedclass) {
                    System.out.println("Class methods data incorrect");
                }
                this.startedmethods = true;
                string = new TOCItem(null, null, locale);
                string.setName("Methods");
                this.itemStack.push(string);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                DefaultMutableTreeNode defaultMutableTreeNode8 = (DefaultMutableTreeNode)this.nodeStack.peek();
                defaultMutableTreeNode8.add(defaultMutableTreeNode);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            } else {
                if (this.startedmethods) {
                    this.startedmethods = false;
                }
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
            }
            return;
        }
        if (tag.name.equals("description")) {
            if (tag.isEnd) {
                if (!this.startedclass) {
                    System.out.println("Class description data incorrect");
                }
                string = null;
                if (tagProperties != null) {
                    string = tagProperties.getProperty("target");
                }
                TOCItem tOCItem = null;
                try {
                    tOCItem = new TOCItem(Map.ID.create((String)string, (HelpSet)this.currentParseHS), null, locale);
                    tOCItem.setName("Description");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOCItem);
                DefaultMutableTreeNode defaultMutableTreeNode9 = (DefaultMutableTreeNode)this.nodeStack.peek();
                defaultMutableTreeNode9.add(defaultMutableTreeNode);
            } else {
                BasicClassViewerNavigatorUI.debug("description must have internal end tag");
            }
            return;
        }
        if (tag.name.equals("class")) {
            if (!tag.isEnd) {
                if (this.startedclass) {
                    System.out.println("Class <class> data incorrect");
                }
                this.startedclass = true;
                string = null;
                String string7 = null;
                if (tagProperties != null) {
                    string = tagProperties.getProperty("target");
                    string7 = tagProperties.getProperty("text");
                }
                TOCItem tOCItem = null;
                try {
                    tOCItem = new TOCItem(Map.ID.create((String)string, (HelpSet)this.currentParseHS), null, locale);
                    if (string7 != null) {
                        tOCItem.setName(string7);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.itemStack.push(tOCItem);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOCItem);
                DefaultMutableTreeNode defaultMutableTreeNode10 = (DefaultMutableTreeNode)this.nodeStack.peek();
                defaultMutableTreeNode10.add(defaultMutableTreeNode);
                this.nodeStack.push(defaultMutableTreeNode);
                this.addTag(tag, locale);
            } else {
                if (this.startedclass) {
                    this.startedclass = false;
                }
                this.nodeStack.pop();
                this.itemStack.pop();
                this.removeTag(tag);
            }
            return;
        }
    }

    public void textFound(ParserEvent parserEvent) {
        if (this.tagStack.empty()) {
            return;
        }
        LangElement langElement = (LangElement)this.tagStack.peek();
        Tag tag = langElement.getTag();
        BasicClassViewerNavigatorUI.debug("Can't add text for " + tag.name);
        BasicClassViewerNavigatorUI.debug("  text is >" + parserEvent.getText() + "<");
    }

    public void commentFound(ParserEvent parserEvent) {
    }

    public void errorFound(ParserEvent parserEvent) {
        System.out.println(parserEvent.getText());
    }

    protected void addTag(Tag tag, Locale locale) {
        LangElement langElement = new LangElement(tag, locale);
        this.tagStack.push(langElement);
        if (this.lastLocale == null) {
            this.lastLocale = locale;
            return;
        }
        if (locale == null) {
            this.lastLocale = locale;
            return;
        }
        if (!this.lastLocale.equals(locale)) {
            this.lastLocale = locale;
        }
    }

    protected void removeTag(Tag tag) {
        String string = tag.toString();
        Locale locale = null;
        while (!this.tagStack.empty()) {
            LangElement langElement = (LangElement)this.tagStack.pop();
            if (!langElement.getTag().toString().equals(string)) continue;
            if (this.tagStack.empty()) {
                locale = this.defaultLocale;
                break;
            }
            langElement = (LangElement)this.tagStack.peek();
            locale = langElement.getLocale();
            break;
        }
        if (this.lastLocale == null) {
            this.lastLocale = locale;
            return;
        }
        if (locale == null) {
            this.lastLocale = locale;
            return;
        }
        if (!this.lastLocale.equals(locale)) {
            this.lastLocale = locale;
        }
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        Map.ID iD;
        Serializable serializable;
        TOCItem tOCItem;
        Object object;
        TreePath treePath;
        BasicClassViewerNavigatorUI.debug("idChanged");
        Map.ID iD2 = helpModelEvent.getID();
        URL uRL = helpModelEvent.getURL();
        HelpModel helpModel = this.treenav.getModel();
        if (helpModelEvent.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + helpModelEvent.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        if (iD2 == null) {
            // empty if block
        }
        if ((treePath = this.tree.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (tOCItem = (TOCItem)(serializable = (DefaultMutableTreeNode)object).getUserObject()) != null && (iD = tOCItem.getID()) != null && iD.equals((Object)iD2)) {
            return;
        }
        BasicClassViewerNavigatorUI.debug("finding: " + iD2);
        object = this.findID(this.topNode, iD2);
        if (object == null) {
            return;
        }
        serializable = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.tree.expandPath((TreePath)serializable);
        this.tree.setSelectionPath((TreePath)serializable);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD) {
        if (iD == null) {
            return null;
        }
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem != null) {
            Map.ID iD2 = tOCItem.getID();
            BasicClassViewerNavigatorUI.debug("  testID: " + iD2);
            if (iD2 != null && iD2.equals((Object)iD)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findID(defaultMutableTreeNode2, iD);
            if (defaultMutableTreeNode3 == null) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.tree.getSelectionModel()) {
            TreePath treePath = this.tree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
            if (tOCItem != null && tOCItem.getID() != null) {
                BasicClassViewerNavigatorUI.debug("Setting CurrentID -" + tOCItem.getID());
                this.changeClass(tOCItem.getID());
            }
        } else if (treeSelectionEvent.getSource() == this.classtree.getSelectionModel()) {
            TreePath treePath = this.classtree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
            if (tOCItem != null && tOCItem.getID() != null) {
                try {
                    BasicClassViewerNavigatorUI.debug("Setting CurrentID -" + tOCItem.getID());
                    this.treenav.getModel().setCurrentID(tOCItem.getID());
                }
                catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                    BasicClassViewerNavigatorUI.debug("BadID");
                    return;
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicClassViewerNavigatorUI.debug("propertyChange");
    }

    private static void debug(String string) {
    }
}

