/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.AbstractTypeFileTreeNodeFactoryProvider;
import org.jd.gui.view.component.JavaFilePage;
import org.jd.gui.view.data.TreeNodeBean;

public class JavaFileTreeNodeFactoryProvider
extends AbstractTypeFileTreeNodeFactoryProvider {
    protected static final ImageIcon JAVA_FILE_ICON = new ImageIcon(JavaFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/jcu_obj.png"));
    protected static final Factory FACTORY = new Factory();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.java");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf(47);
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new AbstractTypeFileTreeNodeFactoryProvider.FileTreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)JAVA_FILE_ICON), FACTORY);
    }

    protected static class Factory
    implements AbstractTypeFileTreeNodeFactoryProvider.PageAndTipFactory {
        protected Factory() {
        }

        @Override
        public <T extends JComponent> T makePage(API a, Container.Entry e) {
            return (T)new JavaFilePage(a, e);
        }

        @Override
        public String makeTip(API api, Container.Entry entry) {
            String location = new File(entry.getUri()).getPath();
            StringBuilder tip = new StringBuilder("<html>Location: ");
            tip.append(location);
            tip.append("</html>");
            return tip.toString();
        }
    }
}

