/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.store.rest;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.store.FeatureStore;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.rest.ManagedResourceStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedFeatureStore
extends ManagedResource
implements ManagedResource.ChildResourceSupport {
    public static final String REST_END_POINT = "/schema/feature-store";
    static final String CLASS_KEY = "class";
    static final String NAME_KEY = "name";
    static final String PARAMS_KEY = "params";
    static final String FEATURE_STORE_NAME_KEY = "store";
    private final Map<String, FeatureStore> stores = new HashMap<String, FeatureStore>();
    private static final String FEATURE_STORE_JSON_FIELD = "featureStores";
    private static final String FEATURES_JSON_FIELD = "features";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void registerManagedFeatureStore(SolrResourceLoader solrResourceLoader, ManagedResourceObserver managedResourceObserver) {
        solrResourceLoader.getManagedResourceRegistry().registerManagedResource(REST_END_POINT, ManagedFeatureStore.class, managedResourceObserver);
    }

    public static ManagedFeatureStore getManagedFeatureStore(SolrCore core) {
        return (ManagedFeatureStore)core.getRestManager().getManagedResource(REST_END_POINT);
    }

    public ManagedFeatureStore(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        super(resourceId, loader, storageIO);
    }

    public synchronized FeatureStore getFeatureStore(String name) {
        if (name == null) {
            name = "_DEFAULT_";
        }
        if (!this.stores.containsKey(name)) {
            this.stores.put(name, new FeatureStore(name));
        }
        return this.stores.get(name);
    }

    protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
        this.stores.clear();
        log.info("------ managed feature ~ loading ------");
        if (managedData instanceof List) {
            List up = (List)managedData;
            for (Map u : up) {
                String featureStore = (String)u.get(FEATURE_STORE_NAME_KEY);
                this.addFeature(u, featureStore);
            }
        }
    }

    public synchronized void addFeature(Map<String, Object> map, String featureStore) {
        log.info("register feature based on {}", map);
        FeatureStore fstore = this.getFeatureStore(featureStore);
        Feature feature = ManagedFeatureStore.fromFeatureMap(this.solrResourceLoader, map);
        fstore.add(feature);
    }

    public Object applyUpdatesToManagedData(Object updates) {
        if (updates instanceof List) {
            List up = (List)updates;
            for (Map u : up) {
                String featureStore = (String)u.get(FEATURE_STORE_NAME_KEY);
                this.addFeature(u, featureStore);
            }
        }
        if (updates instanceof Map) {
            Map updatesMap = (Map)updates;
            String featureStore = (String)updatesMap.get(FEATURE_STORE_NAME_KEY);
            this.addFeature(updatesMap, featureStore);
        }
        ArrayList<Object> features = new ArrayList<Object>();
        for (FeatureStore fs : this.stores.values()) {
            features.addAll(ManagedFeatureStore.featuresAsManagedResources(fs));
        }
        return features;
    }

    public synchronized void doDeleteChild(BaseSolrResource endpoint, String childId) {
        if (this.stores.containsKey(childId)) {
            this.stores.remove(childId);
        }
        this.storeManagedData(this.applyUpdatesToManagedData(null));
    }

    public void doGet(BaseSolrResource endpoint, String childId) {
        SolrQueryResponse response = endpoint.getSolrResponse();
        if (childId == null) {
            response.add(FEATURE_STORE_JSON_FIELD, this.stores.keySet());
        } else {
            FeatureStore store = this.getFeatureStore(childId);
            if (store == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing feature store [" + childId + "]");
            }
            response.add(FEATURES_JSON_FIELD, ManagedFeatureStore.featuresAsManagedResources(store));
        }
    }

    private static List<Object> featuresAsManagedResources(FeatureStore store) {
        List<Feature> storedFeatures = store.getFeatures();
        ArrayList<Object> features = new ArrayList<Object>(storedFeatures.size());
        for (Feature f : storedFeatures) {
            LinkedHashMap<String, Object> m = ManagedFeatureStore.toFeatureMap(f);
            m.put(FEATURE_STORE_NAME_KEY, store.getName());
            features.add(m);
        }
        return features;
    }

    private static LinkedHashMap<String, Object> toFeatureMap(Feature feat) {
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>(4, 1.0f);
        o.put(NAME_KEY, feat.getName());
        o.put(CLASS_KEY, ((Object)((Object)feat)).getClass().getName());
        o.put(PARAMS_KEY, feat.paramsToMap());
        return o;
    }

    private static Feature fromFeatureMap(SolrResourceLoader solrResourceLoader, Map<String, Object> featureMap) {
        String className = (String)featureMap.get(CLASS_KEY);
        String name = (String)featureMap.get(NAME_KEY);
        Map params = (Map)featureMap.get(PARAMS_KEY);
        return Feature.getInstance(solrResourceLoader, className, name, params);
    }
}

