/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlJsonValueExpressionOperator
extends SqlSpecialOperator {
    private final boolean structured;

    public SqlJsonValueExpressionOperator(String name, boolean structured) {
        super(name, SqlKind.JSON_VALUE_EXPRESSION, 100, true, (SqlOperatorBinding opBinding) -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }, (SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) -> {
            if (callBinding.isOperandNull(0, false)) {
                RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
                operandTypes[0] = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }, (SqlOperandTypeChecker)(structured ? OperandTypes.ANY : OperandTypes.STRING));
        this.structured = structured;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        if (!this.structured) {
            writer.keyword("FORMAT JSON");
        }
    }
}

