/*
 * Copyright © 2017 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* THIS FILE HAS BEEN GENERATED, DO NOT HAND EDIT.
 *
 * Sizes of bitfields in genxml instructions, structures, and registers.
 */

#ifndef GENX_BITS_H
#define GENX_BITS_H

#include <stdint.h>

#include "dev/gen_device_info.h"
#include "util/macros.h"



#ifdef __cplusplus
extern "C" {
#endif

/* 3DPRIMITIVE */


#define GFX125_3DPRIMITIVE_length  7
#define GFX12_3DPRIMITIVE_length  7
#define GFX11_3DPRIMITIVE_length  7
#define GFX9_3DPRIMITIVE_length  7
#define GFX8_3DPRIMITIVE_length  7
#define GFX75_3DPRIMITIVE_length  7
#define GFX7_3DPRIMITIVE_length  7
#define GFX6_3DPRIMITIVE_length  6
#define GFX5_3DPRIMITIVE_length  6
#define GFX45_3DPRIMITIVE_length  6
#define GFX4_3DPRIMITIVE_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 7;
   case 70: return 7;
   case 60: return 6;
   case 50: return 6;
   case 45: return 6;
   case 40: return 6;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::3D Command Opcode */


#define GFX125_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX12_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX11_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX9_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX8_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX75_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX7_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX6_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX5_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX45_3DPRIMITIVE_3DCommandOpcode_bits  3
#define GFX4_3DPRIMITIVE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX12_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX11_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX9_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX8_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX75_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX7_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX6_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX5_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX45_3DPRIMITIVE_3DCommandOpcode_start  24
#define GFX4_3DPRIMITIVE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::3D Command Sub Opcode */


#define GFX125_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX12_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX11_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX9_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX8_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX75_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX7_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX6_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX5_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX45_3DPRIMITIVE_3DCommandSubOpcode_bits  8
#define GFX4_3DPRIMITIVE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX12_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX11_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX9_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX8_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX75_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX7_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX6_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX5_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX45_3DPRIMITIVE_3DCommandSubOpcode_start  16
#define GFX4_3DPRIMITIVE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Base Vertex Location */


#define GFX125_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX12_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX11_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX9_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX8_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX75_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX7_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX6_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX5_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX45_3DPRIMITIVE_BaseVertexLocation_bits  32
#define GFX4_3DPRIMITIVE_BaseVertexLocation_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_BaseVertexLocation_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX12_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX11_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX9_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX8_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX75_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX7_3DPRIMITIVE_BaseVertexLocation_start  192
#define GFX6_3DPRIMITIVE_BaseVertexLocation_start  160
#define GFX5_3DPRIMITIVE_BaseVertexLocation_start  160
#define GFX45_3DPRIMITIVE_BaseVertexLocation_start  160
#define GFX4_3DPRIMITIVE_BaseVertexLocation_start  160

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_BaseVertexLocation_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 192;
   case 120: return 192;
   case 110: return 192;
   case 90: return 192;
   case 80: return 192;
   case 75: return 192;
   case 70: return 192;
   case 60: return 160;
   case 50: return 160;
   case 45: return 160;
   case 40: return 160;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Command SubType */


#define GFX125_3DPRIMITIVE_CommandSubType_bits  2
#define GFX12_3DPRIMITIVE_CommandSubType_bits  2
#define GFX11_3DPRIMITIVE_CommandSubType_bits  2
#define GFX9_3DPRIMITIVE_CommandSubType_bits  2
#define GFX8_3DPRIMITIVE_CommandSubType_bits  2
#define GFX75_3DPRIMITIVE_CommandSubType_bits  2
#define GFX7_3DPRIMITIVE_CommandSubType_bits  2
#define GFX6_3DPRIMITIVE_CommandSubType_bits  2
#define GFX5_3DPRIMITIVE_CommandSubType_bits  2
#define GFX45_3DPRIMITIVE_CommandSubType_bits  2
#define GFX4_3DPRIMITIVE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_CommandSubType_start  27
#define GFX12_3DPRIMITIVE_CommandSubType_start  27
#define GFX11_3DPRIMITIVE_CommandSubType_start  27
#define GFX9_3DPRIMITIVE_CommandSubType_start  27
#define GFX8_3DPRIMITIVE_CommandSubType_start  27
#define GFX75_3DPRIMITIVE_CommandSubType_start  27
#define GFX7_3DPRIMITIVE_CommandSubType_start  27
#define GFX6_3DPRIMITIVE_CommandSubType_start  27
#define GFX5_3DPRIMITIVE_CommandSubType_start  27
#define GFX45_3DPRIMITIVE_CommandSubType_start  27
#define GFX4_3DPRIMITIVE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Command Type */


#define GFX125_3DPRIMITIVE_CommandType_bits  3
#define GFX12_3DPRIMITIVE_CommandType_bits  3
#define GFX11_3DPRIMITIVE_CommandType_bits  3
#define GFX9_3DPRIMITIVE_CommandType_bits  3
#define GFX8_3DPRIMITIVE_CommandType_bits  3
#define GFX75_3DPRIMITIVE_CommandType_bits  3
#define GFX7_3DPRIMITIVE_CommandType_bits  3
#define GFX6_3DPRIMITIVE_CommandType_bits  3
#define GFX5_3DPRIMITIVE_CommandType_bits  3
#define GFX45_3DPRIMITIVE_CommandType_bits  3
#define GFX4_3DPRIMITIVE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_CommandType_start  29
#define GFX12_3DPRIMITIVE_CommandType_start  29
#define GFX11_3DPRIMITIVE_CommandType_start  29
#define GFX9_3DPRIMITIVE_CommandType_start  29
#define GFX8_3DPRIMITIVE_CommandType_start  29
#define GFX75_3DPRIMITIVE_CommandType_start  29
#define GFX7_3DPRIMITIVE_CommandType_start  29
#define GFX6_3DPRIMITIVE_CommandType_start  29
#define GFX5_3DPRIMITIVE_CommandType_start  29
#define GFX45_3DPRIMITIVE_CommandType_start  29
#define GFX4_3DPRIMITIVE_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 29;
   case 45: return 29;
   case 40: return 29;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::DWord Length */


#define GFX125_3DPRIMITIVE_DWordLength_bits  8
#define GFX12_3DPRIMITIVE_DWordLength_bits  8
#define GFX11_3DPRIMITIVE_DWordLength_bits  8
#define GFX9_3DPRIMITIVE_DWordLength_bits  8
#define GFX8_3DPRIMITIVE_DWordLength_bits  8
#define GFX75_3DPRIMITIVE_DWordLength_bits  8
#define GFX7_3DPRIMITIVE_DWordLength_bits  8
#define GFX6_3DPRIMITIVE_DWordLength_bits  8
#define GFX5_3DPRIMITIVE_DWordLength_bits  8
#define GFX45_3DPRIMITIVE_DWordLength_bits  8
#define GFX4_3DPRIMITIVE_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_DWordLength_start  0
#define GFX12_3DPRIMITIVE_DWordLength_start  0
#define GFX11_3DPRIMITIVE_DWordLength_start  0
#define GFX9_3DPRIMITIVE_DWordLength_start  0
#define GFX8_3DPRIMITIVE_DWordLength_start  0
#define GFX75_3DPRIMITIVE_DWordLength_start  0
#define GFX7_3DPRIMITIVE_DWordLength_start  0
#define GFX6_3DPRIMITIVE_DWordLength_start  0
#define GFX5_3DPRIMITIVE_DWordLength_start  0
#define GFX45_3DPRIMITIVE_DWordLength_start  0
#define GFX4_3DPRIMITIVE_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::End Offset Enable */


#define GFX125_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GFX12_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GFX11_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GFX9_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GFX8_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GFX75_3DPRIMITIVE_EndOffsetEnable_bits  1
#define GFX7_3DPRIMITIVE_EndOffsetEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_EndOffsetEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_EndOffsetEnable_start  41
#define GFX12_3DPRIMITIVE_EndOffsetEnable_start  41
#define GFX11_3DPRIMITIVE_EndOffsetEnable_start  41
#define GFX9_3DPRIMITIVE_EndOffsetEnable_start  41
#define GFX8_3DPRIMITIVE_EndOffsetEnable_start  41
#define GFX75_3DPRIMITIVE_EndOffsetEnable_start  41
#define GFX7_3DPRIMITIVE_EndOffsetEnable_start  41

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_EndOffsetEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 41;
   case 120: return 41;
   case 110: return 41;
   case 90: return 41;
   case 80: return 41;
   case 75: return 41;
   case 70: return 41;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameter 0 */


#define GFX125_3DPRIMITIVE_ExtendedParameter0_bits  32
#define GFX12_3DPRIMITIVE_ExtendedParameter0_bits  32
#define GFX11_3DPRIMITIVE_ExtendedParameter0_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_ExtendedParameter0_start  224
#define GFX12_3DPRIMITIVE_ExtendedParameter0_start  224
#define GFX11_3DPRIMITIVE_ExtendedParameter0_start  224

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 224;
   case 120: return 224;
   case 110: return 224;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameter 1 */


#define GFX125_3DPRIMITIVE_ExtendedParameter1_bits  32
#define GFX12_3DPRIMITIVE_ExtendedParameter1_bits  32
#define GFX11_3DPRIMITIVE_ExtendedParameter1_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_ExtendedParameter1_start  256
#define GFX12_3DPRIMITIVE_ExtendedParameter1_start  256
#define GFX11_3DPRIMITIVE_ExtendedParameter1_start  256

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 256;
   case 120: return 256;
   case 110: return 256;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameter 2 */


#define GFX125_3DPRIMITIVE_ExtendedParameter2_bits  32
#define GFX12_3DPRIMITIVE_ExtendedParameter2_bits  32
#define GFX11_3DPRIMITIVE_ExtendedParameter2_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter2_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_ExtendedParameter2_start  288
#define GFX12_3DPRIMITIVE_ExtendedParameter2_start  288
#define GFX11_3DPRIMITIVE_ExtendedParameter2_start  288

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParameter2_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 288;
   case 120: return 288;
   case 110: return 288;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Extended Parameters Present */


#define GFX125_3DPRIMITIVE_ExtendedParametersPresent_bits  1
#define GFX12_3DPRIMITIVE_ExtendedParametersPresent_bits  1
#define GFX11_3DPRIMITIVE_ExtendedParametersPresent_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParametersPresent_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_ExtendedParametersPresent_start  11
#define GFX12_3DPRIMITIVE_ExtendedParametersPresent_start  11
#define GFX11_3DPRIMITIVE_ExtendedParametersPresent_start  11

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_ExtendedParametersPresent_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Indirect Parameter Enable */


#define GFX125_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GFX12_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GFX11_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GFX9_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GFX8_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GFX75_3DPRIMITIVE_IndirectParameterEnable_bits  1
#define GFX7_3DPRIMITIVE_IndirectParameterEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectParameterEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GFX12_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GFX11_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GFX9_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GFX8_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GFX75_3DPRIMITIVE_IndirectParameterEnable_start  10
#define GFX7_3DPRIMITIVE_IndirectParameterEnable_start  10

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectParameterEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 10;
   case 120: return 10;
   case 110: return 10;
   case 90: return 10;
   case 80: return 10;
   case 75: return 10;
   case 70: return 10;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Indirect Vertex Count */


#define GFX5_3DPRIMITIVE_IndirectVertexCount_bits  1
#define GFX45_3DPRIMITIVE_IndirectVertexCount_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 1;
   case 45: return 1;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DPRIMITIVE_IndirectVertexCount_start  9
#define GFX45_3DPRIMITIVE_IndirectVertexCount_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_IndirectVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 9;
   case 45: return 9;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Instance Count */


#define GFX125_3DPRIMITIVE_InstanceCount_bits  32
#define GFX12_3DPRIMITIVE_InstanceCount_bits  32
#define GFX11_3DPRIMITIVE_InstanceCount_bits  32
#define GFX9_3DPRIMITIVE_InstanceCount_bits  32
#define GFX8_3DPRIMITIVE_InstanceCount_bits  32
#define GFX75_3DPRIMITIVE_InstanceCount_bits  32
#define GFX7_3DPRIMITIVE_InstanceCount_bits  32
#define GFX6_3DPRIMITIVE_InstanceCount_bits  32
#define GFX5_3DPRIMITIVE_InstanceCount_bits  32
#define GFX45_3DPRIMITIVE_InstanceCount_bits  32
#define GFX4_3DPRIMITIVE_InstanceCount_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InstanceCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_InstanceCount_start  128
#define GFX12_3DPRIMITIVE_InstanceCount_start  128
#define GFX11_3DPRIMITIVE_InstanceCount_start  128
#define GFX9_3DPRIMITIVE_InstanceCount_start  128
#define GFX8_3DPRIMITIVE_InstanceCount_start  128
#define GFX75_3DPRIMITIVE_InstanceCount_start  128
#define GFX7_3DPRIMITIVE_InstanceCount_start  128
#define GFX6_3DPRIMITIVE_InstanceCount_start  96
#define GFX5_3DPRIMITIVE_InstanceCount_start  96
#define GFX45_3DPRIMITIVE_InstanceCount_start  96
#define GFX4_3DPRIMITIVE_InstanceCount_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InstanceCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 128;
   case 120: return 128;
   case 110: return 128;
   case 90: return 128;
   case 80: return 128;
   case 75: return 128;
   case 70: return 128;
   case 60: return 96;
   case 50: return 96;
   case 45: return 96;
   case 40: return 96;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Internal Vertex Count */


#define GFX6_3DPRIMITIVE_InternalVertexCount_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InternalVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DPRIMITIVE_InternalVertexCount_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_InternalVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 9;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Predicate Enable */


#define GFX125_3DPRIMITIVE_PredicateEnable_bits  1
#define GFX12_3DPRIMITIVE_PredicateEnable_bits  1
#define GFX11_3DPRIMITIVE_PredicateEnable_bits  1
#define GFX9_3DPRIMITIVE_PredicateEnable_bits  1
#define GFX8_3DPRIMITIVE_PredicateEnable_bits  1
#define GFX75_3DPRIMITIVE_PredicateEnable_bits  1
#define GFX7_3DPRIMITIVE_PredicateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PredicateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_PredicateEnable_start  8
#define GFX12_3DPRIMITIVE_PredicateEnable_start  8
#define GFX11_3DPRIMITIVE_PredicateEnable_start  8
#define GFX9_3DPRIMITIVE_PredicateEnable_start  8
#define GFX8_3DPRIMITIVE_PredicateEnable_start  8
#define GFX75_3DPRIMITIVE_PredicateEnable_start  8
#define GFX7_3DPRIMITIVE_PredicateEnable_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PredicateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Primitive Topology Type */


#define GFX125_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX12_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX11_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX9_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX8_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX75_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX7_3DPRIMITIVE_PrimitiveTopologyType_bits  6
#define GFX6_3DPRIMITIVE_PrimitiveTopologyType_bits  5
#define GFX5_3DPRIMITIVE_PrimitiveTopologyType_bits  5
#define GFX45_3DPRIMITIVE_PrimitiveTopologyType_bits  5
#define GFX4_3DPRIMITIVE_PrimitiveTopologyType_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PrimitiveTopologyType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 5;
   case 50: return 5;
   case 45: return 5;
   case 40: return 5;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX12_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX11_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX9_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX8_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX75_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX7_3DPRIMITIVE_PrimitiveTopologyType_start  32
#define GFX6_3DPRIMITIVE_PrimitiveTopologyType_start  10
#define GFX5_3DPRIMITIVE_PrimitiveTopologyType_start  10
#define GFX45_3DPRIMITIVE_PrimitiveTopologyType_start  10
#define GFX4_3DPRIMITIVE_PrimitiveTopologyType_start  10

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_PrimitiveTopologyType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 10;
   case 50: return 10;
   case 45: return 10;
   case 40: return 10;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Start Instance Location */


#define GFX125_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX12_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX11_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX9_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX8_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX75_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX7_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX6_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX5_3DPRIMITIVE_StartInstanceLocation_bits  32
#define GFX45_3DPRIMITIVE_StartInstanceLocation_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartInstanceLocation_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX12_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX11_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX9_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX8_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX75_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX7_3DPRIMITIVE_StartInstanceLocation_start  160
#define GFX6_3DPRIMITIVE_StartInstanceLocation_start  128
#define GFX5_3DPRIMITIVE_StartInstanceLocation_start  128
#define GFX45_3DPRIMITIVE_StartInstanceLocation_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartInstanceLocation_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 160;
   case 120: return 160;
   case 110: return 160;
   case 90: return 160;
   case 80: return 160;
   case 75: return 160;
   case 70: return 160;
   case 60: return 128;
   case 50: return 128;
   case 45: return 128;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Start Vertex Location */


#define GFX125_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX12_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX11_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX9_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX8_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX75_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX7_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX6_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX5_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX45_3DPRIMITIVE_StartVertexLocation_bits  32
#define GFX4_3DPRIMITIVE_StartVertexLocation_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartVertexLocation_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX12_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX11_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX9_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX8_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX75_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX7_3DPRIMITIVE_StartVertexLocation_start  96
#define GFX6_3DPRIMITIVE_StartVertexLocation_start  64
#define GFX5_3DPRIMITIVE_StartVertexLocation_start  64
#define GFX45_3DPRIMITIVE_StartVertexLocation_start  64
#define GFX4_3DPRIMITIVE_StartVertexLocation_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_StartVertexLocation_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 96;
   case 120: return 96;
   case 110: return 96;
   case 90: return 96;
   case 80: return 96;
   case 75: return 96;
   case 70: return 96;
   case 60: return 64;
   case 50: return 64;
   case 45: return 64;
   case 40: return 64;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::UAV Coherency Required */


#define GFX125_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GFX12_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GFX11_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GFX9_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GFX8_3DPRIMITIVE_UAVCoherencyRequired_bits  1
#define GFX75_3DPRIMITIVE_UAVCoherencyRequired_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_UAVCoherencyRequired_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GFX12_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GFX11_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GFX9_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GFX8_3DPRIMITIVE_UAVCoherencyRequired_start  9
#define GFX75_3DPRIMITIVE_UAVCoherencyRequired_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_UAVCoherencyRequired_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Vertex Access Type */


#define GFX125_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX12_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX11_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX9_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX8_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX75_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX7_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX6_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX5_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX45_3DPRIMITIVE_VertexAccessType_bits  1
#define GFX4_3DPRIMITIVE_VertexAccessType_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexAccessType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 1;
   case 45: return 1;
   case 40: return 1;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_VertexAccessType_start  40
#define GFX12_3DPRIMITIVE_VertexAccessType_start  40
#define GFX11_3DPRIMITIVE_VertexAccessType_start  40
#define GFX9_3DPRIMITIVE_VertexAccessType_start  40
#define GFX8_3DPRIMITIVE_VertexAccessType_start  40
#define GFX75_3DPRIMITIVE_VertexAccessType_start  40
#define GFX7_3DPRIMITIVE_VertexAccessType_start  40
#define GFX6_3DPRIMITIVE_VertexAccessType_start  15
#define GFX5_3DPRIMITIVE_VertexAccessType_start  15
#define GFX45_3DPRIMITIVE_VertexAccessType_start  15
#define GFX4_3DPRIMITIVE_VertexAccessType_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexAccessType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 40;
   case 120: return 40;
   case 110: return 40;
   case 90: return 40;
   case 80: return 40;
   case 75: return 40;
   case 70: return 40;
   case 60: return 15;
   case 50: return 15;
   case 45: return 15;
   case 40: return 15;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DPRIMITIVE::Vertex Count Per Instance */


#define GFX125_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX12_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX11_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX9_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX8_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX75_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX7_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX6_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX5_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX45_3DPRIMITIVE_VertexCountPerInstance_bits  32
#define GFX4_3DPRIMITIVE_VertexCountPerInstance_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexCountPerInstance_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX12_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX11_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX9_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX8_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX75_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX7_3DPRIMITIVE_VertexCountPerInstance_start  64
#define GFX6_3DPRIMITIVE_VertexCountPerInstance_start  32
#define GFX5_3DPRIMITIVE_VertexCountPerInstance_start  32
#define GFX45_3DPRIMITIVE_VertexCountPerInstance_start  32
#define GFX4_3DPRIMITIVE_VertexCountPerInstance_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DPRIMITIVE_VertexCountPerInstance_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE */


#define GFX125_3DSTATE_3D_MODE_length  2
#define GFX12_3DSTATE_3D_MODE_length  2
#define GFX11_3DSTATE_3D_MODE_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::3D Command Opcode */


#define GFX125_3DSTATE_3D_MODE_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_3D_MODE_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_3D_MODE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_3DCommandOpcode_start  24
#define GFX12_3DSTATE_3D_MODE_3DCommandOpcode_start  24
#define GFX11_3DSTATE_3D_MODE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::3D Command Sub Opcode */


#define GFX125_3DSTATE_3D_MODE_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_3D_MODE_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_3D_MODE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_3D_MODE_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_3D_MODE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::3D Scoreboard Hashing Mode */


#define GFX125_3DSTATE_3D_MODE_3DScoreboardHashingMode_bits  1
#define GFX12_3DSTATE_3D_MODE_3DScoreboardHashingMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DScoreboardHashingMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_3DScoreboardHashingMode_start  36
#define GFX12_3DSTATE_3D_MODE_3DScoreboardHashingMode_start  36

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DScoreboardHashingMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 36;
   case 120: return 36;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::3D Scoreboard Hashing Mode Mask */


#define GFX125_3DSTATE_3D_MODE_3DScoreboardHashingModeMask_bits  1
#define GFX12_3DSTATE_3D_MODE_3DScoreboardHashingModeMask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DScoreboardHashingModeMask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_3DScoreboardHashingModeMask_start  52
#define GFX12_3DSTATE_3D_MODE_3DScoreboardHashingModeMask_start  52

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_3DScoreboardHashingModeMask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 52;
   case 120: return 52;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Command SubType */


#define GFX125_3DSTATE_3D_MODE_CommandSubType_bits  2
#define GFX12_3DSTATE_3D_MODE_CommandSubType_bits  2
#define GFX11_3DSTATE_3D_MODE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_CommandSubType_start  27
#define GFX12_3DSTATE_3D_MODE_CommandSubType_start  27
#define GFX11_3DSTATE_3D_MODE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Command Type */


#define GFX125_3DSTATE_3D_MODE_CommandType_bits  3
#define GFX12_3DSTATE_3D_MODE_CommandType_bits  3
#define GFX11_3DSTATE_3D_MODE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_CommandType_start  29
#define GFX12_3DSTATE_3D_MODE_CommandType_start  29
#define GFX11_3DSTATE_3D_MODE_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Cross Slice Hashing Mode */


#define GFX125_3DSTATE_3D_MODE_CrossSliceHashingMode_bits  2
#define GFX12_3DSTATE_3D_MODE_CrossSliceHashingMode_bits  2
#define GFX11_3DSTATE_3D_MODE_CrossSliceHashingMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CrossSliceHashingMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_CrossSliceHashingMode_start  32
#define GFX12_3DSTATE_3D_MODE_CrossSliceHashingMode_start  32
#define GFX11_3DSTATE_3D_MODE_CrossSliceHashingMode_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CrossSliceHashingMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Cross Slice Hashing Mode Mask */


#define GFX125_3DSTATE_3D_MODE_CrossSliceHashingModeMask_bits  2
#define GFX12_3DSTATE_3D_MODE_CrossSliceHashingModeMask_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CrossSliceHashingModeMask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_CrossSliceHashingModeMask_start  48
#define GFX12_3DSTATE_3D_MODE_CrossSliceHashingModeMask_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_CrossSliceHashingModeMask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::DWord Length */


#define GFX125_3DSTATE_3D_MODE_DWordLength_bits  8
#define GFX12_3DSTATE_3D_MODE_DWordLength_bits  8
#define GFX11_3DSTATE_3D_MODE_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_DWordLength_start  0
#define GFX12_3DSTATE_3D_MODE_DWordLength_start  0
#define GFX11_3DSTATE_3D_MODE_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Mask */


#define GFX11_3DSTATE_3D_MODE_Mask_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_Mask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 16;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX11_3DSTATE_3D_MODE_Mask_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_Mask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 48;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Slice Hashing Table Enable */


#define GFX125_3DSTATE_3D_MODE_SliceHashingTableEnable_bits  1
#define GFX12_3DSTATE_3D_MODE_SliceHashingTableEnable_bits  1
#define GFX11_3DSTATE_3D_MODE_SliceHashingTableEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SliceHashingTableEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_SliceHashingTableEnable_start  38
#define GFX12_3DSTATE_3D_MODE_SliceHashingTableEnable_start  38
#define GFX11_3DSTATE_3D_MODE_SliceHashingTableEnable_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SliceHashingTableEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 38;
   case 120: return 38;
   case 110: return 38;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Slice Hashing Table Enable Mask */


#define GFX125_3DSTATE_3D_MODE_SliceHashingTableEnableMask_bits  1
#define GFX12_3DSTATE_3D_MODE_SliceHashingTableEnableMask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SliceHashingTableEnableMask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_SliceHashingTableEnableMask_start  54
#define GFX12_3DSTATE_3D_MODE_SliceHashingTableEnableMask_start  54

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SliceHashingTableEnableMask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 54;
   case 120: return 54;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Subslice Hashing Mode */


#define GFX11_3DSTATE_3D_MODE_SubsliceHashingMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SubsliceHashingMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 2;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX11_3DSTATE_3D_MODE_SubsliceHashingMode_start  34

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SubsliceHashingMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 34;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Subslice Hashing Table Enable */


#define GFX125_3DSTATE_3D_MODE_SubsliceHashingTableEnable_bits  1
#define GFX12_3DSTATE_3D_MODE_SubsliceHashingTableEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SubsliceHashingTableEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_SubsliceHashingTableEnable_start  37
#define GFX12_3DSTATE_3D_MODE_SubsliceHashingTableEnable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SubsliceHashingTableEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 37;
   case 120: return 37;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_3D_MODE::Subslice Hashing Table Enable Mask */


#define GFX125_3DSTATE_3D_MODE_SubsliceHashingTableEnableMask_bits  1
#define GFX12_3DSTATE_3D_MODE_SubsliceHashingTableEnableMask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SubsliceHashingTableEnableMask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_3D_MODE_SubsliceHashingTableEnableMask_start  53
#define GFX12_3DSTATE_3D_MODE_SubsliceHashingTableEnableMask_start  53

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_3D_MODE_SubsliceHashingTableEnableMask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 53;
   case 120: return 53;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_length  3
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::3D Command Opcode */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 24;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::3D Command Sub Opcode */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage Bias */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 48;
   case 60: return 48;
   case 50: return 48;
   case 45: return 48;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage EndCap Bias */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 80;
   case 120: return 80;
   case 110: return 80;
   case 90: return 80;
   case 80: return 80;
   case 75: return 80;
   case 70: return 80;
   case 60: return 80;
   case 50: return 80;
   case 45: return 80;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage EndCap Slope */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageEndCapSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 64;
   case 45: return 64;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Coverage Slope */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AACoverageSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage Bias */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start  56

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 56;
   case 120: return 56;
   case 110: return 56;
   case 90: return 56;
   case 80: return 56;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage EndCap Bias */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start  88

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapBias_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 88;
   case 120: return 88;
   case 110: return 88;
   case 90: return 88;
   case 80: return 88;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage EndCap Slope */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start  72

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageEndCapSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 72;
   case 120: return 72;
   case 110: return 72;
   case 90: return 72;
   case 80: return 72;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::AA Point Coverage Slope */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start  40

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_AAPointCoverageSlope_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 40;
   case 120: return 40;
   case 110: return 40;
   case 90: return 40;
   case 80: return 40;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::Command SubType */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 2;
   case 45: return 2;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::Command Type */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 29;
   case 45: return 29;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_AA_LINE_PARAMETERS::DWord Length */


#define GFX125_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX12_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX11_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX9_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX8_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX75_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX7_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX6_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX5_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0
#define GFX45_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_AA_LINE_PARAMETERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS */





/* 3DSTATE_BINDING_TABLE_EDIT_DS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Binding Table Block Clear */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Binding Table Edit Target */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_DS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS */





/* 3DSTATE_BINDING_TABLE_EDIT_GS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Binding Table Block Clear */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Binding Table Edit Target */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_GS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS */





/* 3DSTATE_BINDING_TABLE_EDIT_HS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Binding Table Block Clear */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Binding Table Edit Target */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_HS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS */





/* 3DSTATE_BINDING_TABLE_EDIT_PS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Binding Table Block Clear */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Binding Table Edit Target */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_PS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS */





/* 3DSTATE_BINDING_TABLE_EDIT_VS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Binding Table Block Clear */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableBlockClear_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Binding Table Edit Target */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_BindingTableEditTarget_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_EDIT_VS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_EDIT_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_length  4
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_length  6
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_length  6
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 4;
   case 50: return 6;
   case 45: return 6;
   case 40: return 6;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::3D Command Opcode */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 24;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::3D Command Sub Opcode */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Command SubType */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 2;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Command Type */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 29;
   case 50: return 29;
   case 45: return 29;
   case 40: return 29;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::DWord Length */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::GS Binding Table Change */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GSBindingTableChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 9;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::PS Binding Table Change */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PSBindingTableChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 12;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to CLIP Binding Table */


#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits  27
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits  27
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start  101
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start  101
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoCLIPBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 101;
   case 45: return 101;
   case 40: return 101;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to GS Binding Table */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoGSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 69;
   case 50: return 69;
   case 45: return 69;
   case 40: return 69;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to PS Binding Table */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  101
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  165
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  165
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start  165

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoPSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 101;
   case 50: return 165;
   case 45: return 165;
   case 40: return 165;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to SF Binding Table */


#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits  27
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits  27
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start  133
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start  133
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start  133

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoSFBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 133;
   case 45: return 133;
   case 40: return 133;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::Pointer to VS Binding Table */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37
#define GFX5_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37
#define GFX45_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37
#define GFX4_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PointertoVSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 37;
   case 50: return 37;
   case 45: return 37;
   case 40: return 37;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS::VS Binding Table Change */


#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VSBindingTableChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_DS::Pointer to DS Binding Table */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_DS_PointertoDSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 37;
   case 120: return 37;
   case 110: return 37;
   case 90: return 37;
   case 80: return 37;
   case 75: return 37;
   case 70: return 37;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_GS::Pointer to GS Binding Table */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_GS_PointertoGSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 37;
   case 120: return 37;
   case 110: return 37;
   case 90: return 37;
   case 80: return 37;
   case 75: return 37;
   case 70: return 37;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_HS::Pointer to HS Binding Table */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_HS_PointertoHSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 37;
   case 120: return 37;
   case 110: return 37;
   case 90: return 37;
   case 80: return 37;
   case 75: return 37;
   case 70: return 37;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_PS::Pointer to PS Binding Table */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_PS_PointertoPSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 37;
   case 120: return 37;
   case 110: return 37;
   case 90: return 37;
   case 80: return 37;
   case 75: return 37;
   case 70: return 37;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POINTERS_VS::Pointer to VS Binding Table */


#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  16
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GFX12_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GFX11_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GFX9_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GFX8_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GFX75_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37
#define GFX7_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POINTERS_VS_PointertoVSBindingTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 37;
   case 120: return 37;
   case 110: return 37;
   case 90: return 37;
   case 80: return 37;
   case 75: return 37;
   case 70: return 37;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  4
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::3D Command Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::3D Command Sub Opcode */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Base Address */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  52
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 52;
   case 120: return 52;
   case 110: return 52;
   case 90: return 52;
   case 80: return 52;
   case 75: return 20;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Buffer Size */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 20;
   case 120: return 20;
   case 110: return 20;
   case 90: return 20;
   case 80: return 20;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start  108

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolBufferSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 108;
   case 120: return 108;
   case 110: return 108;
   case 90: return 108;
   case 80: return 108;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Enable */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start  43

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 43;
   case 120: return 43;
   case 110: return 43;
   case 90: return 43;
   case 80: return 43;
   case 75: return 43;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Binding Table Pool Upper Bound */


#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 20;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_start  76

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_BindingTablePoolUpperBound_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 76;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Command SubType */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::Command Type */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::DWord Length */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BINDING_TABLE_POOL_ALLOC::MOCS */


#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits  7
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits  7
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits  7
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits  7
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits  7
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start  32
#define GFX12_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start  32
#define GFX11_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start  32
#define GFX9_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start  32
#define GFX8_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start  32
#define GFX75_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start  39

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BINDING_TABLE_POOL_ALLOC_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 39;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_length  2
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::3D Command Opcode */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::3D Command Sub Opcode */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Blend State Pointer */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 26;
   case 120: return 26;
   case 110: return 26;
   case 90: return 26;
   case 80: return 26;
   case 75: return 26;
   case 70: return 26;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 38;
   case 120: return 38;
   case 110: return 38;
   case 90: return 38;
   case 80: return 38;
   case 75: return 38;
   case 70: return 38;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Blend State Pointer Valid */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_BlendStatePointerValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Command SubType */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::Command Type */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_BLEND_STATE_POINTERS::DWord Length */


#define GFX125_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GFX12_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GFX11_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GFX9_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GFX8_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GFX75_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0
#define GFX7_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_BLEND_STATE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS */


#define GFX125_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX12_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX11_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX9_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX8_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX75_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX7_3DSTATE_CC_STATE_POINTERS_length  2
#define GFX6_3DSTATE_CC_STATE_POINTERS_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::3D Command Opcode */


#define GFX125_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::BLEND_STATE Change */


#define GFX6_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_BLEND_STATEChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Color Calc State Pointer */


#define GFX125_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX12_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX11_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX75_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX7_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26
#define GFX6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 26;
   case 120: return 26;
   case 110: return 26;
   case 90: return 26;
   case 80: return 26;
   case 75: return 26;
   case 70: return 26;
   case 60: return 26;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX12_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX11_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX75_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX7_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  38
#define GFX6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 38;
   case 120: return 38;
   case 110: return 38;
   case 90: return 38;
   case 80: return 38;
   case 75: return 38;
   case 70: return 38;
   case 60: return 102;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Color Calc State Pointer Valid */


#define GFX125_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GFX12_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GFX11_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GFX9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GFX8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1
#define GFX6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GFX12_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GFX11_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GFX9_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GFX8_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  32
#define GFX6_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_ColorCalcStatePointerValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 0;
   case 70: return 0;
   case 60: return 96;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Command SubType */


#define GFX125_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX12_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX11_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX9_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX8_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX75_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX7_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2
#define GFX6_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX12_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX11_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX9_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX8_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX75_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX7_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27
#define GFX6_3DSTATE_CC_STATE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Command Type */


#define GFX125_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX12_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX11_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX9_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX8_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX75_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX7_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3
#define GFX6_3DSTATE_CC_STATE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX12_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX11_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX9_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX8_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX75_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX7_3DSTATE_CC_STATE_POINTERS_CommandType_start  29
#define GFX6_3DSTATE_CC_STATE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::DEPTH_STENCIL_STATE Change */


#define GFX6_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DEPTH_STENCIL_STATEChange_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 64;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::DWord Length */


#define GFX125_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX12_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX11_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX9_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX8_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX75_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX7_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8
#define GFX6_3DSTATE_CC_STATE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX12_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX11_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX9_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX8_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX75_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX7_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0
#define GFX6_3DSTATE_CC_STATE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Pointer to BLEND_STATE */


#define GFX6_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 26;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoBLEND_STATE_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 38;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CC_STATE_POINTERS::Pointer to DEPTH_STENCIL_STATE */


#define GFX6_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 26;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CC_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 70;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY */


#define GFX125_3DSTATE_CHROMA_KEY_length  4
#define GFX12_3DSTATE_CHROMA_KEY_length  4
#define GFX11_3DSTATE_CHROMA_KEY_length  4
#define GFX9_3DSTATE_CHROMA_KEY_length  4
#define GFX8_3DSTATE_CHROMA_KEY_length  4
#define GFX75_3DSTATE_CHROMA_KEY_length  4
#define GFX7_3DSTATE_CHROMA_KEY_length  4
#define GFX6_3DSTATE_CHROMA_KEY_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::3D Command Opcode */


#define GFX125_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CHROMA_KEY_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::3D Command Sub Opcode */


#define GFX125_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::ChromaKey High Value */


#define GFX125_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX12_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX11_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX9_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX8_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX75_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX7_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32
#define GFX6_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX12_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX11_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX9_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX8_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX75_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX7_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96
#define GFX6_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyHighValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 96;
   case 120: return 96;
   case 110: return 96;
   case 90: return 96;
   case 80: return 96;
   case 75: return 96;
   case 70: return 96;
   case 60: return 96;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::ChromaKey Low Value */


#define GFX125_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX12_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX11_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX9_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX8_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX75_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX7_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32
#define GFX6_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX12_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX11_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX9_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX8_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX75_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX7_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64
#define GFX6_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyLowValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::ChromaKey Table Index */


#define GFX125_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX12_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX11_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX9_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX8_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX75_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX7_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2
#define GFX6_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX12_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX11_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX9_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX8_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX75_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX7_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62
#define GFX6_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start  62

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_ChromaKeyTableIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 62;
   case 120: return 62;
   case 110: return 62;
   case 90: return 62;
   case 80: return 62;
   case 75: return 62;
   case 70: return 62;
   case 60: return 62;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::Command SubType */


#define GFX125_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX12_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX11_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX9_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX8_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX75_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX7_3DSTATE_CHROMA_KEY_CommandSubType_bits  2
#define GFX6_3DSTATE_CHROMA_KEY_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX12_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX11_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX9_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX8_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX75_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX7_3DSTATE_CHROMA_KEY_CommandSubType_start  27
#define GFX6_3DSTATE_CHROMA_KEY_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::Command Type */


#define GFX125_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX12_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX11_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX9_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX8_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX75_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX7_3DSTATE_CHROMA_KEY_CommandType_bits  3
#define GFX6_3DSTATE_CHROMA_KEY_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX12_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX11_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX9_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX8_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX75_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX7_3DSTATE_CHROMA_KEY_CommandType_start  29
#define GFX6_3DSTATE_CHROMA_KEY_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CHROMA_KEY::DWord Length */


#define GFX125_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX12_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX11_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX9_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX8_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX75_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX7_3DSTATE_CHROMA_KEY_DWordLength_bits  8
#define GFX6_3DSTATE_CHROMA_KEY_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX12_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX11_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX9_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX8_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX75_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX7_3DSTATE_CHROMA_KEY_DWordLength_start  0
#define GFX6_3DSTATE_CHROMA_KEY_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CHROMA_KEY_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS */


#define GFX125_3DSTATE_CLEAR_PARAMS_length  3
#define GFX12_3DSTATE_CLEAR_PARAMS_length  3
#define GFX11_3DSTATE_CLEAR_PARAMS_length  3
#define GFX9_3DSTATE_CLEAR_PARAMS_length  3
#define GFX8_3DSTATE_CLEAR_PARAMS_length  3
#define GFX75_3DSTATE_CLEAR_PARAMS_length  3
#define GFX7_3DSTATE_CLEAR_PARAMS_length  3
#define GFX6_3DSTATE_CLEAR_PARAMS_length  2
#define GFX5_3DSTATE_CLEAR_PARAMS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 2;
   case 50: return 2;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::3D Command Opcode */


#define GFX125_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24
#define GFX5_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Command SubType */


#define GFX125_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX12_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX11_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX9_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX8_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX75_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX7_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX6_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2
#define GFX5_3DSTATE_CLEAR_PARAMS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 2;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX12_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX11_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX9_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX8_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX75_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX7_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX6_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27
#define GFX5_3DSTATE_CLEAR_PARAMS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 27;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Command Type */


#define GFX125_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX12_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX11_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX9_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX8_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX75_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX7_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX6_3DSTATE_CLEAR_PARAMS_CommandType_bits  3
#define GFX5_3DSTATE_CLEAR_PARAMS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX12_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX11_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX9_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX8_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX75_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX7_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX6_3DSTATE_CLEAR_PARAMS_CommandType_start  29
#define GFX5_3DSTATE_CLEAR_PARAMS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 29;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::DWord Length */


#define GFX125_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX12_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX11_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX9_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX8_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX75_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX7_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX6_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8
#define GFX5_3DSTATE_CLEAR_PARAMS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX12_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX11_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX9_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX8_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX75_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX7_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX6_3DSTATE_CLEAR_PARAMS_DWordLength_start  0
#define GFX5_3DSTATE_CLEAR_PARAMS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Depth Clear Value */


#define GFX125_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX12_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX11_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX9_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX8_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX75_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX7_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX6_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32
#define GFX5_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX12_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX11_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX9_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX8_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX75_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX7_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX6_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32
#define GFX5_3DSTATE_CLEAR_PARAMS_DepthClearValue_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLEAR_PARAMS::Depth Clear Value Valid */


#define GFX125_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX12_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX11_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX9_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX8_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX75_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX7_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX6_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1
#define GFX5_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 1;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX12_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX11_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX9_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX8_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX75_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX7_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  64
#define GFX6_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  15
#define GFX5_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLEAR_PARAMS_DepthClearValueValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 15;
   case 50: return 15;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP */


#define GFX125_3DSTATE_CLIP_length  4
#define GFX12_3DSTATE_CLIP_length  4
#define GFX11_3DSTATE_CLIP_length  4
#define GFX9_3DSTATE_CLIP_length  4
#define GFX8_3DSTATE_CLIP_length  4
#define GFX75_3DSTATE_CLIP_length  4
#define GFX7_3DSTATE_CLIP_length  4
#define GFX6_3DSTATE_CLIP_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::3D Command Opcode */


#define GFX125_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CLIP_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CLIP_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CLIP_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CLIP_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::3D Command Sub Opcode */


#define GFX125_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CLIP_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CLIP_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CLIP_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CLIP_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::API Mode */


#define GFX125_3DSTATE_CLIP_APIMode_bits  1
#define GFX12_3DSTATE_CLIP_APIMode_bits  1
#define GFX11_3DSTATE_CLIP_APIMode_bits  1
#define GFX9_3DSTATE_CLIP_APIMode_bits  1
#define GFX8_3DSTATE_CLIP_APIMode_bits  1
#define GFX75_3DSTATE_CLIP_APIMode_bits  1
#define GFX7_3DSTATE_CLIP_APIMode_bits  1
#define GFX6_3DSTATE_CLIP_APIMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_APIMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_APIMode_start  94
#define GFX12_3DSTATE_CLIP_APIMode_start  94
#define GFX11_3DSTATE_CLIP_APIMode_start  94
#define GFX9_3DSTATE_CLIP_APIMode_start  94
#define GFX8_3DSTATE_CLIP_APIMode_start  94
#define GFX75_3DSTATE_CLIP_APIMode_start  94
#define GFX7_3DSTATE_CLIP_APIMode_start  94
#define GFX6_3DSTATE_CLIP_APIMode_start  94

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_APIMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 94;
   case 120: return 94;
   case 110: return 94;
   case 90: return 94;
   case 80: return 94;
   case 75: return 94;
   case 70: return 94;
   case 60: return 94;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Clip Enable */


#define GFX125_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX12_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX11_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX9_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX8_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX75_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX7_3DSTATE_CLIP_ClipEnable_bits  1
#define GFX6_3DSTATE_CLIP_ClipEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ClipEnable_start  95
#define GFX12_3DSTATE_CLIP_ClipEnable_start  95
#define GFX11_3DSTATE_CLIP_ClipEnable_start  95
#define GFX9_3DSTATE_CLIP_ClipEnable_start  95
#define GFX8_3DSTATE_CLIP_ClipEnable_start  95
#define GFX75_3DSTATE_CLIP_ClipEnable_start  95
#define GFX7_3DSTATE_CLIP_ClipEnable_start  95
#define GFX6_3DSTATE_CLIP_ClipEnable_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 95;
   case 120: return 95;
   case 110: return 95;
   case 90: return 95;
   case 80: return 95;
   case 75: return 95;
   case 70: return 95;
   case 60: return 95;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Clip Mode */


#define GFX125_3DSTATE_CLIP_ClipMode_bits  3
#define GFX12_3DSTATE_CLIP_ClipMode_bits  3
#define GFX11_3DSTATE_CLIP_ClipMode_bits  3
#define GFX9_3DSTATE_CLIP_ClipMode_bits  3
#define GFX8_3DSTATE_CLIP_ClipMode_bits  3
#define GFX75_3DSTATE_CLIP_ClipMode_bits  3
#define GFX7_3DSTATE_CLIP_ClipMode_bits  3
#define GFX6_3DSTATE_CLIP_ClipMode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ClipMode_start  77
#define GFX12_3DSTATE_CLIP_ClipMode_start  77
#define GFX11_3DSTATE_CLIP_ClipMode_start  77
#define GFX9_3DSTATE_CLIP_ClipMode_start  77
#define GFX8_3DSTATE_CLIP_ClipMode_start  77
#define GFX75_3DSTATE_CLIP_ClipMode_start  77
#define GFX7_3DSTATE_CLIP_ClipMode_start  77
#define GFX6_3DSTATE_CLIP_ClipMode_start  77

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ClipMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 77;
   case 120: return 77;
   case 110: return 77;
   case 90: return 77;
   case 80: return 77;
   case 75: return 77;
   case 70: return 77;
   case 60: return 77;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Command SubType */


#define GFX125_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX12_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX11_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX9_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX8_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX75_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX7_3DSTATE_CLIP_CommandSubType_bits  2
#define GFX6_3DSTATE_CLIP_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_CommandSubType_start  27
#define GFX12_3DSTATE_CLIP_CommandSubType_start  27
#define GFX11_3DSTATE_CLIP_CommandSubType_start  27
#define GFX9_3DSTATE_CLIP_CommandSubType_start  27
#define GFX8_3DSTATE_CLIP_CommandSubType_start  27
#define GFX75_3DSTATE_CLIP_CommandSubType_start  27
#define GFX7_3DSTATE_CLIP_CommandSubType_start  27
#define GFX6_3DSTATE_CLIP_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Command Type */


#define GFX125_3DSTATE_CLIP_CommandType_bits  3
#define GFX12_3DSTATE_CLIP_CommandType_bits  3
#define GFX11_3DSTATE_CLIP_CommandType_bits  3
#define GFX9_3DSTATE_CLIP_CommandType_bits  3
#define GFX8_3DSTATE_CLIP_CommandType_bits  3
#define GFX75_3DSTATE_CLIP_CommandType_bits  3
#define GFX7_3DSTATE_CLIP_CommandType_bits  3
#define GFX6_3DSTATE_CLIP_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_CommandType_start  29
#define GFX12_3DSTATE_CLIP_CommandType_start  29
#define GFX11_3DSTATE_CLIP_CommandType_start  29
#define GFX9_3DSTATE_CLIP_CommandType_start  29
#define GFX8_3DSTATE_CLIP_CommandType_start  29
#define GFX75_3DSTATE_CLIP_CommandType_start  29
#define GFX7_3DSTATE_CLIP_CommandType_start  29
#define GFX6_3DSTATE_CLIP_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Cull Mode */


#define GFX75_3DSTATE_CLIP_CullMode_bits  2
#define GFX7_3DSTATE_CLIP_CullMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CullMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_CLIP_CullMode_start  48
#define GFX7_3DSTATE_CLIP_CullMode_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_CullMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 48;
   case 70: return 48;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::DWord Length */


#define GFX125_3DSTATE_CLIP_DWordLength_bits  8
#define GFX12_3DSTATE_CLIP_DWordLength_bits  8
#define GFX11_3DSTATE_CLIP_DWordLength_bits  8
#define GFX9_3DSTATE_CLIP_DWordLength_bits  8
#define GFX8_3DSTATE_CLIP_DWordLength_bits  8
#define GFX75_3DSTATE_CLIP_DWordLength_bits  8
#define GFX7_3DSTATE_CLIP_DWordLength_bits  8
#define GFX6_3DSTATE_CLIP_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_DWordLength_start  0
#define GFX12_3DSTATE_CLIP_DWordLength_start  0
#define GFX11_3DSTATE_CLIP_DWordLength_start  0
#define GFX9_3DSTATE_CLIP_DWordLength_start  0
#define GFX8_3DSTATE_CLIP_DWordLength_start  0
#define GFX75_3DSTATE_CLIP_DWordLength_start  0
#define GFX7_3DSTATE_CLIP_DWordLength_start  0
#define GFX6_3DSTATE_CLIP_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Early Cull Enable */


#define GFX125_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GFX12_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GFX11_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GFX9_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GFX8_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GFX75_3DSTATE_CLIP_EarlyCullEnable_bits  1
#define GFX7_3DSTATE_CLIP_EarlyCullEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_EarlyCullEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GFX12_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GFX11_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GFX9_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GFX8_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GFX75_3DSTATE_CLIP_EarlyCullEnable_start  50
#define GFX7_3DSTATE_CLIP_EarlyCullEnable_start  50

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_EarlyCullEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 50;
   case 120: return 50;
   case 110: return 50;
   case 90: return 50;
   case 80: return 50;
   case 75: return 50;
   case 70: return 50;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force Clip Mode */


#define GFX125_3DSTATE_CLIP_ForceClipMode_bits  1
#define GFX12_3DSTATE_CLIP_ForceClipMode_bits  1
#define GFX11_3DSTATE_CLIP_ForceClipMode_bits  1
#define GFX9_3DSTATE_CLIP_ForceClipMode_bits  1
#define GFX8_3DSTATE_CLIP_ForceClipMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceClipMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ForceClipMode_start  48
#define GFX12_3DSTATE_CLIP_ForceClipMode_start  48
#define GFX11_3DSTATE_CLIP_ForceClipMode_start  48
#define GFX9_3DSTATE_CLIP_ForceClipMode_start  48
#define GFX8_3DSTATE_CLIP_ForceClipMode_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceClipMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force User Clip Distance Clip Test Enable Bitmask */


#define GFX125_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1
#define GFX12_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1
#define GFX11_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1
#define GFX9_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1
#define GFX8_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49
#define GFX12_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49
#define GFX11_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49
#define GFX9_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49
#define GFX8_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start  49

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 49;
   case 120: return 49;
   case 110: return 49;
   case 90: return 49;
   case 80: return 49;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force User Clip Distance Cull Test Enable Bitmask */


#define GFX125_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1
#define GFX12_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1
#define GFX11_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1
#define GFX9_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1
#define GFX8_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52
#define GFX12_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52
#define GFX11_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52
#define GFX9_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52
#define GFX8_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start  52

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceUserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 52;
   case 120: return 52;
   case 110: return 52;
   case 90: return 52;
   case 80: return 52;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Force Zero RTA Index Enable */


#define GFX125_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX12_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX11_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX9_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX8_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX75_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX7_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1
#define GFX6_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceZeroRTAIndexEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX12_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX11_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX9_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX8_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX75_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX7_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101
#define GFX6_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ForceZeroRTAIndexEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 101;
   case 120: return 101;
   case 110: return 101;
   case 90: return 101;
   case 80: return 101;
   case 75: return 101;
   case 70: return 101;
   case 60: return 101;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Front Winding */


#define GFX75_3DSTATE_CLIP_FrontWinding_bits  1
#define GFX7_3DSTATE_CLIP_FrontWinding_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_FrontWinding_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_CLIP_FrontWinding_start  52
#define GFX7_3DSTATE_CLIP_FrontWinding_start  52

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_FrontWinding_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 52;
   case 70: return 52;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Guardband Clip Test Enable */


#define GFX125_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX12_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX11_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX9_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX8_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX75_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX7_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1
#define GFX6_3DSTATE_CLIP_GuardbandClipTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_GuardbandClipTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX12_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX11_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX9_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX8_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX75_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX7_3DSTATE_CLIP_GuardbandClipTestEnable_start  90
#define GFX6_3DSTATE_CLIP_GuardbandClipTestEnable_start  90

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_GuardbandClipTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 90;
   case 120: return 90;
   case 110: return 90;
   case 90: return 90;
   case 80: return 90;
   case 75: return 90;
   case 70: return 90;
   case 60: return 90;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Line Strip/List Provoking Vertex Select */


#define GFX125_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX12_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX11_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX9_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX8_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX75_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX7_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2
#define GFX6_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_LineStripListProvokingVertexSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX12_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX11_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX9_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX8_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX75_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX7_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66
#define GFX6_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start  66

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_LineStripListProvokingVertexSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 66;
   case 120: return 66;
   case 110: return 66;
   case 90: return 66;
   case 80: return 66;
   case 75: return 66;
   case 70: return 66;
   case 60: return 66;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Maximum Point Width */


#define GFX125_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX12_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX11_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX9_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX8_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX75_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX7_3DSTATE_CLIP_MaximumPointWidth_bits  11
#define GFX6_3DSTATE_CLIP_MaximumPointWidth_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumPointWidth_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 11;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX12_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX11_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX9_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX8_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX75_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX7_3DSTATE_CLIP_MaximumPointWidth_start  102
#define GFX6_3DSTATE_CLIP_MaximumPointWidth_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumPointWidth_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 102;
   case 120: return 102;
   case 110: return 102;
   case 90: return 102;
   case 80: return 102;
   case 75: return 102;
   case 70: return 102;
   case 60: return 102;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Maximum VP Index */


#define GFX125_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX12_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX11_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX9_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX8_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX75_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX7_3DSTATE_CLIP_MaximumVPIndex_bits  4
#define GFX6_3DSTATE_CLIP_MaximumVPIndex_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumVPIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX12_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX11_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX9_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX8_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX75_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX7_3DSTATE_CLIP_MaximumVPIndex_start  96
#define GFX6_3DSTATE_CLIP_MaximumVPIndex_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MaximumVPIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 96;
   case 120: return 96;
   case 110: return 96;
   case 90: return 96;
   case 80: return 96;
   case 75: return 96;
   case 70: return 96;
   case 60: return 96;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Minimum Point Width */


#define GFX125_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX12_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX11_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX9_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX8_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX75_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX7_3DSTATE_CLIP_MinimumPointWidth_bits  11
#define GFX6_3DSTATE_CLIP_MinimumPointWidth_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MinimumPointWidth_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 11;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX12_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX11_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX9_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX8_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX75_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX7_3DSTATE_CLIP_MinimumPointWidth_start  113
#define GFX6_3DSTATE_CLIP_MinimumPointWidth_start  113

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_MinimumPointWidth_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 113;
   case 120: return 113;
   case 110: return 113;
   case 90: return 113;
   case 80: return 113;
   case 75: return 113;
   case 70: return 113;
   case 60: return 113;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Non-Perspective Barycentric Enable */


#define GFX125_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX12_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX11_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX9_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX8_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX75_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX7_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1
#define GFX6_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX12_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX11_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX9_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX8_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX75_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX7_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72
#define GFX6_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start  72

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_NonPerspectiveBarycentricEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 72;
   case 120: return 72;
   case 110: return 72;
   case 90: return 72;
   case 80: return 72;
   case 75: return 72;
   case 70: return 72;
   case 60: return 72;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Perspective Divide Disable */


#define GFX125_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX12_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX11_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX9_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX8_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX75_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX7_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1
#define GFX6_3DSTATE_CLIP_PerspectiveDivideDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_PerspectiveDivideDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX12_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX11_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX9_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX8_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX75_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX7_3DSTATE_CLIP_PerspectiveDivideDisable_start  73
#define GFX6_3DSTATE_CLIP_PerspectiveDivideDisable_start  73

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_PerspectiveDivideDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 73;
   case 120: return 73;
   case 110: return 73;
   case 90: return 73;
   case 80: return 73;
   case 75: return 73;
   case 70: return 73;
   case 60: return 73;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Statistics Enable */


#define GFX125_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX12_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX11_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX9_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX8_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX75_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX7_3DSTATE_CLIP_StatisticsEnable_bits  1
#define GFX6_3DSTATE_CLIP_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX12_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX11_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX9_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX8_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX75_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX7_3DSTATE_CLIP_StatisticsEnable_start  42
#define GFX6_3DSTATE_CLIP_StatisticsEnable_start  42

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 42;
   case 120: return 42;
   case 110: return 42;
   case 90: return 42;
   case 80: return 42;
   case 75: return 42;
   case 70: return 42;
   case 60: return 42;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Triangle Fan Provoking Vertex Select */


#define GFX125_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX12_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX11_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX9_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX8_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX75_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX7_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2
#define GFX6_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX12_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX11_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX9_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX8_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX75_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX7_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64
#define GFX6_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleFanProvokingVertexSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Triangle Strip/List Provoking Vertex Select */


#define GFX125_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX12_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX11_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX9_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX8_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX75_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX7_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2
#define GFX6_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX12_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX11_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX9_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX8_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX75_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX7_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68
#define GFX6_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start  68

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_TriangleStripListProvokingVertexSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 68;
   case 120: return 68;
   case 110: return 68;
   case 90: return 68;
   case 80: return 68;
   case 75: return 68;
   case 70: return 68;
   case 60: return 68;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::User Clip Distance Clip Test Enable Bitmask */


#define GFX125_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX12_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX11_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX9_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX8_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX75_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX7_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX6_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX12_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX11_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX9_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX8_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX75_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX7_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80
#define GFX6_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 80;
   case 120: return 80;
   case 110: return 80;
   case 90: return 80;
   case 80: return 80;
   case 75: return 80;
   case 70: return 80;
   case 60: return 80;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::User Clip Distance Cull Test Enable Bitmask */


#define GFX125_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX12_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX11_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX9_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX8_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX75_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX7_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX6_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX12_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX11_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX9_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX8_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX75_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX7_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32
#define GFX6_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_UserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Vertex Sub Pixel Precision Select */


#define GFX125_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GFX12_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GFX11_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GFX9_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GFX8_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GFX75_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1
#define GFX7_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GFX12_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GFX11_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GFX9_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GFX8_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GFX75_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51
#define GFX7_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start  51

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_VertexSubPixelPrecisionSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 51;
   case 120: return 51;
   case 110: return 51;
   case 90: return 51;
   case 80: return 51;
   case 75: return 51;
   case 70: return 51;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Viewport XY Clip Test Enable */


#define GFX125_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX12_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX11_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX9_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX8_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX75_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX7_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1
#define GFX6_3DSTATE_CLIP_ViewportXYClipTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportXYClipTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX12_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX11_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX9_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX8_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX75_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX7_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92
#define GFX6_3DSTATE_CLIP_ViewportXYClipTestEnable_start  92

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportXYClipTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 92;
   case 120: return 92;
   case 110: return 92;
   case 90: return 92;
   case 80: return 92;
   case 75: return 92;
   case 70: return 92;
   case 60: return 92;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CLIP::Viewport Z Clip Test Enable */


#define GFX75_3DSTATE_CLIP_ViewportZClipTestEnable_bits  1
#define GFX7_3DSTATE_CLIP_ViewportZClipTestEnable_bits  1
#define GFX6_3DSTATE_CLIP_ViewportZClipTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportZClipTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_CLIP_ViewportZClipTestEnable_start  91
#define GFX7_3DSTATE_CLIP_ViewportZClipTestEnable_start  91
#define GFX6_3DSTATE_CLIP_ViewportZClipTestEnable_start  91

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CLIP_ViewportZClipTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 91;
   case 70: return 91;
   case 60: return 91;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL */


#define GFX125_3DSTATE_CONSTANT_ALL_length  2
#define GFX12_3DSTATE_CONSTANT_ALL_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::3D Command Opcode */


#define GFX125_3DSTATE_CONSTANT_ALL_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CONSTANT_ALL_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CONSTANT_ALL_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::3D Command Sub Opcode */


#define GFX125_3DSTATE_CONSTANT_ALL_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CONSTANT_ALL_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CONSTANT_ALL_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Command SubType */


#define GFX125_3DSTATE_CONSTANT_ALL_CommandSubType_bits  2
#define GFX12_3DSTATE_CONSTANT_ALL_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_CommandSubType_start  27
#define GFX12_3DSTATE_CONSTANT_ALL_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Command Type */


#define GFX125_3DSTATE_CONSTANT_ALL_CommandType_bits  3
#define GFX12_3DSTATE_CONSTANT_ALL_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_CommandType_start  29
#define GFX12_3DSTATE_CONSTANT_ALL_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::DWord Length */


#define GFX125_3DSTATE_CONSTANT_ALL_DWordLength_bits  8
#define GFX12_3DSTATE_CONSTANT_ALL_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_DWordLength_start  0
#define GFX12_3DSTATE_CONSTANT_ALL_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Domain Shader Update Enable */


#define GFX125_3DSTATE_CONSTANT_ALL_DomainShaderUpdateEnable_bits  1
#define GFX12_3DSTATE_CONSTANT_ALL_DomainShaderUpdateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DomainShaderUpdateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_DomainShaderUpdateEnable_start  10
#define GFX12_3DSTATE_CONSTANT_ALL_DomainShaderUpdateEnable_start  10

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DomainShaderUpdateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 10;
   case 120: return 10;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Geometry Shader Update Enable */


#define GFX125_3DSTATE_CONSTANT_ALL_GeometryShaderUpdateEnable_bits  1
#define GFX12_3DSTATE_CONSTANT_ALL_GeometryShaderUpdateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_GeometryShaderUpdateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_GeometryShaderUpdateEnable_start  11
#define GFX12_3DSTATE_CONSTANT_ALL_GeometryShaderUpdateEnable_start  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_GeometryShaderUpdateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Hull Shader Update Enable */


#define GFX125_3DSTATE_CONSTANT_ALL_HullShaderUpdateEnable_bits  1
#define GFX12_3DSTATE_CONSTANT_ALL_HullShaderUpdateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_HullShaderUpdateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_HullShaderUpdateEnable_start  9
#define GFX12_3DSTATE_CONSTANT_ALL_HullShaderUpdateEnable_start  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_HullShaderUpdateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::MOCS */


#define GFX125_3DSTATE_CONSTANT_ALL_MOCS_bits  7
#define GFX12_3DSTATE_CONSTANT_ALL_MOCS_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_MOCS_start  32
#define GFX12_3DSTATE_CONSTANT_ALL_MOCS_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Pixel Shader Update Enable */


#define GFX125_3DSTATE_CONSTANT_ALL_PixelShaderUpdateEnable_bits  1
#define GFX12_3DSTATE_CONSTANT_ALL_PixelShaderUpdateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_PixelShaderUpdateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_PixelShaderUpdateEnable_start  12
#define GFX12_3DSTATE_CONSTANT_ALL_PixelShaderUpdateEnable_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_PixelShaderUpdateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 12;
   case 120: return 12;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Pointer Buffer Mask */


#define GFX125_3DSTATE_CONSTANT_ALL_PointerBufferMask_bits  4
#define GFX12_3DSTATE_CONSTANT_ALL_PointerBufferMask_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_PointerBufferMask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_PointerBufferMask_start  48
#define GFX12_3DSTATE_CONSTANT_ALL_PointerBufferMask_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_PointerBufferMask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Shader Update Enable */


#define GFX125_3DSTATE_CONSTANT_ALL_ShaderUpdateEnable_bits  5
#define GFX12_3DSTATE_CONSTANT_ALL_ShaderUpdateEnable_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_ShaderUpdateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_ShaderUpdateEnable_start  8
#define GFX12_3DSTATE_CONSTANT_ALL_ShaderUpdateEnable_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_ShaderUpdateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Update Mode */


#define GFX125_3DSTATE_CONSTANT_ALL_UpdateMode_bits  1
#define GFX12_3DSTATE_CONSTANT_ALL_UpdateMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_UpdateMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_UpdateMode_start  63
#define GFX12_3DSTATE_CONSTANT_ALL_UpdateMode_start  63

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_UpdateMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 63;
   case 120: return 63;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL::Vertex Shader Update Enable */


#define GFX125_3DSTATE_CONSTANT_ALL_VertexShaderUpdateEnable_bits  1
#define GFX12_3DSTATE_CONSTANT_ALL_VertexShaderUpdateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_VertexShaderUpdateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_VertexShaderUpdateEnable_start  8
#define GFX12_3DSTATE_CONSTANT_ALL_VertexShaderUpdateEnable_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_VertexShaderUpdateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL_DATA */


#define GFX125_3DSTATE_CONSTANT_ALL_DATA_length  2
#define GFX12_3DSTATE_CONSTANT_ALL_DATA_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DATA_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL_DATA::Constant Buffer Read Length */


#define GFX125_3DSTATE_CONSTANT_ALL_DATA_ConstantBufferReadLength_bits  5
#define GFX12_3DSTATE_CONSTANT_ALL_DATA_ConstantBufferReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DATA_ConstantBufferReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_DATA_ConstantBufferReadLength_start  0
#define GFX12_3DSTATE_CONSTANT_ALL_DATA_ConstantBufferReadLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DATA_ConstantBufferReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_ALL_DATA::Pointer To Constant Buffer */


#define GFX125_3DSTATE_CONSTANT_ALL_DATA_PointerToConstantBuffer_bits  59
#define GFX12_3DSTATE_CONSTANT_ALL_DATA_PointerToConstantBuffer_bits  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DATA_PointerToConstantBuffer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 59;
   case 120: return 59;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_ALL_DATA_PointerToConstantBuffer_start  5
#define GFX12_3DSTATE_CONSTANT_ALL_DATA_PointerToConstantBuffer_start  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_ALL_DATA_PointerToConstantBuffer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY */


#define GFX125_3DSTATE_CONSTANT_BODY_length  10
#define GFX12_3DSTATE_CONSTANT_BODY_length  10
#define GFX11_3DSTATE_CONSTANT_BODY_length  10
#define GFX9_3DSTATE_CONSTANT_BODY_length  10
#define GFX8_3DSTATE_CONSTANT_BODY_length  10
#define GFX75_3DSTATE_CONSTANT_BODY_length  6
#define GFX7_3DSTATE_CONSTANT_BODY_length  6
#define GFX6_3DSTATE_CONSTANT_BODY_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 10;
   case 120: return 10;
   case 110: return 10;
   case 90: return 10;
   case 80: return 10;
   case 75: return 6;
   case 70: return 6;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Constant Buffer 0 Read Length */


#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer0ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer0ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer0ReadLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer0ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Constant Buffer 1 Read Length */


#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer1ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer1ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer1ReadLength_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer1ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Constant Buffer 2 Read Length */


#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer2ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer2ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer2ReadLength_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer2ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 64;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Constant Buffer 3 Read Length */


#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer3ReadLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer3ReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_ConstantBuffer3ReadLength_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_ConstantBuffer3ReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 96;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::MOCS */


#define GFX75_3DSTATE_CONSTANT_BODY_MOCS_bits  5
#define GFX7_3DSTATE_CONSTANT_BODY_MOCS_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 5;
   case 70: return 5;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_CONSTANT_BODY_MOCS_start  64
#define GFX7_3DSTATE_CONSTANT_BODY_MOCS_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 64;
   case 70: return 64;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Pointer to Constant Buffer 0 */


#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer0_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer0_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer0_start  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer0_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Pointer to Constant Buffer 1 */


#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer1_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer1_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer1_start  37

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer1_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 37;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Pointer to Constant Buffer 2 */


#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer2_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer2_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer2_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer2_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 69;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_BODY::Pointer to Constant Buffer 3 */


#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer3_bits  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer3_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer3_start  101

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_BODY_PointertoConstantBuffer3_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 101;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR */


#define GFX5_3DSTATE_CONSTANT_COLOR_length  5
#define GFX45_3DSTATE_CONSTANT_COLOR_length  5
#define GFX4_3DSTATE_CONSTANT_COLOR_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 5;
   case 45: return 5;
   case 40: return 5;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::3D Command Opcode */


#define GFX5_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits  3
#define GFX4_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start  24
#define GFX45_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start  24
#define GFX4_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::3D Command Sub Opcode */


#define GFX5_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits  8
#define GFX4_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start  16
#define GFX4_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Alpha */


#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits  32
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits  32
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start  128
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start  128
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorAlpha_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 128;
   case 45: return 128;
   case 40: return 128;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Blue */


#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits  32
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits  32
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start  96
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start  96
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorBlue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 96;
   case 45: return 96;
   case 40: return 96;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Green */


#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits  32
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits  32
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start  64
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start  64
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorGreen_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 64;
   case 45: return 64;
   case 40: return 64;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Blend Constant Color Red */


#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits  32
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits  32
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start  32
#define GFX45_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start  32
#define GFX4_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_BlendConstantColorRed_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Command SubType */


#define GFX5_3DSTATE_CONSTANT_COLOR_CommandSubType_bits  2
#define GFX45_3DSTATE_CONSTANT_COLOR_CommandSubType_bits  2
#define GFX4_3DSTATE_CONSTANT_COLOR_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_CommandSubType_start  27
#define GFX45_3DSTATE_CONSTANT_COLOR_CommandSubType_start  27
#define GFX4_3DSTATE_CONSTANT_COLOR_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::Command Type */


#define GFX5_3DSTATE_CONSTANT_COLOR_CommandType_bits  3
#define GFX45_3DSTATE_CONSTANT_COLOR_CommandType_bits  3
#define GFX4_3DSTATE_CONSTANT_COLOR_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_CommandType_start  29
#define GFX45_3DSTATE_CONSTANT_COLOR_CommandType_start  29
#define GFX4_3DSTATE_CONSTANT_COLOR_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 29;
   case 45: return 29;
   case 40: return 29;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_COLOR::DWord Length */


#define GFX5_3DSTATE_CONSTANT_COLOR_DWordLength_bits  8
#define GFX45_3DSTATE_CONSTANT_COLOR_DWordLength_bits  8
#define GFX4_3DSTATE_CONSTANT_COLOR_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_CONSTANT_COLOR_DWordLength_start  0
#define GFX45_3DSTATE_CONSTANT_COLOR_DWordLength_start  0
#define GFX4_3DSTATE_CONSTANT_COLOR_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_COLOR_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS */


#define GFX125_3DSTATE_CONSTANT_DS_length  11
#define GFX12_3DSTATE_CONSTANT_DS_length  11
#define GFX11_3DSTATE_CONSTANT_DS_length  11
#define GFX9_3DSTATE_CONSTANT_DS_length  11
#define GFX8_3DSTATE_CONSTANT_DS_length  11
#define GFX75_3DSTATE_CONSTANT_DS_length  7
#define GFX7_3DSTATE_CONSTANT_DS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 7;
   case 70: return 7;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::3D Command Opcode */


#define GFX125_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CONSTANT_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Command SubType */


#define GFX125_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GFX12_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GFX11_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GFX9_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GFX8_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GFX75_3DSTATE_CONSTANT_DS_CommandSubType_bits  2
#define GFX7_3DSTATE_CONSTANT_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GFX12_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GFX11_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GFX9_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GFX8_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GFX75_3DSTATE_CONSTANT_DS_CommandSubType_start  27
#define GFX7_3DSTATE_CONSTANT_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Command Type */


#define GFX125_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GFX12_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GFX11_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GFX9_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GFX8_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GFX75_3DSTATE_CONSTANT_DS_CommandType_bits  3
#define GFX7_3DSTATE_CONSTANT_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GFX12_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GFX11_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GFX9_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GFX8_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GFX75_3DSTATE_CONSTANT_DS_CommandType_start  29
#define GFX7_3DSTATE_CONSTANT_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::Constant Body */


#define GFX125_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GFX12_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GFX11_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GFX9_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GFX8_3DSTATE_CONSTANT_DS_ConstantBody_bits  320
#define GFX75_3DSTATE_CONSTANT_DS_ConstantBody_bits  192
#define GFX7_3DSTATE_CONSTANT_DS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 320;
   case 120: return 320;
   case 110: return 320;
   case 90: return 320;
   case 80: return 320;
   case 75: return 192;
   case 70: return 192;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GFX12_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GFX11_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GFX9_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GFX8_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GFX75_3DSTATE_CONSTANT_DS_ConstantBody_start  32
#define GFX7_3DSTATE_CONSTANT_DS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::DWord Length */


#define GFX125_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GFX12_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GFX11_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GFX9_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GFX8_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GFX75_3DSTATE_CONSTANT_DS_DWordLength_bits  8
#define GFX7_3DSTATE_CONSTANT_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GFX12_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GFX11_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GFX9_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GFX8_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GFX75_3DSTATE_CONSTANT_DS_DWordLength_start  0
#define GFX7_3DSTATE_CONSTANT_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_DS::MOCS */


#define GFX125_3DSTATE_CONSTANT_DS_MOCS_bits  7
#define GFX12_3DSTATE_CONSTANT_DS_MOCS_bits  7
#define GFX11_3DSTATE_CONSTANT_DS_MOCS_bits  7
#define GFX9_3DSTATE_CONSTANT_DS_MOCS_bits  7
#define GFX8_3DSTATE_CONSTANT_DS_MOCS_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_DS_MOCS_start  8
#define GFX12_3DSTATE_CONSTANT_DS_MOCS_start  8
#define GFX11_3DSTATE_CONSTANT_DS_MOCS_start  8
#define GFX9_3DSTATE_CONSTANT_DS_MOCS_start  8
#define GFX8_3DSTATE_CONSTANT_DS_MOCS_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_DS_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS */


#define GFX125_3DSTATE_CONSTANT_GS_length  11
#define GFX12_3DSTATE_CONSTANT_GS_length  11
#define GFX11_3DSTATE_CONSTANT_GS_length  11
#define GFX9_3DSTATE_CONSTANT_GS_length  11
#define GFX8_3DSTATE_CONSTANT_GS_length  11
#define GFX75_3DSTATE_CONSTANT_GS_length  7
#define GFX7_3DSTATE_CONSTANT_GS_length  7
#define GFX6_3DSTATE_CONSTANT_GS_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 7;
   case 70: return 7;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::3D Command Opcode */


#define GFX125_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CONSTANT_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 0 Valid */


#define GFX6_3DSTATE_CONSTANT_GS_Buffer0Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer0Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_GS_Buffer0Valid_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer0Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 12;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 1 Valid */


#define GFX6_3DSTATE_CONSTANT_GS_Buffer1Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer1Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_GS_Buffer1Valid_start  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer1Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 13;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 2 Valid */


#define GFX6_3DSTATE_CONSTANT_GS_Buffer2Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer2Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_GS_Buffer2Valid_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer2Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 14;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Buffer 3 Valid */


#define GFX6_3DSTATE_CONSTANT_GS_Buffer3Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer3Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_GS_Buffer3Valid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_Buffer3Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 15;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Command SubType */


#define GFX125_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX12_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX11_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX9_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX8_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX75_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX7_3DSTATE_CONSTANT_GS_CommandSubType_bits  2
#define GFX6_3DSTATE_CONSTANT_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX12_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX11_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX9_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX8_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX75_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX7_3DSTATE_CONSTANT_GS_CommandSubType_start  27
#define GFX6_3DSTATE_CONSTANT_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Command Type */


#define GFX125_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX12_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX11_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX9_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX8_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX75_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX7_3DSTATE_CONSTANT_GS_CommandType_bits  3
#define GFX6_3DSTATE_CONSTANT_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX12_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX11_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX9_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX8_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX75_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX7_3DSTATE_CONSTANT_GS_CommandType_start  29
#define GFX6_3DSTATE_CONSTANT_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::Constant Body */


#define GFX125_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GFX12_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GFX11_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GFX9_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GFX8_3DSTATE_CONSTANT_GS_ConstantBody_bits  320
#define GFX75_3DSTATE_CONSTANT_GS_ConstantBody_bits  192
#define GFX7_3DSTATE_CONSTANT_GS_ConstantBody_bits  192
#define GFX6_3DSTATE_CONSTANT_GS_ConstantBody_bits  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 320;
   case 120: return 320;
   case 110: return 320;
   case 90: return 320;
   case 80: return 320;
   case 75: return 192;
   case 70: return 192;
   case 60: return 128;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX12_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX11_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX9_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX8_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX75_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX7_3DSTATE_CONSTANT_GS_ConstantBody_start  32
#define GFX6_3DSTATE_CONSTANT_GS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::DWord Length */


#define GFX125_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX12_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX11_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX9_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX8_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX75_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX7_3DSTATE_CONSTANT_GS_DWordLength_bits  8
#define GFX6_3DSTATE_CONSTANT_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX12_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX11_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX9_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX8_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX75_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX7_3DSTATE_CONSTANT_GS_DWordLength_start  0
#define GFX6_3DSTATE_CONSTANT_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_GS::MOCS */


#define GFX125_3DSTATE_CONSTANT_GS_MOCS_bits  7
#define GFX12_3DSTATE_CONSTANT_GS_MOCS_bits  7
#define GFX11_3DSTATE_CONSTANT_GS_MOCS_bits  7
#define GFX9_3DSTATE_CONSTANT_GS_MOCS_bits  7
#define GFX8_3DSTATE_CONSTANT_GS_MOCS_bits  7
#define GFX6_3DSTATE_CONSTANT_GS_MOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 0;
   case 70: return 0;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_GS_MOCS_start  8
#define GFX12_3DSTATE_CONSTANT_GS_MOCS_start  8
#define GFX11_3DSTATE_CONSTANT_GS_MOCS_start  8
#define GFX9_3DSTATE_CONSTANT_GS_MOCS_start  8
#define GFX8_3DSTATE_CONSTANT_GS_MOCS_start  8
#define GFX6_3DSTATE_CONSTANT_GS_MOCS_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_GS_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS */


#define GFX125_3DSTATE_CONSTANT_HS_length  11
#define GFX12_3DSTATE_CONSTANT_HS_length  11
#define GFX11_3DSTATE_CONSTANT_HS_length  11
#define GFX9_3DSTATE_CONSTANT_HS_length  11
#define GFX8_3DSTATE_CONSTANT_HS_length  11
#define GFX75_3DSTATE_CONSTANT_HS_length  7
#define GFX7_3DSTATE_CONSTANT_HS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 7;
   case 70: return 7;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::3D Command Opcode */


#define GFX125_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CONSTANT_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Command SubType */


#define GFX125_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GFX12_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GFX11_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GFX9_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GFX8_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GFX75_3DSTATE_CONSTANT_HS_CommandSubType_bits  2
#define GFX7_3DSTATE_CONSTANT_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GFX12_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GFX11_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GFX9_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GFX8_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GFX75_3DSTATE_CONSTANT_HS_CommandSubType_start  27
#define GFX7_3DSTATE_CONSTANT_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Command Type */


#define GFX125_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GFX12_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GFX11_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GFX9_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GFX8_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GFX75_3DSTATE_CONSTANT_HS_CommandType_bits  3
#define GFX7_3DSTATE_CONSTANT_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GFX12_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GFX11_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GFX9_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GFX8_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GFX75_3DSTATE_CONSTANT_HS_CommandType_start  29
#define GFX7_3DSTATE_CONSTANT_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::Constant Body */


#define GFX125_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GFX12_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GFX11_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GFX9_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GFX8_3DSTATE_CONSTANT_HS_ConstantBody_bits  320
#define GFX75_3DSTATE_CONSTANT_HS_ConstantBody_bits  192
#define GFX7_3DSTATE_CONSTANT_HS_ConstantBody_bits  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 320;
   case 120: return 320;
   case 110: return 320;
   case 90: return 320;
   case 80: return 320;
   case 75: return 192;
   case 70: return 192;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GFX12_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GFX11_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GFX9_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GFX8_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GFX75_3DSTATE_CONSTANT_HS_ConstantBody_start  32
#define GFX7_3DSTATE_CONSTANT_HS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::DWord Length */


#define GFX125_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GFX12_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GFX11_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GFX9_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GFX8_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GFX75_3DSTATE_CONSTANT_HS_DWordLength_bits  8
#define GFX7_3DSTATE_CONSTANT_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GFX12_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GFX11_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GFX9_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GFX8_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GFX75_3DSTATE_CONSTANT_HS_DWordLength_start  0
#define GFX7_3DSTATE_CONSTANT_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_HS::MOCS */


#define GFX125_3DSTATE_CONSTANT_HS_MOCS_bits  7
#define GFX12_3DSTATE_CONSTANT_HS_MOCS_bits  7
#define GFX11_3DSTATE_CONSTANT_HS_MOCS_bits  7
#define GFX9_3DSTATE_CONSTANT_HS_MOCS_bits  7
#define GFX8_3DSTATE_CONSTANT_HS_MOCS_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_HS_MOCS_start  8
#define GFX12_3DSTATE_CONSTANT_HS_MOCS_start  8
#define GFX11_3DSTATE_CONSTANT_HS_MOCS_start  8
#define GFX9_3DSTATE_CONSTANT_HS_MOCS_start  8
#define GFX8_3DSTATE_CONSTANT_HS_MOCS_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_HS_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS */


#define GFX125_3DSTATE_CONSTANT_PS_length  11
#define GFX12_3DSTATE_CONSTANT_PS_length  11
#define GFX11_3DSTATE_CONSTANT_PS_length  11
#define GFX9_3DSTATE_CONSTANT_PS_length  11
#define GFX8_3DSTATE_CONSTANT_PS_length  11
#define GFX75_3DSTATE_CONSTANT_PS_length  7
#define GFX7_3DSTATE_CONSTANT_PS_length  7
#define GFX6_3DSTATE_CONSTANT_PS_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 7;
   case 70: return 7;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::3D Command Opcode */


#define GFX125_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CONSTANT_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 0 Valid */


#define GFX6_3DSTATE_CONSTANT_PS_Buffer0Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer0Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_PS_Buffer0Valid_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer0Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 12;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 1 Valid */


#define GFX6_3DSTATE_CONSTANT_PS_Buffer1Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer1Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_PS_Buffer1Valid_start  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer1Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 13;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 2 Valid */


#define GFX6_3DSTATE_CONSTANT_PS_Buffer2Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer2Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_PS_Buffer2Valid_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer2Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 14;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Buffer 3 Valid */


#define GFX6_3DSTATE_CONSTANT_PS_Buffer3Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer3Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_PS_Buffer3Valid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_Buffer3Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 15;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Command SubType */


#define GFX125_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX12_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX11_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX9_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX8_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX75_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX7_3DSTATE_CONSTANT_PS_CommandSubType_bits  2
#define GFX6_3DSTATE_CONSTANT_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX12_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX11_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX9_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX8_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX75_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX7_3DSTATE_CONSTANT_PS_CommandSubType_start  27
#define GFX6_3DSTATE_CONSTANT_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Command Type */


#define GFX125_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX12_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX11_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX9_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX8_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX75_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX7_3DSTATE_CONSTANT_PS_CommandType_bits  3
#define GFX6_3DSTATE_CONSTANT_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX12_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX11_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX9_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX8_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX75_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX7_3DSTATE_CONSTANT_PS_CommandType_start  29
#define GFX6_3DSTATE_CONSTANT_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Constant Body */


#define GFX125_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GFX12_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GFX11_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GFX9_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GFX8_3DSTATE_CONSTANT_PS_ConstantBody_bits  320
#define GFX75_3DSTATE_CONSTANT_PS_ConstantBody_bits  192
#define GFX7_3DSTATE_CONSTANT_PS_ConstantBody_bits  192
#define GFX6_3DSTATE_CONSTANT_PS_ConstantBody_bits  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 320;
   case 120: return 320;
   case 110: return 320;
   case 90: return 320;
   case 80: return 320;
   case 75: return 192;
   case 70: return 192;
   case 60: return 128;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX12_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX11_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX9_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX8_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX75_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX7_3DSTATE_CONSTANT_PS_ConstantBody_start  32
#define GFX6_3DSTATE_CONSTANT_PS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::DWord Length */


#define GFX125_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX12_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX11_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX9_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX8_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX75_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX7_3DSTATE_CONSTANT_PS_DWordLength_bits  8
#define GFX6_3DSTATE_CONSTANT_PS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX12_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX11_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX9_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX8_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX75_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX7_3DSTATE_CONSTANT_PS_DWordLength_start  0
#define GFX6_3DSTATE_CONSTANT_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::Disable Gather at Set Shader Hint */


#define GFX125_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_bits  1
#define GFX12_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_bits  1
#define GFX11_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_start  15
#define GFX12_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_start  15
#define GFX11_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_DisableGatheratSetShaderHint_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 15;
   case 120: return 15;
   case 110: return 15;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_PS::MOCS */


#define GFX125_3DSTATE_CONSTANT_PS_MOCS_bits  7
#define GFX12_3DSTATE_CONSTANT_PS_MOCS_bits  7
#define GFX11_3DSTATE_CONSTANT_PS_MOCS_bits  7
#define GFX9_3DSTATE_CONSTANT_PS_MOCS_bits  7
#define GFX8_3DSTATE_CONSTANT_PS_MOCS_bits  7
#define GFX6_3DSTATE_CONSTANT_PS_MOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 0;
   case 70: return 0;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_PS_MOCS_start  8
#define GFX12_3DSTATE_CONSTANT_PS_MOCS_start  8
#define GFX11_3DSTATE_CONSTANT_PS_MOCS_start  8
#define GFX9_3DSTATE_CONSTANT_PS_MOCS_start  8
#define GFX8_3DSTATE_CONSTANT_PS_MOCS_start  8
#define GFX6_3DSTATE_CONSTANT_PS_MOCS_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_PS_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS */


#define GFX125_3DSTATE_CONSTANT_VS_length  11
#define GFX12_3DSTATE_CONSTANT_VS_length  11
#define GFX11_3DSTATE_CONSTANT_VS_length  11
#define GFX9_3DSTATE_CONSTANT_VS_length  11
#define GFX8_3DSTATE_CONSTANT_VS_length  11
#define GFX75_3DSTATE_CONSTANT_VS_length  7
#define GFX7_3DSTATE_CONSTANT_VS_length  7
#define GFX6_3DSTATE_CONSTANT_VS_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 7;
   case 70: return 7;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::3D Command Opcode */


#define GFX125_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_CONSTANT_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::3D Command Sub Opcode */


#define GFX125_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 0 Valid */


#define GFX6_3DSTATE_CONSTANT_VS_Buffer0Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer0Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_VS_Buffer0Valid_start  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer0Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 12;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 1 Valid */


#define GFX6_3DSTATE_CONSTANT_VS_Buffer1Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer1Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_VS_Buffer1Valid_start  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer1Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 13;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 2 Valid */


#define GFX6_3DSTATE_CONSTANT_VS_Buffer2Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer2Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_VS_Buffer2Valid_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer2Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 14;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Buffer 3 Valid */


#define GFX6_3DSTATE_CONSTANT_VS_Buffer3Valid_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer3Valid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_CONSTANT_VS_Buffer3Valid_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_Buffer3Valid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 15;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Command SubType */


#define GFX125_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX12_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX11_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX9_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX8_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX75_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX7_3DSTATE_CONSTANT_VS_CommandSubType_bits  2
#define GFX6_3DSTATE_CONSTANT_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX12_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX11_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX9_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX8_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX75_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX7_3DSTATE_CONSTANT_VS_CommandSubType_start  27
#define GFX6_3DSTATE_CONSTANT_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Command Type */


#define GFX125_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX12_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX11_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX9_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX8_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX75_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX7_3DSTATE_CONSTANT_VS_CommandType_bits  3
#define GFX6_3DSTATE_CONSTANT_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX12_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX11_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX9_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX8_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX75_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX7_3DSTATE_CONSTANT_VS_CommandType_start  29
#define GFX6_3DSTATE_CONSTANT_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::Constant Body */


#define GFX125_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GFX12_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GFX11_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GFX9_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GFX8_3DSTATE_CONSTANT_VS_ConstantBody_bits  320
#define GFX75_3DSTATE_CONSTANT_VS_ConstantBody_bits  192
#define GFX7_3DSTATE_CONSTANT_VS_ConstantBody_bits  192
#define GFX6_3DSTATE_CONSTANT_VS_ConstantBody_bits  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_ConstantBody_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 320;
   case 120: return 320;
   case 110: return 320;
   case 90: return 320;
   case 80: return 320;
   case 75: return 192;
   case 70: return 192;
   case 60: return 128;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX12_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX11_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX9_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX8_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX75_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX7_3DSTATE_CONSTANT_VS_ConstantBody_start  32
#define GFX6_3DSTATE_CONSTANT_VS_ConstantBody_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_ConstantBody_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::DWord Length */


#define GFX125_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX12_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX11_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX9_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX8_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX75_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX7_3DSTATE_CONSTANT_VS_DWordLength_bits  8
#define GFX6_3DSTATE_CONSTANT_VS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX12_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX11_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX9_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX8_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX75_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX7_3DSTATE_CONSTANT_VS_DWordLength_start  0
#define GFX6_3DSTATE_CONSTANT_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_CONSTANT_VS::MOCS */


#define GFX125_3DSTATE_CONSTANT_VS_MOCS_bits  7
#define GFX12_3DSTATE_CONSTANT_VS_MOCS_bits  7
#define GFX11_3DSTATE_CONSTANT_VS_MOCS_bits  7
#define GFX9_3DSTATE_CONSTANT_VS_MOCS_bits  7
#define GFX8_3DSTATE_CONSTANT_VS_MOCS_bits  7
#define GFX6_3DSTATE_CONSTANT_VS_MOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 0;
   case 70: return 0;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_CONSTANT_VS_MOCS_start  8
#define GFX12_3DSTATE_CONSTANT_VS_MOCS_start  8
#define GFX11_3DSTATE_CONSTANT_VS_MOCS_start  8
#define GFX9_3DSTATE_CONSTANT_VS_MOCS_start  8
#define GFX8_3DSTATE_CONSTANT_VS_MOCS_start  8
#define GFX6_3DSTATE_CONSTANT_VS_MOCS_start  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_CONSTANT_VS_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS */


#define GFX125_3DSTATE_DEPTH_BOUNDS_length  4
#define GFX12_3DSTATE_DEPTH_BOUNDS_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::3D Command Opcode */


#define GFX125_3DSTATE_DEPTH_BOUNDS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_DEPTH_BOUNDS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_DEPTH_BOUNDS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::3DSTATE Command Sub Opcode */


#define GFX125_3DSTATE_DEPTH_BOUNDS_3DSTATECommandSubOpcode_bits  8
#define GFX12_3DSTATE_DEPTH_BOUNDS_3DSTATECommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_3DSTATECommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_3DSTATECommandSubOpcode_start  16
#define GFX12_3DSTATE_DEPTH_BOUNDS_3DSTATECommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_3DSTATECommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Command SubType */


#define GFX125_3DSTATE_DEPTH_BOUNDS_CommandSubType_bits  2
#define GFX12_3DSTATE_DEPTH_BOUNDS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_CommandSubType_start  27
#define GFX12_3DSTATE_DEPTH_BOUNDS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Command Type */


#define GFX125_3DSTATE_DEPTH_BOUNDS_CommandType_bits  3
#define GFX12_3DSTATE_DEPTH_BOUNDS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_CommandType_start  29
#define GFX12_3DSTATE_DEPTH_BOUNDS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Depth Bounds Test Enable */


#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnable_bits  1
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnable_start  32
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnable_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Depth Bounds Test Enable Modify Disable */


#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnableModifyDisable_bits  1
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnableModifyDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnableModifyDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnableModifyDisable_start  15
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnableModifyDisable_start  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestEnableModifyDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 15;
   case 120: return 15;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Depth Bounds Test Max Value */


#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMaxValue_bits  32
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMaxValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMaxValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMaxValue_start  96
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMaxValue_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMaxValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 96;
   case 120: return 96;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Depth Bounds Test Min Value */


#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMinValue_bits  32
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMinValue_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMinValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMinValue_start  64
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMinValue_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestMinValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Depth Bounds Test Value Modify Disable */


#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestValueModifyDisable_bits  1
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestValueModifyDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestValueModifyDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestValueModifyDisable_start  14
#define GFX12_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestValueModifyDisable_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_DepthBoundsTestValueModifyDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 14;
   case 120: return 14;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BOUNDS::Length */


#define GFX125_3DSTATE_DEPTH_BOUNDS_Length_bits  8
#define GFX12_3DSTATE_DEPTH_BOUNDS_Length_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_Length_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BOUNDS_Length_start  0
#define GFX12_3DSTATE_DEPTH_BOUNDS_Length_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BOUNDS_Length_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER */


#define GFX125_3DSTATE_DEPTH_BUFFER_length  8
#define GFX12_3DSTATE_DEPTH_BUFFER_length  8
#define GFX11_3DSTATE_DEPTH_BUFFER_length  8
#define GFX9_3DSTATE_DEPTH_BUFFER_length  8
#define GFX8_3DSTATE_DEPTH_BUFFER_length  8
#define GFX75_3DSTATE_DEPTH_BUFFER_length  7
#define GFX7_3DSTATE_DEPTH_BUFFER_length  7
#define GFX6_3DSTATE_DEPTH_BUFFER_length  7
#define GFX5_3DSTATE_DEPTH_BUFFER_length  6
#define GFX45_3DSTATE_DEPTH_BUFFER_length  6
#define GFX4_3DSTATE_DEPTH_BUFFER_length  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 7;
   case 70: return 7;
   case 60: return 7;
   case 50: return 6;
   case 45: return 6;
   case 40: return 5;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::3D Command Opcode */


#define GFX125_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX4_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX12_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX11_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX9_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX8_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX75_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX7_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX6_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX5_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX45_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX4_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::3D Command Sub Opcode */


#define GFX125_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX4_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX4_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Command SubType */


#define GFX125_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX12_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX11_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX9_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX8_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX75_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX7_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX6_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX5_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX45_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX4_3DSTATE_DEPTH_BUFFER_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX12_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX11_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX9_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX8_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX75_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX7_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX6_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX5_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX45_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27
#define GFX4_3DSTATE_DEPTH_BUFFER_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Command Type */


#define GFX125_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX12_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX11_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX9_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX8_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX75_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX7_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX6_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX5_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX45_3DSTATE_DEPTH_BUFFER_CommandType_bits  3
#define GFX4_3DSTATE_DEPTH_BUFFER_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX12_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX11_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX9_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX8_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX75_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX7_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX6_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX5_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX45_3DSTATE_DEPTH_BUFFER_CommandType_start  29
#define GFX4_3DSTATE_DEPTH_BUFFER_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 29;
   case 45: return 29;
   case 40: return 29;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Control Surface Enable */


#define GFX125_3DSTATE_DEPTH_BUFFER_ControlSurfaceEnable_bits  1
#define GFX12_3DSTATE_DEPTH_BUFFER_ControlSurfaceEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_ControlSurfaceEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_ControlSurfaceEnable_start  51
#define GFX12_3DSTATE_DEPTH_BUFFER_ControlSurfaceEnable_start  51

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_ControlSurfaceEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 51;
   case 120: return 51;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Corner Texel Mode */


#define GFX125_3DSTATE_DEPTH_BUFFER_CornerTexelMode_bits  1
#define GFX12_3DSTATE_DEPTH_BUFFER_CornerTexelMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CornerTexelMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_CornerTexelMode_start  55
#define GFX12_3DSTATE_DEPTH_BUFFER_CornerTexelMode_start  55

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_CornerTexelMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 55;
   case 120: return 55;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::DWord Length */


#define GFX125_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX12_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX11_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX9_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX8_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX75_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX7_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX6_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX5_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX45_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8
#define GFX4_3DSTATE_DEPTH_BUFFER_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX12_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX11_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX9_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX8_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX75_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX7_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX6_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX5_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX45_3DSTATE_DEPTH_BUFFER_DWordLength_start  0
#define GFX4_3DSTATE_DEPTH_BUFFER_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth */


#define GFX125_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX12_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX11_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX9_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX8_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX75_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX7_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX6_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX5_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX45_3DSTATE_DEPTH_BUFFER_Depth_bits  11
#define GFX4_3DSTATE_DEPTH_BUFFER_Depth_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Depth_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 11;
   case 50: return 11;
   case 45: return 11;
   case 40: return 11;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_Depth_start  180
#define GFX12_3DSTATE_DEPTH_BUFFER_Depth_start  180
#define GFX11_3DSTATE_DEPTH_BUFFER_Depth_start  181
#define GFX9_3DSTATE_DEPTH_BUFFER_Depth_start  181
#define GFX8_3DSTATE_DEPTH_BUFFER_Depth_start  181
#define GFX75_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GFX7_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GFX6_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GFX5_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GFX45_3DSTATE_DEPTH_BUFFER_Depth_start  149
#define GFX4_3DSTATE_DEPTH_BUFFER_Depth_start  149

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Depth_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 180;
   case 120: return 180;
   case 110: return 181;
   case 90: return 181;
   case 80: return 181;
   case 75: return 149;
   case 70: return 149;
   case 60: return 149;
   case 50: return 149;
   case 45: return 149;
   case 40: return 149;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Buffer Compression Enable */


#define GFX125_3DSTATE_DEPTH_BUFFER_DepthBufferCompressionEnable_bits  1
#define GFX12_3DSTATE_DEPTH_BUFFER_DepthBufferCompressionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferCompressionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_DepthBufferCompressionEnable_start  53
#define GFX12_3DSTATE_DEPTH_BUFFER_DepthBufferCompressionEnable_start  53

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferCompressionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 53;
   case 120: return 53;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Buffer Coordinate Offset Disable */


#define GFX45_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_bits  1
#define GFX4_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 1;
   case 40: return 1;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX45_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_start  57
#define GFX4_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_start  57

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthBufferCoordinateOffsetDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 57;
   case 40: return 57;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Coordinate Offset X */


#define GFX75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GFX7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GFX6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GFX5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16
#define GFX45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GFX7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GFX6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GFX5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160
#define GFX45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start  160

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetX_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 160;
   case 70: return 160;
   case 60: return 160;
   case 50: return 160;
   case 45: return 160;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Coordinate Offset Y */


#define GFX75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GFX7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GFX6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GFX5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16
#define GFX45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GFX7_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GFX6_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GFX5_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176
#define GFX45_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start  176

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthCoordinateOffsetY_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 176;
   case 70: return 176;
   case 60: return 176;
   case 50: return 176;
   case 45: return 176;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Depth Write Enable */


#define GFX125_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GFX12_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GFX11_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GFX9_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GFX8_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GFX75_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1
#define GFX7_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GFX12_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GFX11_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GFX9_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GFX8_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GFX75_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60
#define GFX7_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start  60

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_DepthWriteEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 60;
   case 120: return 60;
   case 110: return 60;
   case 90: return 60;
   case 80: return 60;
   case 75: return 60;
   case 70: return 60;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Height */


#define GFX125_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX12_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX11_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX9_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX8_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX75_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX7_3DSTATE_DEPTH_BUFFER_Height_bits  14
#define GFX6_3DSTATE_DEPTH_BUFFER_Height_bits  13
#define GFX5_3DSTATE_DEPTH_BUFFER_Height_bits  13
#define GFX45_3DSTATE_DEPTH_BUFFER_Height_bits  13
#define GFX4_3DSTATE_DEPTH_BUFFER_Height_bits  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Height_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 14;
   case 120: return 14;
   case 110: return 14;
   case 90: return 14;
   case 80: return 14;
   case 75: return 14;
   case 70: return 14;
   case 60: return 13;
   case 50: return 13;
   case 45: return 13;
   case 40: return 13;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_Height_start  145
#define GFX12_3DSTATE_DEPTH_BUFFER_Height_start  145
#define GFX11_3DSTATE_DEPTH_BUFFER_Height_start  146
#define GFX9_3DSTATE_DEPTH_BUFFER_Height_start  146
#define GFX8_3DSTATE_DEPTH_BUFFER_Height_start  146
#define GFX75_3DSTATE_DEPTH_BUFFER_Height_start  114
#define GFX7_3DSTATE_DEPTH_BUFFER_Height_start  114
#define GFX6_3DSTATE_DEPTH_BUFFER_Height_start  115
#define GFX5_3DSTATE_DEPTH_BUFFER_Height_start  115
#define GFX45_3DSTATE_DEPTH_BUFFER_Height_start  115
#define GFX4_3DSTATE_DEPTH_BUFFER_Height_start  115

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Height_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 145;
   case 120: return 145;
   case 110: return 146;
   case 90: return 146;
   case 80: return 146;
   case 75: return 114;
   case 70: return 114;
   case 60: return 115;
   case 50: return 115;
   case 45: return 115;
   case 40: return 115;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Hierarchical Depth Buffer Enable */


#define GFX125_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX12_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX11_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX9_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX8_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX75_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX7_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX6_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1
#define GFX5_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 1;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX12_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX11_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX9_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX8_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX75_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX7_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX6_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54
#define GFX5_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start  54

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_HierarchicalDepthBufferEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 54;
   case 120: return 54;
   case 110: return 54;
   case 90: return 54;
   case 80: return 54;
   case 75: return 54;
   case 70: return 54;
   case 60: return 54;
   case 50: return 54;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::LOD */


#define GFX125_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX12_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX11_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX9_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX8_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX75_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX7_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX6_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX5_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX45_3DSTATE_DEPTH_BUFFER_LOD_bits  4
#define GFX4_3DSTATE_DEPTH_BUFFER_LOD_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_LOD_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 4;
   case 45: return 4;
   case 40: return 4;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_LOD_start  240
#define GFX12_3DSTATE_DEPTH_BUFFER_LOD_start  240
#define GFX11_3DSTATE_DEPTH_BUFFER_LOD_start  128
#define GFX9_3DSTATE_DEPTH_BUFFER_LOD_start  128
#define GFX8_3DSTATE_DEPTH_BUFFER_LOD_start  128
#define GFX75_3DSTATE_DEPTH_BUFFER_LOD_start  96
#define GFX7_3DSTATE_DEPTH_BUFFER_LOD_start  96
#define GFX6_3DSTATE_DEPTH_BUFFER_LOD_start  98
#define GFX5_3DSTATE_DEPTH_BUFFER_LOD_start  98
#define GFX45_3DSTATE_DEPTH_BUFFER_LOD_start  98
#define GFX4_3DSTATE_DEPTH_BUFFER_LOD_start  98

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_LOD_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 240;
   case 120: return 240;
   case 110: return 128;
   case 90: return 128;
   case 80: return 128;
   case 75: return 96;
   case 70: return 96;
   case 60: return 98;
   case 50: return 98;
   case 45: return 98;
   case 40: return 98;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::MIP Map Layout Mode */


#define GFX6_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1
#define GFX5_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1
#define GFX45_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1
#define GFX4_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 1;
   case 45: return 1;
   case 40: return 1;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97
#define GFX5_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97
#define GFX45_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97
#define GFX4_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start  97

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MIPMapLayoutMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 97;
   case 50: return 97;
   case 45: return 97;
   case 40: return 97;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::MOCS */


#define GFX125_3DSTATE_DEPTH_BUFFER_MOCS_bits  7
#define GFX12_3DSTATE_DEPTH_BUFFER_MOCS_bits  7
#define GFX11_3DSTATE_DEPTH_BUFFER_MOCS_bits  7
#define GFX9_3DSTATE_DEPTH_BUFFER_MOCS_bits  7
#define GFX8_3DSTATE_DEPTH_BUFFER_MOCS_bits  7
#define GFX75_3DSTATE_DEPTH_BUFFER_MOCS_bits  4
#define GFX7_3DSTATE_DEPTH_BUFFER_MOCS_bits  4
#define GFX6_3DSTATE_DEPTH_BUFFER_MOCS_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 4;
   case 70: return 4;
   case 60: return 5;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_MOCS_start  160
#define GFX12_3DSTATE_DEPTH_BUFFER_MOCS_start  160
#define GFX11_3DSTATE_DEPTH_BUFFER_MOCS_start  160
#define GFX9_3DSTATE_DEPTH_BUFFER_MOCS_start  160
#define GFX8_3DSTATE_DEPTH_BUFFER_MOCS_start  160
#define GFX75_3DSTATE_DEPTH_BUFFER_MOCS_start  128
#define GFX7_3DSTATE_DEPTH_BUFFER_MOCS_start  128
#define GFX6_3DSTATE_DEPTH_BUFFER_MOCS_start  219

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 160;
   case 120: return 160;
   case 110: return 160;
   case 90: return 160;
   case 80: return 160;
   case 75: return 128;
   case 70: return 128;
   case 60: return 219;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Minimum Array Element */


#define GFX125_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX12_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX11_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX9_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX8_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX75_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX7_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX6_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX5_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX45_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11
#define GFX4_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 11;
   case 50: return 11;
   case 45: return 11;
   case 40: return 11;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  168
#define GFX12_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  168
#define GFX11_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  170
#define GFX9_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  170
#define GFX8_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  170
#define GFX75_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GFX7_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GFX6_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GFX5_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GFX45_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138
#define GFX4_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start  138

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MinimumArrayElement_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 168;
   case 120: return 168;
   case 110: return 170;
   case 90: return 170;
   case 80: return 170;
   case 75: return 138;
   case 70: return 138;
   case 60: return 138;
   case 50: return 138;
   case 45: return 138;
   case 40: return 138;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Mip Tail Start LOD */


#define GFX125_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits  4
#define GFX12_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits  4
#define GFX11_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits  4
#define GFX9_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start  218
#define GFX12_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start  218
#define GFX11_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start  218
#define GFX9_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start  218

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_MipTailStartLOD_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 218;
   case 120: return 218;
   case 110: return 218;
   case 90: return 218;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Null Page Coherency Enable */


#define GFX125_3DSTATE_DEPTH_BUFFER_NullPageCoherencyEnable_bits  1
#define GFX12_3DSTATE_DEPTH_BUFFER_NullPageCoherencyEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_NullPageCoherencyEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_NullPageCoherencyEnable_start  59
#define GFX12_3DSTATE_DEPTH_BUFFER_NullPageCoherencyEnable_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_NullPageCoherencyEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 59;
   case 120: return 59;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Render Target View Extent */


#define GFX125_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX12_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX11_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX9_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX8_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX75_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX7_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  11
#define GFX6_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9
#define GFX5_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9
#define GFX45_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9
#define GFX4_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits  9

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 11;
   case 70: return 11;
   case 60: return 9;
   case 50: return 9;
   case 45: return 9;
   case 40: return 9;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GFX12_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GFX11_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GFX9_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GFX8_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  245
#define GFX75_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  213
#define GFX7_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  213
#define GFX6_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129
#define GFX5_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129
#define GFX45_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129
#define GFX4_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start  129

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_RenderTargetViewExtent_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 245;
   case 120: return 245;
   case 110: return 245;
   case 90: return 245;
   case 80: return 245;
   case 75: return 213;
   case 70: return 213;
   case 60: return 129;
   case 50: return 129;
   case 45: return 129;
   case 40: return 129;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Separate Stencil Buffer Enable */


#define GFX6_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_bits  1
#define GFX5_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 1;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_start  53
#define GFX5_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_start  53

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SeparateStencilBufferEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 53;
   case 50: return 53;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Software Tiled Rendering Mode */


#define GFX6_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2
#define GFX5_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2
#define GFX45_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2
#define GFX4_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 2;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55
#define GFX5_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55
#define GFX45_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55
#define GFX4_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start  55

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SoftwareTiledRenderingMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 55;
   case 50: return 55;
   case 45: return 55;
   case 40: return 55;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Stencil Write Enable */


#define GFX11_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GFX9_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GFX8_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GFX75_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1
#define GFX7_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX11_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GFX9_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GFX8_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GFX75_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59
#define GFX7_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_StencilWriteEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 59;
   case 90: return 59;
   case 80: return 59;
   case 75: return 59;
   case 70: return 59;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Base Address */


#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 64;
   case 45: return 64;
   case 40: return 64;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Format */


#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceFormat_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  56
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  56
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start  50

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceFormat_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 56;
   case 120: return 56;
   case 110: return 50;
   case 90: return 50;
   case 80: return 50;
   case 75: return 50;
   case 70: return 50;
   case 60: return 50;
   case 50: return 50;
   case 45: return 50;
   case 40: return 50;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Pitch */


#define GFX125_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  18
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfacePitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 18;
   case 120: return 18;
   case 110: return 18;
   case 90: return 18;
   case 80: return 18;
   case 75: return 18;
   case 70: return 18;
   case 60: return 17;
   case 50: return 17;
   case 45: return 17;
   case 40: return 17;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfacePitch_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfacePitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface QPitch */


#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 15;
   case 120: return 15;
   case 110: return 15;
   case 90: return 15;
   case 80: return 15;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start  224

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceQPitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 224;
   case 120: return 224;
   case 110: return 224;
   case 90: return 224;
   case 80: return 224;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Surface Type */


#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfaceType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX12_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX11_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX9_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX8_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX75_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX7_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX6_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX5_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX45_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61
#define GFX4_3DSTATE_DEPTH_BUFFER_SurfaceType_start  61

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_SurfaceType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 61;
   case 120: return 61;
   case 110: return 61;
   case 90: return 61;
   case 80: return 61;
   case 75: return 61;
   case 70: return 61;
   case 60: return 61;
   case 50: return 61;
   case 45: return 61;
   case 40: return 61;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Tile Walk */


#define GFX6_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1
#define GFX5_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1
#define GFX45_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1
#define GFX4_3DSTATE_DEPTH_BUFFER_TileWalk_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TileWalk_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 1;
   case 45: return 1;
   case 40: return 1;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_DEPTH_BUFFER_TileWalk_start  58
#define GFX5_3DSTATE_DEPTH_BUFFER_TileWalk_start  58
#define GFX45_3DSTATE_DEPTH_BUFFER_TileWalk_start  58
#define GFX4_3DSTATE_DEPTH_BUFFER_TileWalk_start  58

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TileWalk_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 58;
   case 50: return 58;
   case 45: return 58;
   case 40: return 58;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Tiled Resource Mode */


#define GFX125_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits  2
#define GFX12_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits  2
#define GFX11_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits  2
#define GFX9_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledResourceMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start  222
#define GFX12_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start  222
#define GFX11_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start  222
#define GFX9_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start  222

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledResourceMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 222;
   case 120: return 222;
   case 110: return 222;
   case 90: return 222;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Tiled Surface */


#define GFX6_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1
#define GFX5_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1
#define GFX45_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1
#define GFX4_3DSTATE_DEPTH_BUFFER_TiledSurface_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledSurface_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 1;
   case 45: return 1;
   case 40: return 1;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59
#define GFX5_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59
#define GFX45_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59
#define GFX4_3DSTATE_DEPTH_BUFFER_TiledSurface_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_TiledSurface_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 59;
   case 50: return 59;
   case 45: return 59;
   case 40: return 59;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_BUFFER::Width */


#define GFX125_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX12_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX11_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX9_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX8_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX75_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX7_3DSTATE_DEPTH_BUFFER_Width_bits  14
#define GFX6_3DSTATE_DEPTH_BUFFER_Width_bits  13
#define GFX5_3DSTATE_DEPTH_BUFFER_Width_bits  13
#define GFX45_3DSTATE_DEPTH_BUFFER_Width_bits  13
#define GFX4_3DSTATE_DEPTH_BUFFER_Width_bits  13

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Width_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 14;
   case 120: return 14;
   case 110: return 14;
   case 90: return 14;
   case 80: return 14;
   case 75: return 14;
   case 70: return 14;
   case 60: return 13;
   case 50: return 13;
   case 45: return 13;
   case 40: return 13;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DEPTH_BUFFER_Width_start  129
#define GFX12_3DSTATE_DEPTH_BUFFER_Width_start  129
#define GFX11_3DSTATE_DEPTH_BUFFER_Width_start  132
#define GFX9_3DSTATE_DEPTH_BUFFER_Width_start  132
#define GFX8_3DSTATE_DEPTH_BUFFER_Width_start  132
#define GFX75_3DSTATE_DEPTH_BUFFER_Width_start  100
#define GFX7_3DSTATE_DEPTH_BUFFER_Width_start  100
#define GFX6_3DSTATE_DEPTH_BUFFER_Width_start  102
#define GFX5_3DSTATE_DEPTH_BUFFER_Width_start  102
#define GFX45_3DSTATE_DEPTH_BUFFER_Width_start  102
#define GFX4_3DSTATE_DEPTH_BUFFER_Width_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_BUFFER_Width_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 129;
   case 120: return 129;
   case 110: return 132;
   case 90: return 132;
   case 80: return 132;
   case 75: return 100;
   case 70: return 100;
   case 60: return 102;
   case 50: return 102;
   case 45: return 102;
   case 40: return 102;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_length  2
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::3D Command Opcode */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::3D Command Sub Opcode */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::Command SubType */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_bits  2
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_start  27
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::Command Type */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_bits  3
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_start  29
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::DWord Length */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_bits  8
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_start  0
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DEPTH_STENCIL_STATE_POINTERS::Pointer to DEPTH_STENCIL_STATE */


#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits  26
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 26;
   case 70: return 26;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start  38
#define GFX7_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DEPTH_STENCIL_STATE_POINTERS_PointertoDEPTH_STENCIL_STATE_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 38;
   case 70: return 38;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX12_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX11_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX9_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX8_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX75_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX7_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX6_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX5_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX45_3DSTATE_DRAWING_RECTANGLE_length  4
#define GFX4_3DSTATE_DRAWING_RECTANGLE_length  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 4;
   case 45: return 4;
   case 40: return 4;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::3D Command Opcode */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3
#define GFX4_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX12_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX11_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX9_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX8_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX75_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX7_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX6_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX5_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX45_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24
#define GFX4_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::3D Command Sub Opcode */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8
#define GFX4_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle X Max */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMax_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 64;
   case 45: return 64;
   case 40: return 64;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle X Min */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleXMin_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle Y Max */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMax_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 80;
   case 120: return 80;
   case 110: return 80;
   case 90: return 80;
   case 80: return 80;
   case 75: return 80;
   case 70: return 80;
   case 60: return 80;
   case 50: return 80;
   case 45: return 80;
   case 40: return 80;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Clipped Drawing Rectangle Y Min */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX12_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX11_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX9_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX8_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX75_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX7_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX6_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX5_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX45_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48
#define GFX4_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_ClippedDrawingRectangleYMin_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 48;
   case 60: return 48;
   case 50: return 48;
   case 45: return 48;
   case 40: return 48;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Command SubType */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX12_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX11_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX9_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX8_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX75_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX7_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX6_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX5_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX45_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2
#define GFX4_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX12_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX11_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX9_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX8_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX75_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX7_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX6_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX5_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX45_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27
#define GFX4_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Command Type */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX12_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX11_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX9_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX8_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX75_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX7_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX6_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX5_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX45_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3
#define GFX4_3DSTATE_DRAWING_RECTANGLE_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX12_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX11_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX9_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX8_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX75_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX7_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX6_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX5_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX45_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29
#define GFX4_3DSTATE_DRAWING_RECTANGLE_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 29;
   case 45: return 29;
   case 40: return 29;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Core Mode Select */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GFX12_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GFX11_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GFX9_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GFX8_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2
#define GFX75_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GFX12_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GFX11_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GFX9_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GFX8_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14
#define GFX75_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start  14

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_CoreModeSelect_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 14;
   case 120: return 14;
   case 110: return 14;
   case 90: return 14;
   case 80: return 14;
   case 75: return 14;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::DWord Length */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX12_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX11_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX9_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX8_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX75_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX7_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX6_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX5_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX45_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8
#define GFX4_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX12_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX11_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX9_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX8_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX75_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX7_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX6_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX5_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX45_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0
#define GFX4_3DSTATE_DRAWING_RECTANGLE_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Drawing Rectangle Origin X */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX12_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX11_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96
#define GFX4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginX_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 96;
   case 120: return 96;
   case 110: return 96;
   case 90: return 96;
   case 80: return 96;
   case 75: return 96;
   case 70: return 96;
   case 60: return 96;
   case 50: return 96;
   case 45: return 96;
   case 40: return 96;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DRAWING_RECTANGLE::Drawing Rectangle Origin Y */


#define GFX125_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX12_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX11_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16
#define GFX4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX12_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX11_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX9_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX8_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX75_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX7_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX6_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX5_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX45_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112
#define GFX4_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start  112

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DRAWING_RECTANGLE_DrawingRectangleOriginY_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 112;
   case 120: return 112;
   case 110: return 112;
   case 90: return 112;
   case 80: return 112;
   case 75: return 112;
   case 70: return 112;
   case 60: return 112;
   case 50: return 112;
   case 45: return 112;
   case 40: return 112;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS */


#define GFX125_3DSTATE_DS_length  11
#define GFX12_3DSTATE_DS_length  11
#define GFX11_3DSTATE_DS_length  11
#define GFX9_3DSTATE_DS_length  11
#define GFX8_3DSTATE_DS_length  9
#define GFX75_3DSTATE_DS_length  6
#define GFX7_3DSTATE_DS_length  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 9;
   case 75: return 6;
   case 70: return 6;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::3D Command Opcode */


#define GFX125_3DSTATE_DS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_DS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_DS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_DS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_DS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_DS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_DS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_DS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_DS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_DS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_DS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::3D Command Sub Opcode */


#define GFX125_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_DS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_DS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Accesses UAV */


#define GFX125_3DSTATE_DS_AccessesUAV_bits  1
#define GFX12_3DSTATE_DS_AccessesUAV_bits  1
#define GFX11_3DSTATE_DS_AccessesUAV_bits  1
#define GFX9_3DSTATE_DS_AccessesUAV_bits  1
#define GFX8_3DSTATE_DS_AccessesUAV_bits  1
#define GFX75_3DSTATE_DS_AccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_AccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_AccessesUAV_start  110
#define GFX12_3DSTATE_DS_AccessesUAV_start  110
#define GFX11_3DSTATE_DS_AccessesUAV_start  110
#define GFX9_3DSTATE_DS_AccessesUAV_start  110
#define GFX8_3DSTATE_DS_AccessesUAV_start  110
#define GFX75_3DSTATE_DS_AccessesUAV_start  78

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_AccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 110;
   case 120: return 110;
   case 110: return 110;
   case 90: return 110;
   case 80: return 110;
   case 75: return 78;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Binding Table Entry Count */


#define GFX125_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GFX12_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GFX11_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GFX9_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GFX8_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GFX75_3DSTATE_DS_BindingTableEntryCount_bits  8
#define GFX7_3DSTATE_DS_BindingTableEntryCount_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_BindingTableEntryCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_BindingTableEntryCount_start  114
#define GFX12_3DSTATE_DS_BindingTableEntryCount_start  114
#define GFX11_3DSTATE_DS_BindingTableEntryCount_start  114
#define GFX9_3DSTATE_DS_BindingTableEntryCount_start  114
#define GFX8_3DSTATE_DS_BindingTableEntryCount_start  114
#define GFX75_3DSTATE_DS_BindingTableEntryCount_start  82
#define GFX7_3DSTATE_DS_BindingTableEntryCount_start  82

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_BindingTableEntryCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 114;
   case 120: return 114;
   case 110: return 114;
   case 90: return 114;
   case 80: return 114;
   case 75: return 82;
   case 70: return 82;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Cache Disable */


#define GFX125_3DSTATE_DS_CacheDisable_bits  1
#define GFX12_3DSTATE_DS_CacheDisable_bits  1
#define GFX11_3DSTATE_DS_CacheDisable_bits  1
#define GFX9_3DSTATE_DS_CacheDisable_bits  1
#define GFX8_3DSTATE_DS_CacheDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CacheDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_CacheDisable_start  225
#define GFX12_3DSTATE_DS_CacheDisable_start  225
#define GFX11_3DSTATE_DS_CacheDisable_start  225
#define GFX9_3DSTATE_DS_CacheDisable_start  225
#define GFX8_3DSTATE_DS_CacheDisable_start  225

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CacheDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 225;
   case 120: return 225;
   case 110: return 225;
   case 90: return 225;
   case 80: return 225;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Command SubType */


#define GFX125_3DSTATE_DS_CommandSubType_bits  2
#define GFX12_3DSTATE_DS_CommandSubType_bits  2
#define GFX11_3DSTATE_DS_CommandSubType_bits  2
#define GFX9_3DSTATE_DS_CommandSubType_bits  2
#define GFX8_3DSTATE_DS_CommandSubType_bits  2
#define GFX75_3DSTATE_DS_CommandSubType_bits  2
#define GFX7_3DSTATE_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_CommandSubType_start  27
#define GFX12_3DSTATE_DS_CommandSubType_start  27
#define GFX11_3DSTATE_DS_CommandSubType_start  27
#define GFX9_3DSTATE_DS_CommandSubType_start  27
#define GFX8_3DSTATE_DS_CommandSubType_start  27
#define GFX75_3DSTATE_DS_CommandSubType_start  27
#define GFX7_3DSTATE_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Command Type */


#define GFX125_3DSTATE_DS_CommandType_bits  3
#define GFX12_3DSTATE_DS_CommandType_bits  3
#define GFX11_3DSTATE_DS_CommandType_bits  3
#define GFX9_3DSTATE_DS_CommandType_bits  3
#define GFX8_3DSTATE_DS_CommandType_bits  3
#define GFX75_3DSTATE_DS_CommandType_bits  3
#define GFX7_3DSTATE_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_CommandType_start  29
#define GFX12_3DSTATE_DS_CommandType_start  29
#define GFX11_3DSTATE_DS_CommandType_start  29
#define GFX9_3DSTATE_DS_CommandType_start  29
#define GFX8_3DSTATE_DS_CommandType_start  29
#define GFX75_3DSTATE_DS_CommandType_start  29
#define GFX7_3DSTATE_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Compute W Coordinate Enable */


#define GFX125_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GFX12_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GFX11_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GFX9_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GFX8_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GFX75_3DSTATE_DS_ComputeWCoordinateEnable_bits  1
#define GFX7_3DSTATE_DS_ComputeWCoordinateEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ComputeWCoordinateEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GFX12_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GFX11_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GFX9_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GFX8_3DSTATE_DS_ComputeWCoordinateEnable_start  226
#define GFX75_3DSTATE_DS_ComputeWCoordinateEnable_start  162
#define GFX7_3DSTATE_DS_ComputeWCoordinateEnable_start  162

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ComputeWCoordinateEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 226;
   case 120: return 226;
   case 110: return 226;
   case 90: return 226;
   case 80: return 226;
   case 75: return 162;
   case 70: return 162;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::DS Cache Disable */


#define GFX75_3DSTATE_DS_DSCacheDisable_bits  1
#define GFX7_3DSTATE_DS_DSCacheDisable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DSCacheDisable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_DS_DSCacheDisable_start  161
#define GFX7_3DSTATE_DS_DSCacheDisable_start  161

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DSCacheDisable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 161;
   case 70: return 161;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::DUAL_PATCH Kernel Start Pointer */


#define GFX125_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits  58
#define GFX12_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits  58
#define GFX11_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits  58
#define GFX9_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits  58

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DUAL_PATCHKernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 58;
   case 120: return 58;
   case 110: return 58;
   case 90: return 58;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start  294
#define GFX12_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start  294
#define GFX11_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start  294
#define GFX9_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start  294

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DUAL_PATCHKernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 294;
   case 120: return 294;
   case 110: return 294;
   case 90: return 294;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::DWord Length */


#define GFX125_3DSTATE_DS_DWordLength_bits  8
#define GFX12_3DSTATE_DS_DWordLength_bits  8
#define GFX11_3DSTATE_DS_DWordLength_bits  8
#define GFX9_3DSTATE_DS_DWordLength_bits  8
#define GFX8_3DSTATE_DS_DWordLength_bits  8
#define GFX75_3DSTATE_DS_DWordLength_bits  8
#define GFX7_3DSTATE_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_DWordLength_start  0
#define GFX12_3DSTATE_DS_DWordLength_start  0
#define GFX11_3DSTATE_DS_DWordLength_start  0
#define GFX9_3DSTATE_DS_DWordLength_start  0
#define GFX8_3DSTATE_DS_DWordLength_start  0
#define GFX75_3DSTATE_DS_DWordLength_start  0
#define GFX7_3DSTATE_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Dispatch GRF Start Register For URB Data */


#define GFX125_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX12_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX11_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX9_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX8_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX75_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX7_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchGRFStartRegisterForURBData_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 5;
   case 70: return 5;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GFX12_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GFX11_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GFX9_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GFX8_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  212
#define GFX75_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  148
#define GFX7_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start  148

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchGRFStartRegisterForURBData_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 212;
   case 120: return 212;
   case 110: return 212;
   case 90: return 212;
   case 80: return 212;
   case 75: return 148;
   case 70: return 148;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Dispatch Mode */


#define GFX125_3DSTATE_DS_DispatchMode_bits  2
#define GFX12_3DSTATE_DS_DispatchMode_bits  2
#define GFX11_3DSTATE_DS_DispatchMode_bits  2
#define GFX9_3DSTATE_DS_DispatchMode_bits  2
#define GFX8_3DSTATE_DS_DispatchMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_DispatchMode_start  227
#define GFX12_3DSTATE_DS_DispatchMode_start  227
#define GFX11_3DSTATE_DS_DispatchMode_start  227
#define GFX9_3DSTATE_DS_DispatchMode_start  227
#define GFX8_3DSTATE_DS_DispatchMode_start  227

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_DispatchMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 227;
   case 120: return 227;
   case 110: return 227;
   case 90: return 227;
   case 80: return 227;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Enable */


#define GFX125_3DSTATE_DS_Enable_bits  1
#define GFX12_3DSTATE_DS_Enable_bits  1
#define GFX11_3DSTATE_DS_Enable_bits  1
#define GFX9_3DSTATE_DS_Enable_bits  1
#define GFX8_3DSTATE_DS_Enable_bits  1
#define GFX75_3DSTATE_DS_Enable_bits  1
#define GFX7_3DSTATE_DS_Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_Enable_start  224
#define GFX12_3DSTATE_DS_Enable_start  224
#define GFX11_3DSTATE_DS_Enable_start  224
#define GFX9_3DSTATE_DS_Enable_start  224
#define GFX8_3DSTATE_DS_Enable_start  224
#define GFX75_3DSTATE_DS_Enable_start  160
#define GFX7_3DSTATE_DS_Enable_start  160

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 224;
   case 120: return 224;
   case 110: return 224;
   case 90: return 224;
   case 80: return 224;
   case 75: return 160;
   case 70: return 160;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Floating Point Mode */


#define GFX125_3DSTATE_DS_FloatingPointMode_bits  1
#define GFX12_3DSTATE_DS_FloatingPointMode_bits  1
#define GFX11_3DSTATE_DS_FloatingPointMode_bits  1
#define GFX9_3DSTATE_DS_FloatingPointMode_bits  1
#define GFX8_3DSTATE_DS_FloatingPointMode_bits  1
#define GFX75_3DSTATE_DS_FloatingPointMode_bits  1
#define GFX7_3DSTATE_DS_FloatingPointMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_FloatingPointMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_FloatingPointMode_start  112
#define GFX12_3DSTATE_DS_FloatingPointMode_start  112
#define GFX11_3DSTATE_DS_FloatingPointMode_start  112
#define GFX9_3DSTATE_DS_FloatingPointMode_start  112
#define GFX8_3DSTATE_DS_FloatingPointMode_start  112
#define GFX75_3DSTATE_DS_FloatingPointMode_start  80
#define GFX7_3DSTATE_DS_FloatingPointMode_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_FloatingPointMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 112;
   case 120: return 112;
   case 110: return 112;
   case 90: return 112;
   case 80: return 112;
   case 75: return 80;
   case 70: return 80;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Illegal Opcode Exception Enable */


#define GFX125_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GFX12_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GFX11_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GFX9_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GFX8_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GFX75_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1
#define GFX7_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_IllegalOpcodeExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GFX12_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GFX11_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GFX9_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GFX8_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  109
#define GFX75_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  77
#define GFX7_3DSTATE_DS_IllegalOpcodeExceptionEnable_start  77

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_IllegalOpcodeExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 109;
   case 120: return 109;
   case 110: return 109;
   case 90: return 109;
   case 80: return 109;
   case 75: return 77;
   case 70: return 77;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Kernel Start Pointer */


#define GFX125_3DSTATE_DS_KernelStartPointer_bits  58
#define GFX12_3DSTATE_DS_KernelStartPointer_bits  58
#define GFX11_3DSTATE_DS_KernelStartPointer_bits  58
#define GFX9_3DSTATE_DS_KernelStartPointer_bits  58
#define GFX8_3DSTATE_DS_KernelStartPointer_bits  58
#define GFX75_3DSTATE_DS_KernelStartPointer_bits  26
#define GFX7_3DSTATE_DS_KernelStartPointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_KernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 58;
   case 120: return 58;
   case 110: return 58;
   case 90: return 58;
   case 80: return 58;
   case 75: return 26;
   case 70: return 26;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_KernelStartPointer_start  38
#define GFX12_3DSTATE_DS_KernelStartPointer_start  38
#define GFX11_3DSTATE_DS_KernelStartPointer_start  38
#define GFX9_3DSTATE_DS_KernelStartPointer_start  38
#define GFX8_3DSTATE_DS_KernelStartPointer_start  38
#define GFX75_3DSTATE_DS_KernelStartPointer_start  38
#define GFX7_3DSTATE_DS_KernelStartPointer_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_KernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 38;
   case 120: return 38;
   case 110: return 38;
   case 90: return 38;
   case 80: return 38;
   case 75: return 38;
   case 70: return 38;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Maximum Number of Threads */


#define GFX125_3DSTATE_DS_MaximumNumberofThreads_bits  10
#define GFX12_3DSTATE_DS_MaximumNumberofThreads_bits  10
#define GFX11_3DSTATE_DS_MaximumNumberofThreads_bits  10
#define GFX9_3DSTATE_DS_MaximumNumberofThreads_bits  9
#define GFX8_3DSTATE_DS_MaximumNumberofThreads_bits  9
#define GFX75_3DSTATE_DS_MaximumNumberofThreads_bits  9
#define GFX7_3DSTATE_DS_MaximumNumberofThreads_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_MaximumNumberofThreads_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 10;
   case 120: return 10;
   case 110: return 10;
   case 90: return 9;
   case 80: return 9;
   case 75: return 9;
   case 70: return 7;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GFX12_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GFX11_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GFX9_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GFX8_3DSTATE_DS_MaximumNumberofThreads_start  245
#define GFX75_3DSTATE_DS_MaximumNumberofThreads_start  181
#define GFX7_3DSTATE_DS_MaximumNumberofThreads_start  185

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_MaximumNumberofThreads_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 245;
   case 120: return 245;
   case 110: return 245;
   case 90: return 245;
   case 80: return 245;
   case 75: return 181;
   case 70: return 185;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Patch URB Entry Read Length */


#define GFX125_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GFX12_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GFX11_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GFX9_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GFX8_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GFX75_3DSTATE_DS_PatchURBEntryReadLength_bits  7
#define GFX7_3DSTATE_DS_PatchURBEntryReadLength_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 7;
   case 70: return 7;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GFX12_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GFX11_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GFX9_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GFX8_3DSTATE_DS_PatchURBEntryReadLength_start  203
#define GFX75_3DSTATE_DS_PatchURBEntryReadLength_start  139
#define GFX7_3DSTATE_DS_PatchURBEntryReadLength_start  139

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 203;
   case 120: return 203;
   case 110: return 203;
   case 90: return 203;
   case 80: return 203;
   case 75: return 139;
   case 70: return 139;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Patch URB Entry Read Offset */


#define GFX125_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GFX12_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GFX11_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GFX9_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GFX8_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GFX75_3DSTATE_DS_PatchURBEntryReadOffset_bits  6
#define GFX7_3DSTATE_DS_PatchURBEntryReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GFX12_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GFX11_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GFX9_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GFX8_3DSTATE_DS_PatchURBEntryReadOffset_start  196
#define GFX75_3DSTATE_DS_PatchURBEntryReadOffset_start  132
#define GFX7_3DSTATE_DS_PatchURBEntryReadOffset_start  132

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PatchURBEntryReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 196;
   case 120: return 196;
   case 110: return 196;
   case 90: return 196;
   case 80: return 196;
   case 75: return 132;
   case 70: return 132;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Per-Thread Scratch Space */


#define GFX125_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GFX12_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GFX11_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GFX9_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GFX8_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GFX75_3DSTATE_DS_PerThreadScratchSpace_bits  4
#define GFX7_3DSTATE_DS_PerThreadScratchSpace_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PerThreadScratchSpace_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GFX12_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GFX11_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GFX9_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GFX8_3DSTATE_DS_PerThreadScratchSpace_start  128
#define GFX75_3DSTATE_DS_PerThreadScratchSpace_start  96
#define GFX7_3DSTATE_DS_PerThreadScratchSpace_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_PerThreadScratchSpace_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 128;
   case 120: return 128;
   case 110: return 128;
   case 90: return 128;
   case 80: return 128;
   case 75: return 96;
   case 70: return 96;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Sampler Count */


#define GFX125_3DSTATE_DS_SamplerCount_bits  3
#define GFX12_3DSTATE_DS_SamplerCount_bits  3
#define GFX11_3DSTATE_DS_SamplerCount_bits  3
#define GFX9_3DSTATE_DS_SamplerCount_bits  3
#define GFX8_3DSTATE_DS_SamplerCount_bits  3
#define GFX75_3DSTATE_DS_SamplerCount_bits  3
#define GFX7_3DSTATE_DS_SamplerCount_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SamplerCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_SamplerCount_start  123
#define GFX12_3DSTATE_DS_SamplerCount_start  123
#define GFX11_3DSTATE_DS_SamplerCount_start  123
#define GFX9_3DSTATE_DS_SamplerCount_start  123
#define GFX8_3DSTATE_DS_SamplerCount_start  123
#define GFX75_3DSTATE_DS_SamplerCount_start  91
#define GFX7_3DSTATE_DS_SamplerCount_start  91

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SamplerCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 123;
   case 120: return 123;
   case 110: return 123;
   case 90: return 123;
   case 80: return 123;
   case 75: return 91;
   case 70: return 91;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Scratch Space Base Pointer */


#define GFX125_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GFX12_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GFX11_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GFX9_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GFX8_3DSTATE_DS_ScratchSpaceBasePointer_bits  54
#define GFX75_3DSTATE_DS_ScratchSpaceBasePointer_bits  22
#define GFX7_3DSTATE_DS_ScratchSpaceBasePointer_bits  22

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ScratchSpaceBasePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 54;
   case 120: return 54;
   case 110: return 54;
   case 90: return 54;
   case 80: return 54;
   case 75: return 22;
   case 70: return 22;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GFX12_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GFX11_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GFX9_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GFX8_3DSTATE_DS_ScratchSpaceBasePointer_start  138
#define GFX75_3DSTATE_DS_ScratchSpaceBasePointer_start  106
#define GFX7_3DSTATE_DS_ScratchSpaceBasePointer_start  106

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ScratchSpaceBasePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 138;
   case 120: return 138;
   case 110: return 138;
   case 90: return 138;
   case 80: return 138;
   case 75: return 106;
   case 70: return 106;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Single Domain Point Dispatch */


#define GFX8_3DSTATE_DS_SingleDomainPointDispatch_bits  1
#define GFX75_3DSTATE_DS_SingleDomainPointDispatch_bits  1
#define GFX7_3DSTATE_DS_SingleDomainPointDispatch_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SingleDomainPointDispatch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX8_3DSTATE_DS_SingleDomainPointDispatch_start  127
#define GFX75_3DSTATE_DS_SingleDomainPointDispatch_start  95
#define GFX7_3DSTATE_DS_SingleDomainPointDispatch_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SingleDomainPointDispatch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 127;
   case 75: return 95;
   case 70: return 95;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Software Exception Enable */


#define GFX125_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GFX12_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GFX11_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GFX9_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GFX8_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GFX75_3DSTATE_DS_SoftwareExceptionEnable_bits  1
#define GFX7_3DSTATE_DS_SoftwareExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SoftwareExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GFX12_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GFX11_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GFX9_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GFX8_3DSTATE_DS_SoftwareExceptionEnable_start  103
#define GFX75_3DSTATE_DS_SoftwareExceptionEnable_start  71
#define GFX7_3DSTATE_DS_SoftwareExceptionEnable_start  71

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_SoftwareExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 103;
   case 120: return 103;
   case 110: return 103;
   case 90: return 103;
   case 80: return 103;
   case 75: return 71;
   case 70: return 71;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Statistics Enable */


#define GFX125_3DSTATE_DS_StatisticsEnable_bits  1
#define GFX12_3DSTATE_DS_StatisticsEnable_bits  1
#define GFX11_3DSTATE_DS_StatisticsEnable_bits  1
#define GFX9_3DSTATE_DS_StatisticsEnable_bits  1
#define GFX8_3DSTATE_DS_StatisticsEnable_bits  1
#define GFX75_3DSTATE_DS_StatisticsEnable_bits  1
#define GFX7_3DSTATE_DS_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_StatisticsEnable_start  234
#define GFX12_3DSTATE_DS_StatisticsEnable_start  234
#define GFX11_3DSTATE_DS_StatisticsEnable_start  234
#define GFX9_3DSTATE_DS_StatisticsEnable_start  234
#define GFX8_3DSTATE_DS_StatisticsEnable_start  234
#define GFX75_3DSTATE_DS_StatisticsEnable_start  170
#define GFX7_3DSTATE_DS_StatisticsEnable_start  170

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 234;
   case 120: return 234;
   case 110: return 234;
   case 90: return 234;
   case 80: return 234;
   case 75: return 170;
   case 70: return 170;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Thread Dispatch Priority */


#define GFX125_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GFX12_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GFX11_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GFX9_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GFX8_3DSTATE_DS_ThreadDispatchPriority_bits  1
#define GFX75_3DSTATE_DS_ThreadDispatchPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ThreadDispatchPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GFX12_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GFX11_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GFX9_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GFX8_3DSTATE_DS_ThreadDispatchPriority_start  113
#define GFX75_3DSTATE_DS_ThreadDispatchPriority_start  81

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_ThreadDispatchPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 113;
   case 120: return 113;
   case 110: return 113;
   case 90: return 113;
   case 80: return 113;
   case 75: return 81;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::User Clip Distance Clip Test Enable Bitmask */


#define GFX125_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX12_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX11_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX9_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX8_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264
#define GFX12_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264
#define GFX11_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264
#define GFX9_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264
#define GFX8_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start  264

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 264;
   case 120: return 264;
   case 110: return 264;
   case 90: return 264;
   case 80: return 264;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::User Clip Distance Cull Test Enable Bitmask */


#define GFX125_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX12_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX11_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX9_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX8_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256
#define GFX12_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256
#define GFX11_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256
#define GFX9_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256
#define GFX8_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start  256

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_UserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 256;
   case 120: return 256;
   case 110: return 256;
   case 90: return 256;
   case 80: return 256;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Vector Mask Enable */


#define GFX125_3DSTATE_DS_VectorMaskEnable_bits  1
#define GFX12_3DSTATE_DS_VectorMaskEnable_bits  1
#define GFX11_3DSTATE_DS_VectorMaskEnable_bits  1
#define GFX9_3DSTATE_DS_VectorMaskEnable_bits  1
#define GFX8_3DSTATE_DS_VectorMaskEnable_bits  1
#define GFX75_3DSTATE_DS_VectorMaskEnable_bits  1
#define GFX7_3DSTATE_DS_VectorMaskEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VectorMaskEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_VectorMaskEnable_start  126
#define GFX12_3DSTATE_DS_VectorMaskEnable_start  126
#define GFX11_3DSTATE_DS_VectorMaskEnable_start  126
#define GFX9_3DSTATE_DS_VectorMaskEnable_start  126
#define GFX8_3DSTATE_DS_VectorMaskEnable_start  126
#define GFX75_3DSTATE_DS_VectorMaskEnable_start  94
#define GFX7_3DSTATE_DS_VectorMaskEnable_start  94

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VectorMaskEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 126;
   case 120: return 126;
   case 110: return 126;
   case 90: return 126;
   case 80: return 126;
   case 75: return 94;
   case 70: return 94;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Vertex URB Entry Output Length */


#define GFX125_3DSTATE_DS_VertexURBEntryOutputLength_bits  5
#define GFX12_3DSTATE_DS_VertexURBEntryOutputLength_bits  5
#define GFX11_3DSTATE_DS_VertexURBEntryOutputLength_bits  5
#define GFX9_3DSTATE_DS_VertexURBEntryOutputLength_bits  5
#define GFX8_3DSTATE_DS_VertexURBEntryOutputLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_VertexURBEntryOutputLength_start  272
#define GFX12_3DSTATE_DS_VertexURBEntryOutputLength_start  272
#define GFX11_3DSTATE_DS_VertexURBEntryOutputLength_start  272
#define GFX9_3DSTATE_DS_VertexURBEntryOutputLength_start  272
#define GFX8_3DSTATE_DS_VertexURBEntryOutputLength_start  272

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 272;
   case 120: return 272;
   case 110: return 272;
   case 90: return 272;
   case 80: return 272;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_DS::Vertex URB Entry Output Read Offset */


#define GFX125_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6
#define GFX12_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6
#define GFX11_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6
#define GFX9_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6
#define GFX8_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277
#define GFX12_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277
#define GFX11_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277
#define GFX9_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277
#define GFX8_3DSTATE_DS_VertexURBEntryOutputReadOffset_start  277

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_DS_VertexURBEntryOutputReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 277;
   case 120: return 277;
   case 110: return 277;
   case 90: return 277;
   case 80: return 277;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS */





/* 3DSTATE_GATHER_CONSTANT_DS::3D Command Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::3D Command Sub Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Command SubType */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Command Type */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Constant Buffer Binding Table Block */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Constant Buffer Dx9 Generate Stall */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 69;
   case 120: return 69;
   case 110: return 69;
   case 90: return 69;
   case 80: return 69;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Constant Buffer Valid */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::DWord Length */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Gather Buffer Offset */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 17;
   case 120: return 17;
   case 110: return 17;
   case 90: return 17;
   case 80: return 17;
   case 75: return 17;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GFX8_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70
#define GFX75_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 70;
   case 120: return 70;
   case 110: return 70;
   case 90: return 70;
   case 80: return 70;
   case 75: return 70;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::On-Die Table */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start  67
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start  67
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start  67
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 67;
   case 120: return 67;
   case 110: return 67;
   case 90: return 67;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_DS::Update Gather Table Only */


#define GFX125_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start  33
#define GFX12_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start  33
#define GFX11_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start  33
#define GFX9_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_DS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 33;
   case 120: return 33;
   case 110: return 33;
   case 90: return 33;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS */





/* 3DSTATE_GATHER_CONSTANT_GS::3D Command Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::3D Command Sub Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Command SubType */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Command Type */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Constant Buffer Binding Table Block */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Constant Buffer Dx9 Generate Stall */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 69;
   case 120: return 69;
   case 110: return 69;
   case 90: return 69;
   case 80: return 69;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Constant Buffer Valid */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::DWord Length */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Gather Buffer Offset */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 17;
   case 120: return 17;
   case 110: return 17;
   case 90: return 17;
   case 80: return 17;
   case 75: return 17;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GFX8_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70
#define GFX75_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 70;
   case 120: return 70;
   case 110: return 70;
   case 90: return 70;
   case 80: return 70;
   case 75: return 70;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::On-Die Table */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start  67
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start  67
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start  67
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 67;
   case 120: return 67;
   case 110: return 67;
   case 90: return 67;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_GS::Update Gather Table Only */


#define GFX125_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start  33
#define GFX12_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start  33
#define GFX11_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start  33
#define GFX9_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_GS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 33;
   case 120: return 33;
   case 110: return 33;
   case 90: return 33;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS */





/* 3DSTATE_GATHER_CONSTANT_HS::3D Command Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::3D Command Sub Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Command SubType */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Command Type */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Constant Buffer Binding Table Block */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Constant Buffer Dx9 Generate Stall */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 69;
   case 120: return 69;
   case 110: return 69;
   case 90: return 69;
   case 80: return 69;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Constant Buffer Valid */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::DWord Length */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Gather Buffer Offset */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 17;
   case 120: return 17;
   case 110: return 17;
   case 90: return 17;
   case 80: return 17;
   case 75: return 17;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GFX8_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70
#define GFX75_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 70;
   case 120: return 70;
   case 110: return 70;
   case 90: return 70;
   case 80: return 70;
   case 75: return 70;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::On-Die Table */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start  67
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start  67
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start  67
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 67;
   case 120: return 67;
   case 110: return 67;
   case 90: return 67;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_HS::Update Gather Table Only */


#define GFX125_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start  33
#define GFX12_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start  33
#define GFX11_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start  33
#define GFX9_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_HS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 33;
   case 120: return 33;
   case 110: return 33;
   case 90: return 33;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS */





/* 3DSTATE_GATHER_CONSTANT_PS::3D Command Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::3D Command Sub Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Command SubType */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Command Type */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Binding Table Block */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Dx9 Enable */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start  68

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 68;
   case 120: return 68;
   case 110: return 68;
   case 90: return 68;
   case 80: return 68;
   case 75: return 68;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Dx9 Generate Stall */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 69;
   case 120: return 69;
   case 110: return 69;
   case 90: return 69;
   case 80: return 69;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Constant Buffer Valid */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::DWord Length */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::DX9 On-Die Register Read Enable */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start  32
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start  32
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start  32
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_DX9OnDieRegisterReadEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Gather Buffer Offset */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 17;
   case 120: return 17;
   case 110: return 17;
   case 90: return 17;
   case 80: return 17;
   case 75: return 17;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GFX8_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70
#define GFX75_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 70;
   case 120: return 70;
   case 110: return 70;
   case 90: return 70;
   case 80: return 70;
   case 75: return 70;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::On-Die Table */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start  67
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start  67
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start  67
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 67;
   case 120: return 67;
   case 110: return 67;
   case 90: return 67;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_PS::Update Gather Table Only */


#define GFX125_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start  33
#define GFX12_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start  33
#define GFX11_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start  33
#define GFX9_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_PS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 33;
   case 120: return 33;
   case 110: return 33;
   case 90: return 33;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS */





/* 3DSTATE_GATHER_CONSTANT_VS::3D Command Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::3D Command Sub Opcode */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Command SubType */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Command Type */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Binding Table Block */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferBindingTableBlock_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Dx9 Enable */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start  68

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 68;
   case 120: return 68;
   case 110: return 68;
   case 90: return 68;
   case 80: return 68;
   case 75: return 68;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Dx9 Generate Stall */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start  69

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferDx9GenerateStall_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 69;
   case 120: return 69;
   case 110: return 69;
   case 90: return 69;
   case 80: return 69;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Constant Buffer Valid */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_ConstantBufferValid_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::DWord Length */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::DX9 On-Die Register Read Enable */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start  32
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start  32
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start  32
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_DX9OnDieRegisterReadEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Gather Buffer Offset */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 17;
   case 120: return 17;
   case 110: return 17;
   case 90: return 17;
   case 80: return 17;
   case 75: return 17;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GFX8_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70
#define GFX75_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start  70

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_GatherBufferOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 70;
   case 120: return 70;
   case 110: return 70;
   case 90: return 70;
   case 80: return 70;
   case 75: return 70;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::On-Die Table */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start  67
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start  67
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start  67
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start  67

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_OnDieTable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 67;
   case 120: return 67;
   case 110: return 67;
   case 90: return 67;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_CONSTANT_VS::Update Gather Table Only */


#define GFX125_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits  1
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits  1
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits  1
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start  33
#define GFX12_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start  33
#define GFX11_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start  33
#define GFX9_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start  33

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_CONSTANT_VS_UpdateGatherTableOnly_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 33;
   case 120: return 33;
   case 110: return 33;
   case 90: return 33;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_length  4
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::3D Command Opcode */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::3D Command Sub Opcode */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Command SubType */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Command Type */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::DWord Length */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Base Address */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  52
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 52;
   case 120: return 52;
   case 110: return 52;
   case 90: return 52;
   case 80: return 52;
   case 75: return 20;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start  44

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Buffer Size */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 20;
   case 120: return 20;
   case 110: return 20;
   case 90: return 20;
   case 80: return 20;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start  108

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolBufferSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 108;
   case 120: return 108;
   case 110: return 108;
   case 90: return 108;
   case 80: return 108;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Enable */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start  43

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 43;
   case 120: return 43;
   case 110: return 43;
   case 90: return 43;
   case 80: return 43;
   case 75: return 43;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::Gather Pool Upper Bound */


#define GFX75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_bits  20

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 20;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_start  76

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_GatherPoolUpperBound_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 76;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GATHER_POOL_ALLOC::MOCS */


#define GFX125_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits  7
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits  7
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits  7
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits  7
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits  7
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 4;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GATHER_POOL_ALLOC_MOCS_start  32
#define GFX12_3DSTATE_GATHER_POOL_ALLOC_MOCS_start  32
#define GFX11_3DSTATE_GATHER_POOL_ALLOC_MOCS_start  32
#define GFX9_3DSTATE_GATHER_POOL_ALLOC_MOCS_start  32
#define GFX8_3DSTATE_GATHER_POOL_ALLOC_MOCS_start  32
#define GFX75_3DSTATE_GATHER_POOL_ALLOC_MOCS_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GATHER_POOL_ALLOC_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length  2
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length  2
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::3D Command Opcode */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits  3
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start  24
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start  24
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::3D Command Sub Opcode */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits  8
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start  16
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::Command SubType */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits  2
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits  2
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 2;
   case 45: return 2;
   case 40: return 2;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start  27
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start  27
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 27;
   case 45: return 27;
   case 40: return 27;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::Command Type */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits  3
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits  3
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start  29
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start  29
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 29;
   case 45: return 29;
   case 40: return 29;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::DWord Length */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits  8
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits  8
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start  0
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start  0
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP::Global Depth Offset Clamp */


#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits  32
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits  32
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX5_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start  32
#define GFX45_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start  32
#define GFX4_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GLOBAL_DEPTH_OFFSET_CLAMP_GlobalDepthOffsetClamp_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS */


#define GFX125_3DSTATE_GS_length  10
#define GFX12_3DSTATE_GS_length  10
#define GFX11_3DSTATE_GS_length  10
#define GFX9_3DSTATE_GS_length  10
#define GFX8_3DSTATE_GS_length  10
#define GFX75_3DSTATE_GS_length  7
#define GFX7_3DSTATE_GS_length  7
#define GFX6_3DSTATE_GS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 10;
   case 120: return 10;
   case 110: return 10;
   case 90: return 10;
   case 80: return 10;
   case 75: return 7;
   case 70: return 7;
   case 60: return 7;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::3D Command Opcode */


#define GFX125_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_GS_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_GS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_GS_3DCommandOpcode_start  24
#define GFX6_3DSTATE_GS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::3D Command Sub Opcode */


#define GFX125_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_GS_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_GS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_GS_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_GS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Accesses UAV */


#define GFX125_3DSTATE_GS_AccessesUAV_bits  1
#define GFX12_3DSTATE_GS_AccessesUAV_bits  1
#define GFX11_3DSTATE_GS_AccessesUAV_bits  1
#define GFX9_3DSTATE_GS_AccessesUAV_bits  1
#define GFX8_3DSTATE_GS_AccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_AccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_AccessesUAV_start  108
#define GFX12_3DSTATE_GS_AccessesUAV_start  108
#define GFX11_3DSTATE_GS_AccessesUAV_start  108
#define GFX9_3DSTATE_GS_AccessesUAV_start  108
#define GFX8_3DSTATE_GS_AccessesUAV_start  108

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_AccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 108;
   case 120: return 108;
   case 110: return 108;
   case 90: return 108;
   case 80: return 108;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Binding Table Entry Count */


#define GFX125_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX12_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX11_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX9_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX8_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX75_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX7_3DSTATE_GS_BindingTableEntryCount_bits  8
#define GFX6_3DSTATE_GS_BindingTableEntryCount_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_BindingTableEntryCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_BindingTableEntryCount_start  114
#define GFX12_3DSTATE_GS_BindingTableEntryCount_start  114
#define GFX11_3DSTATE_GS_BindingTableEntryCount_start  114
#define GFX9_3DSTATE_GS_BindingTableEntryCount_start  114
#define GFX8_3DSTATE_GS_BindingTableEntryCount_start  114
#define GFX75_3DSTATE_GS_BindingTableEntryCount_start  82
#define GFX7_3DSTATE_GS_BindingTableEntryCount_start  82
#define GFX6_3DSTATE_GS_BindingTableEntryCount_start  82

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_BindingTableEntryCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 114;
   case 120: return 114;
   case 110: return 114;
   case 90: return 114;
   case 80: return 114;
   case 75: return 82;
   case 70: return 82;
   case 60: return 82;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Command SubType */


#define GFX125_3DSTATE_GS_CommandSubType_bits  2
#define GFX12_3DSTATE_GS_CommandSubType_bits  2
#define GFX11_3DSTATE_GS_CommandSubType_bits  2
#define GFX9_3DSTATE_GS_CommandSubType_bits  2
#define GFX8_3DSTATE_GS_CommandSubType_bits  2
#define GFX75_3DSTATE_GS_CommandSubType_bits  2
#define GFX7_3DSTATE_GS_CommandSubType_bits  2
#define GFX6_3DSTATE_GS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_CommandSubType_start  27
#define GFX12_3DSTATE_GS_CommandSubType_start  27
#define GFX11_3DSTATE_GS_CommandSubType_start  27
#define GFX9_3DSTATE_GS_CommandSubType_start  27
#define GFX8_3DSTATE_GS_CommandSubType_start  27
#define GFX75_3DSTATE_GS_CommandSubType_start  27
#define GFX7_3DSTATE_GS_CommandSubType_start  27
#define GFX6_3DSTATE_GS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Command Type */


#define GFX125_3DSTATE_GS_CommandType_bits  3
#define GFX12_3DSTATE_GS_CommandType_bits  3
#define GFX11_3DSTATE_GS_CommandType_bits  3
#define GFX9_3DSTATE_GS_CommandType_bits  3
#define GFX8_3DSTATE_GS_CommandType_bits  3
#define GFX75_3DSTATE_GS_CommandType_bits  3
#define GFX7_3DSTATE_GS_CommandType_bits  3
#define GFX6_3DSTATE_GS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_CommandType_start  29
#define GFX12_3DSTATE_GS_CommandType_start  29
#define GFX11_3DSTATE_GS_CommandType_start  29
#define GFX9_3DSTATE_GS_CommandType_start  29
#define GFX8_3DSTATE_GS_CommandType_start  29
#define GFX75_3DSTATE_GS_CommandType_start  29
#define GFX7_3DSTATE_GS_CommandType_start  29
#define GFX6_3DSTATE_GS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Control Data Format */


#define GFX125_3DSTATE_GS_ControlDataFormat_bits  1
#define GFX12_3DSTATE_GS_ControlDataFormat_bits  1
#define GFX11_3DSTATE_GS_ControlDataFormat_bits  1
#define GFX9_3DSTATE_GS_ControlDataFormat_bits  1
#define GFX8_3DSTATE_GS_ControlDataFormat_bits  1
#define GFX75_3DSTATE_GS_ControlDataFormat_bits  1
#define GFX7_3DSTATE_GS_ControlDataFormat_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataFormat_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_ControlDataFormat_start  287
#define GFX12_3DSTATE_GS_ControlDataFormat_start  287
#define GFX11_3DSTATE_GS_ControlDataFormat_start  287
#define GFX9_3DSTATE_GS_ControlDataFormat_start  287
#define GFX8_3DSTATE_GS_ControlDataFormat_start  287
#define GFX75_3DSTATE_GS_ControlDataFormat_start  223
#define GFX7_3DSTATE_GS_ControlDataFormat_start  184

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataFormat_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 287;
   case 120: return 287;
   case 110: return 287;
   case 90: return 287;
   case 80: return 287;
   case 75: return 223;
   case 70: return 184;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Control Data Header Size */


#define GFX125_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GFX12_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GFX11_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GFX9_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GFX8_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GFX75_3DSTATE_GS_ControlDataHeaderSize_bits  4
#define GFX7_3DSTATE_GS_ControlDataHeaderSize_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataHeaderSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GFX12_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GFX11_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GFX9_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GFX8_3DSTATE_GS_ControlDataHeaderSize_start  244
#define GFX75_3DSTATE_GS_ControlDataHeaderSize_start  180
#define GFX7_3DSTATE_GS_ControlDataHeaderSize_start  180

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ControlDataHeaderSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 244;
   case 120: return 244;
   case 110: return 244;
   case 90: return 244;
   case 80: return 244;
   case 75: return 180;
   case 70: return 180;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::DWord Length */


#define GFX125_3DSTATE_GS_DWordLength_bits  8
#define GFX12_3DSTATE_GS_DWordLength_bits  8
#define GFX11_3DSTATE_GS_DWordLength_bits  8
#define GFX9_3DSTATE_GS_DWordLength_bits  8
#define GFX8_3DSTATE_GS_DWordLength_bits  8
#define GFX75_3DSTATE_GS_DWordLength_bits  8
#define GFX7_3DSTATE_GS_DWordLength_bits  8
#define GFX6_3DSTATE_GS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_DWordLength_start  0
#define GFX12_3DSTATE_GS_DWordLength_start  0
#define GFX11_3DSTATE_GS_DWordLength_start  0
#define GFX9_3DSTATE_GS_DWordLength_start  0
#define GFX8_3DSTATE_GS_DWordLength_start  0
#define GFX75_3DSTATE_GS_DWordLength_start  0
#define GFX7_3DSTATE_GS_DWordLength_start  0
#define GFX6_3DSTATE_GS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Default StreamID */


#define GFX75_3DSTATE_GS_DefaultStreamID_bits  2
#define GFX7_3DSTATE_GS_DefaultStreamID_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamID_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_GS_DefaultStreamID_start  173
#define GFX7_3DSTATE_GS_DefaultStreamID_start  173

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamID_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 173;
   case 70: return 173;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Default Stream Id */


#define GFX125_3DSTATE_GS_DefaultStreamId_bits  2
#define GFX12_3DSTATE_GS_DefaultStreamId_bits  2
#define GFX11_3DSTATE_GS_DefaultStreamId_bits  2
#define GFX9_3DSTATE_GS_DefaultStreamId_bits  2
#define GFX8_3DSTATE_GS_DefaultStreamId_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamId_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_DefaultStreamId_start  237
#define GFX12_3DSTATE_GS_DefaultStreamId_start  237
#define GFX11_3DSTATE_GS_DefaultStreamId_start  237
#define GFX9_3DSTATE_GS_DefaultStreamId_start  237
#define GFX8_3DSTATE_GS_DefaultStreamId_start  237

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DefaultStreamId_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 237;
   case 120: return 237;
   case 110: return 237;
   case 90: return 237;
   case 80: return 237;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Discard Adjacency */


#define GFX125_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX12_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX11_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX9_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX8_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX75_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX7_3DSTATE_GS_DiscardAdjacency_bits  1
#define GFX6_3DSTATE_GS_DiscardAdjacency_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DiscardAdjacency_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_DiscardAdjacency_start  225
#define GFX12_3DSTATE_GS_DiscardAdjacency_start  225
#define GFX11_3DSTATE_GS_DiscardAdjacency_start  225
#define GFX9_3DSTATE_GS_DiscardAdjacency_start  225
#define GFX8_3DSTATE_GS_DiscardAdjacency_start  225
#define GFX75_3DSTATE_GS_DiscardAdjacency_start  161
#define GFX7_3DSTATE_GS_DiscardAdjacency_start  161
#define GFX6_3DSTATE_GS_DiscardAdjacency_start  221

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DiscardAdjacency_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 225;
   case 120: return 225;
   case 110: return 225;
   case 90: return 225;
   case 80: return 225;
   case 75: return 161;
   case 70: return 161;
   case 60: return 221;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Dispatch GRF Start Register For URB Data */


#define GFX125_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX12_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX11_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX9_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX8_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX75_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX7_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4
#define GFX6_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GFX12_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GFX11_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GFX9_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GFX8_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  192
#define GFX75_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  128
#define GFX7_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  128
#define GFX6_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 192;
   case 120: return 192;
   case 110: return 192;
   case 90: return 192;
   case 80: return 192;
   case 75: return 128;
   case 70: return 128;
   case 60: return 128;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Dispatch GRF Start Register For URB Data [5:4] */


#define GFX125_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits  2
#define GFX12_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits  2
#define GFX11_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits  2
#define GFX9_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start  221
#define GFX12_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start  221
#define GFX11_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start  221
#define GFX9_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start  221

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchGRFStartRegisterForURBData54_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 221;
   case 120: return 221;
   case 110: return 221;
   case 90: return 221;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Dispatch Mode */


#define GFX125_3DSTATE_GS_DispatchMode_bits  2
#define GFX12_3DSTATE_GS_DispatchMode_bits  2
#define GFX11_3DSTATE_GS_DispatchMode_bits  2
#define GFX9_3DSTATE_GS_DispatchMode_bits  2
#define GFX8_3DSTATE_GS_DispatchMode_bits  2
#define GFX75_3DSTATE_GS_DispatchMode_bits  2
#define GFX7_3DSTATE_GS_DispatchMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_DispatchMode_start  235
#define GFX12_3DSTATE_GS_DispatchMode_start  235
#define GFX11_3DSTATE_GS_DispatchMode_start  235
#define GFX9_3DSTATE_GS_DispatchMode_start  235
#define GFX8_3DSTATE_GS_DispatchMode_start  235
#define GFX75_3DSTATE_GS_DispatchMode_start  171
#define GFX7_3DSTATE_GS_DispatchMode_start  171

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_DispatchMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 235;
   case 120: return 235;
   case 110: return 235;
   case 90: return 235;
   case 80: return 235;
   case 75: return 171;
   case 70: return 171;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Enable */


#define GFX125_3DSTATE_GS_Enable_bits  1
#define GFX12_3DSTATE_GS_Enable_bits  1
#define GFX11_3DSTATE_GS_Enable_bits  1
#define GFX9_3DSTATE_GS_Enable_bits  1
#define GFX8_3DSTATE_GS_Enable_bits  1
#define GFX75_3DSTATE_GS_Enable_bits  1
#define GFX7_3DSTATE_GS_Enable_bits  1
#define GFX6_3DSTATE_GS_Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_Enable_start  224
#define GFX12_3DSTATE_GS_Enable_start  224
#define GFX11_3DSTATE_GS_Enable_start  224
#define GFX9_3DSTATE_GS_Enable_start  224
#define GFX8_3DSTATE_GS_Enable_start  224
#define GFX75_3DSTATE_GS_Enable_start  160
#define GFX7_3DSTATE_GS_Enable_start  160
#define GFX6_3DSTATE_GS_Enable_start  207

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 224;
   case 120: return 224;
   case 110: return 224;
   case 90: return 224;
   case 80: return 224;
   case 75: return 160;
   case 70: return 160;
   case 60: return 207;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Expected Vertex Count */


#define GFX125_3DSTATE_GS_ExpectedVertexCount_bits  6
#define GFX12_3DSTATE_GS_ExpectedVertexCount_bits  6
#define GFX11_3DSTATE_GS_ExpectedVertexCount_bits  6
#define GFX9_3DSTATE_GS_ExpectedVertexCount_bits  6
#define GFX8_3DSTATE_GS_ExpectedVertexCount_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ExpectedVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_ExpectedVertexCount_start  96
#define GFX12_3DSTATE_GS_ExpectedVertexCount_start  96
#define GFX11_3DSTATE_GS_ExpectedVertexCount_start  96
#define GFX9_3DSTATE_GS_ExpectedVertexCount_start  96
#define GFX8_3DSTATE_GS_ExpectedVertexCount_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ExpectedVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 96;
   case 120: return 96;
   case 110: return 96;
   case 90: return 96;
   case 80: return 96;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Floating Point Mode */


#define GFX125_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX12_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX11_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX9_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX8_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX75_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX7_3DSTATE_GS_FloatingPointMode_bits  1
#define GFX6_3DSTATE_GS_FloatingPointMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_FloatingPointMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_FloatingPointMode_start  112
#define GFX12_3DSTATE_GS_FloatingPointMode_start  112
#define GFX11_3DSTATE_GS_FloatingPointMode_start  112
#define GFX9_3DSTATE_GS_FloatingPointMode_start  112
#define GFX8_3DSTATE_GS_FloatingPointMode_start  112
#define GFX75_3DSTATE_GS_FloatingPointMode_start  80
#define GFX7_3DSTATE_GS_FloatingPointMode_start  80
#define GFX6_3DSTATE_GS_FloatingPointMode_start  80

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_FloatingPointMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 112;
   case 120: return 112;
   case 110: return 112;
   case 90: return 112;
   case 80: return 112;
   case 75: return 80;
   case 70: return 80;
   case 60: return 80;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::GS Invocations Increment Value */


#define GFX75_3DSTATE_GS_GSInvocationsIncrementValue_bits  5
#define GFX7_3DSTATE_GS_GSInvocationsIncrementValue_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSInvocationsIncrementValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 5;
   case 70: return 5;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_GS_GSInvocationsIncrementValue_start  165
#define GFX7_3DSTATE_GS_GSInvocationsIncrementValue_start  165

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSInvocationsIncrementValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 165;
   case 70: return 165;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::GS accesses UAV */


#define GFX75_3DSTATE_GS_GSaccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSaccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_GS_GSaccessesUAV_start  76

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_GSaccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 76;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Hint */


#define GFX125_3DSTATE_GS_Hint_bits  1
#define GFX12_3DSTATE_GS_Hint_bits  1
#define GFX11_3DSTATE_GS_Hint_bits  1
#define GFX9_3DSTATE_GS_Hint_bits  1
#define GFX8_3DSTATE_GS_Hint_bits  1
#define GFX75_3DSTATE_GS_Hint_bits  1
#define GFX7_3DSTATE_GS_Hint_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Hint_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_Hint_start  227
#define GFX12_3DSTATE_GS_Hint_start  227
#define GFX11_3DSTATE_GS_Hint_start  227
#define GFX9_3DSTATE_GS_Hint_start  227
#define GFX8_3DSTATE_GS_Hint_start  227
#define GFX75_3DSTATE_GS_Hint_start  163
#define GFX7_3DSTATE_GS_Hint_start  163

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_Hint_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 227;
   case 120: return 227;
   case 110: return 227;
   case 90: return 227;
   case 80: return 227;
   case 75: return 163;
   case 70: return 163;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Illegal Opcode Exception Enable */


#define GFX125_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX12_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX11_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX9_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX8_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX75_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX7_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1
#define GFX6_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IllegalOpcodeExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GFX12_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GFX11_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GFX9_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GFX8_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  109
#define GFX75_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  77
#define GFX7_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  77
#define GFX6_3DSTATE_GS_IllegalOpcodeExceptionEnable_start  77

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IllegalOpcodeExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 109;
   case 120: return 109;
   case 110: return 109;
   case 90: return 109;
   case 80: return 109;
   case 75: return 77;
   case 70: return 77;
   case 60: return 77;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Include Primitive ID */


#define GFX125_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GFX12_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GFX11_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GFX9_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GFX8_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GFX75_3DSTATE_GS_IncludePrimitiveID_bits  1
#define GFX7_3DSTATE_GS_IncludePrimitiveID_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludePrimitiveID_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_IncludePrimitiveID_start  228
#define GFX12_3DSTATE_GS_IncludePrimitiveID_start  228
#define GFX11_3DSTATE_GS_IncludePrimitiveID_start  228
#define GFX9_3DSTATE_GS_IncludePrimitiveID_start  228
#define GFX8_3DSTATE_GS_IncludePrimitiveID_start  228
#define GFX75_3DSTATE_GS_IncludePrimitiveID_start  164
#define GFX7_3DSTATE_GS_IncludePrimitiveID_start  164

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludePrimitiveID_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 228;
   case 120: return 228;
   case 110: return 228;
   case 90: return 228;
   case 80: return 228;
   case 75: return 164;
   case 70: return 164;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Include Vertex Handles */


#define GFX125_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GFX12_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GFX11_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GFX9_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GFX8_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GFX75_3DSTATE_GS_IncludeVertexHandles_bits  1
#define GFX7_3DSTATE_GS_IncludeVertexHandles_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludeVertexHandles_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_IncludeVertexHandles_start  202
#define GFX12_3DSTATE_GS_IncludeVertexHandles_start  202
#define GFX11_3DSTATE_GS_IncludeVertexHandles_start  202
#define GFX9_3DSTATE_GS_IncludeVertexHandles_start  202
#define GFX8_3DSTATE_GS_IncludeVertexHandles_start  202
#define GFX75_3DSTATE_GS_IncludeVertexHandles_start  138
#define GFX7_3DSTATE_GS_IncludeVertexHandles_start  138

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_IncludeVertexHandles_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 202;
   case 120: return 202;
   case 110: return 202;
   case 90: return 202;
   case 80: return 202;
   case 75: return 138;
   case 70: return 138;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Instance Control */


#define GFX125_3DSTATE_GS_InstanceControl_bits  5
#define GFX12_3DSTATE_GS_InstanceControl_bits  5
#define GFX11_3DSTATE_GS_InstanceControl_bits  5
#define GFX9_3DSTATE_GS_InstanceControl_bits  5
#define GFX8_3DSTATE_GS_InstanceControl_bits  5
#define GFX75_3DSTATE_GS_InstanceControl_bits  5
#define GFX7_3DSTATE_GS_InstanceControl_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InstanceControl_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 5;
   case 70: return 5;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_InstanceControl_start  239
#define GFX12_3DSTATE_GS_InstanceControl_start  239
#define GFX11_3DSTATE_GS_InstanceControl_start  239
#define GFX9_3DSTATE_GS_InstanceControl_start  239
#define GFX8_3DSTATE_GS_InstanceControl_start  239
#define GFX75_3DSTATE_GS_InstanceControl_start  175
#define GFX7_3DSTATE_GS_InstanceControl_start  175

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InstanceControl_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 239;
   case 120: return 239;
   case 110: return 239;
   case 90: return 239;
   case 80: return 239;
   case 75: return 175;
   case 70: return 175;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Invocations Increment Value */


#define GFX125_3DSTATE_GS_InvocationsIncrementValue_bits  5
#define GFX12_3DSTATE_GS_InvocationsIncrementValue_bits  5
#define GFX11_3DSTATE_GS_InvocationsIncrementValue_bits  5
#define GFX9_3DSTATE_GS_InvocationsIncrementValue_bits  5
#define GFX8_3DSTATE_GS_InvocationsIncrementValue_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InvocationsIncrementValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_InvocationsIncrementValue_start  229
#define GFX12_3DSTATE_GS_InvocationsIncrementValue_start  229
#define GFX11_3DSTATE_GS_InvocationsIncrementValue_start  229
#define GFX9_3DSTATE_GS_InvocationsIncrementValue_start  229
#define GFX8_3DSTATE_GS_InvocationsIncrementValue_start  229

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_InvocationsIncrementValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 229;
   case 120: return 229;
   case 110: return 229;
   case 90: return 229;
   case 80: return 229;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Kernel Start Pointer */


#define GFX125_3DSTATE_GS_KernelStartPointer_bits  58
#define GFX12_3DSTATE_GS_KernelStartPointer_bits  58
#define GFX11_3DSTATE_GS_KernelStartPointer_bits  58
#define GFX9_3DSTATE_GS_KernelStartPointer_bits  58
#define GFX8_3DSTATE_GS_KernelStartPointer_bits  58
#define GFX75_3DSTATE_GS_KernelStartPointer_bits  26
#define GFX7_3DSTATE_GS_KernelStartPointer_bits  26
#define GFX6_3DSTATE_GS_KernelStartPointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_KernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 58;
   case 120: return 58;
   case 110: return 58;
   case 90: return 58;
   case 80: return 58;
   case 75: return 26;
   case 70: return 26;
   case 60: return 26;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_KernelStartPointer_start  38
#define GFX12_3DSTATE_GS_KernelStartPointer_start  38
#define GFX11_3DSTATE_GS_KernelStartPointer_start  38
#define GFX9_3DSTATE_GS_KernelStartPointer_start  38
#define GFX8_3DSTATE_GS_KernelStartPointer_start  38
#define GFX75_3DSTATE_GS_KernelStartPointer_start  38
#define GFX7_3DSTATE_GS_KernelStartPointer_start  38
#define GFX6_3DSTATE_GS_KernelStartPointer_start  38

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_KernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 38;
   case 120: return 38;
   case 110: return 38;
   case 90: return 38;
   case 80: return 38;
   case 75: return 38;
   case 70: return 38;
   case 60: return 38;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Mask Stack Exception Enable */


#define GFX125_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX12_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX11_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX9_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX8_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX75_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX7_3DSTATE_GS_MaskStackExceptionEnable_bits  1
#define GFX6_3DSTATE_GS_MaskStackExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaskStackExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GFX12_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GFX11_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GFX9_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GFX8_3DSTATE_GS_MaskStackExceptionEnable_start  107
#define GFX75_3DSTATE_GS_MaskStackExceptionEnable_start  75
#define GFX7_3DSTATE_GS_MaskStackExceptionEnable_start  75
#define GFX6_3DSTATE_GS_MaskStackExceptionEnable_start  75

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaskStackExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 107;
   case 120: return 107;
   case 110: return 107;
   case 90: return 107;
   case 80: return 107;
   case 75: return 75;
   case 70: return 75;
   case 60: return 75;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Maximum Number of Threads */


#define GFX125_3DSTATE_GS_MaximumNumberofThreads_bits  9
#define GFX12_3DSTATE_GS_MaximumNumberofThreads_bits  9
#define GFX11_3DSTATE_GS_MaximumNumberofThreads_bits  9
#define GFX9_3DSTATE_GS_MaximumNumberofThreads_bits  9
#define GFX8_3DSTATE_GS_MaximumNumberofThreads_bits  8
#define GFX75_3DSTATE_GS_MaximumNumberofThreads_bits  8
#define GFX7_3DSTATE_GS_MaximumNumberofThreads_bits  7
#define GFX6_3DSTATE_GS_MaximumNumberofThreads_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaximumNumberofThreads_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 8;
   case 75: return 8;
   case 70: return 7;
   case 60: return 7;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_MaximumNumberofThreads_start  256
#define GFX12_3DSTATE_GS_MaximumNumberofThreads_start  256
#define GFX11_3DSTATE_GS_MaximumNumberofThreads_start  256
#define GFX9_3DSTATE_GS_MaximumNumberofThreads_start  256
#define GFX8_3DSTATE_GS_MaximumNumberofThreads_start  248
#define GFX75_3DSTATE_GS_MaximumNumberofThreads_start  184
#define GFX7_3DSTATE_GS_MaximumNumberofThreads_start  185
#define GFX6_3DSTATE_GS_MaximumNumberofThreads_start  185

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_MaximumNumberofThreads_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 256;
   case 120: return 256;
   case 110: return 256;
   case 90: return 256;
   case 80: return 248;
   case 75: return 184;
   case 70: return 185;
   case 60: return 185;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Output Topology */


#define GFX125_3DSTATE_GS_OutputTopology_bits  6
#define GFX12_3DSTATE_GS_OutputTopology_bits  6
#define GFX11_3DSTATE_GS_OutputTopology_bits  6
#define GFX9_3DSTATE_GS_OutputTopology_bits  6
#define GFX8_3DSTATE_GS_OutputTopology_bits  6
#define GFX75_3DSTATE_GS_OutputTopology_bits  6
#define GFX7_3DSTATE_GS_OutputTopology_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputTopology_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_OutputTopology_start  209
#define GFX12_3DSTATE_GS_OutputTopology_start  209
#define GFX11_3DSTATE_GS_OutputTopology_start  209
#define GFX9_3DSTATE_GS_OutputTopology_start  209
#define GFX8_3DSTATE_GS_OutputTopology_start  209
#define GFX75_3DSTATE_GS_OutputTopology_start  145
#define GFX7_3DSTATE_GS_OutputTopology_start  145

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputTopology_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 209;
   case 120: return 209;
   case 110: return 209;
   case 90: return 209;
   case 80: return 209;
   case 75: return 145;
   case 70: return 145;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Output Vertex Size */


#define GFX125_3DSTATE_GS_OutputVertexSize_bits  6
#define GFX12_3DSTATE_GS_OutputVertexSize_bits  6
#define GFX11_3DSTATE_GS_OutputVertexSize_bits  6
#define GFX9_3DSTATE_GS_OutputVertexSize_bits  6
#define GFX8_3DSTATE_GS_OutputVertexSize_bits  6
#define GFX75_3DSTATE_GS_OutputVertexSize_bits  6
#define GFX7_3DSTATE_GS_OutputVertexSize_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputVertexSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_OutputVertexSize_start  215
#define GFX12_3DSTATE_GS_OutputVertexSize_start  215
#define GFX11_3DSTATE_GS_OutputVertexSize_start  215
#define GFX9_3DSTATE_GS_OutputVertexSize_start  215
#define GFX8_3DSTATE_GS_OutputVertexSize_start  215
#define GFX75_3DSTATE_GS_OutputVertexSize_start  151
#define GFX7_3DSTATE_GS_OutputVertexSize_start  151

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_OutputVertexSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 215;
   case 120: return 215;
   case 110: return 215;
   case 90: return 215;
   case 80: return 215;
   case 75: return 151;
   case 70: return 151;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Per-Thread Scratch Space */


#define GFX125_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX12_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX11_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX9_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX8_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX75_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX7_3DSTATE_GS_PerThreadScratchSpace_bits  4
#define GFX6_3DSTATE_GS_PerThreadScratchSpace_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_PerThreadScratchSpace_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GFX12_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GFX11_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GFX9_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GFX8_3DSTATE_GS_PerThreadScratchSpace_start  128
#define GFX75_3DSTATE_GS_PerThreadScratchSpace_start  96
#define GFX7_3DSTATE_GS_PerThreadScratchSpace_start  96
#define GFX6_3DSTATE_GS_PerThreadScratchSpace_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_PerThreadScratchSpace_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 128;
   case 120: return 128;
   case 110: return 128;
   case 90: return 128;
   case 80: return 128;
   case 75: return 96;
   case 70: return 96;
   case 60: return 96;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Rendering Enabled */


#define GFX6_3DSTATE_GS_RenderingEnabled_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_RenderingEnabled_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_RenderingEnabled_start  168

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_RenderingEnabled_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 168;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Reorder Mode */


#define GFX125_3DSTATE_GS_ReorderMode_bits  1
#define GFX12_3DSTATE_GS_ReorderMode_bits  1
#define GFX11_3DSTATE_GS_ReorderMode_bits  1
#define GFX9_3DSTATE_GS_ReorderMode_bits  1
#define GFX8_3DSTATE_GS_ReorderMode_bits  1
#define GFX75_3DSTATE_GS_ReorderMode_bits  1
#define GFX7_3DSTATE_GS_ReorderMode_bits  1
#define GFX6_3DSTATE_GS_ReorderMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ReorderMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_ReorderMode_start  226
#define GFX12_3DSTATE_GS_ReorderMode_start  226
#define GFX11_3DSTATE_GS_ReorderMode_start  226
#define GFX9_3DSTATE_GS_ReorderMode_start  226
#define GFX8_3DSTATE_GS_ReorderMode_start  226
#define GFX75_3DSTATE_GS_ReorderMode_start  162
#define GFX7_3DSTATE_GS_ReorderMode_start  162
#define GFX6_3DSTATE_GS_ReorderMode_start  222

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ReorderMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 226;
   case 120: return 226;
   case 110: return 226;
   case 90: return 226;
   case 80: return 226;
   case 75: return 162;
   case 70: return 162;
   case 60: return 222;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SO Statistics Enable */


#define GFX6_3DSTATE_GS_SOStatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SOStatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SOStatisticsEnable_start  169

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SOStatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 169;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SVBI Payload Enable */


#define GFX6_3DSTATE_GS_SVBIPayloadEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPayloadEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVBIPayloadEnable_start  220

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPayloadEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 220;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SVBI Post-Increment Enable */


#define GFX6_3DSTATE_GS_SVBIPostIncrementEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVBIPostIncrementEnable_start  219

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 219;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::SVBI Post-Increment Value */


#define GFX6_3DSTATE_GS_SVBIPostIncrementValue_bits  10

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementValue_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 10;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVBIPostIncrementValue_start  208

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVBIPostIncrementValue_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 208;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Sampler Count */


#define GFX125_3DSTATE_GS_SamplerCount_bits  3
#define GFX12_3DSTATE_GS_SamplerCount_bits  3
#define GFX11_3DSTATE_GS_SamplerCount_bits  3
#define GFX9_3DSTATE_GS_SamplerCount_bits  3
#define GFX8_3DSTATE_GS_SamplerCount_bits  3
#define GFX75_3DSTATE_GS_SamplerCount_bits  3
#define GFX7_3DSTATE_GS_SamplerCount_bits  3
#define GFX6_3DSTATE_GS_SamplerCount_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SamplerCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_SamplerCount_start  123
#define GFX12_3DSTATE_GS_SamplerCount_start  123
#define GFX11_3DSTATE_GS_SamplerCount_start  123
#define GFX9_3DSTATE_GS_SamplerCount_start  123
#define GFX8_3DSTATE_GS_SamplerCount_start  123
#define GFX75_3DSTATE_GS_SamplerCount_start  91
#define GFX7_3DSTATE_GS_SamplerCount_start  91
#define GFX6_3DSTATE_GS_SamplerCount_start  91

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SamplerCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 123;
   case 120: return 123;
   case 110: return 123;
   case 90: return 123;
   case 80: return 123;
   case 75: return 91;
   case 70: return 91;
   case 60: return 91;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Scratch Space Base Pointer */


#define GFX125_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GFX12_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GFX11_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GFX9_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GFX8_3DSTATE_GS_ScratchSpaceBasePointer_bits  54
#define GFX75_3DSTATE_GS_ScratchSpaceBasePointer_bits  22
#define GFX7_3DSTATE_GS_ScratchSpaceBasePointer_bits  22
#define GFX6_3DSTATE_GS_ScratchSpaceBasePointer_bits  22

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ScratchSpaceBasePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 54;
   case 120: return 54;
   case 110: return 54;
   case 90: return 54;
   case 80: return 54;
   case 75: return 22;
   case 70: return 22;
   case 60: return 22;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GFX12_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GFX11_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GFX9_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GFX8_3DSTATE_GS_ScratchSpaceBasePointer_start  138
#define GFX75_3DSTATE_GS_ScratchSpaceBasePointer_start  106
#define GFX7_3DSTATE_GS_ScratchSpaceBasePointer_start  106
#define GFX6_3DSTATE_GS_ScratchSpaceBasePointer_start  106

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ScratchSpaceBasePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 138;
   case 120: return 138;
   case 110: return 138;
   case 90: return 138;
   case 80: return 138;
   case 75: return 106;
   case 70: return 106;
   case 60: return 106;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Semaphore Handle */


#define GFX75_3DSTATE_GS_SemaphoreHandle_bits  13
#define GFX7_3DSTATE_GS_SemaphoreHandle_bits  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SemaphoreHandle_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 13;
   case 70: return 12;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_GS_SemaphoreHandle_start  192
#define GFX7_3DSTATE_GS_SemaphoreHandle_start  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SemaphoreHandle_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 192;
   case 70: return 192;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Single Program Flow */


#define GFX125_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX12_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX11_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX9_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX8_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX75_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX7_3DSTATE_GS_SingleProgramFlow_bits  1
#define GFX6_3DSTATE_GS_SingleProgramFlow_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SingleProgramFlow_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_SingleProgramFlow_start  127
#define GFX12_3DSTATE_GS_SingleProgramFlow_start  127
#define GFX11_3DSTATE_GS_SingleProgramFlow_start  127
#define GFX9_3DSTATE_GS_SingleProgramFlow_start  127
#define GFX8_3DSTATE_GS_SingleProgramFlow_start  127
#define GFX75_3DSTATE_GS_SingleProgramFlow_start  95
#define GFX7_3DSTATE_GS_SingleProgramFlow_start  95
#define GFX6_3DSTATE_GS_SingleProgramFlow_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SingleProgramFlow_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 127;
   case 120: return 127;
   case 110: return 127;
   case 90: return 127;
   case 80: return 127;
   case 75: return 95;
   case 70: return 95;
   case 60: return 95;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Software Exception Enable */


#define GFX125_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX12_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX11_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX9_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX8_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX75_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX7_3DSTATE_GS_SoftwareExceptionEnable_bits  1
#define GFX6_3DSTATE_GS_SoftwareExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SoftwareExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GFX12_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GFX11_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GFX9_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GFX8_3DSTATE_GS_SoftwareExceptionEnable_start  103
#define GFX75_3DSTATE_GS_SoftwareExceptionEnable_start  71
#define GFX7_3DSTATE_GS_SoftwareExceptionEnable_start  71
#define GFX6_3DSTATE_GS_SoftwareExceptionEnable_start  71

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SoftwareExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 103;
   case 120: return 103;
   case 110: return 103;
   case 90: return 103;
   case 80: return 103;
   case 75: return 71;
   case 70: return 71;
   case 60: return 71;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Static Output */


#define GFX125_3DSTATE_GS_StaticOutput_bits  1
#define GFX12_3DSTATE_GS_StaticOutput_bits  1
#define GFX11_3DSTATE_GS_StaticOutput_bits  1
#define GFX9_3DSTATE_GS_StaticOutput_bits  1
#define GFX8_3DSTATE_GS_StaticOutput_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutput_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_StaticOutput_start  286
#define GFX12_3DSTATE_GS_StaticOutput_start  286
#define GFX11_3DSTATE_GS_StaticOutput_start  286
#define GFX9_3DSTATE_GS_StaticOutput_start  286
#define GFX8_3DSTATE_GS_StaticOutput_start  286

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutput_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 286;
   case 120: return 286;
   case 110: return 286;
   case 90: return 286;
   case 80: return 286;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Static Output Vertex Count */


#define GFX125_3DSTATE_GS_StaticOutputVertexCount_bits  11
#define GFX12_3DSTATE_GS_StaticOutputVertexCount_bits  11
#define GFX11_3DSTATE_GS_StaticOutputVertexCount_bits  11
#define GFX9_3DSTATE_GS_StaticOutputVertexCount_bits  11
#define GFX8_3DSTATE_GS_StaticOutputVertexCount_bits  11

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutputVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 11;
   case 120: return 11;
   case 110: return 11;
   case 90: return 11;
   case 80: return 11;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_StaticOutputVertexCount_start  272
#define GFX12_3DSTATE_GS_StaticOutputVertexCount_start  272
#define GFX11_3DSTATE_GS_StaticOutputVertexCount_start  272
#define GFX9_3DSTATE_GS_StaticOutputVertexCount_start  272
#define GFX8_3DSTATE_GS_StaticOutputVertexCount_start  272

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StaticOutputVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 272;
   case 120: return 272;
   case 110: return 272;
   case 90: return 272;
   case 80: return 272;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Statistics Enable */


#define GFX125_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX12_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX11_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX9_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX8_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX75_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX7_3DSTATE_GS_StatisticsEnable_bits  1
#define GFX6_3DSTATE_GS_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_StatisticsEnable_start  234
#define GFX12_3DSTATE_GS_StatisticsEnable_start  234
#define GFX11_3DSTATE_GS_StatisticsEnable_start  234
#define GFX9_3DSTATE_GS_StatisticsEnable_start  234
#define GFX8_3DSTATE_GS_StatisticsEnable_start  234
#define GFX75_3DSTATE_GS_StatisticsEnable_start  170
#define GFX7_3DSTATE_GS_StatisticsEnable_start  170
#define GFX6_3DSTATE_GS_StatisticsEnable_start  170

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 234;
   case 120: return 234;
   case 110: return 234;
   case 90: return 234;
   case 80: return 234;
   case 75: return 170;
   case 70: return 170;
   case 60: return 170;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Thread Dispatch Priority */


#define GFX125_3DSTATE_GS_ThreadDispatchPriority_bits  1
#define GFX12_3DSTATE_GS_ThreadDispatchPriority_bits  1
#define GFX11_3DSTATE_GS_ThreadDispatchPriority_bits  1
#define GFX9_3DSTATE_GS_ThreadDispatchPriority_bits  1
#define GFX8_3DSTATE_GS_ThreadDispatchPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadDispatchPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_ThreadDispatchPriority_start  113
#define GFX12_3DSTATE_GS_ThreadDispatchPriority_start  113
#define GFX11_3DSTATE_GS_ThreadDispatchPriority_start  113
#define GFX9_3DSTATE_GS_ThreadDispatchPriority_start  113
#define GFX8_3DSTATE_GS_ThreadDispatchPriority_start  113

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadDispatchPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 113;
   case 120: return 113;
   case 110: return 113;
   case 90: return 113;
   case 80: return 113;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Thread Priority */


#define GFX75_3DSTATE_GS_ThreadPriority_bits  1
#define GFX7_3DSTATE_GS_ThreadPriority_bits  1
#define GFX6_3DSTATE_GS_ThreadPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_GS_ThreadPriority_start  81
#define GFX7_3DSTATE_GS_ThreadPriority_start  81
#define GFX6_3DSTATE_GS_ThreadPriority_start  81

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_ThreadPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 81;
   case 70: return 81;
   case 60: return 81;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::User Clip Distance Clip Test Enable Bitmask */


#define GFX125_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX12_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX11_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX9_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8
#define GFX8_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296
#define GFX12_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296
#define GFX11_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296
#define GFX9_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296
#define GFX8_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start  296

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceClipTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 296;
   case 120: return 296;
   case 110: return 296;
   case 90: return 296;
   case 80: return 296;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::User Clip Distance Cull Test Enable Bitmask */


#define GFX125_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX12_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX11_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX9_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8
#define GFX8_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288
#define GFX12_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288
#define GFX11_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288
#define GFX9_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288
#define GFX8_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start  288

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_UserClipDistanceCullTestEnableBitmask_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 288;
   case 120: return 288;
   case 110: return 288;
   case 90: return 288;
   case 80: return 288;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vector Mask Enable */


#define GFX125_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX12_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX11_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX9_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX8_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX75_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX7_3DSTATE_GS_VectorMaskEnable_bits  1
#define GFX6_3DSTATE_GS_VectorMaskEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VectorMaskEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_VectorMaskEnable_start  126
#define GFX12_3DSTATE_GS_VectorMaskEnable_start  126
#define GFX11_3DSTATE_GS_VectorMaskEnable_start  126
#define GFX9_3DSTATE_GS_VectorMaskEnable_start  126
#define GFX8_3DSTATE_GS_VectorMaskEnable_start  126
#define GFX75_3DSTATE_GS_VectorMaskEnable_start  94
#define GFX7_3DSTATE_GS_VectorMaskEnable_start  94
#define GFX6_3DSTATE_GS_VectorMaskEnable_start  94

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VectorMaskEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 126;
   case 120: return 126;
   case 110: return 126;
   case 90: return 126;
   case 80: return 126;
   case 75: return 94;
   case 70: return 94;
   case 60: return 94;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Output Length */


#define GFX125_3DSTATE_GS_VertexURBEntryOutputLength_bits  5
#define GFX12_3DSTATE_GS_VertexURBEntryOutputLength_bits  5
#define GFX11_3DSTATE_GS_VertexURBEntryOutputLength_bits  5
#define GFX9_3DSTATE_GS_VertexURBEntryOutputLength_bits  5
#define GFX8_3DSTATE_GS_VertexURBEntryOutputLength_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_VertexURBEntryOutputLength_start  304
#define GFX12_3DSTATE_GS_VertexURBEntryOutputLength_start  304
#define GFX11_3DSTATE_GS_VertexURBEntryOutputLength_start  304
#define GFX9_3DSTATE_GS_VertexURBEntryOutputLength_start  304
#define GFX8_3DSTATE_GS_VertexURBEntryOutputLength_start  304

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 304;
   case 120: return 304;
   case 110: return 304;
   case 90: return 304;
   case 80: return 304;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Output Read Offset */


#define GFX125_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6
#define GFX12_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6
#define GFX11_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6
#define GFX9_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6
#define GFX8_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309
#define GFX12_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309
#define GFX11_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309
#define GFX9_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309
#define GFX8_3DSTATE_GS_VertexURBEntryOutputReadOffset_start  309

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryOutputReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 309;
   case 120: return 309;
   case 110: return 309;
   case 90: return 309;
   case 80: return 309;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Read Length */


#define GFX125_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX12_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX11_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX9_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX8_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX75_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX7_3DSTATE_GS_VertexURBEntryReadLength_bits  6
#define GFX6_3DSTATE_GS_VertexURBEntryReadLength_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 6;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GFX12_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GFX11_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GFX9_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GFX8_3DSTATE_GS_VertexURBEntryReadLength_start  203
#define GFX75_3DSTATE_GS_VertexURBEntryReadLength_start  139
#define GFX7_3DSTATE_GS_VertexURBEntryReadLength_start  139
#define GFX6_3DSTATE_GS_VertexURBEntryReadLength_start  139

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 203;
   case 120: return 203;
   case 110: return 203;
   case 90: return 203;
   case 80: return 203;
   case 75: return 139;
   case 70: return 139;
   case 60: return 139;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS::Vertex URB Entry Read Offset */


#define GFX125_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX12_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX11_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX9_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX8_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX75_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX7_3DSTATE_GS_VertexURBEntryReadOffset_bits  6
#define GFX6_3DSTATE_GS_VertexURBEntryReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 6;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GFX12_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GFX11_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GFX9_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GFX8_3DSTATE_GS_VertexURBEntryReadOffset_start  196
#define GFX75_3DSTATE_GS_VertexURBEntryReadOffset_start  132
#define GFX7_3DSTATE_GS_VertexURBEntryReadOffset_start  132
#define GFX6_3DSTATE_GS_VertexURBEntryReadOffset_start  132

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_VertexURBEntryReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 196;
   case 120: return 196;
   case 110: return 196;
   case 90: return 196;
   case 80: return 196;
   case 75: return 132;
   case 70: return 132;
   case 60: return 132;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX */


#define GFX6_3DSTATE_GS_SVB_INDEX_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 7;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::3D Command Opcode */


#define GFX6_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 24;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::3D Command Sub Opcode */


#define GFX6_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 16;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Command SubType */


#define GFX6_3DSTATE_GS_SVB_INDEX_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 27;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Command Type */


#define GFX6_3DSTATE_GS_SVB_INDEX_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 3;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 29;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::DWord Length */


#define GFX6_3DSTATE_GS_SVB_INDEX_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 8;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Index Number */


#define GFX6_3DSTATE_GS_SVB_INDEX_IndexNumber_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_IndexNumber_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 2;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_IndexNumber_start  61

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_IndexNumber_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 61;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Load Internal Vertex Count */


#define GFX6_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 1;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_LoadInternalVertexCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Maximum Index */


#define GFX6_3DSTATE_GS_SVB_INDEX_MaximumIndex_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_MaximumIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_MaximumIndex_start  96

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_MaximumIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 96;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_GS_SVB_INDEX::Streamed Vertex Buffer Index */


#define GFX6_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 32;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX6_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_GS_SVB_INDEX_StreamedVertexBufferIndex_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 64;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_length  5
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_length  3
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_length  3
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_length  3
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::3D Command Opcode */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::3D Command Sub Opcode */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Command SubType */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 2;
   case 50: return 2;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 27;
   case 50: return 27;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Command Type */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 29;
   case 50: return 29;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::DWord Length */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Hierarchical Depth Buffer MOCS */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  7
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start  57

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferMOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 57;
   case 120: return 57;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Hierarchical Depth Buffer Write Thru Enable */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferWriteThruEnable_bits  1
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferWriteThruEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferWriteThruEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferWriteThruEnable_start  52
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferWriteThruEnable_start  52

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_HierarchicalDepthBufferWriteThruEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 52;
   case 120: return 52;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::MOCS */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  7
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  7
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  7
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  7
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  7
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  4
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  4
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_MOCS_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 7;
   case 120: return 7;
   case 110: return 7;
   case 90: return 7;
   case 80: return 7;
   case 75: return 4;
   case 70: return 4;
   case 60: return 4;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start  57

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_MOCS_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 57;
   case 120: return 57;
   case 110: return 57;
   case 90: return 57;
   case 80: return 57;
   case 75: return 57;
   case 70: return 57;
   case 60: return 57;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Surface Base Address */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  64
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceBaseAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 64;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Surface Pitch */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits  17

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 17;
   case 120: return 17;
   case 110: return 17;
   case 90: return 17;
   case 80: return 17;
   case 75: return 17;
   case 70: return 17;
   case 60: return 17;
   case 50: return 17;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX75_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX7_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX6_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32
#define GFX5_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfacePitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Surface QPitch */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits  15

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 15;
   case 120: return 15;
   case 110: return 15;
   case 90: return 15;
   case 80: return 15;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128
#define GFX9_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128
#define GFX8_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_SurfaceQPitch_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 128;
   case 120: return 128;
   case 110: return 128;
   case 90: return 128;
   case 80: return 128;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HIER_DEPTH_BUFFER::Tiled Resource Mode */


#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_bits  2
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_bits  2
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_start  54
#define GFX12_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_start  54
#define GFX11_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_start  55

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HIER_DEPTH_BUFFER_TiledResourceMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 54;
   case 120: return 54;
   case 110: return 55;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS */


#define GFX125_3DSTATE_HS_length  9
#define GFX12_3DSTATE_HS_length  9
#define GFX11_3DSTATE_HS_length  9
#define GFX9_3DSTATE_HS_length  9
#define GFX8_3DSTATE_HS_length  9
#define GFX75_3DSTATE_HS_length  7
#define GFX7_3DSTATE_HS_length  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 7;
   case 70: return 7;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::3D Command Opcode */


#define GFX125_3DSTATE_HS_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_HS_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_HS_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_HS_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_HS_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_HS_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_HS_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_3DCommandOpcode_start  24
#define GFX12_3DSTATE_HS_3DCommandOpcode_start  24
#define GFX11_3DSTATE_HS_3DCommandOpcode_start  24
#define GFX9_3DSTATE_HS_3DCommandOpcode_start  24
#define GFX8_3DSTATE_HS_3DCommandOpcode_start  24
#define GFX75_3DSTATE_HS_3DCommandOpcode_start  24
#define GFX7_3DSTATE_HS_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::3D Command Sub Opcode */


#define GFX125_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_HS_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_HS_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_HS_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_HS_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Accesses UAV */


#define GFX125_3DSTATE_HS_AccessesUAV_bits  1
#define GFX12_3DSTATE_HS_AccessesUAV_bits  1
#define GFX11_3DSTATE_HS_AccessesUAV_bits  1
#define GFX9_3DSTATE_HS_AccessesUAV_bits  1
#define GFX8_3DSTATE_HS_AccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_AccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_AccessesUAV_start  249
#define GFX12_3DSTATE_HS_AccessesUAV_start  249
#define GFX11_3DSTATE_HS_AccessesUAV_start  249
#define GFX9_3DSTATE_HS_AccessesUAV_start  249
#define GFX8_3DSTATE_HS_AccessesUAV_start  249

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_AccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 249;
   case 120: return 249;
   case 110: return 249;
   case 90: return 249;
   case 80: return 249;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Binding Table Entry Count */


#define GFX125_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GFX12_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GFX11_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GFX9_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GFX8_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GFX75_3DSTATE_HS_BindingTableEntryCount_bits  8
#define GFX7_3DSTATE_HS_BindingTableEntryCount_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_BindingTableEntryCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_BindingTableEntryCount_start  50
#define GFX12_3DSTATE_HS_BindingTableEntryCount_start  50
#define GFX11_3DSTATE_HS_BindingTableEntryCount_start  50
#define GFX9_3DSTATE_HS_BindingTableEntryCount_start  50
#define GFX8_3DSTATE_HS_BindingTableEntryCount_start  50
#define GFX75_3DSTATE_HS_BindingTableEntryCount_start  50
#define GFX7_3DSTATE_HS_BindingTableEntryCount_start  50

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_BindingTableEntryCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 50;
   case 120: return 50;
   case 110: return 50;
   case 90: return 50;
   case 80: return 50;
   case 75: return 50;
   case 70: return 50;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Command SubType */


#define GFX125_3DSTATE_HS_CommandSubType_bits  2
#define GFX12_3DSTATE_HS_CommandSubType_bits  2
#define GFX11_3DSTATE_HS_CommandSubType_bits  2
#define GFX9_3DSTATE_HS_CommandSubType_bits  2
#define GFX8_3DSTATE_HS_CommandSubType_bits  2
#define GFX75_3DSTATE_HS_CommandSubType_bits  2
#define GFX7_3DSTATE_HS_CommandSubType_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandSubType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 2;
   case 75: return 2;
   case 70: return 2;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_CommandSubType_start  27
#define GFX12_3DSTATE_HS_CommandSubType_start  27
#define GFX11_3DSTATE_HS_CommandSubType_start  27
#define GFX9_3DSTATE_HS_CommandSubType_start  27
#define GFX8_3DSTATE_HS_CommandSubType_start  27
#define GFX75_3DSTATE_HS_CommandSubType_start  27
#define GFX7_3DSTATE_HS_CommandSubType_start  27

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandSubType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 27;
   case 120: return 27;
   case 110: return 27;
   case 90: return 27;
   case 80: return 27;
   case 75: return 27;
   case 70: return 27;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Command Type */


#define GFX125_3DSTATE_HS_CommandType_bits  3
#define GFX12_3DSTATE_HS_CommandType_bits  3
#define GFX11_3DSTATE_HS_CommandType_bits  3
#define GFX9_3DSTATE_HS_CommandType_bits  3
#define GFX8_3DSTATE_HS_CommandType_bits  3
#define GFX75_3DSTATE_HS_CommandType_bits  3
#define GFX7_3DSTATE_HS_CommandType_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandType_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_CommandType_start  29
#define GFX12_3DSTATE_HS_CommandType_start  29
#define GFX11_3DSTATE_HS_CommandType_start  29
#define GFX9_3DSTATE_HS_CommandType_start  29
#define GFX8_3DSTATE_HS_CommandType_start  29
#define GFX75_3DSTATE_HS_CommandType_start  29
#define GFX7_3DSTATE_HS_CommandType_start  29

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_CommandType_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 29;
   case 120: return 29;
   case 110: return 29;
   case 90: return 29;
   case 80: return 29;
   case 75: return 29;
   case 70: return 29;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::DWord Length */


#define GFX125_3DSTATE_HS_DWordLength_bits  8
#define GFX12_3DSTATE_HS_DWordLength_bits  8
#define GFX11_3DSTATE_HS_DWordLength_bits  8
#define GFX9_3DSTATE_HS_DWordLength_bits  8
#define GFX8_3DSTATE_HS_DWordLength_bits  8
#define GFX75_3DSTATE_HS_DWordLength_bits  8
#define GFX7_3DSTATE_HS_DWordLength_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DWordLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_DWordLength_start  0
#define GFX12_3DSTATE_HS_DWordLength_start  0
#define GFX11_3DSTATE_HS_DWordLength_start  0
#define GFX9_3DSTATE_HS_DWordLength_start  0
#define GFX8_3DSTATE_HS_DWordLength_start  0
#define GFX75_3DSTATE_HS_DWordLength_start  0
#define GFX7_3DSTATE_HS_DWordLength_start  0

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DWordLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Dispatch GRF Start Register For URB Data */


#define GFX125_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX12_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX11_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX9_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX8_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX75_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5
#define GFX7_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits  5

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 5;
   case 70: return 5;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GFX12_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GFX11_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GFX9_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GFX8_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  243
#define GFX75_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  179
#define GFX7_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start  179

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 243;
   case 120: return 243;
   case 110: return 243;
   case 90: return 243;
   case 80: return 243;
   case 75: return 179;
   case 70: return 179;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Dispatch GRF Start Register For URB Data [5] */


#define GFX125_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits  1
#define GFX12_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits  1
#define GFX11_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits  1
#define GFX9_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start  252
#define GFX12_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start  252
#define GFX11_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start  252
#define GFX9_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start  252

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchGRFStartRegisterForURBData5_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 252;
   case 120: return 252;
   case 110: return 252;
   case 90: return 252;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Dispatch Mode */


#define GFX125_3DSTATE_HS_DispatchMode_bits  2
#define GFX12_3DSTATE_HS_DispatchMode_bits  2
#define GFX11_3DSTATE_HS_DispatchMode_bits  2
#define GFX9_3DSTATE_HS_DispatchMode_bits  2

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 2;
   case 120: return 2;
   case 110: return 2;
   case 90: return 2;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_DispatchMode_start  241
#define GFX12_3DSTATE_HS_DispatchMode_start  241
#define GFX11_3DSTATE_HS_DispatchMode_start  241
#define GFX9_3DSTATE_HS_DispatchMode_start  241

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_DispatchMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 241;
   case 120: return 241;
   case 110: return 241;
   case 90: return 241;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Enable */


#define GFX125_3DSTATE_HS_Enable_bits  1
#define GFX12_3DSTATE_HS_Enable_bits  1
#define GFX11_3DSTATE_HS_Enable_bits  1
#define GFX9_3DSTATE_HS_Enable_bits  1
#define GFX8_3DSTATE_HS_Enable_bits  1
#define GFX75_3DSTATE_HS_Enable_bits  1
#define GFX7_3DSTATE_HS_Enable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_Enable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_Enable_start  95
#define GFX12_3DSTATE_HS_Enable_start  95
#define GFX11_3DSTATE_HS_Enable_start  95
#define GFX9_3DSTATE_HS_Enable_start  95
#define GFX8_3DSTATE_HS_Enable_start  95
#define GFX75_3DSTATE_HS_Enable_start  95
#define GFX7_3DSTATE_HS_Enable_start  95

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_Enable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 95;
   case 120: return 95;
   case 110: return 95;
   case 90: return 95;
   case 80: return 95;
   case 75: return 95;
   case 70: return 95;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Floating Point Mode */


#define GFX125_3DSTATE_HS_FloatingPointMode_bits  1
#define GFX12_3DSTATE_HS_FloatingPointMode_bits  1
#define GFX11_3DSTATE_HS_FloatingPointMode_bits  1
#define GFX9_3DSTATE_HS_FloatingPointMode_bits  1
#define GFX8_3DSTATE_HS_FloatingPointMode_bits  1
#define GFX75_3DSTATE_HS_FloatingPointMode_bits  1
#define GFX7_3DSTATE_HS_FloatingPointMode_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_FloatingPointMode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_FloatingPointMode_start  48
#define GFX12_3DSTATE_HS_FloatingPointMode_start  48
#define GFX11_3DSTATE_HS_FloatingPointMode_start  48
#define GFX9_3DSTATE_HS_FloatingPointMode_start  48
#define GFX8_3DSTATE_HS_FloatingPointMode_start  48
#define GFX75_3DSTATE_HS_FloatingPointMode_start  48
#define GFX7_3DSTATE_HS_FloatingPointMode_start  48

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_FloatingPointMode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 48;
   case 120: return 48;
   case 110: return 48;
   case 90: return 48;
   case 80: return 48;
   case 75: return 48;
   case 70: return 48;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::HS accesses UAV */


#define GFX75_3DSTATE_HS_HSaccessesUAV_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_HSaccessesUAV_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_HS_HSaccessesUAV_start  185

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_HSaccessesUAV_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 185;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Illegal Opcode Exception Enable */


#define GFX125_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GFX12_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GFX11_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GFX9_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GFX8_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GFX75_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1
#define GFX7_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IllegalOpcodeExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GFX12_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GFX11_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GFX9_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GFX8_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GFX75_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45
#define GFX7_3DSTATE_HS_IllegalOpcodeExceptionEnable_start  45

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IllegalOpcodeExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 45;
   case 120: return 45;
   case 110: return 45;
   case 90: return 45;
   case 80: return 45;
   case 75: return 45;
   case 70: return 45;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Include Primitive ID */


#define GFX125_3DSTATE_HS_IncludePrimitiveID_bits  1
#define GFX12_3DSTATE_HS_IncludePrimitiveID_bits  1
#define GFX11_3DSTATE_HS_IncludePrimitiveID_bits  1
#define GFX9_3DSTATE_HS_IncludePrimitiveID_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludePrimitiveID_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_IncludePrimitiveID_start  224
#define GFX12_3DSTATE_HS_IncludePrimitiveID_start  224
#define GFX11_3DSTATE_HS_IncludePrimitiveID_start  224
#define GFX9_3DSTATE_HS_IncludePrimitiveID_start  224

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludePrimitiveID_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 224;
   case 120: return 224;
   case 110: return 224;
   case 90: return 224;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Include Vertex Handles */


#define GFX125_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GFX12_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GFX11_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GFX9_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GFX8_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GFX75_3DSTATE_HS_IncludeVertexHandles_bits  1
#define GFX7_3DSTATE_HS_IncludeVertexHandles_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludeVertexHandles_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_IncludeVertexHandles_start  248
#define GFX12_3DSTATE_HS_IncludeVertexHandles_start  248
#define GFX11_3DSTATE_HS_IncludeVertexHandles_start  248
#define GFX9_3DSTATE_HS_IncludeVertexHandles_start  248
#define GFX8_3DSTATE_HS_IncludeVertexHandles_start  248
#define GFX75_3DSTATE_HS_IncludeVertexHandles_start  184
#define GFX7_3DSTATE_HS_IncludeVertexHandles_start  184

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_IncludeVertexHandles_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 248;
   case 120: return 248;
   case 110: return 248;
   case 90: return 248;
   case 80: return 248;
   case 75: return 184;
   case 70: return 184;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Instance Count */


#define GFX125_3DSTATE_HS_InstanceCount_bits  5
#define GFX12_3DSTATE_HS_InstanceCount_bits  5
#define GFX11_3DSTATE_HS_InstanceCount_bits  4
#define GFX9_3DSTATE_HS_InstanceCount_bits  4
#define GFX8_3DSTATE_HS_InstanceCount_bits  4
#define GFX75_3DSTATE_HS_InstanceCount_bits  4
#define GFX7_3DSTATE_HS_InstanceCount_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_InstanceCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_InstanceCount_start  64
#define GFX12_3DSTATE_HS_InstanceCount_start  64
#define GFX11_3DSTATE_HS_InstanceCount_start  64
#define GFX9_3DSTATE_HS_InstanceCount_start  64
#define GFX8_3DSTATE_HS_InstanceCount_start  64
#define GFX75_3DSTATE_HS_InstanceCount_start  64
#define GFX7_3DSTATE_HS_InstanceCount_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_InstanceCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 64;
   case 120: return 64;
   case 110: return 64;
   case 90: return 64;
   case 80: return 64;
   case 75: return 64;
   case 70: return 64;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Kernel Start Pointer */


#define GFX125_3DSTATE_HS_KernelStartPointer_bits  58
#define GFX12_3DSTATE_HS_KernelStartPointer_bits  58
#define GFX11_3DSTATE_HS_KernelStartPointer_bits  58
#define GFX9_3DSTATE_HS_KernelStartPointer_bits  58
#define GFX8_3DSTATE_HS_KernelStartPointer_bits  58
#define GFX75_3DSTATE_HS_KernelStartPointer_bits  26
#define GFX7_3DSTATE_HS_KernelStartPointer_bits  26

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_KernelStartPointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 58;
   case 120: return 58;
   case 110: return 58;
   case 90: return 58;
   case 80: return 58;
   case 75: return 26;
   case 70: return 26;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_KernelStartPointer_start  102
#define GFX12_3DSTATE_HS_KernelStartPointer_start  102
#define GFX11_3DSTATE_HS_KernelStartPointer_start  102
#define GFX9_3DSTATE_HS_KernelStartPointer_start  102
#define GFX8_3DSTATE_HS_KernelStartPointer_start  102
#define GFX75_3DSTATE_HS_KernelStartPointer_start  102
#define GFX7_3DSTATE_HS_KernelStartPointer_start  102

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_KernelStartPointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 102;
   case 120: return 102;
   case 110: return 102;
   case 90: return 102;
   case 80: return 102;
   case 75: return 102;
   case 70: return 102;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Maximum Number of Threads */


#define GFX125_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GFX12_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GFX11_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GFX9_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GFX8_3DSTATE_HS_MaximumNumberofThreads_bits  9
#define GFX75_3DSTATE_HS_MaximumNumberofThreads_bits  8
#define GFX7_3DSTATE_HS_MaximumNumberofThreads_bits  7

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_MaximumNumberofThreads_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 9;
   case 120: return 9;
   case 110: return 9;
   case 90: return 9;
   case 80: return 9;
   case 75: return 8;
   case 70: return 7;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GFX12_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GFX11_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GFX9_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GFX8_3DSTATE_HS_MaximumNumberofThreads_start  72
#define GFX75_3DSTATE_HS_MaximumNumberofThreads_start  32
#define GFX7_3DSTATE_HS_MaximumNumberofThreads_start  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_MaximumNumberofThreads_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 72;
   case 120: return 72;
   case 110: return 72;
   case 90: return 72;
   case 80: return 72;
   case 75: return 32;
   case 70: return 32;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Patch Count Threshold */


#define GFX125_3DSTATE_HS_PatchCountThreshold_bits  3
#define GFX12_3DSTATE_HS_PatchCountThreshold_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_PatchCountThreshold_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_PatchCountThreshold_start  225
#define GFX12_3DSTATE_HS_PatchCountThreshold_start  225

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_PatchCountThreshold_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 225;
   case 120: return 225;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Per-Thread Scratch Space */


#define GFX125_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GFX12_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GFX11_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GFX9_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GFX8_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GFX75_3DSTATE_HS_PerThreadScratchSpace_bits  4
#define GFX7_3DSTATE_HS_PerThreadScratchSpace_bits  4

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_PerThreadScratchSpace_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 4;
   case 120: return 4;
   case 110: return 4;
   case 90: return 4;
   case 80: return 4;
   case 75: return 4;
   case 70: return 4;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GFX12_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GFX11_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GFX9_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GFX8_3DSTATE_HS_PerThreadScratchSpace_start  160
#define GFX75_3DSTATE_HS_PerThreadScratchSpace_start  128
#define GFX7_3DSTATE_HS_PerThreadScratchSpace_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_PerThreadScratchSpace_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 160;
   case 120: return 160;
   case 110: return 160;
   case 90: return 160;
   case 80: return 160;
   case 75: return 128;
   case 70: return 128;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Sampler Count */


#define GFX125_3DSTATE_HS_SamplerCount_bits  3
#define GFX12_3DSTATE_HS_SamplerCount_bits  3
#define GFX11_3DSTATE_HS_SamplerCount_bits  3
#define GFX9_3DSTATE_HS_SamplerCount_bits  3
#define GFX8_3DSTATE_HS_SamplerCount_bits  3
#define GFX75_3DSTATE_HS_SamplerCount_bits  3
#define GFX7_3DSTATE_HS_SamplerCount_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SamplerCount_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_SamplerCount_start  59
#define GFX12_3DSTATE_HS_SamplerCount_start  59
#define GFX11_3DSTATE_HS_SamplerCount_start  59
#define GFX9_3DSTATE_HS_SamplerCount_start  59
#define GFX8_3DSTATE_HS_SamplerCount_start  59
#define GFX75_3DSTATE_HS_SamplerCount_start  59
#define GFX7_3DSTATE_HS_SamplerCount_start  59

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SamplerCount_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 59;
   case 120: return 59;
   case 110: return 59;
   case 90: return 59;
   case 80: return 59;
   case 75: return 59;
   case 70: return 59;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Scratch Space Base Pointer */


#define GFX125_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GFX12_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GFX11_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GFX9_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GFX8_3DSTATE_HS_ScratchSpaceBasePointer_bits  54
#define GFX75_3DSTATE_HS_ScratchSpaceBasePointer_bits  22
#define GFX7_3DSTATE_HS_ScratchSpaceBasePointer_bits  22

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ScratchSpaceBasePointer_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 54;
   case 120: return 54;
   case 110: return 54;
   case 90: return 54;
   case 80: return 54;
   case 75: return 22;
   case 70: return 22;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GFX12_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GFX11_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GFX9_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GFX8_3DSTATE_HS_ScratchSpaceBasePointer_start  170
#define GFX75_3DSTATE_HS_ScratchSpaceBasePointer_start  138
#define GFX7_3DSTATE_HS_ScratchSpaceBasePointer_start  138

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ScratchSpaceBasePointer_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 170;
   case 120: return 170;
   case 110: return 170;
   case 90: return 170;
   case 80: return 170;
   case 75: return 138;
   case 70: return 138;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Semaphore Handle */


#define GFX75_3DSTATE_HS_SemaphoreHandle_bits  13
#define GFX7_3DSTATE_HS_SemaphoreHandle_bits  12

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SemaphoreHandle_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 13;
   case 70: return 12;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_HS_SemaphoreHandle_start  192
#define GFX7_3DSTATE_HS_SemaphoreHandle_start  192

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SemaphoreHandle_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 192;
   case 70: return 192;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Single Program Flow */


#define GFX125_3DSTATE_HS_SingleProgramFlow_bits  1
#define GFX12_3DSTATE_HS_SingleProgramFlow_bits  1
#define GFX11_3DSTATE_HS_SingleProgramFlow_bits  1
#define GFX9_3DSTATE_HS_SingleProgramFlow_bits  1
#define GFX8_3DSTATE_HS_SingleProgramFlow_bits  1
#define GFX75_3DSTATE_HS_SingleProgramFlow_bits  1
#define GFX7_3DSTATE_HS_SingleProgramFlow_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SingleProgramFlow_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_SingleProgramFlow_start  251
#define GFX12_3DSTATE_HS_SingleProgramFlow_start  251
#define GFX11_3DSTATE_HS_SingleProgramFlow_start  251
#define GFX9_3DSTATE_HS_SingleProgramFlow_start  251
#define GFX8_3DSTATE_HS_SingleProgramFlow_start  251
#define GFX75_3DSTATE_HS_SingleProgramFlow_start  187
#define GFX7_3DSTATE_HS_SingleProgramFlow_start  187

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SingleProgramFlow_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 251;
   case 120: return 251;
   case 110: return 251;
   case 90: return 251;
   case 80: return 251;
   case 75: return 187;
   case 70: return 187;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Software Exception Enable */


#define GFX125_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GFX12_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GFX11_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GFX9_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GFX8_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GFX75_3DSTATE_HS_SoftwareExceptionEnable_bits  1
#define GFX7_3DSTATE_HS_SoftwareExceptionEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SoftwareExceptionEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GFX12_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GFX11_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GFX9_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GFX8_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GFX75_3DSTATE_HS_SoftwareExceptionEnable_start  44
#define GFX7_3DSTATE_HS_SoftwareExceptionEnable_start  39

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_SoftwareExceptionEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 44;
   case 120: return 44;
   case 110: return 44;
   case 90: return 44;
   case 80: return 44;
   case 75: return 44;
   case 70: return 39;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Statistics Enable */


#define GFX125_3DSTATE_HS_StatisticsEnable_bits  1
#define GFX12_3DSTATE_HS_StatisticsEnable_bits  1
#define GFX11_3DSTATE_HS_StatisticsEnable_bits  1
#define GFX9_3DSTATE_HS_StatisticsEnable_bits  1
#define GFX8_3DSTATE_HS_StatisticsEnable_bits  1
#define GFX75_3DSTATE_HS_StatisticsEnable_bits  1
#define GFX7_3DSTATE_HS_StatisticsEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_StatisticsEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_StatisticsEnable_start  93
#define GFX12_3DSTATE_HS_StatisticsEnable_start  93
#define GFX11_3DSTATE_HS_StatisticsEnable_start  93
#define GFX9_3DSTATE_HS_StatisticsEnable_start  93
#define GFX8_3DSTATE_HS_StatisticsEnable_start  93
#define GFX75_3DSTATE_HS_StatisticsEnable_start  93
#define GFX7_3DSTATE_HS_StatisticsEnable_start  93

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_StatisticsEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 93;
   case 120: return 93;
   case 110: return 93;
   case 90: return 93;
   case 80: return 93;
   case 75: return 93;
   case 70: return 93;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Thread Dispatch Priority */


#define GFX125_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GFX12_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GFX11_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GFX9_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GFX8_3DSTATE_HS_ThreadDispatchPriority_bits  1
#define GFX75_3DSTATE_HS_ThreadDispatchPriority_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ThreadDispatchPriority_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GFX12_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GFX11_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GFX9_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GFX8_3DSTATE_HS_ThreadDispatchPriority_start  49
#define GFX75_3DSTATE_HS_ThreadDispatchPriority_start  49

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_ThreadDispatchPriority_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 49;
   case 120: return 49;
   case 110: return 49;
   case 90: return 49;
   case 80: return 49;
   case 75: return 49;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Vector Mask Enable */


#define GFX125_3DSTATE_HS_VectorMaskEnable_bits  1
#define GFX12_3DSTATE_HS_VectorMaskEnable_bits  1
#define GFX11_3DSTATE_HS_VectorMaskEnable_bits  1
#define GFX9_3DSTATE_HS_VectorMaskEnable_bits  1
#define GFX8_3DSTATE_HS_VectorMaskEnable_bits  1
#define GFX75_3DSTATE_HS_VectorMaskEnable_bits  1
#define GFX7_3DSTATE_HS_VectorMaskEnable_bits  1

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VectorMaskEnable_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 1;
   case 120: return 1;
   case 110: return 1;
   case 90: return 1;
   case 80: return 1;
   case 75: return 1;
   case 70: return 1;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_VectorMaskEnable_start  250
#define GFX12_3DSTATE_HS_VectorMaskEnable_start  250
#define GFX11_3DSTATE_HS_VectorMaskEnable_start  250
#define GFX9_3DSTATE_HS_VectorMaskEnable_start  250
#define GFX8_3DSTATE_HS_VectorMaskEnable_start  250
#define GFX75_3DSTATE_HS_VectorMaskEnable_start  186
#define GFX7_3DSTATE_HS_VectorMaskEnable_start  186

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VectorMaskEnable_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 250;
   case 120: return 250;
   case 110: return 250;
   case 90: return 250;
   case 80: return 250;
   case 75: return 186;
   case 70: return 186;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Vertex URB Entry Read Length */


#define GFX125_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GFX12_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GFX11_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GFX9_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GFX8_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GFX75_3DSTATE_HS_VertexURBEntryReadLength_bits  6
#define GFX7_3DSTATE_HS_VertexURBEntryReadLength_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadLength_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GFX12_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GFX11_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GFX9_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GFX8_3DSTATE_HS_VertexURBEntryReadLength_start  235
#define GFX75_3DSTATE_HS_VertexURBEntryReadLength_start  171
#define GFX7_3DSTATE_HS_VertexURBEntryReadLength_start  171

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadLength_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 235;
   case 120: return 235;
   case 110: return 235;
   case 90: return 235;
   case 80: return 235;
   case 75: return 171;
   case 70: return 171;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_HS::Vertex URB Entry Read Offset */


#define GFX125_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GFX12_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GFX11_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GFX9_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GFX8_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GFX75_3DSTATE_HS_VertexURBEntryReadOffset_bits  6
#define GFX7_3DSTATE_HS_VertexURBEntryReadOffset_bits  6

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadOffset_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 6;
   case 120: return 6;
   case 110: return 6;
   case 90: return 6;
   case 80: return 6;
   case 75: return 6;
   case 70: return 6;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GFX12_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GFX11_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GFX9_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GFX8_3DSTATE_HS_VertexURBEntryReadOffset_start  228
#define GFX75_3DSTATE_HS_VertexURBEntryReadOffset_start  164
#define GFX7_3DSTATE_HS_VertexURBEntryReadOffset_start  164

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_HS_VertexURBEntryReadOffset_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 228;
   case 120: return 228;
   case 110: return 228;
   case 90: return 228;
   case 80: return 228;
   case 75: return 164;
   case 70: return 164;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER */


#define GFX125_3DSTATE_INDEX_BUFFER_length  5
#define GFX12_3DSTATE_INDEX_BUFFER_length  5
#define GFX11_3DSTATE_INDEX_BUFFER_length  5
#define GFX9_3DSTATE_INDEX_BUFFER_length  5
#define GFX8_3DSTATE_INDEX_BUFFER_length  5
#define GFX75_3DSTATE_INDEX_BUFFER_length  3
#define GFX7_3DSTATE_INDEX_BUFFER_length  3
#define GFX6_3DSTATE_INDEX_BUFFER_length  3
#define GFX5_3DSTATE_INDEX_BUFFER_length  3
#define GFX45_3DSTATE_INDEX_BUFFER_length  3
#define GFX4_3DSTATE_INDEX_BUFFER_length  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_length(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 5;
   case 120: return 5;
   case 110: return 5;
   case 90: return 5;
   case 80: return 5;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::3D Command Opcode */


#define GFX125_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX12_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX11_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX9_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX8_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX75_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX7_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX6_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX5_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX45_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3
#define GFX4_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits  3

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 3;
   case 120: return 3;
   case 110: return 3;
   case 90: return 3;
   case 80: return 3;
   case 75: return 3;
   case 70: return 3;
   case 60: return 3;
   case 50: return 3;
   case 45: return 3;
   case 40: return 3;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX12_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX11_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX9_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX8_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX75_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX7_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX6_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX5_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX45_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24
#define GFX4_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start  24

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 24;
   case 120: return 24;
   case 110: return 24;
   case 90: return 24;
   case 80: return 24;
   case 75: return 24;
   case 70: return 24;
   case 60: return 24;
   case 50: return 24;
   case 45: return 24;
   case 40: return 24;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::3D Command Sub Opcode */


#define GFX125_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX12_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX11_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX9_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX8_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX75_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX7_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX6_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX5_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX45_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8
#define GFX4_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits  8

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 8;
   case 120: return 8;
   case 110: return 8;
   case 90: return 8;
   case 80: return 8;
   case 75: return 8;
   case 70: return 8;
   case 60: return 8;
   case 50: return 8;
   case 45: return 8;
   case 40: return 8;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX12_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX11_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX9_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX8_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX75_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX7_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX6_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX5_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX45_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16
#define GFX4_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start  16

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_3DCommandSubOpcode_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 16;
   case 120: return 16;
   case 110: return 16;
   case 90: return 16;
   case 80: return 16;
   case 75: return 16;
   case 70: return 16;
   case 60: return 16;
   case 50: return 16;
   case 45: return 16;
   case 40: return 16;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Buffer Ending Address */


#define GFX75_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GFX7_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GFX6_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GFX5_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GFX45_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32
#define GFX4_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferEndingAddress_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 32;
   case 70: return 32;
   case 60: return 32;
   case 50: return 32;
   case 45: return 32;
   case 40: return 32;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX75_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GFX7_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GFX6_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GFX5_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GFX45_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64
#define GFX4_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start  64

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferEndingAddress_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 0;
   case 120: return 0;
   case 110: return 0;
   case 90: return 0;
   case 80: return 0;
   case 75: return 64;
   case 70: return 64;
   case 60: return 64;
   case 50: return 64;
   case 45: return 64;
   case 40: return 64;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Buffer Size */


#define GFX125_3DSTATE_INDEX_BUFFER_BufferSize_bits  32
#define GFX12_3DSTATE_INDEX_BUFFER_BufferSize_bits  32
#define GFX11_3DSTATE_INDEX_BUFFER_BufferSize_bits  32
#define GFX9_3DSTATE_INDEX_BUFFER_BufferSize_bits  32
#define GFX8_3DSTATE_INDEX_BUFFER_BufferSize_bits  32

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferSize_bits(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 32;
   case 120: return 32;
   case 110: return 32;
   case 90: return 32;
   case 80: return 32;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



#define GFX125_3DSTATE_INDEX_BUFFER_BufferSize_start  128
#define GFX12_3DSTATE_INDEX_BUFFER_BufferSize_start  128
#define GFX11_3DSTATE_INDEX_BUFFER_BufferSize_start  128
#define GFX9_3DSTATE_INDEX_BUFFER_BufferSize_start  128
#define GFX8_3DSTATE_INDEX_BUFFER_BufferSize_start  128

static inline uint32_t ATTRIBUTE_PURE
_3DSTATE_INDEX_BUFFER_BufferSize_start(const struct gen_device_info *devinfo)
{
   switch (devinfo->verx10) {
   case 125: return 128;
   case 120: return 128;
   case 110: return 128;
   case 90: return 128;
   case 80: return 128;
   case 75: return 0;
   case 70: return 0;
   case 60: return 0;
   case 50: return 0;
   case 45: return 0;
   case 40: return 0;
   default:
      unreachable("Invalid hardware generation");
   }
}



/* 3DSTATE_INDEX_BUFFER::Buffer Starting Address */


#define GFX125_3DSTATE_INDEX_BUFFER_BufferStartingAddress_bits  64
#defi