/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.core.AprStatus;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.LibraryNotFoundError;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class AprLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static final List<String> initInfoLogMessages = new ArrayList<String>(3);
    protected static final StringManager sm = StringManager.getManager(AprLifecycleListener.class);
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 2;
    protected static final int TCN_REQUIRED_PATCH = 14;
    protected static final int TCN_RECOMMENDED_MINOR = 2;
    protected static final int TCN_RECOMMENDED_PV = 30;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAprAvailable() {
        if (AprStatus.isInstanceCreated()) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
            }
        }
        return AprStatus.isAprAvailable();
    }

    public AprLifecycleListener() {
        AprStatus.setInstanceCreated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!(event.getLifecycle() instanceof Server)) {
                    log.warn((Object)sm.getString("listener.notServer", new Object[]{event.getLifecycle().getClass().getSimpleName()}));
                }
                AprLifecycleListener.init();
                for (String msg : initInfoLogMessages) {
                    log.info((Object)msg);
                }
                initInfoLogMessages.clear();
                if (AprStatus.isAprAvailable()) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t) {
                        t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                        ExceptionUtils.handleThrowable((Throwable)t);
                        log.error((Object)sm.getString("aprListener.sslInit"), t);
                    }
                }
                if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                    String errorMessage = sm.getString("aprListener.initializeFIPSFailed");
                    Error e = new Error(errorMessage);
                    log.fatal((Object)errorMessage, (Throwable)e);
                    throw e;
                }
            }
        }
        if ("after_destroy".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!AprStatus.isAprAvailable()) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable t) {
                    t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.info((Object)sm.getString("aprListener.aprDestroy"));
                }
            }
        }
    }

    private static void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
        AprStatus.setAprAvailable(false);
        AprStatus.setAprInitialized(false);
        sslInitialized = false;
        fipsModeActive = false;
    }

    private static void init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        int apver = 0;
        int rqver = 1214;
        int rcver = 1230;
        if (AprStatus.isAprInitialized()) {
            return;
        }
        AprStatus.setAprInitialized(true);
        try {
            Library.initialize(null);
            major = Library.TCN_MAJOR_VERSION;
            minor = Library.TCN_MINOR_VERSION;
            patch = Library.TCN_PATCH_VERSION;
            apver = major * 1000 + minor * 100 + patch;
        }
        catch (LibraryNotFoundError lnfe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("aprListener.aprInitDebug", new Object[]{lnfe.getLibraryNames(), System.getProperty("java.library.path"), lnfe.getMessage()}), (Throwable)lnfe);
            }
            initInfoLogMessages.add(sm.getString("aprListener.aprInit", new Object[]{System.getProperty("java.library.path")}));
            return;
        }
        catch (Throwable t) {
            t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
            ExceptionUtils.handleThrowable((Throwable)t);
            log.warn((Object)sm.getString("aprListener.aprInitError", new Object[]{t.getMessage()}), t);
            return;
        }
        if (apver < rqver) {
            log.error((Object)sm.getString("aprListener.tcnInvalid", new Object[]{Library.versionString(), "1.2.14"}));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            return;
        }
        if (apver < rcver) {
            initInfoLogMessages.add(sm.getString("aprListener.tcnVersion", new Object[]{Library.versionString(), "1.2.30"}));
        }
        initInfoLogMessages.add(sm.getString("aprListener.tcnValid", new Object[]{Library.versionString(), Library.aprVersionString()}));
        initInfoLogMessages.add(sm.getString("aprListener.flags", new Object[]{Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM, Library.APR_HAVE_UNIX}));
        AprStatus.setAprAvailable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeSSL() throws Exception {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
            boolean enterFipsMode;
            fipsModeActive = false;
            int fipsModeState = SSL.fipsModeGet();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("aprListener.currentFIPSMode", new Object[]{fipsModeState}));
            }
            if ("on".equalsIgnoreCase(FIPSMode)) {
                if (fipsModeState == 1) {
                    log.info((Object)sm.getString("aprListener.skipFIPSInitialization"));
                    fipsModeActive = true;
                    enterFipsMode = false;
                } else {
                    enterFipsMode = true;
                }
            } else if ("require".equalsIgnoreCase(FIPSMode)) {
                if (fipsModeState != 1) throw new IllegalStateException(sm.getString("aprListener.requireNotInFIPSMode"));
                fipsModeActive = true;
                enterFipsMode = false;
            } else {
                if (!"enter".equalsIgnoreCase(FIPSMode)) throw new IllegalArgumentException(sm.getString("aprListener.wrongFIPSMode", new Object[]{FIPSMode}));
                if (fipsModeState != 0) throw new IllegalStateException(sm.getString("aprListener.enterAlreadyInFIPSMode", new Object[]{fipsModeState}));
                enterFipsMode = true;
            }
            if (enterFipsMode) {
                log.info((Object)sm.getString("aprListener.initializingFIPS"));
                fipsModeState = SSL.fipsModeSet((int)1);
                if (fipsModeState != 1) {
                    String message = sm.getString("aprListener.initializeFIPSFailed");
                    log.error((Object)message);
                    throw new IllegalStateException(message);
                }
                fipsModeActive = true;
                log.info((Object)sm.getString("aprListener.initializeFIPSSuccess"));
            }
        }
        log.info((Object)sm.getString("aprListener.initializedOpenSSL", new Object[]{SSL.versionString()}));
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        if (!SSLEngine.equals(AprLifecycleListener.SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            AprLifecycleListener.SSLEngine = SSLEngine;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        if (!SSLRandomSeed.equals(AprLifecycleListener.SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String FIPSMode) {
        if (!FIPSMode.equals(AprLifecycleListener.FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            AprLifecycleListener.FIPSMode = FIPSMode;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    public void setUseOpenSSL(boolean useOpenSSL) {
        if (useOpenSSL != AprStatus.getUseOpenSSL()) {
            AprStatus.setUseOpenSSL(useOpenSSL);
        }
    }

    public static boolean getUseOpenSSL() {
        return AprStatus.getUseOpenSSL();
    }

    public static boolean isInstanceCreated() {
        return AprStatus.isInstanceCreated();
    }
}

