<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2021 Julien Barnoin <julien@barnoin.com>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\Notifications\Controller;

use OCA\Notifications\Model\SettingsMapper;
use OCP\AppFramework\OCSController;
use OCP\AppFramework\Http\DataResponse;
use OCP\IRequest;

class SettingsController extends OCSController {
	/** @var SettingsMapper */
	protected $settingsMapper;

	/** @var string */
	protected $userId;

	public function __construct(string $appName,
								IRequest $request,
								SettingsMapper $settingsMapper,
								string $userId) {
		parent::__construct($appName, $request);
		$this->settingsMapper = $settingsMapper;
		$this->userId = $userId;
	}

	/**
	 * @NoAdminRequired
	 *
	 * @param int $batchSetting
	 * @return DataResponse
	 */
	public function personal(int $batchSetting): DataResponse {
		$this->settingsMapper->setBatchSettingForUser($this->userId, $batchSetting);
		return new DataResponse();
	}
}
