set -l subcommands add-blob alias-env attach-disk blobs cancel-task clean-up \
    cloud-check cloud-config config configs cpi-config create-env create-release \
    delete-config delete-deployment delete-disk delete-env delete-release \
    delete-snapshot delete-snapshots delete-stemcell delete-vm deploy deployment \
    deployments diff-config disks environment environments errands event events \
    export-release finalize-release generate-job generate-package help ignore \
    init-release inspect-release instances interpolate locks log-in log-out logs \
    manifest orphan-disk recreate releases remove-blob repack-stemcell \
    reset-release restart run-errand runtime-config scp snapshots ssh start \
    stemcells stop sync-blobs take-snapshot task tasks unignore \
    update-cloud-config update-config update-cpi-config update-resurrection \
    update-runtime-config upload-blobs upload-release upload-stemcell variables \
    vendor-package vms

complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a add-blob -d "Add blob"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a alias-env -d "Alias environment to save URL and CA certificate"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a attach-disk -d "Attaches disk to an instance"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a blobs -d "List blobs"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a cancel-task -d "Cancel task at its next checkpoint"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a clean-up -d "Clean up releases, stemcells, disks, etc."
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a cloud-check -d "Cloud consistency check and interactive repair"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a cloud-config -d "Show current cloud config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a config -d "Show current config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a configs -d "List configs"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a cpi-config -d "Show current CPI config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a create-env -d "Create or update BOSH environment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a create-release -d "Create release"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-config -d "Delete config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-deployment -d "Delete deployment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-disk -d "Delete disk"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-env -d "Delete BOSH environment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-release -d "Delete release"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-snapshot -d "Delete snapshot"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-snapshots -d "Delete all snapshots in a deployment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-stemcell -d "Delete stemcell"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a delete-vm -d "Delete VM"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a deploy -d "Update deployment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a deployment -d "Show deployment information"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a deployments -d "List deployments"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a diff-config -d "Diff two configs by ID"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a disks -d "List disks"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a environment -d "Show environment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a environments -d "List environments"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a errands -d "List errands"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a event -d "Show event details"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a events -d "List events"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a export-release -d "Export the compiled release to a tarball"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a finalize-release -d "Create final release from dev release tarball"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a generate-job -d "Generate job"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a generate-package -d "Generate package"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a help -d "Show this help message"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a ignore -d "Ignore an instance"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a init-release -d "Initialize release"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a inspect-release -d "List release contents such as jobs"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a instances -d "List all instances in a deployment"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a interpolate -d "Interpolates variables into a manifest"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a locks -d "List current locks"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a log-in -d "Log in"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a log-out -d "Log out"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a logs -d "Fetch logs from instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a manifest -d "Show deployment manifest"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a orphan-disk -d "Orphan disk"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a recreate -d "Recreate instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a releases -d "List releases"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a remove-blob -d "Remove blob"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a repack-stemcell -d "Repack stemcell"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a reset-release -d "Reset release"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a restart -d "Restart instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a run-errand -d "Run errand"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a runtime-config -d "Show current runtime config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a scp -d "SCP to/from instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a snapshots -d "List snapshots"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a ssh -d "SSH into instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a start -d "Start instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a stemcells -d "List stemcells"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a stop -d "Stop instance(s)"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a sync-blobs -d "Sync blobs"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a take-snapshot -d "Take snapshot"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a task -d "Show task status and start tracking its output"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a tasks -d "List running or recent tasks"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a unignore -d "Unignore an instance"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a update-cloud-config -d "Update current cloud config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a update-config -d "Update config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a update-cpi-config -d "Update current CPI config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a update-resurrection -d "Enable/disable resurrection"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a update-runtime-config -d "Update current runtime config"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a upload-blobs -d "Upload blobs"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a upload-release -d "Upload release"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a upload-stemcell -d "Upload stemcell"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a variables -d "List variables"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a vendor-package -d "Vendor package"
complete -f -n "__fish_use_subcommand $subcommands" -c bosh -a vms -d "List all VMs in all deployments"
