/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class KeyValueTest
extends TestCase {
    private static final String[] ALGOS = new String[]{"DSA", "RSA"};
    private KeyInfoFactory fac;
    private PublicKey[] keys = null;

    public KeyValueTest() {
        super("KeyValueTest");
    }

    public KeyValueTest(String string) {
        super(string);
    }

    private PublicKey genPublicKey(String string, int n) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
        keyPairGenerator.initialize(n, new SecureRandom(("Not so random bytes" + System.currentTimeMillis()).getBytes()));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair.getPublic();
    }

    public void setUp() throws Exception {
        this.fac = KeyInfoFactory.getInstance("DOM", new XMLDSigRI());
        this.keys = new PublicKey[ALGOS.length];
        for (int i = 0; i < ALGOS.length; ++i) {
            this.keys[i] = this.genPublicKey(ALGOS[i], 512);
        }
    }

    public void tearDown() {
    }

    public void testgetPublicKey() {
        try {
            KeyValue keyValue = this.fac.newKeyValue(this.keys[0]);
            KeyValueTest.assertNotNull((Object)keyValue.getPublicKey());
        }
        catch (KeyException keyException) {
            KeyValueTest.fail((String)"Should pass instead of throwing KeyException");
        }
    }

    public void testConstructor() {
        for (int i = 0; i < this.keys.length; ++i) {
            try {
                KeyValue keyValue = this.fac.newKeyValue(this.keys[i]);
                KeyValueTest.assertEquals((Object)this.keys[i], (Object)keyValue.getPublicKey());
                continue;
            }
            catch (KeyException keyException) {
                KeyValueTest.fail((String)"Should pass instead of throwing KeyException");
            }
        }
    }

    public void testisFeatureSupported() {
        XMLStructure xMLStructure = null;
        try {
            xMLStructure = this.fac.newKeyValue(this.keys[0]);
            xMLStructure.isFeatureSupported(null);
            KeyValueTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (KeyException keyException) {
            KeyValueTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        KeyValueTest.assertTrue((!xMLStructure.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

