/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteVolume
extends BaseCmd {
    public DeleteVolume(String[] args) {
        super("ec2delvol", "ec2-delete-volume");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    protected String getOptionString() {
        return "VOLUME";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete an existing volume");
        System.out.println("     The VOLUME parameter identifies the (available) volume to be deleted.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("VOLUME");
        String volumeId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        RequestResultPair rsp = jec2.deleteVolume(volumeId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputVolume(System.out, volumeId);
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DeleteVolume(args).invoke();
    }
}

