/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.symbol.Decorator;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.SemanticScope;

public class Decorations {

    public static interface IsDocument
    extends Decorator.Condition {
    }

    public static class Converter
    implements Decorator.Decoration {
        private final FunctionTable.LocalFunction converter;

        public Converter(FunctionTable.LocalFunction converter) {
            this.converter = converter;
        }

        public FunctionTable.LocalFunction getConverter() {
            return this.converter;
        }
    }

    public static class IRNodeDecoration
    implements Decorator.Decoration {
        private final IRNode irNode;

        public IRNodeDecoration(IRNode irNode) {
            this.irNode = Objects.requireNonNull(irNode);
        }

        public IRNode getIRNode() {
            return this.irNode;
        }
    }

    public static class AccessDepth
    implements Decorator.Decoration {
        private final int accessDepth;

        public AccessDepth(int accessDepth) {
            this.accessDepth = accessDepth;
        }

        public int getAccessDepth() {
            return this.accessDepth;
        }
    }

    public static interface Compound
    extends Decorator.Condition {
    }

    public static interface Negate
    extends Decorator.Condition {
    }

    public static class InstanceType
    implements Decorator.Decoration {
        private final Class<?> instanceType;

        public InstanceType(Class<?> instanceType) {
            this.instanceType = Objects.requireNonNull(instanceType);
        }

        public Class<?> getInstanceType() {
            return this.instanceType;
        }

        public String getInstanceCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.instanceType);
        }
    }

    public static class CapturesDecoration
    implements Decorator.Decoration {
        private final List<SemanticScope.Variable> captures;

        public CapturesDecoration(List<SemanticScope.Variable> captures) {
            this.captures = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(captures)));
        }

        public List<SemanticScope.Variable> getCaptures() {
            return this.captures;
        }
    }

    public static class EncodingDecoration
    implements Decorator.Decoration {
        private final String encoding;

        public EncodingDecoration(String encoding) {
            this.encoding = Objects.requireNonNull(encoding);
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public static class ReferenceDecoration
    implements Decorator.Decoration {
        private final FunctionRef reference;

        public ReferenceDecoration(FunctionRef reference) {
            this.reference = Objects.requireNonNull(reference);
        }

        public FunctionRef getReference() {
            return this.reference;
        }
    }

    public static class ParameterNames
    implements Decorator.Decoration {
        private final List<String> parameterNames;

        public ParameterNames(List<String> parameterNames) {
            this.parameterNames = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(parameterNames)));
        }

        public List<String> getParameterNames() {
            return this.parameterNames;
        }
    }

    public static class TypeParameters
    implements Decorator.Decoration {
        private final List<Class<?>> typeParameters;

        public TypeParameters(List<Class<?>> typeParameters) {
            this.typeParameters = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(typeParameters)));
        }

        public List<Class<?>> getTypeParameters() {
            return this.typeParameters;
        }
    }

    public static class ReturnType
    implements Decorator.Decoration {
        private final Class<?> returnType;

        public ReturnType(Class<?> returnType) {
            this.returnType = Objects.requireNonNull(returnType);
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String getReturnCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.returnType);
        }
    }

    public static class MethodNameDecoration
    implements Decorator.Decoration {
        private final String methodName;

        public MethodNameDecoration(String methodName) {
            this.methodName = Objects.requireNonNull(methodName);
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    public static class StandardPainlessInstanceBinding
    implements Decorator.Decoration {
        private final PainlessInstanceBinding painlessInstanceBinding;

        public StandardPainlessInstanceBinding(PainlessInstanceBinding painlessInstanceBinding) {
            this.painlessInstanceBinding = Objects.requireNonNull(painlessInstanceBinding);
        }

        public PainlessInstanceBinding getPainlessInstanceBinding() {
            return this.painlessInstanceBinding;
        }
    }

    public static class StandardPainlessClassBinding
    implements Decorator.Decoration {
        private final PainlessClassBinding painlessClassBinding;

        public StandardPainlessClassBinding(PainlessClassBinding painlessClassBinding) {
            this.painlessClassBinding = Objects.requireNonNull(painlessClassBinding);
        }

        public PainlessClassBinding getPainlessClassBinding() {
            return this.painlessClassBinding;
        }
    }

    public static class StandardLocalFunction
    implements Decorator.Decoration {
        private final FunctionTable.LocalFunction localFunction;

        public StandardLocalFunction(FunctionTable.LocalFunction localFunction) {
            this.localFunction = Objects.requireNonNull(localFunction);
        }

        public FunctionTable.LocalFunction getLocalFunction() {
            return this.localFunction;
        }
    }

    public static class StandardConstant
    implements Decorator.Decoration {
        private final Object standardConstant;

        public StandardConstant(Object standardConstant) {
            this.standardConstant = Objects.requireNonNull(standardConstant);
        }

        public Object getStandardConstant() {
            return this.standardConstant;
        }
    }

    public static class SetterPainlessMethod
    implements Decorator.Decoration {
        private final PainlessMethod setterPainlessMethod;

        public SetterPainlessMethod(PainlessMethod setterPainlessMethod) {
            this.setterPainlessMethod = Objects.requireNonNull(setterPainlessMethod);
        }

        public PainlessMethod getSetterPainlessMethod() {
            return this.setterPainlessMethod;
        }
    }

    public static class GetterPainlessMethod
    implements Decorator.Decoration {
        private final PainlessMethod getterPainlessMethod;

        public GetterPainlessMethod(PainlessMethod getterPainlessMethod) {
            this.getterPainlessMethod = Objects.requireNonNull(getterPainlessMethod);
        }

        public PainlessMethod getGetterPainlessMethod() {
            return this.getterPainlessMethod;
        }
    }

    public static class StandardPainlessMethod
    implements Decorator.Decoration {
        private final PainlessMethod standardPainlessMethod;

        public StandardPainlessMethod(PainlessMethod standardPainlessMethod) {
            this.standardPainlessMethod = Objects.requireNonNull(standardPainlessMethod);
        }

        public PainlessMethod getStandardPainlessMethod() {
            return this.standardPainlessMethod;
        }
    }

    public static class StandardPainlessConstructor
    implements Decorator.Decoration {
        private final PainlessConstructor standardPainlessConstructor;

        public StandardPainlessConstructor(PainlessConstructor standardPainlessConstructor) {
            this.standardPainlessConstructor = Objects.requireNonNull(standardPainlessConstructor);
        }

        public PainlessConstructor getStandardPainlessConstructor() {
            return this.standardPainlessConstructor;
        }
    }

    public static class StandardPainlessField
    implements Decorator.Decoration {
        private final PainlessField standardPainlessField;

        public StandardPainlessField(PainlessField standardPainlessField) {
            this.standardPainlessField = Objects.requireNonNull(standardPainlessField);
        }

        public PainlessField getStandardPainlessField() {
            return this.standardPainlessField;
        }
    }

    public static class DowncastPainlessCast
    implements Decorator.Decoration {
        private final PainlessCast downcastPainlessCast;

        public DowncastPainlessCast(PainlessCast downcastPainlessCast) {
            this.downcastPainlessCast = Objects.requireNonNull(downcastPainlessCast);
        }

        public PainlessCast getDowncastPainlessCast() {
            return this.downcastPainlessCast;
        }
    }

    public static class UpcastPainlessCast
    implements Decorator.Decoration {
        private final PainlessCast upcastPainlessCast;

        public UpcastPainlessCast(PainlessCast upcastPainlessCast) {
            this.upcastPainlessCast = Objects.requireNonNull(upcastPainlessCast);
        }

        public PainlessCast getUpcastPainlessCast() {
            return this.upcastPainlessCast;
        }
    }

    public static class CompoundType
    implements Decorator.Decoration {
        private final Class<?> compoundType;

        public CompoundType(Class<?> compoundType) {
            this.compoundType = Objects.requireNonNull(compoundType);
        }

        public Class<?> getCompoundType() {
            return this.compoundType;
        }

        public String getCompoundCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.compoundType);
        }
    }

    public static class ComparisonType
    implements Decorator.Decoration {
        private final Class<?> comparisonType;

        public ComparisonType(Class<?> comparisonType) {
            this.comparisonType = Objects.requireNonNull(comparisonType);
        }

        public Class<?> getComparisonType() {
            return this.comparisonType;
        }

        public String getComparisonCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.comparisonType);
        }
    }

    public static class ShiftType
    implements Decorator.Decoration {
        private final Class<?> shiftType;

        public ShiftType(Class<?> shiftType) {
            this.shiftType = Objects.requireNonNull(shiftType);
        }

        public Class<?> getShiftType() {
            return this.shiftType;
        }

        public String getShiftCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.shiftType);
        }
    }

    public static class BinaryType
    implements Decorator.Decoration {
        private final Class<?> binaryType;

        public BinaryType(Class<?> binaryType) {
            this.binaryType = Objects.requireNonNull(binaryType);
        }

        public Class<?> getBinaryType() {
            return this.binaryType;
        }

        public String getBinaryCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.binaryType);
        }
    }

    public static class UnaryType
    implements Decorator.Decoration {
        private final Class<?> unaryType;

        public UnaryType(Class<?> unaryType) {
            this.unaryType = Objects.requireNonNull(unaryType);
        }

        public Class<?> getUnaryType() {
            return this.unaryType;
        }

        public String getUnaryCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.unaryType);
        }
    }

    public static class IterablePainlessMethod
    implements Decorator.Decoration {
        private final PainlessMethod iterablePainlessMethod;

        public IterablePainlessMethod(PainlessMethod iterablePainlessMethod) {
            this.iterablePainlessMethod = Objects.requireNonNull(iterablePainlessMethod);
        }

        public PainlessMethod getIterablePainlessMethod() {
            return this.iterablePainlessMethod;
        }
    }

    public static class SemanticVariable
    implements Decorator.Decoration {
        private final SemanticScope.Variable semanticVariable;

        public SemanticVariable(SemanticScope.Variable semanticVariable) {
            this.semanticVariable = semanticVariable;
        }

        public SemanticScope.Variable getSemanticVariable() {
            return this.semanticVariable;
        }
    }

    public static class ExpressionPainlessCast
    implements Decorator.Decoration {
        private final PainlessCast expressionPainlessCast;

        public ExpressionPainlessCast(PainlessCast expressionPainlessCast) {
            this.expressionPainlessCast = Objects.requireNonNull(expressionPainlessCast);
        }

        public PainlessCast getExpressionPainlessCast() {
            return this.expressionPainlessCast;
        }
    }

    public static interface ListShortcut
    extends Decorator.Condition {
    }

    public static interface MapShortcut
    extends Decorator.Condition {
    }

    public static interface Shortcut
    extends Decorator.Condition {
    }

    public static interface ContinuousLoop
    extends Decorator.Condition {
    }

    public static interface DefOptimized
    extends Decorator.Condition {
    }

    public static class PartialCanonicalTypeName
    implements Decorator.Decoration {
        private final String partialCanonicalTypeName;

        public PartialCanonicalTypeName(String partialCanonicalTypeName) {
            this.partialCanonicalTypeName = Objects.requireNonNull(partialCanonicalTypeName);
        }

        public String getPartialCanonicalTypeName() {
            return this.partialCanonicalTypeName;
        }
    }

    public static class StaticType
    implements Decorator.Decoration {
        private final Class<?> staticType;

        public StaticType(Class<?> staticType) {
            this.staticType = Objects.requireNonNull(staticType);
        }

        public Class<?> getStaticType() {
            return this.staticType;
        }

        public String getStaticCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.staticType);
        }
    }

    public static class ValueType
    implements Decorator.Decoration {
        private final Class<?> valueType;

        public ValueType(Class<?> valueType) {
            this.valueType = Objects.requireNonNull(valueType);
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public String getValueCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.valueType);
        }
    }

    public static interface Internal
    extends Decorator.Condition {
    }

    public static interface Explicit
    extends Decorator.Condition {
    }

    public static class TargetType
    implements Decorator.Decoration {
        private final Class<?> targetType;

        public TargetType(Class<?> targetType) {
            this.targetType = Objects.requireNonNull(targetType);
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public String getTargetCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.targetType);
        }
    }

    public static interface Write
    extends Decorator.Condition {
    }

    public static interface Read
    extends Decorator.Condition {
    }

    public static interface AnyBreak
    extends Decorator.Condition {
    }

    public static interface AnyContinue
    extends Decorator.Condition {
    }

    public static interface AllEscape
    extends Decorator.Condition {
    }

    public static interface LoopEscape
    extends Decorator.Condition {
    }

    public static interface MethodEscape
    extends Decorator.Condition {
    }

    public static interface LastLoop
    extends Decorator.Condition {
    }

    public static interface InLoop
    extends Decorator.Condition {
    }

    public static interface BeginLoop
    extends Decorator.Condition {
    }

    public static interface LastSource
    extends Decorator.Condition {
    }
}

