# completion for tmutil (macOS)

complete -f -c tmutil -n __fish_use_subcommand -a addexclusion -d 'Add an exclusion not to back up a file'
complete -f -c tmutil -n '__fish_seen_subcommand_from addexclusion' -s v -d 'Volume exclusion'
complete -f -c tmutil -n '__fish_seen_subcommand_from addexclusion' -s p -d 'Path exclusion'
complete -r -c tmutil -n __fish_use_subcommand -a associatedisk -d 'Bind a snapshot volume directory to the specified local disk'
complete -r -c tmutil -n __fish_use_subcommand -a calculatedrift -d 'Determine the amount of change between snapshots'
complete -r -c tmutil -n __fish_use_subcommand -a compare -d 'Perform a backup diff'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s a -d 'Compare all supported metadata'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s n -d 'No metadata comparison'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s @ -d 'Compare extended attributes'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s c -d 'Compare creation times'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s d -d 'Compare file data forks'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s e -d 'Compare ACLs'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s f -d 'Compare file flags'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s g -d 'Compare GIDs'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s m -d 'Compare file modes'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s s -d 'Compare sizes'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s t -d 'Compare modification times'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s u -d 'Compare UIDs'
complete -r -c tmutil -n '__fish_seen_subcommand_from compare' -s D -d 'Limit traversal depth to depth levels from the beginning of iteration'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s E -d 'Dont take exclusions into account'
complete -r -c tmutil -n '__fish_seen_subcommand_from compare' -s I -d 'Ignore path'
complete -f -c tmutil -n '__fish_seen_subcommand_from compare' -s U -d 'Ignore logical volume identity'
complete -r -c tmutil -n __fish_use_subcommand -a delete -d 'Delete one or more snapshots'
complete -r -c tmutil -n __fish_use_subcommand -a deletelocalsnapshots -d 'Delete all local Time Machine snapshots for the specified date (formatted YYYY-MM-DD-HHMMSS)'
complete -f -c tmutil -n __fish_use_subcommand -a destinationinfo -d 'Print information about destinations'
complete -f -c tmutil -n __fish_use_subcommand -a disable -d 'Turn off automatic backups'
complete -f -c tmutil -n __fish_use_subcommand -a disablelocal -d 'Turn off local Time Machine snapshots'
complete -f -c tmutil -n __fish_use_subcommand -a enable -d 'Turn on automatic backups'
complete -f -c tmutil -n __fish_use_subcommand -a enablelocal -d 'Turn on local Time Machine snapshots'
complete -r -c tmutil -n __fish_use_subcommand -a inheritbackup -d 'Claim a machine directory or sparsebundle for use by the current machine'
complete -f -c tmutil -n __fish_use_subcommand -a isexcluded -d 'Determine if a file, directory, or volume are excluded from backups'
complete -f -c tmutil -n __fish_use_subcommand -a latestbackup -d 'Print the path to the latest snapshot'
complete -c tmutil -n __fish_use_subcommand -a listlocalsnapshotdates -d 'List the creation dates of all local Time Machine snapshots'
complete -r -c tmutil -n __fish_use_subcommand -a listlocalsnapshots -d 'List local Time Machine snapshots of the specified volume'
complete -f -c tmutil -n __fish_use_subcommand -a listbackups -d 'Print paths for all snapshots'
complete -f -c tmutil -n __fish_use_subcommand -a localsnapshot -d 'Create new local Time Machine snapshots of all APFS volumes included in TM backup'
complete -f -c tmutil -n __fish_use_subcommand -a machinedirectory -d 'Print the path to the current machine directory'
complete -f -c tmutil -n __fish_use_subcommand -a removedestination -d 'Removes a backup destination'
complete -f -c tmutil -n __fish_use_subcommand -a removeexclusion -d 'Remove an exclusion'
complete -f -c tmutil -n '__fish_seen_subcommand_from removeexclusion' -s v -d 'Volume exclusion'
complete -f -c tmutil -n '__fish_seen_subcommand_from removeexclusion' -s p -d 'Path exclusion'
complete -f -c tmutil -n __fish_use_subcommand -a restore -d 'Restore an item'
complete -r -c tmutil -n '__fish_seen_subcommand_from restore' -s v
complete -r -c tmutil -n __fish_use_subcommand -a setdestination -d 'Set a backup destination'
complete -f -c tmutil -n '__fish_seen_subcommand_from setdestination' -s a -d 'Add to the list of destinations'
complete -f -c tmutil -n '__fish_seen_subcommand_from setdestination' -s p -d 'Enter the password at a non-echoing interactive prompt'
complete -f -c tmutil -n __fish_use_subcommand -a snapshot -d 'Create new local Time Machine snapshot'
complete -f -c tmutil -n __fish_use_subcommand -a startbackup -d 'Begin a backup if one is not already running'
complete -f -c tmutil -n '__fish_seen_subcommand_from startbackup' -s a -l auto -d 'Automatic mode'
complete -f -c tmutil -n '__fish_seen_subcommand_from startbackup' -s b -l block -d 'Block until finished'
complete -f -c tmutil -n '__fish_seen_subcommand_from startbackup' -s r -l rotation -d 'Automatic rotation'
complete -r -c tmutil -n '__fish_seen_subcommand_from startbackup' -s d -l destination -d 'Backup destination'
complete -f -c tmutil -n __fish_use_subcommand -a stopbackup -d 'Cancel a backup currently in progress'
complete -r -c tmutil -n __fish_use_subcommand -a thinlocalsnapshots -d 'Thin local Time Machine snapshots for the specified volume'
complete -r -c tmutil -n __fish_use_subcommand -a uniquesize -d 'Analyze the specified path and determine its unique size'
complete -r -c tmutil -n __fish_use_subcommand -a verifychecksums -d 'Verify snapshot'
complete -f -c tmutil -n __fish_use_subcommand -a version -d 'Print version'

complete -f -c tmutil -n '__fish_seen_subcommand_from destinationinfo isexcluded compare' -s X -d 'Print as XML'
