/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.fp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.fp.RemoveFeaturePackCommandActivator;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;

@CommandDefinition(name="remove-dependency", description="Remove a feature pack dependency from the provisioning state", activator=RemoveFeaturePackCommandActivator.class)
public class StateRemoveFeaturePackCommand
extends AbstractStateCommand {
    @Argument(completer=ProvisionedFPCompleter.class, description="Feature pack to remove")
    protected String fpl;

    @Override
    protected void runCommand(PmCommandInvocation invoc, State session) throws IOException, ProvisioningException, CommandExecutionException {
        session.removeDependency(invoc.getPmSession(), invoc.getPmSession().getResolvedLocation(null, this.fpl));
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }

    public static class ProvisionedFPCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            State session = completerInvocation.getPmSession().getState();
            ArrayList<String> lst = new ArrayList<String>();
            if (session != null) {
                for (FeaturePackConfig fp : session.getConfig().getFeaturePackDeps()) {
                    String loc = completerInvocation.getPmSession().getExposedLocation(null, fp.getLocation()).toString();
                    lst.add(loc);
                }
            }
            return lst;
        }
    }
}

