/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.locators.NotifyingBeans;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.guice.bean.locators.QualifiedBeans;
import org.sonatype.guice.bean.locators.WatchedBeans;
import org.sonatype.guice.bean.locators.WeakBeanReference;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final List<Provider<? extends QualifiedBeans<?, ?>>> exposedBeans = new ArrayList();
    private final Set<Injector> injectors = new LinkedHashSet<Injector>();

    @Override
    public synchronized <Q extends Annotation, T> Iterable<QualifiedBean<Q, T>> locate(Key<T> key, Runnable notify) {
        QualifiedBeans beans = this.initialize(null == notify ? new QualifiedBeans(key) : new NotifyingBeans(key, notify));
        this.exposedBeans.add(new WeakBeanReference(beans));
        return beans;
    }

    @Override
    public synchronized <Q extends Annotation, T, W> void watch(Key<T> key, Mediator<Q, T, W> mediator, W watcher) {
        this.exposedBeans.add(this.initialize(new WatchedBeans<Q, T, W>(key, mediator, watcher)));
    }

    @Override
    @Inject
    public synchronized void add(Injector injector) {
        if (null == injector || !this.injectors.add(injector)) {
            return;
        }
        for (int i = 0; i < this.exposedBeans.size(); ++i) {
            QualifiedBeans<?, ?> beans = this.exposedBeans.get(i).get();
            if (null != beans) {
                beans.add(injector);
                continue;
            }
            this.exposedBeans.remove(i--);
        }
    }

    @Override
    public synchronized void remove(Injector injector) {
        if (null == injector || !this.injectors.remove(injector)) {
            return;
        }
        for (int i = 0; i < this.exposedBeans.size(); ++i) {
            QualifiedBeans<?, ?> beans = this.exposedBeans.get(i).get();
            if (null != beans) {
                beans.remove(injector);
                continue;
            }
            this.exposedBeans.remove(i--);
        }
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < this.exposedBeans.size(); ++i) {
            QualifiedBeans<?, ?> beans = this.exposedBeans.get(i).get();
            if (null != beans) {
                beans.clear();
                continue;
            }
            this.exposedBeans.remove(i--);
        }
        this.injectors.clear();
    }

    private <B extends QualifiedBeans<?, ?>> B initialize(B beans) {
        for (Injector injector : this.injectors) {
            beans.add(injector);
        }
        for (int i = 0; i < this.exposedBeans.size(); ++i) {
            if (null != this.exposedBeans.get(i).get()) continue;
            this.exposedBeans.remove(i--);
        }
        return beans;
    }
}

