/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.File;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.changedetection.state.CrossBuildFileHashCache;
import org.gradle.api.internal.changedetection.state.FileTimeStampInspector;
import org.gradle.internal.hash.ChecksumHasher;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildSession.class)
public class DefaultChecksumService
implements ChecksumService {
    private final CachingFileHasher md5;
    private final CachingFileHasher sha1;
    private final CachingFileHasher sha256;
    private final CachingFileHasher sha512;

    public DefaultChecksumService(StringInterner stringInterner, CrossBuildFileHashCache fileStore, FileSystem fileSystem, FileTimeStampInspector fileTimeStampInspector) {
        this.md5 = this.createCache(stringInterner, fileStore, fileSystem, fileTimeStampInspector, "md5", Hashing.md5());
        this.sha1 = this.createCache(stringInterner, fileStore, fileSystem, fileTimeStampInspector, "sha1", Hashing.sha1());
        this.sha256 = this.createCache(stringInterner, fileStore, fileSystem, fileTimeStampInspector, "sha256", Hashing.sha256());
        this.sha512 = this.createCache(stringInterner, fileStore, fileSystem, fileTimeStampInspector, "sha512", Hashing.sha512());
    }

    private CachingFileHasher createCache(StringInterner stringInterner, CrossBuildFileHashCache fileStore, FileSystem fileSystem, FileTimeStampInspector fileTimeStampInspector, String name, HashFunction hashFunction) {
        return new CachingFileHasher(new ChecksumHasher(hashFunction), fileStore, stringInterner, fileTimeStampInspector, name + "-checksums", fileSystem, 1000);
    }

    public HashCode md5(File file) {
        return this.doHash(file, this.md5);
    }

    public HashCode sha1(File file) {
        return this.doHash(file, this.sha1);
    }

    public HashCode sha256(File file) {
        return this.doHash(file, this.sha256);
    }

    public HashCode sha512(File file) {
        return this.doHash(file, this.sha512);
    }

    public HashCode hash(File src, String algorithm) {
        switch (algorithm.toLowerCase()) {
            case "md5": {
                return this.md5(src);
            }
            case "sha1": 
            case "sha-1": {
                return this.sha1(src);
            }
            case "sha256": 
            case "sha-256": {
                return this.sha256(src);
            }
            case "sha512": 
            case "sha-512": {
                return this.sha512(src);
            }
        }
        throw new UnsupportedOperationException("Cannot hash with algorith " + algorithm);
    }

    private HashCode doHash(File file, CachingFileHasher hasher) {
        return hasher.hash(file);
    }
}

