/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.component.model.VariantWithOverloadAttributes;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class ProjectArtifactSetResolver {
    private final ArtifactResolver artifactResolver;
    private final Map<ComponentArtifactIdentifier, ResolvableArtifact> allProjectArtifacts = new ConcurrentHashMap<ComponentArtifactIdentifier, ResolvableArtifact>();
    private final Map<VariantResolveMetadata.Identifier, ResolvedVariant> allProjectVariants = new ConcurrentHashMap<VariantResolveMetadata.Identifier, ResolvedVariant>();

    public ProjectArtifactSetResolver(ProjectArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ArtifactSet resolveArtifacts(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier ownerId, ModuleSources moduleSources, ExcludeSpec exclusions, Set<? extends VariantResolveMetadata> variants, AttributesSchemaInternal schema, ArtifactTypeRegistry artifactTypeRegistry, ImmutableAttributes selectionAttributes) {
        ImmutableSet.Builder result = ImmutableSet.builderWithExpectedSize((int)variants.size());
        for (VariantResolveMetadata variantResolveMetadata : variants) {
            ResolvedVariant resolvedVariant = this.mapVariant(ownerId, moduleSources, exclusions, artifactTypeRegistry, variantResolveMetadata);
            result.add((Object)resolvedVariant);
        }
        return DefaultArtifactSet.createFromVariants(componentIdentifier, (ImmutableSet<ResolvedVariant>)result.build(), schema, selectionAttributes);
    }

    private ResolvedVariant mapVariant(ModuleVersionIdentifier ownerId, ModuleSources moduleSources, ExcludeSpec exclusions, ArtifactTypeRegistry artifactTypeRegistry, VariantResolveMetadata variant) {
        VariantResolveMetadata.Identifier identifier = variant.getIdentifier();
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Project variant %s does not have an identifier.", variant.asDescribable()));
        }
        ImmutableAttributes variantAttributes = artifactTypeRegistry.mapAttributesFor(variant.getAttributes().asImmutable(), (Iterable<? extends ComponentArtifactMetadata>)variant.getArtifacts());
        if (exclusions.mayExcludeArtifacts()) {
            return DefaultArtifactSet.toResolvedVariant(variant, ownerId, moduleSources, exclusions, this.artifactResolver, this.allProjectArtifacts, variantAttributes);
        }
        VariantWithOverloadAttributes key = new VariantWithOverloadAttributes(identifier, variantAttributes);
        return this.allProjectVariants.computeIfAbsent(key, k -> DefaultArtifactSet.toResolvedVariant(variant, ownerId, moduleSources, exclusions, this.artifactResolver, this.allProjectArtifacts, variantAttributes));
    }
}

