"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var constants_1 = require("../../../../specs/constants");
var utils_1 = require("../../../../state/utils");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var scenegraph_1 = require("./scenegraph");
var getSpecs = function (state) { return state.specs; };
var getParentDimensions = function (state) { return state.parentDimensions; };
exports.geometries = re_reselect_1.default([getSpecs, getParentDimensions], function (specs, parentDimensions) {
    var goalSpecs = utils_1.getSpecsFromStore(specs, __1.ChartTypes.Goal, constants_1.SpecTypes.Series);
    return goalSpecs.length === 1 ? scenegraph_1.render(goalSpecs[0], parentDimensions) : viewmodel_types_1.nullShapeViewModel();
})(function (state) { return state.chartId; });
//# sourceMappingURL=geometries.js.map