"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../renderers/canvas");
var line_1 = require("../../../xy_chart/renderer/canvas/primitives/line");
var rect_1 = require("../../../xy_chart/renderer/canvas/primitives/rect");
var text_1 = require("../../../xy_chart/renderer/canvas/primitives/text");
function renderCanvas2d(globalCtx, dpr, _a) {
    var config = _a.config, heatmapViewModel = _a.heatmapViewModel;
    var _b = config;
    canvas_1.withContext(globalCtx, function (context) {
        context.scale(dpr, dpr);
        context.textAlign = 'center';
        context.textBaseline = 'middle';
        var filteredCells = heatmapViewModel.cells.filter(function (cell) {
            return cell.yIndex < heatmapViewModel.pageSize;
        });
        var filteredYValues = heatmapViewModel.yValues.filter(function (value, yIndex) {
            return yIndex < heatmapViewModel.pageSize;
        });
        canvas_1.renderLayers(context, [
            function (ctx) { return canvas_1.clearCanvas(ctx, config.width, config.height); },
            function (ctx) {
                canvas_1.withContext(ctx, function (ctx) {
                    line_1.renderMultiLine(ctx, heatmapViewModel.gridLines.x, heatmapViewModel.gridLines.stroke);
                    line_1.renderMultiLine(ctx, heatmapViewModel.gridLines.y, heatmapViewModel.gridLines.stroke);
                });
            },
            function (ctx) {
                return canvas_1.withContext(ctx, function (ctx) {
                    var _a = heatmapViewModel.gridOrigin, x = _a.x, y = _a.y;
                    ctx.translate(x, y);
                    filteredCells.forEach(function (cell) {
                        if (!cell.visible) {
                            return;
                        }
                        rect_1.renderRect(ctx, cell, cell.fill, cell.stroke);
                    });
                });
            },
            function (ctx) {
                return canvas_1.withContext(ctx, function (ctx) {
                    var _a = heatmapViewModel.gridOrigin, x = _a.x, y = _a.y;
                    ctx.translate(x, y);
                    if (!config.cell.label.visible) {
                        return;
                    }
                    filteredCells.forEach(function (cell) {
                        if (!cell.visible) {
                            return;
                        }
                        text_1.renderText(ctx, {
                            x: cell.x + cell.width / 2,
                            y: cell.y + cell.height / 2,
                        }, cell.formatted, config.cell.label);
                    });
                });
            },
            function (ctx) {
                return canvas_1.withContext(ctx, function (ctx) {
                    if (!config.yAxisLabel.visible) {
                        return;
                    }
                    filteredYValues.forEach(function (yValue) {
                        var _a, _b;
                        var font = {
                            fontFamily: config.yAxisLabel.fontFamily,
                            fontStyle: config.yAxisLabel.fontStyle ? config.yAxisLabel.fontStyle : 'normal',
                            fontVariant: 'normal',
                            fontWeight: 'normal',
                            textColor: 'black',
                            textOpacity: 1,
                        };
                        var padding = config.yAxisLabel.padding;
                        var horizontalPadding = typeof padding === 'number' ? padding * 2 : (_a = padding.left, (_a !== null && _a !== void 0 ? _a : 0)) + (_b = padding.right, (_b !== null && _b !== void 0 ? _b : 0));
                        var _c = __read(text_1.wrapLines(ctx, yValue.text, font, config.yAxisLabel.fontSize, heatmapViewModel.gridOrigin.x - horizontalPadding, 16, {
                            shouldAddEllipsis: true,
                            wrapAtWord: false,
                        }).lines, 1), resultText = _c[0];
                        text_1.renderText(ctx, {
                            x: yValue.x,
                            y: yValue.y,
                        }, resultText, __assign(__assign({}, config.yAxisLabel), { align: 'right' }));
                    });
                });
            },
            function (ctx) {
                return canvas_1.withContext(ctx, function (ctx) {
                    if (!config.xAxisLabel.visible) {
                        return;
                    }
                    heatmapViewModel.xValues.forEach(function (xValue) {
                        text_1.renderText(ctx, {
                            x: xValue.x,
                            y: xValue.y,
                        }, xValue.text, config.xAxisLabel);
                    });
                });
            },
        ]);
    });
}
exports.renderCanvas2d = renderCanvas2d;
//# sourceMappingURL=canvas_renderers.js.map