"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var color_library_wrappers_1 = require("../../../partition_chart/layout/utils/color_library_wrappers");
var get_heatmap_config_1 = require("./get_heatmap_config");
var heatmap_spec_1 = require("./heatmap_spec");
var picked_shapes_1 = require("./picked_shapes");
var EMPTY_TOOLTIP = Object.freeze({
    header: null,
    values: [],
});
exports.getTooltipInfoSelector = re_reselect_1.default([heatmap_spec_1.getSpecOrNull, get_heatmap_config_1.getHeatmapConfigSelector, picked_shapes_1.getPickedShapes], function (spec, config, pickedShapes) {
    if (!spec) {
        return EMPTY_TOOLTIP;
    }
    var tooltipInfo = {
        header: null,
        values: [],
    };
    if (Array.isArray(pickedShapes)) {
        pickedShapes
            .filter(function (_a) {
            var visible = _a.visible;
            return visible;
        })
            .forEach(function (shape) {
            var _a;
            tooltipInfo.values.push({
                label: config.xAxisLabel.name,
                color: 'transparent',
                isHighlighted: false,
                isVisible: true,
                seriesIdentifier: {
                    specId: spec.id,
                    key: spec.id,
                },
                value: "" + shape.datum.x,
                formattedValue: config.xAxisLabel.formatter(shape.datum.x),
            });
            tooltipInfo.values.push({
                label: config.yAxisLabel.name,
                color: 'transparent',
                isHighlighted: false,
                isVisible: true,
                seriesIdentifier: {
                    specId: spec.id,
                    key: spec.id,
                },
                value: "" + shape.datum.y,
                formattedValue: config.yAxisLabel.formatter(shape.datum.y),
            });
            tooltipInfo.values.push({
                label: (_a = spec.name, (_a !== null && _a !== void 0 ? _a : spec.id)),
                color: color_library_wrappers_1.RGBtoString(shape.fill.color),
                isHighlighted: false,
                isVisible: true,
                seriesIdentifier: {
                    specId: spec.id,
                    key: spec.id,
                },
                value: "" + shape.value,
                formattedValue: "" + shape.formatted,
            });
        });
    }
    else {
        tooltipInfo.values.push({
            label: "",
            color: 'transparent',
            isHighlighted: false,
            isVisible: true,
            seriesIdentifier: {
                specId: spec.id,
                key: spec.id,
            },
            value: "" + pickedShapes.value,
            formattedValue: "" + pickedShapes.value,
        });
    }
    return tooltipInfo;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=tooltip.js.map