"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
function buildBarStyles(baseColor, themeRectStyle, themeRectBorderStyle, geometryStateStyle) {
    var fillOpacity = function (opacity) { return opacity * themeRectStyle.opacity * geometryStateStyle.opacity; };
    var fillColor = color_library_wrappers_1.stringToRGB(commons_1.getColorFromVariant(baseColor, themeRectStyle.fill), fillOpacity);
    var fill = {
        color: fillColor,
    };
    var defaultStrokeOpacity = themeRectBorderStyle.strokeOpacity === undefined ? themeRectStyle.opacity : themeRectBorderStyle.strokeOpacity;
    var borderStrokeOpacity = defaultStrokeOpacity * geometryStateStyle.opacity;
    var strokeOpacity = function (opacity) { return opacity * borderStrokeOpacity; };
    var strokeColor = color_library_wrappers_1.stringToRGB(commons_1.getColorFromVariant(baseColor, themeRectBorderStyle.stroke), strokeOpacity);
    var stroke = {
        color: strokeColor,
        width: themeRectBorderStyle.visible ? themeRectBorderStyle.strokeWidth : 0,
    };
    return { fill: fill, stroke: stroke };
}
exports.buildBarStyles = buildBarStyles;
//# sourceMappingURL=bar.js.map