"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getAccessorFn(accessor) {
    return function (datum) {
        return typeof datum === 'object' && datum !== null ? datum[accessor] : undefined;
    };
}
exports.getAccessorFn = getAccessorFn;
function getAccessorFormatLabel(accessor, label) {
    if (typeof accessor === 'string') {
        return "" + label + accessor;
    }
    return accessor(label);
}
exports.getAccessorFormatLabel = getAccessorFormatLabel;
function getAccessorValue(datum, accessor) {
    if (typeof accessor === 'function') {
        return accessor(datum);
    }
    return datum[accessor];
}
exports.getAccessorValue = getAccessorValue;
//# sourceMappingURL=accessor.js.map