/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMOptRemarkEntry;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMOptRemarks {
    public static final int OPT_REMARKS_API_VERSION = 0;

    protected LLVMOptRemarks() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMOptRemarkParserCreate(long Buf, long Size) {
        long __functionAddress = Functions.OptRemarkParserCreate;
        return JNI.invokePJP((long)Buf, (long)Size, (long)__functionAddress);
    }

    @NativeType(value="LLVMOptRemarkParserRef")
    public static long LLVMOptRemarkParserCreate(@NativeType(value="void const *") ByteBuffer Buf) {
        return LLVMOptRemarks.nLLVMOptRemarkParserCreate(MemoryUtil.memAddress((ByteBuffer)Buf), Buf.remaining());
    }

    public static long nLLVMOptRemarkParserGetNext(long Parser) {
        long __functionAddress = Functions.OptRemarkParserGetNext;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        return JNI.invokePP((long)Parser, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="LLVMOptRemarkEntry *")
    public static LLVMOptRemarkEntry LLVMOptRemarkParserGetNext(@NativeType(value="LLVMOptRemarkParserRef") long Parser) {
        long __result = LLVMOptRemarks.nLLVMOptRemarkParserGetNext(Parser);
        return LLVMOptRemarkEntry.createSafe(__result);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMOptRemarkParserHasError(@NativeType(value="LLVMOptRemarkParserRef") long Parser) {
        long __functionAddress = Functions.OptRemarkParserHasError;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        return JNI.invokePI((long)Parser, (long)__functionAddress) != 0;
    }

    public static long nLLVMOptRemarkParserGetErrorMessage(long Parser) {
        long __functionAddress = Functions.OptRemarkParserGetErrorMessage;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        return JNI.invokePP((long)Parser, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMOptRemarkParserGetErrorMessage(@NativeType(value="LLVMOptRemarkParserRef") long Parser) {
        long __result = LLVMOptRemarks.nLLVMOptRemarkParserGetErrorMessage(Parser);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void LLVMOptRemarkParserDispose(@NativeType(value="LLVMOptRemarkParserRef") long Parser) {
        long __functionAddress = Functions.OptRemarkParserDispose;
        if (Checks.CHECKS) {
            Checks.check((long)Parser);
        }
        JNI.invokePV((long)Parser, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMOptRemarkVersion() {
        long __functionAddress = Functions.OptRemarkVersion;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeI((long)__functionAddress);
    }

    public static final class Functions {
        public static final long OptRemarkParserCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOptRemarkParserCreate");
        public static final long OptRemarkParserGetNext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOptRemarkParserGetNext");
        public static final long OptRemarkParserHasError = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOptRemarkParserHasError");
        public static final long OptRemarkParserGetErrorMessage = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOptRemarkParserGetErrorMessage");
        public static final long OptRemarkParserDispose = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOptRemarkParserDispose");
        public static final long OptRemarkVersion = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMOptRemarkVersion");

        private Functions() {
        }
    }
}

