/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_OverdrawStatistics")
public class MeshoptOverdrawStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXELS_COVERED;
    public static final int PIXELS_SHADED;
    public static final int OVERDRAW;

    public MeshoptOverdrawStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptOverdrawStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int pixels_covered() {
        return MeshoptOverdrawStatistics.npixels_covered(this.address());
    }

    @NativeType(value="unsigned int")
    public int pixels_shaded() {
        return MeshoptOverdrawStatistics.npixels_shaded(this.address());
    }

    public float overdraw() {
        return MeshoptOverdrawStatistics.noverdraw(this.address());
    }

    public static MeshoptOverdrawStatistics malloc() {
        return (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MeshoptOverdrawStatistics calloc() {
        return (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MeshoptOverdrawStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MeshoptOverdrawStatistics create(long address) {
        return (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)address);
    }

    @Nullable
    public static MeshoptOverdrawStatistics createSafe(long address) {
        return address == 0L ? null : (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MeshoptOverdrawStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptOverdrawStatistics.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MeshoptOverdrawStatistics mallocStack() {
        return MeshoptOverdrawStatistics.mallocStack(MemoryStack.stackGet());
    }

    public static MeshoptOverdrawStatistics callocStack() {
        return MeshoptOverdrawStatistics.callocStack(MemoryStack.stackGet());
    }

    public static MeshoptOverdrawStatistics mallocStack(MemoryStack stack) {
        return (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptOverdrawStatistics callocStack(MemoryStack stack) {
        return (MeshoptOverdrawStatistics)MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MeshoptOverdrawStatistics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MeshoptOverdrawStatistics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptOverdrawStatistics.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int npixels_covered(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXELS_COVERED);
    }

    public static int npixels_shaded(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXELS_SHADED);
    }

    public static float noverdraw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OVERDRAW);
    }

    static {
        Struct.Layout layout = MeshoptOverdrawStatistics.__struct((Struct.Member[])new Struct.Member[]{MeshoptOverdrawStatistics.__member((int)4), MeshoptOverdrawStatistics.__member((int)4), MeshoptOverdrawStatistics.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXELS_COVERED = layout.offsetof(0);
        PIXELS_SHADED = layout.offsetof(1);
        OVERDRAW = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeshoptOverdrawStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptOverdrawStatistics ELEMENT_FACTORY = MeshoptOverdrawStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeshoptOverdrawStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int pixels_covered() {
            return MeshoptOverdrawStatistics.npixels_covered(this.address());
        }

        @NativeType(value="unsigned int")
        public int pixels_shaded() {
            return MeshoptOverdrawStatistics.npixels_shaded(this.address());
        }

        public float overdraw() {
            return MeshoptOverdrawStatistics.noverdraw(this.address());
        }
    }
}

