/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkMemoryFdPropertiesKHR;
import org.lwjgl.vulkan.VkMemoryGetFdInfoKHR;

public class KHRExternalMemoryFd {
    public static final int VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION = 1;
    public static final String VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME = "VK_KHR_external_memory_fd";
    public static final int VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR = 1000074000;
    public static final int VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR = 1000074001;
    public static final int VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR = 1000074002;

    protected KHRExternalMemoryFd() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME) && VK.checkExtension(VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME, VK.isSupported(provider, "vkGetMemoryFdKHR", caps) && VK.isSupported(provider, "vkGetMemoryFdPropertiesKHR", caps));
    }

    public static int nvkGetMemoryFdKHR(VkDevice device, long pGetFdInfo, long pFd) {
        long __functionAddress = device.getCapabilities().vkGetMemoryFdKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)device.address(), (long)pGetFdInfo, (long)pFd, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetMemoryFdKHR(VkDevice device, @NativeType(value="VkMemoryGetFdInfoKHR const *") VkMemoryGetFdInfoKHR pGetFdInfo, @NativeType(value="int *") IntBuffer pFd) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFd, (int)1);
        }
        return KHRExternalMemoryFd.nvkGetMemoryFdKHR(device, pGetFdInfo.address(), MemoryUtil.memAddress((IntBuffer)pFd));
    }

    public static int nvkGetMemoryFdPropertiesKHR(VkDevice device, int handleType, int fd, long pMemoryFdProperties) {
        long __functionAddress = device.getCapabilities().vkGetMemoryFdPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (int)handleType, (int)fd, (long)pMemoryFdProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetMemoryFdPropertiesKHR(VkDevice device, @NativeType(value="VkExternalMemoryHandleTypeFlagBits") int handleType, int fd, @NativeType(value="VkMemoryFdPropertiesKHR *") VkMemoryFdPropertiesKHR pMemoryFdProperties) {
        return KHRExternalMemoryFd.nvkGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties.address());
    }

    @NativeType(value="VkResult")
    public static int vkGetMemoryFdKHR(VkDevice device, @NativeType(value="VkMemoryGetFdInfoKHR const *") VkMemoryGetFdInfoKHR pGetFdInfo, @NativeType(value="int *") int[] pFd) {
        long __functionAddress = device.getCapabilities().vkGetMemoryFdKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pFd, (int)1);
        }
        return JNI.callPPPI((long)device.address(), (long)pGetFdInfo.address(), (int[])pFd, (long)__functionAddress);
    }
}

