/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceVulkan11Properties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEUUID;
    public static final int DRIVERUUID;
    public static final int DEVICELUID;
    public static final int DEVICENODEMASK;
    public static final int DEVICELUIDVALID;
    public static final int SUBGROUPSIZE;
    public static final int SUBGROUPSUPPORTEDSTAGES;
    public static final int SUBGROUPSUPPORTEDOPERATIONS;
    public static final int SUBGROUPQUADOPERATIONSINALLSTAGES;
    public static final int POINTCLIPPINGBEHAVIOR;
    public static final int MAXMULTIVIEWVIEWCOUNT;
    public static final int MAXMULTIVIEWINSTANCEINDEX;
    public static final int PROTECTEDNOFAULT;
    public static final int MAXPERSETDESCRIPTORS;
    public static final int MAXMEMORYALLOCATIONSIZE;

    public VkPhysicalDeviceVulkan11Properties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceVulkan11Properties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceVulkan11Properties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceVulkan11Properties.npNext(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer deviceUUID() {
        return VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceUUID(int index) {
        return VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer driverUUID() {
        return VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte driverUUID(int index) {
        return VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_LUID_SIZE]")
    public ByteBuffer deviceLUID() {
        return VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceLUID(int index) {
        return VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int deviceNodeMask() {
        return VkPhysicalDeviceVulkan11Properties.ndeviceNodeMask(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean deviceLUIDValid() {
        return VkPhysicalDeviceVulkan11Properties.ndeviceLUIDValid(this.address()) != 0;
    }

    @NativeType(value="uint32_t")
    public int subgroupSize() {
        return VkPhysicalDeviceVulkan11Properties.nsubgroupSize(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int subgroupSupportedStages() {
        return VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedStages(this.address());
    }

    @NativeType(value="VkSubgroupFeatureFlags")
    public int subgroupSupportedOperations() {
        return VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedOperations(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean subgroupQuadOperationsInAllStages() {
        return VkPhysicalDeviceVulkan11Properties.nsubgroupQuadOperationsInAllStages(this.address()) != 0;
    }

    @NativeType(value="VkPointClippingBehavior")
    public int pointClippingBehavior() {
        return VkPhysicalDeviceVulkan11Properties.npointClippingBehavior(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxMultiviewViewCount() {
        return VkPhysicalDeviceVulkan11Properties.nmaxMultiviewViewCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxMultiviewInstanceIndex() {
        return VkPhysicalDeviceVulkan11Properties.nmaxMultiviewInstanceIndex(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean protectedNoFault() {
        return VkPhysicalDeviceVulkan11Properties.nprotectedNoFault(this.address()) != 0;
    }

    @NativeType(value="uint32_t")
    public int maxPerSetDescriptors() {
        return VkPhysicalDeviceVulkan11Properties.nmaxPerSetDescriptors(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxMemoryAllocationSize() {
        return VkPhysicalDeviceVulkan11Properties.nmaxMemoryAllocationSize(this.address());
    }

    public VkPhysicalDeviceVulkan11Properties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceVulkan11Properties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceVulkan11Properties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties deviceUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties deviceUUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address(), index, value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties driverUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties driverUUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address(), index, value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties deviceLUID(@NativeType(value="uint8_t[VK_LUID_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties deviceLUID(int index, @NativeType(value="uint8_t") byte value) {
        VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address(), index, value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties deviceNodeMask(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan11Properties.ndeviceNodeMask(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties deviceLUIDValid(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan11Properties.ndeviceLUIDValid(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties subgroupSize(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan11Properties.nsubgroupSize(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties subgroupSupportedStages(@NativeType(value="VkShaderStageFlags") int value) {
        VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedStages(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties subgroupSupportedOperations(@NativeType(value="VkSubgroupFeatureFlags") int value) {
        VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedOperations(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties subgroupQuadOperationsInAllStages(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan11Properties.nsubgroupQuadOperationsInAllStages(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties pointClippingBehavior(@NativeType(value="VkPointClippingBehavior") int value) {
        VkPhysicalDeviceVulkan11Properties.npointClippingBehavior(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties maxMultiviewViewCount(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan11Properties.nmaxMultiviewViewCount(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties maxMultiviewInstanceIndex(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan11Properties.nmaxMultiviewInstanceIndex(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties protectedNoFault(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan11Properties.nprotectedNoFault(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties maxPerSetDescriptors(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan11Properties.nmaxPerSetDescriptors(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties maxMemoryAllocationSize(@NativeType(value="VkDeviceSize") long value) {
        VkPhysicalDeviceVulkan11Properties.nmaxMemoryAllocationSize(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties set(int sType, long pNext, ByteBuffer deviceUUID, ByteBuffer driverUUID, ByteBuffer deviceLUID, int deviceNodeMask, boolean deviceLUIDValid, int subgroupSize, int subgroupSupportedStages, int subgroupSupportedOperations, boolean subgroupQuadOperationsInAllStages, int pointClippingBehavior, int maxMultiviewViewCount, int maxMultiviewInstanceIndex, boolean protectedNoFault, int maxPerSetDescriptors, long maxMemoryAllocationSize) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceUUID(deviceUUID);
        this.driverUUID(driverUUID);
        this.deviceLUID(deviceLUID);
        this.deviceNodeMask(deviceNodeMask);
        this.deviceLUIDValid(deviceLUIDValid);
        this.subgroupSize(subgroupSize);
        this.subgroupSupportedStages(subgroupSupportedStages);
        this.subgroupSupportedOperations(subgroupSupportedOperations);
        this.subgroupQuadOperationsInAllStages(subgroupQuadOperationsInAllStages);
        this.pointClippingBehavior(pointClippingBehavior);
        this.maxMultiviewViewCount(maxMultiviewViewCount);
        this.maxMultiviewInstanceIndex(maxMultiviewInstanceIndex);
        this.protectedNoFault(protectedNoFault);
        this.maxPerSetDescriptors(maxPerSetDescriptors);
        this.maxMemoryAllocationSize(maxMemoryAllocationSize);
        return this;
    }

    public VkPhysicalDeviceVulkan11Properties set(VkPhysicalDeviceVulkan11Properties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceVulkan11Properties malloc() {
        return (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceVulkan11Properties calloc() {
        return (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceVulkan11Properties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceVulkan11Properties create(long address) {
        return (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceVulkan11Properties createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceVulkan11Properties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceVulkan11Properties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceVulkan11Properties mallocStack() {
        return VkPhysicalDeviceVulkan11Properties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceVulkan11Properties callocStack() {
        return VkPhysicalDeviceVulkan11Properties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceVulkan11Properties mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceVulkan11Properties callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceVulkan11Properties)VkPhysicalDeviceVulkan11Properties.wrap(VkPhysicalDeviceVulkan11Properties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceVulkan11Properties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceVulkan11Properties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceVulkan11Properties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static ByteBuffer ndeviceUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICEUUID), (int)16);
    }

    public static byte ndeviceUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DEVICEUUID + Checks.check((int)index, (int)16) * 1L);
    }

    public static ByteBuffer ndriverUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERUUID), (int)16);
    }

    public static byte ndriverUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DRIVERUUID + Checks.check((int)index, (int)16) * 1L);
    }

    public static ByteBuffer ndeviceLUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICELUID), (int)8);
    }

    public static byte ndeviceLUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DEVICELUID + Checks.check((int)index, (int)8) * 1L);
    }

    public static int ndeviceNodeMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICENODEMASK);
    }

    public static int ndeviceLUIDValid(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICELUIDVALID);
    }

    public static int nsubgroupSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBGROUPSIZE);
    }

    public static int nsubgroupSupportedStages(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBGROUPSUPPORTEDSTAGES);
    }

    public static int nsubgroupSupportedOperations(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBGROUPSUPPORTEDOPERATIONS);
    }

    public static int nsubgroupQuadOperationsInAllStages(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBGROUPQUADOPERATIONSINALLSTAGES);
    }

    public static int npointClippingBehavior(long struct) {
        return UNSAFE.getInt(null, struct + (long)POINTCLIPPINGBEHAVIOR);
    }

    public static int nmaxMultiviewViewCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXMULTIVIEWVIEWCOUNT);
    }

    public static int nmaxMultiviewInstanceIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXMULTIVIEWINSTANCEINDEX);
    }

    public static int nprotectedNoFault(long struct) {
        return UNSAFE.getInt(null, struct + (long)PROTECTEDNOFAULT);
    }

    public static int nmaxPerSetDescriptors(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSETDESCRIPTORS);
    }

    public static long nmaxMemoryAllocationSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXMEMORYALLOCATIONSIZE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndeviceUUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DEVICEUUID), (long)(value.remaining() * 1));
    }

    public static void ndeviceUUID(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DEVICEUUID + Checks.check((int)index, (int)16) * 1L, value);
    }

    public static void ndriverUUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DRIVERUUID), (long)(value.remaining() * 1));
    }

    public static void ndriverUUID(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DRIVERUUID + Checks.check((int)index, (int)16) * 1L, value);
    }

    public static void ndeviceLUID(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DEVICELUID), (long)(value.remaining() * 1));
    }

    public static void ndeviceLUID(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DEVICELUID + Checks.check((int)index, (int)8) * 1L, value);
    }

    public static void ndeviceNodeMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICENODEMASK, value);
    }

    public static void ndeviceLUIDValid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICELUIDVALID, value);
    }

    public static void nsubgroupSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBGROUPSIZE, value);
    }

    public static void nsubgroupSupportedStages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBGROUPSUPPORTEDSTAGES, value);
    }

    public static void nsubgroupSupportedOperations(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBGROUPSUPPORTEDOPERATIONS, value);
    }

    public static void nsubgroupQuadOperationsInAllStages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBGROUPQUADOPERATIONSINALLSTAGES, value);
    }

    public static void npointClippingBehavior(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)POINTCLIPPINGBEHAVIOR, value);
    }

    public static void nmaxMultiviewViewCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXMULTIVIEWVIEWCOUNT, value);
    }

    public static void nmaxMultiviewInstanceIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXMULTIVIEWINSTANCEINDEX, value);
    }

    public static void nprotectedNoFault(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PROTECTEDNOFAULT, value);
    }

    public static void nmaxPerSetDescriptors(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSETDESCRIPTORS, value);
    }

    public static void nmaxMemoryAllocationSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXMEMORYALLOCATIONSIZE, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceVulkan11Properties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)POINTER_SIZE), VkPhysicalDeviceVulkan11Properties.__array((int)1, (int)16), VkPhysicalDeviceVulkan11Properties.__array((int)1, (int)16), VkPhysicalDeviceVulkan11Properties.__array((int)1, (int)8), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)4), VkPhysicalDeviceVulkan11Properties.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEUUID = layout.offsetof(2);
        DRIVERUUID = layout.offsetof(3);
        DEVICELUID = layout.offsetof(4);
        DEVICENODEMASK = layout.offsetof(5);
        DEVICELUIDVALID = layout.offsetof(6);
        SUBGROUPSIZE = layout.offsetof(7);
        SUBGROUPSUPPORTEDSTAGES = layout.offsetof(8);
        SUBGROUPSUPPORTEDOPERATIONS = layout.offsetof(9);
        SUBGROUPQUADOPERATIONSINALLSTAGES = layout.offsetof(10);
        POINTCLIPPINGBEHAVIOR = layout.offsetof(11);
        MAXMULTIVIEWVIEWCOUNT = layout.offsetof(12);
        MAXMULTIVIEWINSTANCEINDEX = layout.offsetof(13);
        PROTECTEDNOFAULT = layout.offsetof(14);
        MAXPERSETDESCRIPTORS = layout.offsetof(15);
        MAXMEMORYALLOCATIONSIZE = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceVulkan11Properties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceVulkan11Properties ELEMENT_FACTORY = VkPhysicalDeviceVulkan11Properties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceVulkan11Properties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceVulkan11Properties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceVulkan11Properties.npNext(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer deviceUUID() {
            return VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceUUID(int index) {
            return VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer driverUUID() {
            return VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte driverUUID(int index) {
            return VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_LUID_SIZE]")
        public ByteBuffer deviceLUID() {
            return VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceLUID(int index) {
            return VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int deviceNodeMask() {
            return VkPhysicalDeviceVulkan11Properties.ndeviceNodeMask(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean deviceLUIDValid() {
            return VkPhysicalDeviceVulkan11Properties.ndeviceLUIDValid(this.address()) != 0;
        }

        @NativeType(value="uint32_t")
        public int subgroupSize() {
            return VkPhysicalDeviceVulkan11Properties.nsubgroupSize(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int subgroupSupportedStages() {
            return VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedStages(this.address());
        }

        @NativeType(value="VkSubgroupFeatureFlags")
        public int subgroupSupportedOperations() {
            return VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedOperations(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean subgroupQuadOperationsInAllStages() {
            return VkPhysicalDeviceVulkan11Properties.nsubgroupQuadOperationsInAllStages(this.address()) != 0;
        }

        @NativeType(value="VkPointClippingBehavior")
        public int pointClippingBehavior() {
            return VkPhysicalDeviceVulkan11Properties.npointClippingBehavior(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxMultiviewViewCount() {
            return VkPhysicalDeviceVulkan11Properties.nmaxMultiviewViewCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxMultiviewInstanceIndex() {
            return VkPhysicalDeviceVulkan11Properties.nmaxMultiviewInstanceIndex(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean protectedNoFault() {
            return VkPhysicalDeviceVulkan11Properties.nprotectedNoFault(this.address()) != 0;
        }

        @NativeType(value="uint32_t")
        public int maxPerSetDescriptors() {
            return VkPhysicalDeviceVulkan11Properties.nmaxPerSetDescriptors(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxMemoryAllocationSize() {
            return VkPhysicalDeviceVulkan11Properties.nmaxMemoryAllocationSize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceVulkan11Properties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceVulkan11Properties.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address(), value);
            return this;
        }

        public Buffer deviceUUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPhysicalDeviceVulkan11Properties.ndeviceUUID(this.address(), index, value);
            return this;
        }

        public Buffer driverUUID(@NativeType(value="uint8_t[VK_UUID_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address(), value);
            return this;
        }

        public Buffer driverUUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPhysicalDeviceVulkan11Properties.ndriverUUID(this.address(), index, value);
            return this;
        }

        public Buffer deviceLUID(@NativeType(value="uint8_t[VK_LUID_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address(), value);
            return this;
        }

        public Buffer deviceLUID(int index, @NativeType(value="uint8_t") byte value) {
            VkPhysicalDeviceVulkan11Properties.ndeviceLUID(this.address(), index, value);
            return this;
        }

        public Buffer deviceNodeMask(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan11Properties.ndeviceNodeMask(this.address(), value);
            return this;
        }

        public Buffer deviceLUIDValid(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan11Properties.ndeviceLUIDValid(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer subgroupSize(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan11Properties.nsubgroupSize(this.address(), value);
            return this;
        }

        public Buffer subgroupSupportedStages(@NativeType(value="VkShaderStageFlags") int value) {
            VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedStages(this.address(), value);
            return this;
        }

        public Buffer subgroupSupportedOperations(@NativeType(value="VkSubgroupFeatureFlags") int value) {
            VkPhysicalDeviceVulkan11Properties.nsubgroupSupportedOperations(this.address(), value);
            return this;
        }

        public Buffer subgroupQuadOperationsInAllStages(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan11Properties.nsubgroupQuadOperationsInAllStages(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer pointClippingBehavior(@NativeType(value="VkPointClippingBehavior") int value) {
            VkPhysicalDeviceVulkan11Properties.npointClippingBehavior(this.address(), value);
            return this;
        }

        public Buffer maxMultiviewViewCount(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan11Properties.nmaxMultiviewViewCount(this.address(), value);
            return this;
        }

        public Buffer maxMultiviewInstanceIndex(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan11Properties.nmaxMultiviewInstanceIndex(this.address(), value);
            return this;
        }

        public Buffer protectedNoFault(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan11Properties.nprotectedNoFault(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer maxPerSetDescriptors(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan11Properties.nmaxPerSetDescriptors(this.address(), value);
            return this;
        }

        public Buffer maxMemoryAllocationSize(@NativeType(value="VkDeviceSize") long value) {
            VkPhysicalDeviceVulkan11Properties.nmaxMemoryAllocationSize(this.address(), value);
            return this;
        }
    }
}

