/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfATTDEF;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfENDBLK;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntityCollector;
import de.escape.quincunx.dxf.reader.DxfEntitySet;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;
import java.util.Enumeration;

public class DxfBLOCK
extends DxfEntity
implements DxfEntityCollector {
    protected String blockName;
    protected String typeName;
    protected String external;
    protected int type;
    protected Point3D refPoint = new Point3D();
    protected DxfEntitySet entitySet = new DxfEntitySet();
    protected DxfEntitySet attribSet;

    public DxfBLOCK() {
        this.color = 0;
    }

    public boolean setGroup(short grpNr, String str) {
        switch (grpNr) {
            case 1: {
                this.external = str;
                return true;
            }
            case 2: {
                this.blockName = str;
                return true;
            }
            case 3: {
                this.typeName = str;
                return true;
            }
        }
        return super.setGroup(grpNr, str);
    }

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 20: 
            case 30: {
                this.setCoord(this.refPoint, grpNr / 10, fval);
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        if (grpNr == 70) {
            this.type = ival;
            return true;
        }
        return super.setGroup(grpNr, ival);
    }

    public boolean isBlockNamed(String name) {
        return this.blockName != null && this.blockName.equals(name);
    }

    public boolean addEntity(DxfEntity entity) throws DxfException {
        if (entity instanceof DxfBLOCK) {
            throw new DxfException("err!Nested");
        }
        if (entity instanceof DxfENDBLK) {
            return false;
        }
        if (entity instanceof DxfATTDEF) {
            if (this.attribSet == null) {
                this.attribSet = new DxfEntitySet();
            }
            this.attribSet.addEntity(entity);
        } else {
            this.entitySet.addEntity(entity);
        }
        return true;
    }

    public DxfEntityCollector getEntityCollector() {
        return this;
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
        converter.convert(this, dxf, collector);
    }

    public final String getBlockName() {
        return this.blockName;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final String getExternal() {
        return this.external;
    }

    public final int getType() {
        return this.type;
    }

    public final Point3D getReferencePoint() {
        return this.refPoint;
    }

    public final DxfEntitySet getEntities() {
        return this.entitySet;
    }

    public DxfEntitySet getAttdefSet() {
        return this.attribSet;
    }

    public short getColor() {
        return 0;
    }

    public String toString() {
        return "BLOCK " + this.blockName;
    }

    public boolean finishRead(DxfFile file) {
        if (this.refPoint.z != 0.0f) {
            Enumeration e = this.entitySet.getEntities();
            while (e.hasMoreElements()) {
                ((DxfEntity)e.nextElement()).setExternalZ(this.refPoint.z);
            }
        }
        return super.finishRead(file);
    }
}

