/*
 * Decompiled with CFR 0.152.
 */
package training.ui.welcomeScreen;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.InteractiveCourseData;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.HeightLimitedPane;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.LearnIdeContentColorsAndFonts;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.LabelUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.FeaturesTrainerIcons;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.OpenLessonActivities;
import training.learn.course.IftModule;
import training.learn.course.KLesson;
import training.statistic.StatisticBase;
import training.ui.views.NewContentLabel;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Ltraining/ui/welcomeScreen/IFTInteractiveCourseData;", "Lcom/intellij/openapi/wm/InteractiveCourseData;", "()V", "findOnboardingLesson", "Ltraining/learn/course/KLesson;", "module", "Ltraining/learn/course/IftModule;", "getAction", "Ljavax/swing/Action;", "getActionButtonName", "", "getDescription", "getExpandContent", "Ljavax/swing/JComponent;", "getIcon", "Ljavax/swing/Icon;", "getName", "moduleDescription", "Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/HeightLimitedPane;", "moduleHasNewContent", "", "moduleHeader", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "newContentMarker", "openLearningFromWelcomeScreen", "", "intellij.featuresTrainer"})
final class IFTInteractiveCourseData
implements InteractiveCourseData {
    @NotNull
    public String getName() {
        return LearnBundle.INSTANCE.message("welcome.tab.header.learn.ide.features", new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return LearnBundle.INSTANCE.message("welcome.tab.description.learn.ide.features", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = FeaturesTrainerIcons.Img.PluginIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FeaturesTrainerIcons.Img.PluginIcon");
        return icon;
    }

    @NotNull
    public String getActionButtonName() {
        return LearnBundle.INSTANCE.message("welcome.tab.start.learning.button", new Object[0]);
    }

    @NotNull
    public Action getAction() {
        return new AbstractAction(this, LearnBundle.INSTANCE.message("welcome.tab.start.learning.button", new Object[0])){
            final /* synthetic */ IFTInteractiveCourseData this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                IFTInteractiveCourseData.access$openLearningFromWelcomeScreen(this.this$0, null);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public JComponent getExpandContent() {
        Collection<IftModule> modules = CourseManager.Companion.getInstance().getModules();
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(UtilsKt.rigid(16, 1));
        for (IftModule module : modules) {
            LinkLabel<Object> moduleHeader2 = this.moduleHeader(module);
            if (!this.moduleHasNewContent(module)) {
                panel.add((Component)moduleHeader2);
            } else {
                JPanel nameLine = new JPanel();
                nameLine.setOpaque(false);
                nameLine.setLayout(new BoxLayout(nameLine, 0));
                nameLine.setAlignmentX(0.0f);
                nameLine.add((Component)moduleHeader2);
                nameLine.add(UtilsKt.rigid(10, 0));
                nameLine.add(new NewContentLabel());
                panel.add(nameLine);
            }
            panel.add(UtilsKt.rigid(2, 2));
            panel.add((Component)this.moduleDescription(module));
            panel.add(UtilsKt.rigid(16, 16));
        }
        panel.add(UtilsKt.rigid(16, 15));
        StatisticBase.Companion.logWelcomeScreenPanelExpanded();
        return panel;
    }

    private final boolean moduleHasNewContent(IftModule module) {
        boolean bl;
        block4: {
            if (!UtilsKt.getIftPluginIsUsing()) {
                return false;
            }
            Iterable $this$any$iv = module.getLessons();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KLesson it = (KLesson)element$iv;
                    boolean bl2 = false;
                    if (!it.isNewLesson$intellij_featuresTrainer()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public JComponent newContentMarker() {
        boolean bl;
        block5: {
            if (UtilsKt.getLearningPanelWasOpenedInCurrentVersion()) {
                return null;
            }
            Iterable $this$any$iv = CourseManager.Companion.getInstance().getModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IftModule it = (IftModule)element$iv;
                    boolean bl2 = false;
                    if (!this.moduleHasNewContent(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return new NewContentLabel();
        }
        return null;
    }

    private final HeightLimitedPane moduleDescription(IftModule module) {
        return new HeightLimitedPane(module.getDescription(), -1, LearnIdeContentColorsAndFonts.INSTANCE.getModuleDescriptionColor(), false, null, 24, null);
    }

    private final LinkLabel<Object> moduleHeader(IftModule module) {
        LinkLabel<Object> linkLabel2 = new LinkLabel<Object>(module, module.getName(), null){
            final /* synthetic */ IftModule $module;

            public void setUI(@Nullable LabelUI ui) {
                super.setUI(ui);
                if (this.getFont() != null) {
                    Font font = this.getFont();
                    Font font2 = this.getFont();
                    Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
                    this.setFont(new FontUIResource(font.deriveFont(font2.getSize2D() + (float)JBUIScale.scale((int)-1) + (float)(SystemInfo.isWindows ? JBUIScale.scale((int)1) : 0))));
                }
            }
            {
                this.$module = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        linkLabel2.setName("linkLabel." + module.getName());
        linkLabel2.setListener(new LinkListener(this, module){
            final /* synthetic */ IFTInteractiveCourseData this$0;
            final /* synthetic */ IftModule $module;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                StatisticBase.Companion.logModuleStarted(this.$module);
                IFTInteractiveCourseData.access$openLearningFromWelcomeScreen(this.this$0, this.$module);
            }
            {
                this.this$0 = iFTInteractiveCourseData;
                this.$module = iftModule;
            }
        }, null);
        return (LinkLabel)linkLabel2;
    }

    private final void openLearningFromWelcomeScreen(IftModule module) {
        block0: {
            LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport2 == null) break block0;
            langSupport2.startFromWelcomeFrame((Function1<? super Sdk, Unit>)((Function1)new Function1<Sdk, Unit>(this, module){
                final /* synthetic */ IFTInteractiveCourseData this$0;
                final /* synthetic */ IftModule $module;

                public final void invoke(@Nullable Sdk selectedSdk) {
                    KLesson onboardingLesson = IFTInteractiveCourseData.access$findOnboardingLesson(this.this$0, this.$module);
                    if (onboardingLesson != null) {
                        OpenLessonActivities.INSTANCE.openOnboardingFromWelcomeScreen(onboardingLesson, selectedSdk);
                    } else {
                        CourseManager courseManager = CourseManager.Companion.getInstance();
                        IftModule iftModule = this.$module;
                        if (iftModule == null) {
                            iftModule = (IftModule)CollectionsKt.firstOrNull((Iterable)CourseManager.Companion.getInstance().getModules());
                        }
                        courseManager.setUnfoldModuleOnInit(iftModule);
                        OpenLessonActivities.INSTANCE.openLearnProjectFromWelcomeScreen(selectedSdk);
                    }
                }
                {
                    this.this$0 = iFTInteractiveCourseData;
                    this.$module = iftModule;
                    super(1);
                }
            }));
        }
    }

    private final KLesson findOnboardingLesson(IftModule module) {
        KLesson kLesson;
        KLesson firstLesson;
        Object object = module;
        KLesson kLesson2 = firstLesson = object != null && (object = ((IftModule)object).getLessons()) != null ? (KLesson)CollectionsKt.singleOrNull((List)object) : null;
        if (kLesson2 != null) {
            KLesson kLesson3 = kLesson2;
            boolean bl = false;
            boolean bl2 = false;
            KLesson it = kLesson3;
            boolean bl3 = false;
            kLesson = StringsKt.contains$default((CharSequence)it.getId(), (CharSequence)"onboarding", (boolean)false, (int)2, null) ? kLesson3 : null;
        } else {
            kLesson = null;
        }
        return kLesson;
    }

    public static final /* synthetic */ void access$openLearningFromWelcomeScreen(IFTInteractiveCourseData $this, IftModule module) {
        $this.openLearningFromWelcomeScreen(module);
    }

    public static final /* synthetic */ KLesson access$findOnboardingLesson(IFTInteractiveCourseData $this, IftModule module) {
        return $this.findOnboardingLesson(module);
    }
}

