/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.copyright;

import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/copyright/CopyrightManagerDocumentListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "()V", "isDocumentListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "newFilePaths", "", "", "kotlin.jvm.PlatformType", "", "addDocumentListener", "", "after", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "handleEvent", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.copyright"})
final class CopyrightManagerDocumentListener
implements BulkFileListener {
    private final Set<String> newFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isDocumentListenerAdded = new AtomicBoolean();

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
            this.newFilePaths.add(vFileEvent.getPath());
            if (!this.isDocumentListenerAdded.compareAndSet(false, true)) continue;
            this.addDocumentListener();
        }
    }

    private final void addDocumentListener() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ CopyrightManagerDocumentListener this$0;

            public void documentChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (CopyrightManagerDocumentListener.access$getNewFilePaths$p(this.this$0).isEmpty()) {
                    return;
                }
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(e.getDocument());
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026ile(e.document) ?: return");
                VirtualFile virtualFile2 = virtualFile;
                if (!CopyrightManagerDocumentListener.access$getNewFilePaths$p(this.this$0).remove(virtualFile2.getPath())) {
                    return;
                }
                boolean $i$f$serviceIfCreated = false;
                ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getServiceIfCreated(ProjectManager.class);
                if (projectManager == null) {
                    return;
                }
                ProjectManager projectManager2 = projectManager;
                Project[] projectArray = projectManager2.getOpenProjects();
                int n = projectArray.length;
                for (int i = 0; i < n; ++i) {
                    Project project;
                    Project project2 = project = projectArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    if (project2.isDisposed()) continue;
                    CopyrightManagerDocumentListener.access$handleEvent(this.this$0, virtualFile2, project);
                }
            }
            {
                this.this$0 = this$0;
            }
        }, (Disposable)FileTypeUtil.getInstance());
    }

    private final void handleEvent(VirtualFile virtualFile, Project project) {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Module module = projectRootManager.getFileIndex().getModuleForFile(virtualFile);
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ProjectRootManager.getIn\u2026le(virtualFile) ?: return");
        Module module2 = module;
        if (!FileTypeUtil.isSupportedFile(virtualFile) || PsiManager.getInstance((Project)project).findFile(virtualFile) == null) {
            return;
        }
        AppUIExecutor.onUiThread((ModalityState)ModalityState.NON_MODAL).later().withDocumentsCommitted(project).execute(new Runnable(project, virtualFile, module2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Module $module;

            public final void run() {
                block2: {
                    if (this.$project.isDisposed() || !this.$virtualFile.isValid()) {
                        return;
                    }
                    PsiFile file = PsiManager.getInstance((Project)this.$project).findFile(this.$virtualFile);
                    if (file == null || !file.isWritable()) break block2;
                    CopyrightProfile copyrightProfile = CopyrightManager.Companion.getInstance(this.$project).getCopyrightOptions(file);
                    if (copyrightProfile != null) {
                        CopyrightProfile copyrightProfile2 = copyrightProfile;
                        boolean bl = false;
                        boolean bl2 = false;
                        CopyrightProfile it = copyrightProfile2;
                        boolean bl3 = false;
                        new UpdateCopyrightProcessor(this.$project, this.$module, file).run();
                    }
                }
            }
            {
                this.$project = project;
                this.$virtualFile = virtualFile;
                this.$module = module;
            }
        });
    }

    public static final /* synthetic */ Set access$getNewFilePaths$p(CopyrightManagerDocumentListener $this) {
        return $this.newFilePaths;
    }

    public static final /* synthetic */ void access$handleEvent(CopyrightManagerDocumentListener $this, VirtualFile virtualFile, Project project) {
        $this.handleEvent(virtualFile, project);
    }
}

