/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.lists.hunspell;

import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.stemmer.snowball.SnowballStemmer;
import ai.grazie.spell.utils.Stemmer;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.TimeoutPolicy;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u001a0!j\b\u0012\u0004\u0012\u00020\u001a`\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010#\u001a\u00020\u001aR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList;", "Lai/grazie/spell/lists/WordListWithFrequency;", "Lai/grazie/spell/utils/Stemmer;", "affix", "Ljava/io/InputStream;", "dict", "policy", "Lorg/apache/lucene/analysis/hunspell/TimeoutPolicy;", "checkCanceled", "Ljava/lang/Runnable;", "(Ljava/io/InputStream;Ljava/io/InputStream;Lorg/apache/lucene/analysis/hunspell/TimeoutPolicy;Ljava/lang/Runnable;)V", "defaultFrequency", "", "getDefaultFrequency", "()I", "dictionary", "Lorg/apache/lucene/analysis/hunspell/Dictionary;", "hunspell", "Lorg/apache/lucene/analysis/hunspell/Hunspell;", "maxFrequency", "getMaxFrequency", "stemmer", "Lai/grazie/spell/stemmer/snowball/SnowballStemmer;", "contains", "", "word", "", "caseSensitive", "getFrequency", "(Ljava/lang/String;)Ljava/lang/Integer;", "language", "stem", "suggest", "Ljava/util/LinkedHashSet;", "Lai/grazie/spell/utils/LinkedSet;", "tryChars", "gec-spell-local-engine"})
public final class HunspellWordList
implements WordListWithFrequency,
Stemmer {
    private final SnowballStemmer stemmer;
    private final Dictionary dictionary;
    private final Hunspell hunspell;
    private final int maxFrequency;
    private final int defaultFrequency;

    @Nullable
    public final String language() {
        Field field = Dictionary.class.getDeclaredField("language");
        if (field.trySetAccessible()) {
            return (String)field.get(this.dictionary);
        }
        return null;
    }

    @NotNull
    public final String tryChars() {
        Field field = Dictionary.class.getDeclaredField("tryChars");
        if (field.trySetAccessible()) {
            Object object = field.get(this.dictionary);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return (String)object;
        }
        return "";
    }

    @Override
    public boolean contains(@NotNull String word, boolean caseSensitive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (caseSensitive) {
            bl = this.hunspell.spell(word);
        } else {
            String string = word;
            boolean bl2 = false;
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            bl = this.hunspell.spell(string2);
        }
        return bl;
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        List list = this.hunspell.suggest(word);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"hunspell.suggest(word)");
        return com.intellij.grazie.utils.CollectionsKt.toLinkedSet(list);
    }

    @Override
    @NotNull
    public String stem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        List list = this.hunspell.getRoots(word);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"hunspell.getRoots(word)");
        String string = (String)CollectionsKt.singleOrNull((List)list);
        if (string == null) {
            String string2 = this.stemmer.stem(word);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stemmer.stem(word)");
        }
        return string;
    }

    @Override
    public int getMaxFrequency() {
        return this.maxFrequency;
    }

    @Override
    public int getDefaultFrequency() {
        return this.defaultFrequency;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Integer getFrequency(@NotNull String word) {
        Integer result2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        List list = this.hunspell.getRoots(word);
        boolean bl = false;
        boolean bl2 = false;
        Iterable it = list;
        boolean bl3 = false;
        List list2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it");
        Collection collection = list2;
        boolean bl4 = false;
        List list3 = !collection.isEmpty() ? list : null;
        if (list3 == null) {
            return null;
        }
        List roots = list3;
        Iterable $this$map$iv = roots;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n;
            void it2;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            List list4 = this.dictionary.lookupEntries((String)it2).getMorphologicalValues(0, "fr:");
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"dictionary.lookupEntries\u2026hologicalValues(0, \"fr:\")");
            if ((String)CollectionsKt.getOrNull((List)list4, (int)0) != null) {
                String string2;
                boolean bl6 = false;
                n = Integer.parseInt(string2);
            } else {
                n = this.getDefaultFrequency();
            }
            Integer n2 = n;
            collection2.add(n2);
        }
        Integer n = result2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return n != null ? n.intValue() : this.getDefaultFrequency();
    }

    public HunspellWordList(@NotNull InputStream affix, @NotNull InputStream dict, @NotNull TimeoutPolicy policy, @NotNull Runnable checkCanceled) {
        Intrinsics.checkNotNullParameter((Object)affix, (String)"affix");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
        this.stemmer = new SnowballStemmer();
        this.dictionary = new Dictionary((Directory)new ByteBuffersDirectory(), "hunspell", affix, dict);
        this.hunspell = new Hunspell(this.dictionary, policy, checkCanceled);
        this.maxFrequency = 127;
    }

    public /* synthetic */ HunspellWordList(InputStream inputStream, InputStream inputStream2, TimeoutPolicy timeoutPolicy, Runnable runnable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            timeoutPolicy = TimeoutPolicy.RETURN_PARTIAL_RESULT;
        }
        if ((n & 8) != 0) {
            runnable = 1.INSTANCE;
        }
        this(inputStream, inputStream2, timeoutPolicy, runnable);
    }

    @Override
    public int getFrequencyOrDefault(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return WordListWithFrequency.DefaultImpls.getFrequencyOrDefault(this, word);
    }
}

