/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.GrazieConfig;
import com.intellij.pom.Navigatable;
import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Rule {
    private final String globalId;
    private final String presentableName;
    private final String category;

    public Rule(String globalId, String presentableName, String category) {
        this.globalId = globalId;
        this.presentableName = presentableName;
        this.category = category;
        if (!globalId.contains(".")) {
            throw new IllegalArgumentException("Global id should be a qualified name with at least one dot inside: " + this);
        }
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public String getPresentableName() {
        return this.presentableName;
    }

    @NotNull
    public abstract String getDescription();

    @NotNull
    public String getSearchableDescription() {
        String string = this.getDescription();
        if (string == null) {
            Rule.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public URL getUrl() {
        return null;
    }

    public final String getCategory() {
        return this.category;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public Navigatable editSettings() {
        return null;
    }

    public final boolean isCurrentlyEnabled() {
        return this.isEnabledInState(GrazieConfig.Companion.get());
    }

    public final boolean isEnabledInState(GrazieConfig.State state) {
        return this.isEnabledByDefault() ? !state.getUserDisabledRules().contains(this.globalId) : state.getUserEnabledRules().contains(this.globalId);
    }

    public final boolean equals(Object o) {
        return this == o || this.getClass().equals(o.getClass()) && this.globalId.equals(((Rule)o).globalId);
    }

    public final int hashCode() {
        return Objects.hash(this.globalId);
    }

    public String toString() {
        return this.presentableName + "(" + this.globalId + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/grazie/text/Rule", "getSearchableDescription"));
    }
}

