/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import net.jcip.annotations.Immutable;

@Immutable
public final class OptimalStringAlignment
implements StringDistance {
    @Override
    public double distance(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        int n = s1.length();
        int m = s2.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 2][m + 2];
        for (int i2 = 0; i2 <= n; ++i2) {
            d[i2][0] = i2;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (int i3 = 1; i3 <= n; ++i3) {
            for (int j = 1; j <= m; ++j) {
                int cost = 1;
                if (s1.charAt(i3 - 1) == s2.charAt(j - 1)) {
                    cost = 0;
                }
                d[i3][j] = OptimalStringAlignment.min(d[i3 - 1][j - 1] + cost, d[i3][j - 1] + 1, d[i3 - 1][j] + 1);
                if (i3 <= 1 || j <= 1 || s1.charAt(i3 - 1) != s2.charAt(j - 2) || s1.charAt(i3 - 2) != s2.charAt(j - 1)) continue;
                d[i3][j] = Math.min(d[i3][j], d[i3 - 2][j - 2] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a2, int b2, int c) {
        return Math.min(a2, Math.min(b2, c));
    }
}

