/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.SystemOfUnitsService;
import javax.measure.spi.UnitFormatService;

public abstract class ServiceProvider {
    private static final Object LOCK = new Object();
    private static volatile ServiceProvider[] providers;

    protected ServiceProvider() {
    }

    public int getPriority() {
        return 0;
    }

    public abstract SystemOfUnitsService getSystemOfUnitsService();

    public abstract UnitFormatService getUnitFormatService();

    public abstract <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(Class<Q> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceProvider[] getProviders() {
        ServiceProvider[] p2 = providers;
        if (p2 == null) {
            Object object = LOCK;
            synchronized (object) {
                p2 = providers;
                if (p2 == null) {
                    ArrayList<ServiceProvider> loaded = new ArrayList<ServiceProvider>();
                    for (ServiceProvider provider : ServiceLoader.load(ServiceProvider.class)) {
                        loaded.add(provider);
                    }
                    p2 = loaded.toArray(new ServiceProvider[loaded.size()]);
                    Arrays.sort(p2, new Comparator<ServiceProvider>(){

                        @Override
                        public int compare(ServiceProvider p1, ServiceProvider p2) {
                            return p2.getPriority() - p1.getPriority();
                        }
                    });
                    providers = p2;
                }
            }
        }
        return p2;
    }

    public static List<ServiceProvider> available() {
        return Arrays.asList(ServiceProvider.getProviders());
    }

    public static ServiceProvider current() {
        ServiceProvider[] p2 = ServiceProvider.getProviders();
        if (p2.length != 0) {
            return p2[0];
        }
        throw new IllegalStateException("No measurement ServiceProvider found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProvider setCurrent(ServiceProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        Object object = LOCK;
        synchronized (object) {
            ServiceProvider old;
            ServiceProvider[] p2 = ServiceProvider.getProviders();
            ServiceProvider serviceProvider = old = p2.length != 0 ? p2[0] : null;
            if (provider != old) {
                ArrayList<ServiceProvider> copy = new ArrayList<ServiceProvider>(Arrays.asList(p2));
                copy.remove(provider);
                copy.add(0, provider);
                providers = copy.toArray(new ServiceProvider[copy.size()]);
                Logger.getLogger("javax.measure.spi").log(Level.CONFIG, old == null ? "Measurement ServiceProvider set to {0}" : "Measurement ServiceProvider replaced by {0}", provider.getClass().getName());
            }
            return old;
        }
    }
}

