/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.builders;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntStack;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.fsa.builders.FSASerializer;
import morfologik.fsa.builders.FSAUtils;

public final class FSA5Serializer
implements FSASerializer {
    private static final int MAX_ARC_SIZE = 6;
    private static final int MAX_NODE_DATA_SIZE = 16;
    private static final int SIZEOF_FLAGS = 1;
    private static final EnumSet<FSAFlags> flags = EnumSet.of(FSAFlags.NUMBERS, FSAFlags.SEPARATORS, FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
    public byte fillerByte = (byte)95;
    public byte annotationByte = (byte)43;
    private boolean withNumbers;
    private IntIntHashMap offsets = new IntIntHashMap();
    private IntIntHashMap numbers = new IntIntHashMap();

    @Override
    public FSA5Serializer withNumbers() {
        this.withNumbers = true;
        return this;
    }

    @Override
    public FSA5Serializer withFiller(byte filler) {
        this.fillerByte = filler;
        return this;
    }

    @Override
    public FSA5Serializer withAnnotationSeparator(byte annotationSeparator) {
        this.annotationByte = annotationSeparator;
        return this;
    }

    @Override
    public <T extends OutputStream> T serialize(FSA fsa, T os) throws IOException {
        int[] linearized = this.linearize(fsa);
        int nodeDataLength = 0;
        if (this.withNumbers) {
            this.numbers = FSAUtils.rightLanguageForAllStates(fsa);
            for (int maxNumber = this.numbers.get(fsa.getRootNode()); maxNumber > 0; maxNumber >>>= 8) {
                ++nodeDataLength;
            }
        }
        int gtl = 1;
        while (true) {
            if (!this.emitArcs(fsa, null, linearized, gtl, nodeDataLength)) {
                ++gtl;
                continue;
            }
            if (this.emitArcs(fsa, null, linearized, gtl, nodeDataLength)) break;
            ++gtl;
        }
        FSAHeader.write(os, (byte)5);
        os.write(this.fillerByte);
        os.write(this.annotationByte);
        os.write(nodeDataLength << 4 | gtl);
        boolean gtlUnchanged = this.emitArcs(fsa, os, linearized, gtl, nodeDataLength);
        assert (gtlUnchanged) : "gtl changed in the final pass.";
        return os;
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return flags;
    }

    private int[] linearize(FSA fsa) {
        int[] linearized = new int[]{};
        int last = 0;
        BitSet visited = new BitSet();
        IntStack nodes = new IntStack();
        nodes.push(fsa.getRootNode());
        while (!nodes.isEmpty()) {
            int node = nodes.pop();
            if (visited.get(node)) continue;
            if (last >= linearized.length) {
                linearized = Arrays.copyOf(linearized, linearized.length + 100000);
            }
            visited.set(node);
            linearized[last++] = node;
            int arc = fsa.getFirstArc(node);
            while (arc != 0) {
                int target;
                if (!fsa.isArcTerminal(arc) && !visited.get(target = fsa.getEndNode(arc))) {
                    nodes.push(target);
                }
                arc = fsa.getNextArc(arc);
            }
        }
        return Arrays.copyOf(linearized, last);
    }

    private boolean emitArcs(FSA fsa, OutputStream os, int[] linearized, int gtl, int nodeDataLength) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(Math.max(16, 6));
        int offset = 0;
        offset += this.emitNodeData(bb, os, nodeDataLength, 0);
        offset += this.emitArc(bb, os, gtl, 0, (byte)0, 0);
        offset += this.emitNodeData(bb, os, nodeDataLength, 0);
        offset = fsa.getRootNode() != 0 ? (offset += this.emitArc(bb, os, gtl, 6, (byte)94, 0)) : (offset += this.emitArc(bb, os, gtl, 2, (byte)94, 0));
        int maxStates = linearized.length;
        for (int j = 0; j < maxStates; ++j) {
            int s = linearized[j];
            if (os == null) {
                this.offsets.put(s, offset);
            } else assert (this.offsets.get(s) == offset) : s + " " + this.offsets.get(s) + " " + offset;
            offset += this.emitNodeData(bb, os, nodeDataLength, this.withNumbers ? this.numbers.get(s) : 0);
            int arc = fsa.getFirstArc(s);
            while (arc != 0) {
                int bytes;
                int target;
                int targetOffset;
                if (fsa.isArcTerminal(arc)) {
                    targetOffset = 0;
                    target = 0;
                } else {
                    target = fsa.getEndNode(arc);
                    targetOffset = this.offsets.get(target);
                }
                int flags = 0;
                if (fsa.isArcFinal(arc)) {
                    flags |= 1;
                }
                if (fsa.getNextArc(arc) == 0) {
                    flags |= 2;
                    if (j + 1 < maxStates && target == linearized[j + 1] && targetOffset != 0) {
                        flags |= 4;
                        targetOffset = 0;
                    }
                }
                if ((bytes = this.emitArc(bb, os, gtl, flags, fsa.getArcLabel(arc), targetOffset)) < 0) {
                    return false;
                }
                offset += bytes;
                arc = fsa.getNextArc(arc);
            }
        }
        return true;
    }

    private int emitArc(ByteBuffer bb, OutputStream os, int gtl, int flags, byte label2, int targetOffset) throws IOException {
        int arcBytes = (flags & 4) != 0 ? 1 : gtl;
        flags |= targetOffset << 3;
        bb.put(label2);
        for (int b2 = 0; b2 < arcBytes; ++b2) {
            bb.put((byte)flags);
            flags >>>= 8;
        }
        if (flags != 0) {
            return -1;
        }
        bb.flip();
        int bytes = bb.remaining();
        if (os != null) {
            os.write(bb.array(), bb.position(), bb.remaining());
        }
        bb.clear();
        return bytes;
    }

    private int emitNodeData(ByteBuffer bb, OutputStream os, int nodeDataLength, int number) throws IOException {
        if (nodeDataLength > 0 && os != null) {
            for (int i2 = 0; i2 < nodeDataLength; ++i2) {
                bb.put((byte)number);
                number >>>= 8;
            }
            bb.flip();
            os.write(bb.array(), bb.position(), bb.remaining());
            bb.clear();
        }
        return nodeDataLength;
    }
}

