/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.loomchild.segment.AbstractTextIterator;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.RuleMatcher;
import net.loomchild.segment.srx.SrxDocument;

public class AccurateSrxTextIterator
extends AbstractTextIterator {
    private List<LanguageRule> languageRuleList;
    private CharSequence text;
    private String segment;
    private List<RuleMatcher> ruleMatcherList;
    private int startPosition;
    private int endPosition;

    public AccurateSrxTextIterator(SrxDocument document, String languageCode, CharSequence text2) {
        this.languageRuleList = document.getLanguageRuleList(languageCode);
        this.text = text2;
        this.segment = null;
        this.startPosition = 0;
        this.endPosition = 0;
        this.ruleMatcherList = new LinkedList<RuleMatcher>();
        for (LanguageRule languageRule : this.languageRuleList) {
            for (Rule rule : languageRule.getRuleList()) {
                RuleMatcher matcher = new RuleMatcher(document, rule, text2);
                this.ruleMatcherList.add(matcher);
            }
        }
    }

    public String next() {
        if (this.hasNext()) {
            if (this.segment == null) {
                this.initMatchers();
            }
            boolean found = false;
            while (this.ruleMatcherList.size() > 0 && !found) {
                RuleMatcher minMatcher = this.getMinMatcher();
                this.endPosition = minMatcher.getBreakPosition();
                if (minMatcher.getRule().isBreak() && this.endPosition > this.startPosition) {
                    found = true;
                    this.cutMatchers();
                }
                this.moveMatchers();
            }
            if (!found) {
                this.endPosition = this.text.length();
            }
            this.segment = this.text.subSequence(this.startPosition, this.endPosition).toString();
            this.startPosition = this.endPosition;
            return this.segment;
        }
        return null;
    }

    public boolean hasNext() {
        return this.startPosition < this.text.length();
    }

    private void initMatchers() {
        Iterator<RuleMatcher> i2 = this.ruleMatcherList.iterator();
        while (i2.hasNext()) {
            RuleMatcher matcher = i2.next();
            matcher.find();
            if (!matcher.hitEnd()) continue;
            i2.remove();
        }
    }

    private void moveMatchers() {
        Iterator<RuleMatcher> i2 = this.ruleMatcherList.iterator();
        block0: while (i2.hasNext()) {
            RuleMatcher matcher = i2.next();
            while (matcher.getBreakPosition() <= this.endPosition) {
                matcher.find();
                if (!matcher.hitEnd()) continue;
                i2.remove();
                continue block0;
            }
        }
    }

    private void cutMatchers() {
        Iterator<RuleMatcher> i2 = this.ruleMatcherList.iterator();
        while (i2.hasNext()) {
            RuleMatcher matcher = i2.next();
            if (matcher.getStartPosition() >= this.endPosition) continue;
            matcher.find(this.endPosition);
            if (!matcher.hitEnd()) continue;
            i2.remove();
        }
    }

    private RuleMatcher getMinMatcher() {
        int minPosition = Integer.MAX_VALUE;
        RuleMatcher minMatcher = null;
        for (RuleMatcher matcher : this.ruleMatcherList) {
            if (matcher.getBreakPosition() >= minPosition) continue;
            minPosition = matcher.getBreakPosition();
            minMatcher = matcher;
        }
        return minMatcher;
    }
}

