/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TestHackHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDateCheckFilter
extends RuleFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDateCheckFilter.class);
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d+).*");

    protected abstract int getDayOfWeek(String var1);

    protected abstract String getDayOfWeek(Calendar var1);

    protected int getDayOfMonth(String localizedDayOfMonth) {
        return 0;
    }

    protected abstract int getMonth(String var1);

    protected abstract Calendar getCalendar();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) {
        try {
            int dayOfWeekFromDate;
            int dayOfWeekFromString = this.getDayOfWeek(this.getRequired("weekDay", args).replace("\u00ad", ""));
            Calendar dateFromDate = this.getDate(args);
            try {
                dayOfWeekFromDate = dateFromDate.get(7);
            }
            catch (IllegalArgumentException ignore2) {
                return null;
            }
            if (dayOfWeekFromString != dayOfWeekFromDate) {
                Calendar calFromDateString = Calendar.getInstance();
                calFromDateString.set(7, dayOfWeekFromString);
                String message = match.getMessage().replace("{realDay}", this.getDayOfWeek(dateFromDate)).replace("{day}", this.getDayOfWeek(calFromDateString)).replace("{currentYear}", Integer.toString(Calendar.getInstance().get(1)));
                RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
                ruleMatch.setType(match.getType());
                return ruleMatch;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.warn("Skipping potential match for " + match.getRule().getFullId(), (Throwable)e);
            return null;
        }
    }

    private Calendar getDate(Map<String, String> args) {
        String yearArg = args.get("year");
        int year = yearArg == null && TestHackHelper.isJUnitTest() ? 2014 : (yearArg == null ? this.getCalendar().get(1) : Integer.parseInt(yearArg));
        int month = this.getMonthFromArguments(args);
        int dayOfMonth = this.getDayOfMonthFromArguments(args);
        Calendar calendar = this.getCalendar();
        calendar.setLenient(false);
        calendar.set(year, month, dayOfMonth, 0, 0, 0);
        return calendar;
    }

    private int getDayOfMonthFromArguments(Map<String, String> args) {
        String dayOfMonthString = this.getRequired("day", args);
        Matcher matcherDayOfMonth = DAY_OF_MONTH_PATTERN.matcher(dayOfMonthString);
        int dayOfMonth = matcherDayOfMonth.matches() ? Integer.parseInt(matcherDayOfMonth.group(1)) : this.getDayOfMonth(dayOfMonthString);
        return dayOfMonth;
    }

    private int getMonthFromArguments(Map<String, String> args) {
        String monthStr = this.getRequired("month", args);
        int month = StringUtils.isNumeric((CharSequence)monthStr) ? Integer.parseInt(monthStr) : this.getMonth(StringTools.trimSpecialCharacters(monthStr));
        return month - 1;
    }
}

