/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.patterns.IgnoreWhitespaceFilter;
import org.languagetool.rules.patterns.PatternRuleId;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class PatternRuleXmlCreator {
    /*
     * Enabled aggressive exception aggregation
     */
    public final String toXML(PatternRuleId ruleId, Language language) {
        List<String> filenames = language.getRuleFileNames();
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (String filename : filenames) {
            try {
                InputStream is = JLanguageTool.getDataBroker().getAsStream(filename);
                try {
                    Document doc = this.getDocument(is);
                    Node ruleNode = (Node)xpath.evaluate("/rules/category/rule[@id='" + ruleId.getId() + "']", doc, XPathConstants.NODE);
                    if (ruleNode != null) {
                        String string = this.nodeToString(ruleNode);
                        return string;
                    }
                    Node ruleNodeInGroup = (Node)xpath.evaluate("/rules/category/rulegroup/rule[@id='" + ruleId.getId() + "']", doc, XPathConstants.NODE);
                    if (ruleNodeInGroup != null) {
                        String string = this.nodeToString(ruleNodeInGroup);
                        return string;
                    }
                    if (ruleId.getSubId() != null) {
                        NodeList ruleGroupNodes = (NodeList)xpath.evaluate("/rules/category/rulegroup[@id='" + ruleId.getId() + "']/rule", doc, XPathConstants.NODESET);
                        if (ruleGroupNodes == null) continue;
                        for (int i2 = 0; i2 < ruleGroupNodes.getLength(); ++i2) {
                            if (!Integer.toString(i2 + 1).equals(ruleId.getSubId())) continue;
                            String string = this.nodeToString(ruleGroupNodes.item(i2));
                            return string;
                        }
                        continue;
                    }
                    Node ruleGroupNode = (Node)xpath.evaluate("/rules/category/rulegroup[@id='" + ruleId.getId() + "']", doc, XPathConstants.NODE);
                    if (ruleGroupNode == null) continue;
                    String string = this.nodeToString(ruleGroupNode);
                    return string;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not turn rule '" + ruleId + "' for language " + language + " into a string", e);
            }
        }
        throw new RuntimeException("Could not find rule '" + ruleId + "' for language " + language + " in files: " + filenames);
    }

    private Document getDocument(InputStream is) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSParser parser = impl.createLSParser((short)1, null);
        parser.setFilter(new IgnoreWhitespaceFilter());
        LSInput domInput = impl.createLSInput();
        domInput.setByteStream(is);
        return parser.parse(domInput);
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        String xml = sw.toString().replace("<token", "\n    <token").replace("<and", "\n    <and").replace("</and>", "\n    </and>").replace("<phraseref", "\n    <phraseref").replace("<antipattern", "\n  <antipattern").replace("<pattern", "\n  <pattern").replace("</pattern", "\n  </pattern").replace("</antipattern", "\n  </antipattern").replace("</rule>", "\n</rule>").replace("<filter", "\n  <filter").replace("<message", "\n  <message").replace("<short", "\n  <short").replace("<url", "\n  <url").replace("<example", "\n  <example").replace("</suggestion><suggestion>", "</suggestion>\n  <suggestion>").replace("</message><suggestion>", "</message>\n  <suggestion>");
        return xml;
    }
}

