/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.symspell.implementation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.rules.spelling.symspell.implementation.EditDistance;
import org.languagetool.rules.spelling.symspell.implementation.SuggestItem;
import org.languagetool.rules.spelling.symspell.implementation.SuggestionStage;

public class SymSpell
implements Serializable {
    private static int defaultMaxEditDistance = 2;
    private static int defaultPrefixLength = 7;
    private static int defaultCountThreshold = 1;
    private static int defaultInitialCapacity = 16;
    private static int defaultCompactLevel = 5;
    private int initialCapacity;
    private int maxDictionaryEditDistance;
    private int prefixLength;
    private long countThreshold;
    private int compactMask;
    private EditDistance.DistanceAlgorithm distanceAlgorithm = EditDistance.DistanceAlgorithm.Damerau;
    private int maxLength;
    private Map<Integer, String[]> deletes;
    private Map<String, Long> words;
    private Map<String, Long> belowThresholdWords = new HashMap<String, Long>();
    private static long N = 1024908267229L;

    public SymSpell(int initialCapacity, int maxDictionaryEditDistance, int prefixLength, int countThreshold) {
        if (initialCapacity < 0) {
            initialCapacity = defaultInitialCapacity;
        }
        if (maxDictionaryEditDistance < 0) {
            maxDictionaryEditDistance = defaultMaxEditDistance;
        }
        if (prefixLength < 1 || prefixLength <= maxDictionaryEditDistance) {
            prefixLength = defaultPrefixLength;
        }
        if (countThreshold < 0) {
            countThreshold = defaultCountThreshold;
        }
        this.initialCapacity = initialCapacity;
        this.words = new HashMap<String, Long>(initialCapacity);
        this.maxDictionaryEditDistance = maxDictionaryEditDistance;
        this.prefixLength = prefixLength;
        this.countThreshold = countThreshold;
        this.compactMask = -1 >> 3 + defaultCompactLevel << 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean createDictionaryEntry(String key, long count, SuggestionStage staging) {
        if (count <= 0L) {
            if (this.countThreshold > 0L) {
                return false;
            }
            count = 0L;
        }
        if (this.countThreshold > 1L && this.belowThresholdWords.containsKey(key)) {
            long countPrevious = this.belowThresholdWords.get(key);
            long l = count = Long.MAX_VALUE - countPrevious > count ? countPrevious + count : Long.MAX_VALUE;
            if (count < this.countThreshold) {
                this.belowThresholdWords.put(key, count);
                return false;
            }
            this.belowThresholdWords.remove(key);
        } else {
            if (this.words.containsKey(key)) {
                long countPrevious = this.words.get(key);
                count = Long.MAX_VALUE - countPrevious > count ? countPrevious + count : Long.MAX_VALUE;
                this.words.put(key, count);
                return false;
            }
            if (count < this.countThreshold) {
                this.belowThresholdWords.put(key, count);
                return false;
            }
        }
        this.words.put(key, count);
        if (key.equals("can't")) {
            System.out.println("Added to words..!");
        }
        if (key.length() > this.maxLength) {
            this.maxLength = key.length();
        }
        HashSet<String> edits = this.editsPrefix(key);
        if (staging != null) {
            edits.forEach(delete -> staging.add(this.getStringHash((String)delete), key));
            return true;
        }
        if (this.deletes == null) {
            this.deletes = new HashMap<Integer, String[]>(this.initialCapacity);
        }
        edits.forEach(delete -> {
            String[] suggestions;
            int deleteHash = this.getStringHash((String)delete);
            if (this.deletes.containsKey(deleteHash)) {
                suggestions = this.deletes.get(deleteHash);
                String[] newSuggestions = Arrays.copyOf(suggestions, suggestions.length + 1);
                this.deletes.put(deleteHash, newSuggestions);
                suggestions = newSuggestions;
            } else {
                suggestions = new String[1];
                this.deletes.put(deleteHash, suggestions);
            }
            suggestions[suggestions.length - 1] = key;
        });
        return true;
    }

    public boolean loadDictionary(String corpus, int termIndex, int countIndex) {
        File file2 = new File(corpus);
        if (!file2.exists()) {
            return false;
        }
        BufferedReader br2 = null;
        try {
            br2 = Files.newBufferedReader(Paths.get(corpus, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        if (br2 == null) {
            return false;
        }
        return this.loadDictionary(br2, termIndex, countIndex);
    }

    public boolean loadDictionary(InputStream corpus, int termIndex, int countIndex) {
        if (corpus == null) {
            return false;
        }
        BufferedReader br2 = new BufferedReader(new InputStreamReader(corpus, StandardCharsets.UTF_8));
        return this.loadDictionary(br2, termIndex, countIndex);
    }

    public boolean loadDictionary(BufferedReader br2, int termIndex, int countIndex) {
        if (br2 == null) {
            return false;
        }
        SuggestionStage staging = new SuggestionStage(16384);
        block4: while (true) {
            try {
                String line;
                while ((line = br2.readLine()) != null) {
                    String[] lineParts = line.split("\\s");
                    if (lineParts.length < 2) continue;
                    String key = lineParts[termIndex];
                    try {
                        long count = Long.parseLong(lineParts[countIndex]);
                        this.createDictionaryEntry(key, count, staging);
                        continue block4;
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(ex.getMessage());
                    }
                }
                break;
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
                break;
            }
        }
        if (this.deletes == null) {
            this.deletes = new HashMap<Integer, String[]>(staging.deleteCount());
        }
        this.commitStaged(staging);
        return true;
    }

    public boolean createDictionary(String corpus) {
        File file2 = new File(corpus);
        if (!file2.exists()) {
            return false;
        }
        SuggestionStage staging = new SuggestionStage(16384);
        try (BufferedReader br2 = Files.newBufferedReader(Paths.get(corpus, new String[0]));){
            String line;
            while ((line = br2.readLine()) != null) {
                Arrays.stream(this.parseWords(line)).forEach(key -> this.createDictionaryEntry((String)key, 1L, staging));
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        if (this.deletes == null) {
            this.deletes = new HashMap<Integer, String[]>(staging.deleteCount());
        }
        this.commitStaged(staging);
        return true;
    }

    public void purgeBelowThresholdWords() {
        this.belowThresholdWords = new HashMap<String, Long>();
    }

    public void commitStaged(SuggestionStage staging) {
        if (this.deletes == null) {
            this.deletes = new HashMap<Integer, String[]>(staging.deletes.size());
        }
        staging.commitTo(this.deletes);
    }

    public List<SuggestItem> lookup(String input2, Verbosity verbosity) {
        return this.lookup(input2, verbosity, this.maxDictionaryEditDistance);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<SuggestItem> lookup(String input2, Verbosity verbosity, int maxEditDistance) {
        long suggestionCount;
        if (maxEditDistance > this.maxDictionaryEditDistance) {
            throw new IllegalArgumentException("Dist to big: " + maxEditDistance);
        }
        ArrayList<SuggestItem> suggestions = new ArrayList<SuggestItem>();
        int inputLen = input2.length();
        if (inputLen - maxEditDistance > this.maxLength) {
            return suggestions;
        }
        HashSet<String> consideredDeletes = new HashSet<String>();
        HashSet<String> consideredSuggestions = new HashSet<String>();
        if (this.words.containsKey(input2)) {
            suggestionCount = this.words.get(input2);
            suggestions.add(new SuggestItem(input2, 0, suggestionCount));
            if (verbosity != Verbosity.All) {
                return suggestions;
            }
        }
        consideredSuggestions.add(input2);
        int maxEditDistance2 = maxEditDistance;
        int candidatePointer = 0;
        ArrayList<String> candidates = new ArrayList<String>();
        int inputPrefixLen = inputLen;
        if (inputPrefixLen > this.prefixLength) {
            inputPrefixLen = this.prefixLength;
            candidates.add(input2.substring(0, inputPrefixLen));
        } else {
            candidates.add(input2);
        }
        EditDistance distanceComparer = new EditDistance(input2, this.distanceAlgorithm);
        while (candidatePointer < candidates.size()) {
            String candidate;
            int candidateLen;
            int lengthDiff;
            if ((lengthDiff = inputPrefixLen - (candidateLen = (candidate = (String)candidates.get(candidatePointer++)).length())) > maxEditDistance2) {
                if (verbosity != Verbosity.All) break;
                continue;
            }
            if (this.deletes.containsKey(this.getStringHash(candidate))) {
                String[] dictSuggestions;
                block5: for (String suggestion : dictSuggestions = this.deletes.get(this.getStringHash(candidate))) {
                    int distance;
                    int suggPrefixLen;
                    int suggestionLen;
                    if (suggestion.equals(input2) || Math.abs((suggestionLen = suggestion.length()) - inputLen) > maxEditDistance2 || suggestionLen < candidateLen || suggestionLen == candidateLen && !suggestion.equals(candidate) || (suggPrefixLen = Math.min(suggestionLen, this.prefixLength)) > inputPrefixLen && suggPrefixLen - candidateLen > maxEditDistance2) continue;
                    int min = 0;
                    if (candidateLen == 0) {
                        distance = Math.max(inputLen, suggestionLen);
                        if (distance > maxEditDistance2 || !consideredSuggestions.add(suggestion)) {
                            continue;
                        }
                    } else if (suggestionLen != 1 ? this.prefixLength - maxEditDistance == candidateLen && (min = Math.min(inputLen, suggestionLen) - this.prefixLength) > 1 && !input2.substring(inputLen + 1 - min).equals(suggestion.substring(suggestionLen + 1 - min)) || min > 0 && input2.charAt(inputLen - min) != suggestion.charAt(suggestionLen - min) && (input2.charAt(inputLen - min - 1) != suggestion.charAt(suggestionLen - min) || input2.charAt(inputLen - min) != suggestion.charAt(suggestionLen - min - 1)) || verbosity != Verbosity.All && !this.deleteInSuggestionPrefix(candidate, candidateLen, suggestion, suggestionLen) || !consideredSuggestions.add(suggestion) || (distance = distanceComparer.compare(suggestion, maxEditDistance2)) < 0 : (distance = input2.indexOf(suggestion.charAt(0)) < 0 ? inputLen : inputLen - 1) > maxEditDistance2 || !consideredSuggestions.add(suggestion)) continue;
                    if (distance > maxEditDistance2) continue;
                    suggestionCount = this.words.get(suggestion);
                    SuggestItem si = new SuggestItem(suggestion, distance, suggestionCount);
                    if (suggestions.size() > 0) {
                        switch (verbosity) {
                            case Closest: {
                                if (distance >= maxEditDistance2) break;
                                suggestions.clear();
                                break;
                            }
                            case Top: {
                                if (distance >= maxEditDistance2 && suggestionCount <= ((SuggestItem)suggestions.get((int)0)).count) continue block5;
                                maxEditDistance2 = distance;
                                suggestions.set(0, si);
                                continue block5;
                            }
                        }
                    }
                    if (verbosity != Verbosity.All) {
                        maxEditDistance2 = distance;
                    }
                    suggestions.add(si);
                }
            }
            if (lengthDiff >= maxEditDistance || candidateLen > this.prefixLength || verbosity != Verbosity.All && lengthDiff >= maxEditDistance2) continue;
            for (int i2 = 0; i2 < candidateLen; ++i2) {
                StringBuilder sb = new StringBuilder(candidate);
                sb.deleteCharAt(i2);
                String delete = sb.toString();
                if (!consideredDeletes.add(delete)) continue;
                candidates.add(delete);
            }
        }
        if (suggestions.size() > 1) {
            Collections.sort(suggestions);
        }
        return suggestions;
    }

    public List<SuggestItem> lookupCompound(String input2, int maxEditDistance) {
        EditDistance editDistance;
        if (maxEditDistance > this.maxDictionaryEditDistance) {
            throw new IllegalArgumentException("Dist to big " + maxEditDistance);
        }
        String[] termList1 = this.parseWords(input2);
        ArrayList<SuggestItem> suggestionParts = new ArrayList<SuggestItem>();
        boolean lastCombi = false;
        for (int i2 = 0; i2 < termList1.length; ++i2) {
            List<SuggestItem> suggestionsCombi;
            List<SuggestItem> suggestions = this.lookup(termList1[i2], Verbosity.Top, maxEditDistance);
            if (i2 > 0 && !lastCombi && !(suggestionsCombi = this.lookup(termList1[i2 - 1] + termList1[i2], Verbosity.Top, maxEditDistance)).isEmpty()) {
                SuggestItem best1 = (SuggestItem)suggestionParts.get(suggestionParts.size() - 1);
                SuggestItem best2 = !suggestions.isEmpty() ? suggestions.get(0) : new SuggestItem(termList1[i2], maxEditDistance + 1, 0L);
                editDistance = new EditDistance(termList1[i2 - 1] + " " + termList1[i2], EditDistance.DistanceAlgorithm.Damerau);
                if (suggestionsCombi.get((int)0).distance + 1 < editDistance.DamerauLevenshteinDistance(best1.term + " " + best2.term, maxEditDistance)) {
                    ++suggestionsCombi.get((int)0).distance;
                    suggestionParts.set(suggestionParts.size() - 1, suggestionsCombi.get(0));
                    lastCombi = true;
                    continue;
                }
            }
            lastCombi = false;
            if (!(suggestions.isEmpty() || suggestions.get((int)0).distance != 0 && termList1[i2].length() != 1)) {
                suggestionParts.add(suggestions.get(0));
                continue;
            }
            ArrayList<SuggestItem> suggestionsSplit = new ArrayList<SuggestItem>();
            if (!suggestions.isEmpty()) {
                suggestionsSplit.add(suggestions.get(0));
            }
            if (termList1[i2].length() > 1) {
                for (int j = 1; j < termList1[i2].length(); ++j) {
                    List<SuggestItem> suggestions2;
                    String part1 = termList1[i2].substring(0, j);
                    String part2 = termList1[i2].substring(j);
                    List<SuggestItem> suggestions1 = this.lookup(part1, Verbosity.Top, maxEditDistance);
                    if (suggestions1.isEmpty() || !suggestions.isEmpty() && suggestions.get(0).equals(suggestions1.get(0)) || (suggestions2 = this.lookup(part2, Verbosity.Top, maxEditDistance)).isEmpty() || !suggestions.isEmpty() && suggestions.get(0).equals(suggestions2.get(0))) continue;
                    String split = suggestions1.get((int)0).term + " " + suggestions2.get((int)0).term;
                    editDistance = new EditDistance(termList1[i2], EditDistance.DistanceAlgorithm.Damerau);
                    SuggestItem suggestionSplit = new SuggestItem(split, editDistance.DamerauLevenshteinDistance(split, maxEditDistance), Math.min(suggestions1.get((int)0).count, suggestions2.get((int)0).count));
                    if (suggestionSplit.distance >= 0) {
                        suggestionsSplit.add(suggestionSplit);
                    }
                    if (suggestionSplit.distance == 1) break;
                }
                if (!suggestionsSplit.isEmpty()) {
                    Collections.sort(suggestionsSplit);
                    suggestionParts.add((SuggestItem)suggestionsSplit.get(0));
                    continue;
                }
                SuggestItem si = new SuggestItem(termList1[i2], 0, maxEditDistance + 1);
                suggestionParts.add(si);
                continue;
            }
            SuggestItem si = new SuggestItem(termList1[i2], 0, maxEditDistance + 1);
            suggestionParts.add(si);
        }
        SuggestItem suggestion = new SuggestItem("", Integer.MAX_VALUE, Long.MAX_VALUE);
        StringBuilder s = new StringBuilder();
        for (SuggestItem si : suggestionParts) {
            s.append(si.term).append(' ');
            suggestion.count = Math.min(suggestion.count, si.count);
        }
        suggestion.term = s.toString().replaceAll("\\s+$", "");
        editDistance = new EditDistance(suggestion.term, EditDistance.DistanceAlgorithm.Damerau);
        suggestion.distance = editDistance.DamerauLevenshteinDistance(input2, this.maxDictionaryEditDistance);
        ArrayList<SuggestItem> suggestionsLine = new ArrayList<SuggestItem>();
        suggestionsLine.add(suggestion);
        return suggestionsLine;
    }

    public List<SuggestItem> lookupCompound(String input2) {
        return this.lookupCompound(input2, this.maxDictionaryEditDistance);
    }

    private boolean deleteInSuggestionPrefix(String delete, int deleteLen, String suggestion, int suggestionLen) {
        if (deleteLen == 0) {
            return true;
        }
        if (this.prefixLength < suggestionLen) {
            suggestionLen = this.prefixLength;
        }
        int j = 0;
        for (int i2 = 0; i2 < deleteLen; ++i2) {
            char delChar = delete.charAt(i2);
            while (j < suggestionLen && delChar != suggestion.charAt(j)) {
                ++j;
            }
            if (j != suggestionLen) continue;
            return false;
        }
        return true;
    }

    private String[] parseWords(String text2) {
        Pattern pattern = Pattern.compile("['\u2019\\p{L}-[_]]+");
        Matcher match = pattern.matcher(text2.toLowerCase());
        ArrayList<String> matches = new ArrayList<String>();
        while (match.find()) {
            matches.add(match.group());
        }
        String[] toreturn = new String[matches.size()];
        matches.toArray(toreturn);
        return toreturn;
    }

    private HashSet<String> edits(String word, int editDistance, HashSet<String> deleteWords) {
        ++editDistance;
        if (word.length() > 1) {
            for (int i2 = 0; i2 < word.length(); ++i2) {
                StringBuilder sb = new StringBuilder(word);
                sb.deleteCharAt(i2);
                String delete = sb.toString();
                if (!deleteWords.add(delete) || editDistance >= this.maxDictionaryEditDistance) continue;
                this.edits(delete, editDistance, deleteWords);
            }
        }
        return deleteWords;
    }

    private HashSet<String> editsPrefix(String key) {
        HashSet<String> hashSet = new HashSet<String>();
        if (key.length() <= this.maxDictionaryEditDistance) {
            hashSet.add("");
        }
        if (key.length() > this.prefixLength) {
            key = key.substring(0, this.prefixLength);
        }
        hashSet.add(key);
        return this.edits(key, 0, hashSet);
    }

    private int getStringHash(String s) {
        int len = s.length();
        int lenMask = len;
        if (lenMask > 3) {
            lenMask = 3;
        }
        long hash = 2166136261L;
        for (int i2 = 0; i2 < len; ++i2) {
            hash ^= (long)s.charAt(i2);
            hash *= 16777619L;
        }
        hash &= (long)this.compactMask;
        return (int)(hash |= (long)lenMask);
    }

    public SegmentedSuggestion wordSegmentation(String input2) {
        return this.wordSegmentation(input2, this.maxDictionaryEditDistance, this.maxLength);
    }

    public SegmentedSuggestion wordSegmentation(String input2, int maxEditDistance) {
        return this.wordSegmentation(input2, maxEditDistance, this.maxLength);
    }

    public SegmentedSuggestion wordSegmentation(String input2, int maxEditDistance, int maxSegmentationWordLength) {
        if (input2.isEmpty()) {
            return new SegmentedSuggestion();
        }
        int arraySize = Math.min(maxSegmentationWordLength, input2.length());
        SegmentedSuggestion[] compositions = new SegmentedSuggestion[arraySize];
        for (int i2 = 0; i2 < arraySize; ++i2) {
            compositions[i2] = new SegmentedSuggestion();
        }
        int circularIndex = -1;
        for (int j = 0; j < input2.length(); ++j) {
            int imax = Math.min(input2.length() - j, maxSegmentationWordLength);
            for (int i3 = 1; i3 <= imax; ++i3) {
                double topProbabilityLog;
                String topResult;
                String part = input2.substring(j, j + i3);
                int separatorLength = 0;
                int topEd = 0;
                if (Character.isWhitespace(part.charAt(0))) {
                    part = part.substring(1);
                } else {
                    separatorLength = 1;
                }
                topEd += part.length();
                part = part.replace(" ", "");
                topEd -= part.length();
                List<SuggestItem> results = this.lookup(part, Verbosity.Top, maxEditDistance);
                if (results.size() > 0) {
                    topResult = results.get((int)0).term;
                    topEd += results.get((int)0).distance;
                    topProbabilityLog = Math.log10((double)results.get((int)0).count / (double)N);
                } else {
                    topResult = part;
                    topEd += part.length();
                    topProbabilityLog = Math.log10(10.0 / ((double)N * Math.pow(10.0, part.length())));
                }
                int destinationIndex = (i3 + circularIndex) % arraySize;
                if (j == 0) {
                    compositions[destinationIndex].segmentedString = part;
                    compositions[destinationIndex].correctedString = topResult;
                    compositions[destinationIndex].distanceSum = topEd;
                    compositions[destinationIndex].probabilityLogSum = topProbabilityLog;
                    continue;
                }
                if (i3 != maxSegmentationWordLength && (compositions[circularIndex].distanceSum + topEd != compositions[destinationIndex].distanceSum && compositions[circularIndex].distanceSum + separatorLength + topEd != compositions[destinationIndex].distanceSum || !(compositions[destinationIndex].probabilityLogSum < compositions[circularIndex].probabilityLogSum + topProbabilityLog)) && compositions[circularIndex].distanceSum + separatorLength + topEd >= compositions[destinationIndex].distanceSum) continue;
                compositions[destinationIndex].segmentedString = compositions[circularIndex].segmentedString + " " + part;
                compositions[destinationIndex].correctedString = compositions[circularIndex].correctedString + " " + topResult;
                compositions[destinationIndex].distanceSum = compositions[circularIndex].distanceSum + topEd;
                compositions[destinationIndex].probabilityLogSum = compositions[circularIndex].probabilityLogSum + topProbabilityLog;
            }
            if (++circularIndex < arraySize) continue;
            circularIndex = 0;
        }
        return compositions[circularIndex];
    }

    class SegmentedSuggestion {
        String segmentedString = "";
        String correctedString = "";
        int distanceSum = 0;
        double probabilityLogSum = 0.0;

        SegmentedSuggestion() {
        }
    }

    public static enum Verbosity {
        Top,
        Closest,
        All;

    }
}

