/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.SrxTextIterator;
import net.loomchild.segment.srx.io.Srx2SaxParser;
import org.languagetool.JLanguageTool;

final class SrxTools {
    private SrxTools() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static SrxDocument createSrxDocument(String path) {
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);){
            SrxDocument srxDocument;
            try (BufferedReader srxReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                HashMap<String, Object> parserParameters = new HashMap<String, Object>();
                parserParameters.put("validate", true);
                Srx2SaxParser srxParser = new Srx2SaxParser(parserParameters);
                srxDocument = srxParser.parse(srxReader);
            }
            return srxDocument;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load SRX rules", e);
        }
    }

    static List<String> tokenize(String text2, SrxDocument srxDocument, String code2) {
        ArrayList<String> segments = new ArrayList<String>();
        SrxTextIterator textIterator = new SrxTextIterator(srxDocument, code2, text2);
        while (textIterator.hasNext()) {
            segments.add(textIterator.next());
        }
        return segments;
    }
}

