/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.unit.Prefix;

public final class PowersOfIntConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3546932001671571300L;
    private final int base;
    private final int exponent;
    private final int hashCode;
    private final double doubleFactor;

    public static PowersOfIntConverter of(Prefix prefix) {
        return new PowersOfIntConverter(prefix.getBase(), prefix.getExponent());
    }

    public static PowersOfIntConverter of(int base2, int exponent) {
        return new PowersOfIntConverter(base2, exponent);
    }

    protected PowersOfIntConverter(int base2, int exponent) {
        if (base2 == 0) {
            throw new IllegalArgumentException("base cannot be zero (because 0^0 is undefined)");
        }
        this.base = base2;
        this.exponent = exponent;
        this.doubleFactor = Math.pow(base2, exponent);
        this.hashCode = Objects.hash(base2, exponent);
    }

    public int getBase() {
        return this.base;
    }

    public int getExponent() {
        return this.exponent;
    }

    @Override
    public boolean isIdentity() {
        if (this.base == 1) {
            return true;
        }
        return this.exponent == 0;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        if (that instanceof PowersOfIntConverter) {
            return ((PowersOfIntConverter)that).base == this.base;
        }
        return that instanceof RationalConverter;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        if (that instanceof PowersOfIntConverter) {
            PowersOfIntConverter other = (PowersOfIntConverter)that;
            if (this.base == other.base) {
                return this.composeSameBaseNonIdentity(other);
            }
        }
        if (that instanceof RationalConverter) {
            return (AbstractConverter)this.toRationalConverter().concatenate((RationalConverter)that);
        }
        throw new IllegalStateException(String.format("%s.simpleCompose() not handled for converter %s", this, that));
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new PowersOfIntConverter(this.base, -this.exponent);
    }

    @Override
    protected Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
        BigInteger bintFactor = BigInteger.valueOf(this.base).pow(Math.abs(this.exponent));
        if (this.exponent > 0) {
            return bintFactor.multiply(value);
        }
        BigInteger[] divideAndRemainder = value.divideAndRemainder(bintFactor);
        BigInteger divisionResult = divideAndRemainder[0];
        BigInteger divisionRemainder = divideAndRemainder[1];
        if (BigInteger.ZERO.compareTo(divisionRemainder) == 0) {
            return divisionResult;
        }
        BigDecimal bdecFactor = new BigDecimal(bintFactor);
        BigDecimal bdecValue = new BigDecimal(value);
        return bdecValue.divide(bdecFactor, Calculus.MATH_CONTEXT);
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        BigDecimal bdecFactor = new BigDecimal(BigInteger.valueOf(this.base).pow(Math.abs(this.exponent)));
        BigDecimal bdecValue = value;
        return this.exponent > 0 ? bdecValue.multiply(bdecFactor, ctx) : bdecValue.divide(bdecFactor, ctx);
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value * this.doubleFactor;
    }

    @Override
    public boolean equals(Object obj) {
        UnitConverter other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnitConverter) {
            other = (UnitConverter)obj;
            if (this.isIdentity() && other.isIdentity()) {
                return true;
            }
        }
        if (obj instanceof PowersOfIntConverter) {
            other = (PowersOfIntConverter)obj;
            return this.base == ((PowersOfIntConverter)other).base && this.exponent == ((PowersOfIntConverter)other).exponent;
        }
        return false;
    }

    @Override
    public final String transformationLiteral() {
        if (this.base < 0) {
            return String.format("x -> x * (%s)^%s", this.base, this.exponent);
        }
        return String.format("x -> x * %s^%s", this.base, this.exponent);
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (this.isIdentity() && o.isIdentity()) {
            return 0;
        }
        if (o instanceof PowersOfIntConverter) {
            PowersOfIntConverter other = (PowersOfIntConverter)o;
            int c = Integer.compare(this.base, other.base);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.exponent, other.exponent);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private PowersOfIntConverter composeSameBaseNonIdentity(PowersOfIntConverter other) {
        return new PowersOfIntConverter(this.base, this.exponent + other.exponent);
    }

    public RationalConverter toRationalConverter() {
        return this.exponent > 0 ? new RationalConverter(BigInteger.valueOf(this.base).pow(this.exponent), BigInteger.ONE) : new RationalConverter(BigInteger.ONE, BigInteger.valueOf(this.base).pow(-this.exponent));
    }
}

