/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.NumberQuantity;

final class IntegerQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = 1405915111744728289L;
    final int value;

    public IntegerQuantity(int value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result2 = this.doubleValue(unit);
        if (result2 < -9.223372036854776E18 || result2 > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result2 + ")");
        }
        return (long)result2;
    }

    private boolean isOverflowing(double value) {
        return value > 2.147483647E9;
    }

    private ComparableQuantity<Q> addRaw(Number a2, Number b2, Unit<Q> unit) {
        return NumberQuantity.of(a2.intValue() + b2.intValue(), unit);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        Quantity<Q> thatConverted = that.to(this.getUnit());
        Quantity thisConverted = this.to((Unit)that.getUnit());
        double resultValueInThisUnit = this.getValue().doubleValue() + thatConverted.getValue().doubleValue();
        double resultValueInThatUnit = thisConverted.getValue().doubleValue() + that.getValue().doubleValue();
        ComparableQuantity resultInThisUnit = this.addRaw(this.getValue(), thatConverted.getValue(), this.getUnit());
        ComparableQuantity<Q> resultInThatUnit = this.addRaw(thisConverted.getValue(), that.getValue(), that.getUnit());
        if (this.isOverflowing(resultValueInThisUnit)) {
            if (this.isOverflowing(resultValueInThatUnit)) {
                throw new ArithmeticException();
            }
            return resultInThatUnit;
        }
        if (this.isOverflowing(resultValueInThatUnit)) {
            return resultInThisUnit;
        }
        if (this.hasFraction(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        AbstractQuantity<Q> thatNegated = NumberQuantity.of(-that.getValue().intValue(), that.getUnit());
        return this.add((Quantity)thatNegated);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new IntegerQuantity(this.value * that.getValue().intValue(), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.intValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return NumberQuantity.of((double)this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1 / this.value, this.getUnit().inverse());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return NumberQuantity.of((double)this.value / that.doubleValue(), this.getUnit());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) throws ArithmeticException {
        return null;
    }
}

