/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.awt.Component;
import java.awt.Point;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifierKt;
import org.jetbrains.idea.svn.auth.SvnInteractiveAuthenticationProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.InfoClient;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 -2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0002,-B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0015\u0010 \u001a\u00070\u001b\u00a2\u0006\u0002\b!2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\b\u0010+\u001a\u00020\u001dH\u0002RN\u0010\b\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0002\b\u0003 \n*\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier;", "Lcom/intellij/openapi/vcs/impl/GenericNotifierImpl;", "Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$AuthenticationRequest;", "Lorg/jetbrains/idea/svn/api/Url;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myCopiesPassiveResults", "", "kotlin.jvm.PlatformType", "", "", "myTimer", "Ljava/util/concurrent/ScheduledFuture;", "myVerificationInProgress", "rootsToWorkingCopies", "Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "getRootsToWorkingCopies", "()Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "getVcs", "()Lorg/jetbrains/idea/svn/SvnVcs;", "ask", "obj", "description", "", "dispose", "", "ensureNotify", "getKey", "getNotificationContent", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "getWcUrl", "isAuthenticatedFor", "Lcom/intellij/util/ThreeState;", "vf", "Lcom/intellij/openapi/vfs/VirtualFile;", "factory", "Lorg/jetbrains/idea/svn/api/ClientFactory;", "onFirstNotification", "onStateChangedToSuccess", "showAlreadyChecking", "AuthenticationRequest", "Companion", "intellij.vcs.svn"})
public final class SvnAuthenticationNotifier
extends GenericNotifierImpl<AuthenticationRequest, Url>
implements Disposable {
    private final Map<Url, Boolean> myCopiesPassiveResults;
    private final ScheduledFuture<?> myTimer;
    private volatile boolean myVerificationInProgress;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final SvnVcs getVcs() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)svnVcs), (String)"SvnVcs.getInstance(myProject)");
        return svnVcs;
    }

    private final RootsToWorkingCopies getRootsToWorkingCopies() {
        return RootsToWorkingCopies.Companion.getInstance(this.myProject);
    }

    public void dispose() {
        this.myTimer.cancel(false);
    }

    protected boolean ask(@NotNull AuthenticationRequest obj, @Nullable String description) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (this.myVerificationInProgress) {
            this.showAlreadyChecking();
            return false;
        }
        this.myVerificationInProgress = true;
        Ref resultRef = new Ref();
        Function0 checker2 = (Function0)new Function0<Unit>(this, obj, resultRef){
            final /* synthetic */ SvnAuthenticationNotifier this$0;
            final /* synthetic */ AuthenticationRequest $obj;
            final /* synthetic */ Ref $resultRef;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    boolean result = SvnAuthenticationNotifier.Companion.interactiveValidation(this.$obj.getMyProject(), this.$obj.getUrl(), this.$obj.getRealm(), this.$obj.getKind());
                    SvnAuthenticationNotifierKt.access$getLOG$p().debug("ask result for: " + this.$obj.getUrl() + " is: " + result);
                    this.$resultRef.set((Object)result);
                    if (result) {
                        SvnAuthenticationNotifier.access$onStateChangedToSuccess(this.this$0, this.$obj);
                    }
                }
                finally {
                    SvnAuthenticationNotifier.access$setMyVerificationInProgress$p(this.this$0, false);
                }
            }
            {
                this.this$0 = svnAuthenticationNotifier;
                this.$obj = authenticationRequest;
                this.$resultRef = ref;
                super(0);
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        if (application.isReadAccessAllowed() || !ProgressManager.getInstance().hasProgressIndicator()) {
            Function0 function0 = checker2;
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            });
            bl = false;
        } else {
            checker2.invoke();
            Object object = resultRef.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resultRef.get()");
            bl = (Boolean)object;
        }
        return bl;
    }

    private final void showAlreadyChecking() {
        JComponent component;
        IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(this.myProject);
        if (ideFrame == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ideFrame, (String)"WindowManagerEx.getInsta\u2026eFor(myProject) ?: return");
        IdeFrame frameFor = ideFrame;
        JComponent jComponent = component = frameFor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
        Point point = jComponent.getMousePosition();
        if (point == null) {
            point = new Point((int)((double)component.getWidth() * 0.7), 0);
        }
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(SvnBundle.message("popup.content.already.checking", new Object[0]), MessageType.WARNING, null).createBalloon().show(new RelativePoint(point2), Balloon.Position.below);
    }

    private final void onStateChangedToSuccess(AuthenticationRequest obj) {
        Map<Url, Boolean> map = this.myCopiesPassiveResults;
        Intrinsics.checkNotNullExpressionValue(map, (String)"myCopiesPassiveResults");
        map.put(this.getKey(obj), true);
        this.getVcs().invokeRefreshSvnRoots();
        boolean bl = false;
        List outdatedRequests = new ArrayList();
        for (Url key : this.getAllCurrentKeys()) {
            Url commonAncestor = key.commonAncestorWith(obj.getUrl());
            if (commonAncestor == null || StringUtil.isEmptyOrSpaces((String)commonAncestor.getHost()) || StringUtil.isEmptyOrSpaces((String)commonAncestor.getPath())) continue;
            outdatedRequests.add(key);
        }
        SvnAuthenticationNotifierKt.access$getLOG$p().debug("on state changed ");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, outdatedRequests){
            final /* synthetic */ SvnAuthenticationNotifier this$0;
            final /* synthetic */ List $outdatedRequests;

            public final void run() {
                Iterable $this$forEach$iv = this.$outdatedRequests;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Url it = (Url)element$iv;
                    boolean bl = false;
                    this.this$0.removeLazyNotificationByKey(it);
                }
            }
            {
                this.this$0 = svnAuthenticationNotifier;
                this.$outdatedRequests = list;
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean ensureNotify(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.myCopiesPassiveResults.remove(this.getKey(obj));
        return super.ensureNotify((Object)obj);
    }

    protected boolean onFirstNotification(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return ProgressManager.getInstance().hasProgressIndicator() && this.ask(obj, null);
    }

    @NotNull
    protected Url getKey(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Url url = obj.getWcUrl();
        Intrinsics.checkNotNull((Object)url);
        return url;
    }

    @Nullable
    public final Url getWcUrl(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj.isOutsideCopies()) {
            return null;
        }
        if (obj.getWcUrl() != null) {
            return obj.getWcUrl();
        }
        WorkingCopy copy = this.getRootsToWorkingCopies().getMatchingCopy(obj.getUrl());
        if (copy != null) {
            obj.setOutsideCopies(false);
            obj.setWcUrl(copy.getUrl());
        } else {
            obj.setOutsideCopies(true);
        }
        WorkingCopy workingCopy = copy;
        return workingCopy != null ? workingCopy.getUrl() : null;
    }

    @NotNull
    public final ThreeState isAuthenticatedFor(@NotNull VirtualFile vf, @Nullable ClientFactory factory) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        WorkingCopy workingCopy = this.getRootsToWorkingCopies().getWcRoot(vf);
        if (workingCopy == null) {
            return ThreeState.UNSURE;
        }
        WorkingCopy wcCopy = workingCopy;
        boolean haveCancellation = this.getStateFor(wcCopy.getUrl());
        if (haveCancellation) {
            return ThreeState.NO;
        }
        Boolean keptResult = this.myCopiesPassiveResults.get(wcCopy.getUrl());
        if (Intrinsics.areEqual((Object)Boolean.TRUE, (Object)keptResult)) {
            return ThreeState.YES;
        }
        if (Intrinsics.areEqual((Object)Boolean.FALSE, (Object)keptResult)) {
            return ThreeState.NO;
        }
        boolean calculatedResult = factory == null ? Companion.passiveValidation(this.getVcs(), wcCopy.getUrl()) : SvnAuthenticationNotifier.Companion.passiveValidation(factory, wcCopy.getUrl());
        Map<Url, Boolean> map = this.myCopiesPassiveResults;
        Intrinsics.checkNotNullExpressionValue(map, (String)"myCopiesPassiveResults");
        map.put(wcCopy.getUrl(), calculatedResult);
        ThreeState threeState = ThreeState.fromBoolean((boolean)calculatedResult);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"ThreeState.fromBoolean(calculatedResult)");
        return threeState;
    }

    @NotNull
    protected String getNotificationContent(@NotNull AuthenticationRequest obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String string = HtmlChunk.link((String)"", (String)SvnBundle.message("notification.action.click.to.fix", new Object[0])).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"link(\"\", message(\"notifi\u2026lick.to.fix\")).toString()");
        String action = string;
        String string2 = SvnBundle.message("notification.content.not.logged.into.subversion", obj.getRealm(), obj.getUrl().toDecodedString());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"notification.co\u2026bj.url.toDecodedString())");
        String content = string2;
        return action + ' ' + content;
    }

    public SvnAuthenticationNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = SvnBundle.message("notification.title.not.logged.into.subversion", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"notification.ti\u2026.logged.into.subversion\")");
        super(project, "Subversion", string, NotificationType.ERROR);
        boolean bl = false;
        this.myCopiesPassiveResults = Collections.synchronizedMap(new LinkedHashMap());
        this.myTimer = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ SvnAuthenticationNotifier this$0;

            public final void run() {
                SvnAuthenticationNotifier.access$getMyCopiesPassiveResults$p(this.this$0).clear();
            }
            {
                this.this$0 = svnAuthenticationNotifier;
            }
        }, 10L, 600L, TimeUnit.SECONDS);
    }

    public static final /* synthetic */ void access$onStateChangedToSuccess(SvnAuthenticationNotifier $this, AuthenticationRequest obj) {
        $this.onStateChangedToSuccess(obj);
    }

    public static final /* synthetic */ boolean access$getMyVerificationInProgress$p(SvnAuthenticationNotifier $this) {
        return $this.myVerificationInProgress;
    }

    public static final /* synthetic */ void access$setMyVerificationInProgress$p(SvnAuthenticationNotifier $this, boolean bl) {
        $this.myVerificationInProgress = bl;
    }

    public static final /* synthetic */ Map access$getMyCopiesPassiveResults$p(SvnAuthenticationNotifier $this) {
        return $this.myCopiesPassiveResults;
    }

    @JvmStatic
    @NotNull
    public static final SvnAuthenticationNotifier getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final boolean passiveValidation(@NotNull SvnVcs vcs, @NotNull Url url) {
        return Companion.passiveValidation(vcs, url);
    }

    @JvmStatic
    public static final void clearAuthenticationCache(@NotNull Project project, @Nullable Component component, @Nullable String configDirPath) {
        Companion.clearAuthenticationCache(project, component, configDirPath);
    }

    @JvmStatic
    public static final void clearAuthenticationDirectory(@NotNull SvnConfiguration configuration) {
        Companion.clearAuthenticationDirectory(configuration);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$AuthenticationRequest;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "kind", "", "url", "Lorg/jetbrains/idea/svn/api/Url;", "realm", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lorg/jetbrains/idea/svn/api/Url;Ljava/lang/String;)V", "isOutsideCopies", "", "()Z", "setOutsideCopies", "(Z)V", "getKind", "()Ljava/lang/String;", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getRealm", "getUrl", "()Lorg/jetbrains/idea/svn/api/Url;", "wcUrl", "getWcUrl", "setWcUrl", "(Lorg/jetbrains/idea/svn/api/Url;)V", "intellij.vcs.svn"})
    public static final class AuthenticationRequest {
        @Nullable
        private Url wcUrl;
        private boolean isOutsideCopies;
        @NotNull
        private final Project myProject;
        @NotNull
        private final String kind;
        @NotNull
        private final Url url;
        @NotNull
        private final String realm;

        @Nullable
        public final Url getWcUrl() {
            return this.wcUrl;
        }

        public final void setWcUrl(@Nullable Url url) {
            this.wcUrl = url;
        }

        public final boolean isOutsideCopies() {
            return this.isOutsideCopies;
        }

        public final void setOutsideCopies(boolean bl) {
            this.isOutsideCopies = bl;
        }

        @NotNull
        public final Project getMyProject() {
            return this.myProject;
        }

        @NotNull
        public final String getKind() {
            return this.kind;
        }

        @NotNull
        public final Url getUrl() {
            return this.url;
        }

        @NotNull
        public final String getRealm() {
            return this.realm;
        }

        public AuthenticationRequest(@NotNull Project myProject, @NotNull String kind, @NotNull Url url, @NotNull String realm) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
            this.myProject = myProject;
            this.kind = kind;
            this.url = url;
            this.realm = realm;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JL\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\u0011H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier$Companion;", "", "()V", "clearAuthenticationCache", "", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljava/awt/Component;", "configDirPath", "", "clearAuthenticationDirectory", "configuration", "Lorg/jetbrains/idea/svn/SvnConfiguration;", "getInstance", "Lorg/jetbrains/idea/svn/auth/SvnAuthenticationNotifier;", "interactiveValidation", "", "url", "Lorg/jetbrains/idea/svn/api/Url;", "realm", "kind", "passiveValidation", "vcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "factory", "Lorg/jetbrains/idea/svn/api/ClientFactory;", "showAuthenticationFailedWithHotFixes", "e", "Lorg/jetbrains/idea/svn/commandLine/SvnBindException;", "validationImpl", "manager", "Lorg/jetbrains/idea/svn/auth/SvnAuthenticationManager;", "checkWrite", "interactive", "intellij.vcs.svn"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SvnAuthenticationNotifier getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(SvnAuthenticationNotifier.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (SvnAuthenticationNotifier)((Object)object);
        }

        private final boolean passiveValidation(ClientFactory factory, Url url) {
            boolean bl;
            try {
                bl = factory.create(InfoClient.class, false).doInfo(Target.Companion.on$default(Target.Companion, url, null, 2, null), Revision.UNDEFINED) != null;
            }
            catch (SvnBindException ignore) {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        public final boolean passiveValidation(@NotNull SvnVcs vcs, @NotNull Url url) {
            Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            SvnConfiguration svnConfiguration = vcs.getSvnConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)svnConfiguration, (String)"vcs.svnConfiguration");
            SvnConfiguration configuration = svnConfiguration;
            SvnAuthenticationManager passiveManager = configuration.getPassiveAuthenticationManager(vcs);
            Project project = vcs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"vcs.project");
            SvnAuthenticationManager svnAuthenticationManager = passiveManager;
            Intrinsics.checkNotNullExpressionValue((Object)svnAuthenticationManager, (String)"passiveManager");
            return this.validationImpl(project, url, configuration, svnAuthenticationManager, false, null, null, false);
        }

        public final boolean interactiveValidation(@NotNull Project project, @NotNull Url url, @NotNull String realm, @NotNull String kind) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            SvnConfiguration configuration = SvnConfiguration.getInstance(project);
            SvnAuthenticationManager passiveManager = configuration.getInteractiveManager(SvnVcs.getInstance(project));
            SvnConfiguration svnConfiguration = configuration;
            Intrinsics.checkNotNullExpressionValue((Object)svnConfiguration, (String)"configuration");
            SvnAuthenticationManager svnAuthenticationManager = passiveManager;
            Intrinsics.checkNotNullExpressionValue((Object)svnAuthenticationManager, (String)"passiveManager");
            return this.validationImpl(project, url, svnConfiguration, svnAuthenticationManager, true, realm, kind, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean validationImpl(Project project, Url url, SvnConfiguration configuration, SvnAuthenticationManager manager, boolean checkWrite, String realm, String kind, boolean interactive) {
            Proxy proxyToRelease = null;
            if (!interactive && configuration.isUseDefaultProxy()) {
                HttpConfigurable instance = HttpConfigurable.getInstance();
                if (instance.USE_HTTP_PROXY && instance.PROXY_AUTHENTICATION) {
                    HttpConfigurable httpConfigurable = instance;
                    Intrinsics.checkNotNullExpressionValue((Object)httpConfigurable, (String)"instance");
                    if (StringUtil.isEmptyOrSpaces((String)httpConfigurable.getProxyLogin()) || StringUtil.isEmptyOrSpaces((String)instance.getPlainProxyPassword())) {
                        return false;
                    }
                }
                if (instance.USE_PROXY_PAC) {
                    List list;
                    try {
                        list = CommonProxy.getInstance().select(new URI(url.toString()));
                    }
                    catch (URISyntaxException e) {
                        SvnAuthenticationNotifierKt.access$getLOG$p().info("wrong URL: " + url);
                        return false;
                    }
                    List list2 = list;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"try {\n            Common\u2026 return false\n          }");
                    List select = list2;
                    for (Proxy proxy : select) {
                        if (!HttpConfigurable.isRealProxy((Proxy)proxy) || Proxy.Type.HTTP != proxy.type()) continue;
                        SocketAddress socketAddress = proxy.address();
                        if (socketAddress == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                        }
                        InetSocketAddress address = (InetSocketAddress)socketAddress;
                        PasswordAuthentication password = HttpConfigurable.getInstance().getGenericPassword(address.getHostString(), address.getPort());
                        if (password != null) continue;
                        CommonProxy.getInstance().noAuthentication("http", address.getHostString(), address.getPort());
                        proxyToRelease = proxy;
                    }
                }
            }
            SvnInteractiveAuthenticationProvider.clearCallState();
            Target target = Target.Companion.on$default(Target.Companion, url, null, 2, null);
            try {
                SvnVcs.getInstance(project).getFactory(target).create(InfoClient.class, interactive).doInfo(target, Revision.HEAD);
            }
            catch (ProcessCanceledException e) {
                boolean proxy = false;
                return proxy;
            }
            catch (SvnBindException e) {
                if (SvnUtil.isAuthError(e)) {
                    SvnAuthenticationNotifierKt.access$getLOG$p().debug((Throwable)((Object)e));
                    boolean proxy = false;
                    return proxy;
                }
                SvnAuthenticationNotifierKt.access$getLOG$p().info("some other exc", (Throwable)((Object)e));
                if (interactive) {
                    this.showAuthenticationFailedWithHotFixes(project, configuration, e);
                }
                boolean proxy = false;
                return proxy;
            }
            finally {
                if (!interactive && configuration.isUseDefaultProxy() && proxyToRelease != null) {
                    SocketAddress socketAddress = proxyToRelease.address();
                    if (socketAddress == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                    }
                    InetSocketAddress address = (InetSocketAddress)socketAddress;
                    CommonProxy.getInstance().noAuthentication("http", address.getHostString(), address.getPort());
                }
            }
            if (!checkWrite) {
                return true;
            }
            if (SvnInteractiveAuthenticationProvider.wasCalled() && SvnInteractiveAuthenticationProvider.wasCancelled()) {
                return false;
            }
            if (SvnInteractiveAuthenticationProvider.wasCalled()) {
                return true;
            }
            SvnVcs svnVcs = SvnVcs.getInstance(project);
            SvnInteractiveAuthenticationProvider provider = new SvnInteractiveAuthenticationProvider(svnVcs, manager);
            AuthenticationData svnAuthentication = provider.requestClientAuthentication(kind, url, realm, true);
            if (svnAuthentication != null) {
                String string = kind;
                Intrinsics.checkNotNull((Object)string);
                String string2 = realm;
                Intrinsics.checkNotNull((Object)string2);
                configuration.acknowledge(string, string2, svnAuthentication);
                configuration.getAuthenticationManager(svnVcs).acknowledgeAuthentication(kind, url, realm, svnAuthentication);
                return true;
            }
            return false;
        }

        private final void showAuthenticationFailedWithHotFixes(Project project, SvnConfiguration configuration, SvnBindException e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(project, e, configuration){
                final /* synthetic */ Project $project;
                final /* synthetic */ SvnBindException $e;
                final /* synthetic */ SvnConfiguration $configuration;

                public final void run() {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)this.$project, (String)SvnBundle.message("notification.content.authentication.failed", this.$e.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[]{new NamedRunnable(this, SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0])){
                        final /* synthetic */ showAuthenticationFailedWithHotFixes.1 this$0;

                        public void run() {
                            SvnAuthenticationNotifier.Companion.clearAuthenticationCache(this.this$0.$project, null, this.this$0.$configuration.getConfigurationDirectory());
                        }
                        {
                            this.this$0 = this$0;
                            super($super_call_param$1);
                        }
                    }, new NamedRunnable(this, SvnBundle.message("action.title.select.configuration.directory", new Object[0])){
                        final /* synthetic */ showAuthenticationFailedWithHotFixes.1 this$0;

                        public void run() {
                            SvnConfigurable.selectConfigurationDirectory(this.this$0.$configuration.getConfigurationDirectory(), (Consumer<? super String>)new Consumer(this){
                                final /* synthetic */ showAuthenticationFailedWithHotFixes.2 this$0;

                                public final void consume(String it) {
                                    this.this$0.this$0.$configuration.setConfigurationDirParameters(false, it);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, this.this$0.$project, null);
                        }
                        {
                            this.this$0 = this$0;
                            super($super_call_param$1);
                        }
                    }});
                }
                {
                    this.$project = project;
                    this.$e = svnBindException;
                    this.$configuration = svnConfiguration;
                }
            }, ModalityState.NON_MODAL, project.getDisposed());
        }

        @JvmStatic
        public final void clearAuthenticationCache(@NotNull Project project, @Nullable Component component, @Nullable String configDirPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (configDirPath != null) {
                int result;
                int n = result = component == null ? Messages.showYesNoDialog((Project)project, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon()) : Messages.showYesNoDialog((Component)component, (String)SvnBundle.message("confirmation.text.delete.stored.authentication.information", new Object[0]), (String)SvnBundle.message("confirmation.title.clear.authentication.cache", new Object[0]), (Icon)Messages.getWarningIcon());
                if (result == 0) {
                    SvnConfiguration.RUNTIME_AUTH_CACHE.clear();
                    SvnConfiguration svnConfiguration = SvnConfiguration.getInstance(project);
                    Intrinsics.checkNotNullExpressionValue((Object)svnConfiguration, (String)"SvnConfiguration.getInstance(project)");
                    this.clearAuthenticationDirectory(svnConfiguration);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        public final void clearAuthenticationDirectory(@NotNull SvnConfiguration configuration) {
            Path authDir;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Path path = authDir = Paths.get(configuration.getConfigurationDirectory(), "auth");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"authDir");
            if (!PathKt.exists((Path)path)) return;
            Function0 process2 = (Function0)new Function0<Unit>(authDir){
                final /* synthetic */ Path $authDir;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ProgressIndicator ind;
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = ind = progressManager.getProgressIndicator();
                    if (progressIndicator != null) {
                        progressIndicator.setIndeterminate(true);
                    }
                    ProgressIndicator progressIndicator2 = ind;
                    if (progressIndicator2 != null) {
                        progressIndicator2.setText(SvnBundle.message("progress.text.clearing.stored.credentials", this.$authDir));
                    }
                    Path path = this.$authDir;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"authDir");
                    Path path2 = path;
                    Function1 filter$iv = clearAuthenticationDirectory.process.1.INSTANCE;
                    boolean $i$f$directoryStreamIfExists = false;
                    try {
                        void $this$directoryStreamIfExists$iv;
                        Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, new DirectoryStream.Filter(filter$iv){
                            final /* synthetic */ Function1 $filter;
                            {
                                this.$filter = function1;
                            }

                            public final boolean accept(Path it) {
                                Path path = it;
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                                return (Boolean)this.$filter.invoke((Object)path);
                            }
                        });
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            DirectoryStream it = (DirectoryStream)closeable;
                            boolean bl3 = false;
                            for (Path dir : it) {
                                ProgressIndicator progressIndicator3 = ind;
                                if (progressIndicator3 != null) {
                                    progressIndicator3.setText(SvnBundle.message("progress.text.deleting", dir));
                                }
                                Path path3 = dir;
                                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dir");
                                PathKt.delete$default((Path)path3, (boolean)false, (int)1, null);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                }
                {
                    this.$authDir = path;
                    super(0);
                }
            };
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
            if (!application.isUnitTestMode()) {
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"getApplication()");
                if (application2.isDispatchThread()) {
                    Function0 function0 = process2;
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new /* invalid duplicate definition of identical inner class */, SvnBundle.message("progress.title.clear.authentication.cache", new Object[0]), false, configuration.getProject());
                    return;
                }
            }
            process2.invoke();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

