/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.features;

import com.intellij.filePrediction.features.history.FileHistoryManagerWrapper;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereFileFeaturesProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.internal.statistic.local.FileTypeUsageSummary;
import com.intellij.internal.statistic.local.FileTypeUsageSummaryProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\b\u0000\u0018\u0000 32\u00020\u0001:\u000223B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J>\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0016J4\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001bH\u0002J8\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\n2\b\b\u0002\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\bH\u0002J!\u0010(\u001a\u0004\u0018\u00010%2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010)J;\u0010*\u001a\u00020+\"\u0004\b\u0000\u0010,\"\u0004\b\u0001\u0010-*\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u0002H-0.2\u0006\u0010/\u001a\u0002H,2\b\u00100\u001a\u0004\u0018\u0001H-H\u0002\u00a2\u0006\u0002\u00101\u00a8\u00064"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider;", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereElementFeaturesProvider;", "()V", "calculatePackageDistance", "Lkotlin/Pair;", "", "", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "openedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "deepCopyFileTypeStats", "", "", "Lcom/intellij/internal/statistic/local/FileTypeUsageSummary;", "project", "Lcom/intellij/openapi/project/Project;", "getDataToCache", "", "getElementFeatures", "element", "currentTime", "", "queryLength", "elementPriority", "cache", "getFeatures", "Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider$Cache;", "getFileTypeStats", "fileTypeStats", "getModificationTimeStats", "getPredictionScore", "getRecentFilesIndex", "getVirtualFileDirectory", "file", "maxChecksUp", "isElementSupported", "", "isFavorite", "isOpened", "isSameModuleAsOpenedFile", "(Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "putIfValueNotNull", "", "K", "V", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "Cache", "Companion", "intellij.searchEverywhereMl"})
public final class SearchEverywhereFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    @NotNull
    public static final String IS_DIRECTORY_DATA_KEY = "isDirectory";
    @NotNull
    public static final String FILETYPE_DATA_KEY = "fileType";
    @NotNull
    public static final String IS_FAVORITE_DATA_KEY = "isFavorite";
    @NotNull
    public static final String IS_OPENED_DATA_KEY = "isOpened";
    @NotNull
    public static final String RECENT_INDEX_DATA_KEY = "recentFilesIndex";
    @NotNull
    public static final String PREDICTION_SCORE_DATA_KEY = "predictionScore";
    @NotNull
    public static final String PRIORITY_DATA_KEY = "priority";
    @NotNull
    public static final String IS_SAME_MODULE_DATA_KEY = "isSameModule";
    @NotNull
    public static final String PACKAGE_DISTANCE_DATA_KEY = "packageDistance";
    @NotNull
    public static final String PACKAGE_DISTANCE_NORMALIZED_DATA_KEY = "packageDistanceNorm";
    @NotNull
    public static final String FILETYPE_USAGE_RATIO_DATA_KEY = "fileTypeUsageRatio";
    @NotNull
    public static final String FILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY = "fileTypeUsageRatioToMax";
    @NotNull
    public static final String FILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY = "fileTypeUsageRatioToMin";
    @NotNull
    public static final String TIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY = "timeSinceLastFileTypeUsage";
    @NotNull
    public static final String FILETYPE_USED_IN_LAST_MINUTE_DATA_KEY = "fileTypeUsedInLastMinute";
    @NotNull
    public static final String FILETYPE_USED_IN_LAST_HOUR_DATA_KEY = "fileTypeUsedInLastHour";
    @NotNull
    public static final String FILETYPE_USED_IN_LAST_DAY_DATA_KEY = "fileTypeUsedInLastDay";
    @NotNull
    public static final String FILETYPE_USED_IN_LAST_MONTH_DATA_KEY = "fileTypeUsedInLastMonth";
    @NotNull
    public static final String TIME_SINCE_LAST_MODIFICATION_DATA_KEY = "timeSinceLastModification";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY = "wasModifiedInLastMinute";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY = "wasModifiedInLastHour";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_DAY_DATA_KEY = "wasModifiedInLastDay";
    @NotNull
    public static final String WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY = "wasModifiedInLastMonth";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Object getDataToCache(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        FileEditor fileEditor = fileEditorManager.getSelectedEditor();
        VirtualFile openedFile = fileEditor != null ? fileEditor.getFile() : null;
        return new Cache(this.deepCopyFileTypeStats(project), openedFile);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, FileTypeUsageSummary> deepCopyFileTypeStats(Project project) {
        void $this$mapValuesTo$iv$iv;
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(FileTypeUsageSummaryProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        FileTypeUsageSummaryProvider service = (FileTypeUsageSummaryProvider)object;
        Map $this$mapValues$iv = service.getFileTypeStats();
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            FileTypeUsageSummary fileTypeUsageSummary = new FileTypeUsageSummary(((FileTypeUsageSummary)it.getValue()).usageCount, ((FileTypeUsageSummary)it.getValue()).lastUsed);
            map3.put(k2, fileTypeUsageSummary);
        }
        Map statsCopy = destination$iv$iv;
        return statsCopy;
    }

    @Override
    public boolean isElementSupported(@NotNull Object element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element;
        if (object instanceof PsiFileSystemItem) {
            bl = ((PsiFileSystemItem)element).getVirtualFile() != null;
        } else if (object instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
            PsiElement psiElement = ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)element).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.item");
            bl = this.isElementSupported(psiElement);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Map<String, Object> getElementFeatures(@NotNull Object element, long currentTime, int queryLength, int elementPriority, @Nullable Object cache) {
        PsiFileSystemItem psiFileSystemItem;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element;
        if (object instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
            PsiElement psiElement = ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)element).getItem();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFileSystemItem");
            }
            psiFileSystemItem = (PsiFileSystemItem)psiElement;
        } else if (object instanceof PsiFileSystemItem) {
            psiFileSystemItem = (PsiFileSystemItem)element;
        } else {
            return MapsKt.emptyMap();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        Object object2 = cache;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.actions.searcheverywhere.ml.features.SearchEverywhereFileFeaturesProvider.Cache");
        }
        Cache fileTypeStats = (Cache)object2;
        return this.getFeatures(item, currentTime, elementPriority, fileTypeStats);
    }

    private final Map<String, Object> getFeatures(PsiFileSystemItem item, long currentTime, int elementPriority, Cache cache) {
        HashMap data = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)IS_FAVORITE_DATA_KEY, (Object)this.isFavorite(item)), TuplesKt.to((Object)IS_DIRECTORY_DATA_KEY, (Object)item.isDirectory()), TuplesKt.to((Object)PRIORITY_DATA_KEY, (Object)elementPriority)});
        Pair<Integer, Double> pair = this.calculatePackageDistance(item, cache.getOpenedFile());
        if (pair != null) {
            Pair<Integer, Double> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<Integer, Double> it = pair2;
            boolean bl3 = false;
            ((Map)data).put(PACKAGE_DISTANCE_DATA_KEY, it.getFirst());
            ((Map)data).put(PACKAGE_DISTANCE_NORMALIZED_DATA_KEY, it.getSecond());
        }
        this.putIfValueNotNull(data, IS_SAME_MODULE_DATA_KEY, this.isSameModuleAsOpenedFile(item, cache.getOpenedFile()));
        if (item.isDirectory()) {
            return data;
        }
        ((Map)data).put(IS_OPENED_DATA_KEY, this.isOpened(item));
        Map map = data;
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        FileType fileType = virtualFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"item.virtualFile.fileType");
        String string = fileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.virtualFile.fileType.name");
        map.put(FILETYPE_DATA_KEY, string);
        ((Map)data).put(RECENT_INDEX_DATA_KEY, this.getRecentFilesIndex(item));
        ((Map)data).put(PREDICTION_SCORE_DATA_KEY, this.getPredictionScore(item));
        data.putAll(this.getModificationTimeStats(item, currentTime));
        data.putAll(this.getFileTypeStats(item, currentTime, cache.getFileTypeStats()));
        return data;
    }

    private final boolean isFavorite(PsiFileSystemItem item) {
        FavoritesManager favoritesManager = FavoritesManager.getInstance((Project)item.getProject());
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(favoritesManager, item){
            final /* synthetic */ FavoritesManager $favoritesManager;
            final /* synthetic */ PsiFileSystemItem $item;

            public final Boolean compute() {
                return this.$favoritesManager.getFavoriteListName(null, this.$item.getVirtualFile()) != null;
            }
            {
                this.$favoritesManager = favoritesManager;
                this.$item = psiFileSystemItem;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.compute<Boole\u2026em.virtualFile) != null }");
        return (Boolean)object;
    }

    private final boolean isOpened(PsiFileSystemItem item) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(item.project)");
        Object[] openedFiles = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)openedFiles, (String)"openedFiles");
        return ArraysKt.contains((Object[])openedFiles, (Object)item.getVirtualFile());
    }

    private final int getRecentFilesIndex(PsiFileSystemItem item) {
        EditorHistoryManager historyManager;
        EditorHistoryManager editorHistoryManager = historyManager = EditorHistoryManager.getInstance((Project)item.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)editorHistoryManager, (String)"historyManager");
        List list = editorHistoryManager.getFileList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"historyManager.fileList");
        List recentFilesList = list;
        int fileIndex = recentFilesList.indexOf(item.getVirtualFile());
        if (fileIndex == -1) {
            return fileIndex;
        }
        return recentFilesList.size() - fileIndex;
    }

    private final Map<String, Object> getModificationTimeStats(PsiFileSystemItem item, long currentTime) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        long timeSinceLastMod = currentTime - virtualFile.getTimeStamp();
        return MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)TIME_SINCE_LAST_MODIFICATION_DATA_KEY, (Object)timeSinceLastMod), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY, (Object)(timeSinceLastMod <= (long)60000 ? 1 : 0)), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY, (Object)(timeSinceLastMod <= (long)3600000 ? 1 : 0)), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_DAY_DATA_KEY, (Object)(timeSinceLastMod <= (long)86400000 ? 1 : 0)), TuplesKt.to((Object)WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY, (Object)(timeSinceLastMod <= 2419200000L ? 1 : 0))});
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getFileTypeStats(PsiFileSystemItem item, long currentTime, Map<String, FileTypeUsageSummary> fileTypeStats) {
        Iterable iterable = fileTypeStats.values();
        boolean bl = false;
        int n = 0;
        for (Object t : iterable) {
            void it;
            FileTypeUsageSummary fileTypeUsageSummary = (FileTypeUsageSummary)t;
            int n2 = n;
            boolean bl2 = false;
            int n3 = it.usageCount;
            n = n2 + n3;
        }
        int totalUsage = n;
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        FileType fileType = virtualFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"item.virtualFile.fileType");
        FileTypeUsageSummary stats = fileTypeStats.get(fileType.getName());
        if (stats == null) {
            return MapsKt.emptyMap();
        }
        long timeSinceLastUsage = currentTime - stats.lastUsed;
        double usageRatio = this.roundDouble$intellij_searchEverywhereMl((double)stats.usageCount / (double)totalUsage);
        Map<String, FileTypeUsageSummary> bl2 = fileTypeStats;
        boolean bl3 = false;
        Iterable iterable2 = bl2.entrySet();
        boolean bl4 = false;
        Iterator iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        Map.Entry it = (Map.Entry)iterator.next();
        boolean bl5 = false;
        int n4 = ((FileTypeUsageSummary)it.getValue()).usageCount;
        while (iterator.hasNext()) {
            Map.Entry it22 = (Map.Entry)iterator.next();
            $i$a$-minOf-SearchEverywhereFileFeaturesProvider$getFileTypeStats$min$1 = false;
            int it22 = ((FileTypeUsageSummary)it22.getValue()).usageCount;
            if (n4 <= it22) continue;
            n4 = it22;
        }
        int min = n4;
        Map<String, FileTypeUsageSummary> map = fileTypeStats;
        boolean bl6 = false;
        Iterable iterable3 = map.entrySet();
        boolean bl7 = false;
        Iterator iterator2 = iterable3.iterator();
        if (!iterator2.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        Map.Entry it2 = (Map.Entry)iterator2.next();
        boolean bl8 = false;
        int n5 = ((FileTypeUsageSummary)it2.getValue()).usageCount;
        while (iterator2.hasNext()) {
            Map.Entry it3 = (Map.Entry)iterator2.next();
            $i$a$-maxOf-SearchEverywhereFileFeaturesProvider$getFileTypeStats$max$1 = false;
            int n6 = ((FileTypeUsageSummary)it3.getValue()).usageCount;
            if (n5 >= n6) continue;
            n5 = n6;
        }
        int max = n5;
        return MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)FILETYPE_USAGE_RATIO_DATA_KEY, (Object)usageRatio), TuplesKt.to((Object)FILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY, (Object)this.roundDouble$intellij_searchEverywhereMl((double)stats.usageCount / (double)max)), TuplesKt.to((Object)FILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY, (Object)this.roundDouble$intellij_searchEverywhereMl((double)stats.usageCount / (double)min)), TuplesKt.to((Object)TIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY, (Object)timeSinceLastUsage), TuplesKt.to((Object)FILETYPE_USED_IN_LAST_MINUTE_DATA_KEY, (Object)(timeSinceLastUsage <= (long)60000 ? 1 : 0)), TuplesKt.to((Object)FILETYPE_USED_IN_LAST_HOUR_DATA_KEY, (Object)(timeSinceLastUsage <= (long)3600000 ? 1 : 0)), TuplesKt.to((Object)FILETYPE_USED_IN_LAST_DAY_DATA_KEY, (Object)(timeSinceLastUsage <= (long)86400000 ? 1 : 0)), TuplesKt.to((Object)FILETYPE_USED_IN_LAST_MONTH_DATA_KEY, (Object)(timeSinceLastUsage <= 2419200000L ? 1 : 0))});
    }

    private final double getPredictionScore(PsiFileSystemItem item) {
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"item.project");
        FileHistoryManagerWrapper historyManagerWrapper = FileHistoryManagerWrapper.Companion.getInstance(project);
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        double probability = historyManagerWrapper.calcNextFileProbability(virtualFile);
        return this.roundDouble$intellij_searchEverywhereMl(probability);
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean isSameModuleAsOpenedFile(PsiFileSystemItem item, VirtualFile openedFile) {
        void openedFileModule;
        if (openedFile == null) {
            return null;
        }
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"item.project");
        Project project2 = project;
        Pair pair = (Pair)ReadAction.compute((ThrowableComputable)new ThrowableComputable(project2, openedFile, item){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $openedFile;
            final /* synthetic */ PsiFileSystemItem $item;

            public final Pair<Module, Module> compute() {
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex fileIndex = projectFileIndex;
                return new Pair((Object)fileIndex.getModuleForFile(this.$openedFile), (Object)fileIndex.getModuleForFile(this.$item.getVirtualFile()));
            }
            {
                this.$project = project;
                this.$openedFile = virtualFile;
                this.$item = psiFileSystemItem;
            }
        });
        Module module = (Module)pair.component1();
        Module itemModule = (Module)pair.component2();
        if (openedFileModule == null || itemModule == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)openedFileModule, (Object)itemModule);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Double> calculatePackageDistance(PsiFileSystemItem item, VirtualFile openedFile) {
        void openedFilePackage;
        if (openedFile == null) {
            return null;
        }
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"item.project");
        Project project2 = project;
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(this, project2, openedFile, item){
            final /* synthetic */ SearchEverywhereFileFeaturesProvider this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $openedFile;
            final /* synthetic */ PsiFileSystemItem $item;

            public final Pair<String, String> compute() {
                String string;
                String string2;
                boolean bl;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex fileIndex = projectFileIndex;
                VirtualFile virtualFile = SearchEverywhereFileFeaturesProvider.getVirtualFileDirectory$default(this.this$0, this.$openedFile, 0, 2, null);
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl2 = false;
                    bl = false;
                    VirtualFile it = virtualFile2;
                    boolean bl3 = false;
                    string2 = fileIndex.getPackageNameByDirectory(it);
                } else {
                    string2 = null;
                }
                String openedFilePackageName = string2;
                VirtualFile virtualFile3 = this.$item.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"item.virtualFile");
                VirtualFile virtualFile4 = SearchEverywhereFileFeaturesProvider.getVirtualFileDirectory$default(this.this$0, virtualFile3, 0, 2, null);
                if (virtualFile4 != null) {
                    VirtualFile virtualFile5 = virtualFile4;
                    bl = false;
                    boolean bl4 = false;
                    VirtualFile it = virtualFile5;
                    boolean bl5 = false;
                    string = fileIndex.getPackageNameByDirectory(it);
                } else {
                    string = null;
                }
                String foundFilePackageName = string;
                return new Pair((Object)openedFilePackageName, foundFilePackageName);
            }
            {
                this.this$0 = searchEverywhereFileFeaturesProvider;
                this.$project = project;
                this.$openedFile = virtualFile;
                this.$item = psiFileSystemItem;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        Pair $this$run = (Pair)object;
        boolean bl3 = false;
        calculatePackageDistance.2.1 $fun$splitPackage$1 = calculatePackageDistance.2.1.INSTANCE;
        Pair pair = new Pair($fun$splitPackage$1.invoke((String)$this$run.getFirst()), $fun$splitPackage$1.invoke((String)$this$run.getSecond()));
        List list = (List)pair.component1();
        List foundFilePackage = (List)pair.component2();
        if (openedFilePackage == null || foundFilePackage == null) {
            return null;
        }
        int maxDistance = openedFilePackage.size() + foundFilePackage.size();
        int common = 0;
        bl = false;
        for (String value : (Iterable)openedFilePackage) {
            void index;
            if (foundFilePackage.size() == index || Intrinsics.areEqual((Object)((String)foundFilePackage.get((int)index)), (Object)value) ^ true) break;
            ++common;
            ++index;
        }
        int distance = maxDistance - 2 * common;
        double normalizedDistance = this.roundDouble$intellij_searchEverywhereMl(maxDistance != 0 ? (double)distance / (double)maxDistance : 0.0);
        return new Pair((Object)distance, (Object)normalizedDistance);
    }

    private final VirtualFile getVirtualFileDirectory(VirtualFile file, int maxChecksUp) {
        if (file.isDirectory()) {
            return file;
        }
        if (maxChecksUp > 1) {
            VirtualFile virtualFile = file.getParent();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile parent = virtualFile;
            return this.getVirtualFileDirectory(parent, maxChecksUp - 1);
        }
        return null;
    }

    static /* synthetic */ VirtualFile getVirtualFileDirectory$default(SearchEverywhereFileFeaturesProvider searchEverywhereFileFeaturesProvider, VirtualFile virtualFile, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return searchEverywhereFileFeaturesProvider.getVirtualFileDirectory(virtualFile, n);
    }

    private final <K, V> void putIfValueNotNull(Map<K, V> $this$putIfValueNotNull, K key, V value) {
        block0: {
            V v = value;
            if (v == null) break block0;
            V v2 = v;
            boolean bl = false;
            boolean bl2 = false;
            V it = v2;
            boolean bl3 = false;
            $this$putIfValueNotNull.put(key, it);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider$Cache;", "", "fileTypeStats", "", "", "Lcom/intellij/internal/statistic/local/FileTypeUsageSummary;", "openedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/Map;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFileTypeStats", "()Ljava/util/Map;", "getOpenedFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.searchEverywhereMl"})
    private static final class Cache {
        @NotNull
        private final Map<String, FileTypeUsageSummary> fileTypeStats;
        @Nullable
        private final VirtualFile openedFile;

        @NotNull
        public final Map<String, FileTypeUsageSummary> getFileTypeStats() {
            return this.fileTypeStats;
        }

        @Nullable
        public final VirtualFile getOpenedFile() {
            return this.openedFile;
        }

        public Cache(@NotNull Map<String, FileTypeUsageSummary> fileTypeStats, @Nullable VirtualFile openedFile) {
            Intrinsics.checkNotNullParameter(fileTypeStats, (String)"fileTypeStats");
            this.fileTypeStats = fileTypeStats;
            this.openedFile = openedFile;
        }

        @NotNull
        public final Map<String, FileTypeUsageSummary> component1() {
            return this.fileTypeStats;
        }

        @Nullable
        public final VirtualFile component2() {
            return this.openedFile;
        }

        @NotNull
        public final Cache copy(@NotNull Map<String, FileTypeUsageSummary> fileTypeStats, @Nullable VirtualFile openedFile) {
            Intrinsics.checkNotNullParameter(fileTypeStats, (String)"fileTypeStats");
            return new Cache(fileTypeStats, openedFile);
        }

        public static /* synthetic */ Cache copy$default(Cache cache, Map map, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                map = cache.fileTypeStats;
            }
            if ((n & 2) != 0) {
                virtualFile = cache.openedFile;
            }
            return cache.copy(map, virtualFile);
        }

        @NotNull
        public String toString() {
            return "Cache(fileTypeStats=" + this.fileTypeStats + ", openedFile=" + this.openedFile + ")";
        }

        public int hashCode() {
            Map<String, FileTypeUsageSummary> map = this.fileTypeStats;
            VirtualFile virtualFile = this.openedFile;
            return (map != null ? ((Object)map).hashCode() : 0) * 31 + (virtualFile != null ? virtualFile.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Cache)) break block3;
                    Cache cache = (Cache)object;
                    if (!Intrinsics.areEqual(this.fileTypeStats, cache.fileTypeStats) || !Intrinsics.areEqual((Object)this.openedFile, (Object)cache.openedFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/features/SearchEverywhereFileFeaturesProvider$Companion;", "", "()V", "FILETYPE_DATA_KEY", "", "FILETYPE_USAGE_RATIO_DATA_KEY", "FILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY", "FILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY", "FILETYPE_USED_IN_LAST_DAY_DATA_KEY", "FILETYPE_USED_IN_LAST_HOUR_DATA_KEY", "FILETYPE_USED_IN_LAST_MINUTE_DATA_KEY", "FILETYPE_USED_IN_LAST_MONTH_DATA_KEY", "IS_DIRECTORY_DATA_KEY", "IS_FAVORITE_DATA_KEY", "IS_OPENED_DATA_KEY", "IS_SAME_MODULE_DATA_KEY", "PACKAGE_DISTANCE_DATA_KEY", "PACKAGE_DISTANCE_NORMALIZED_DATA_KEY", "PREDICTION_SCORE_DATA_KEY", "PRIORITY_DATA_KEY", "RECENT_INDEX_DATA_KEY", "TIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY", "TIME_SINCE_LAST_MODIFICATION_DATA_KEY", "WAS_MODIFIED_IN_LAST_DAY_DATA_KEY", "WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY", "WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY", "WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

