/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/MarkdownNotifier;", "", "()V", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "notifyAboutConversionWarning", "", "project", "Lcom/intellij/openapi/project/Project;", "msg", "", "notifyIfConvertFailed", "notifyNetworkProblems", "notifyOfSuccessfulExport", "notifyPandocDetected", "notifyPandocDetectionFailed", "notifyPandocNotDetected", "intellij.markdown"})
public final class MarkdownNotifier {
    @NotNull
    public static final MarkdownNotifier INSTANCE;

    @NotNull
    public final NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Markdown");
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (notificationGroup == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return notificationGroup;
    }

    public final void notifyNetworkProblems(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NotificationGroup notificationGroup = this.getNotificationGroup();
        String string = MarkdownBundle.message("markdown.google.import.network.problems.msg", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026rt.network.problems.msg\")");
        notificationGroup.createNotification(string, NotificationType.ERROR).notify(project);
    }

    public final void notifyPandocDetected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NotificationGroup notificationGroup = this.getNotificationGroup();
        String string = MarkdownBundle.message("markdown.settings.pandoc.notification.detected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026c.notification.detected\")");
        notificationGroup.createNotification(string, NotificationType.INFORMATION).notify(project);
    }

    public final void notifyPandocNotDetected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NotificationGroup notificationGroup = this.getNotificationGroup();
        String string = MarkdownBundle.message("markdown.settings.pandoc.notification.not.detected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026tification.not.detected\")");
        notificationGroup.createNotification(string, NotificationType.WARNING).notify(project);
    }

    public final void notifyPandocDetectionFailed(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.getNotificationGroup().createNotification(msg, NotificationType.ERROR).notify(project);
    }

    public final void notifyIfConvertFailed(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.getNotificationGroup().createNotification(msg, NotificationType.ERROR).notify(project);
    }

    public final void notifyOfSuccessfulExport(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.getNotificationGroup().createNotification(msg, NotificationType.INFORMATION).notify(project);
    }

    public final void notifyAboutConversionWarning(@NotNull Project project, @NlsSafe @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.getNotificationGroup().createNotification(msg, NotificationType.WARNING).notify(project);
    }

    private MarkdownNotifier() {
    }

    static {
        MarkdownNotifier markdownNotifier;
        INSTANCE = markdownNotifier = new MarkdownNotifier();
    }
}

