/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.mermaid;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithExternalFiles;
import org.intellij.plugins.markdown.extensions.jcef.mermaid.MermaidCodeGeneratingProviderExtension;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidBrowserExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "directory", "Ljava/io/File;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Ljava/io/File;)V", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "", "getScripts", "()Ljava/util/List;", "styles", "getStyles", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "storeFileEvent", "data", "Companion", "Provider", "intellij.markdown"})
public final class MermaidBrowserExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final ResourceProvider resourceProvider;
    private final File directory;
    private static final String MAIN_SCRIPT_FILENAME = "mermaid/mermaid.js";
    private static final String THEME_DEFINITION_FILENAME = "mermaid/themeDefinition.js";
    private static final String DOWNLOAD_URL = "https://unpkg.com/mermaid@8.13.3/dist/mermaid.js";
    private static final String CHECKSUM = "5a958b28bdd744b981422470fd160107";
    private static final String storeFileEventName = "storeMermaidFile";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void storeFileEvent(String data) {
        block4: {
            CharSequence charSequence = data;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return;
            }
            String string = data;
            int n = 0;
            int n2 = StringsKt.indexOf$default((CharSequence)data, (char)';', (int)0, (boolean)false, (int)6, null);
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String key = string3;
            String string4 = data;
            n2 = StringsKt.indexOf$default((CharSequence)data, (char)';', (int)0, (boolean)false, (int)6, null) + 1;
            bl2 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String content2 = string6;
            MermaidCodeGeneratingProviderExtension mermaidCodeGeneratingProviderExtension = MermaidBrowserExtension.Companion.getGeneratingProvider();
            if (mermaidCodeGeneratingProviderExtension == null) break block4;
            string4 = content2;
            Charset charset = Charsets.UTF_8;
            bl2 = false;
            String string7 = string4;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string7.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            mermaidCodeGeneratingProviderExtension.store(key, byArray);
        }
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getScripts().contains(resourceName) || this.getStyles().contains(resourceName);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            var2_2 = resourceName;
            switch (var2_2.hashCode()) {
                case 1100547521: {
                    if (!var2_2.equals("mermaid/themeDefinition.js")) ** break;
                    break;
                }
                case -256281068: {
                    if (!var2_2.equals("mermaid/mermaid.js")) ** break;
                    v0 = ResourceProvider.Companion.loadExternalResource$default(ResourceProvider.Companion, new File(this.directory, resourceName), null, 2, null);
                    break block5;
                }
            }
            var3_3 = "window.mermaidTheme = '" + MermaidCodeGeneratingProviderExtension.Companion.determineTheme() + "';";
            var4_4 = Charsets.UTF_8;
            var5_5 = false;
            v1 = var3_3;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v2 = v1.getBytes(var4_4);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).getBytes(charset)");
            v0 = new ResourceProvider.Resource(v2, null, 2, null);
            break block5;
            v0 = ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, this.getClass(), resourceName, null, 4, null);
        }
        return v0;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void dispose() {
    }

    public MermaidBrowserExtension(final @NotNull MarkdownHtmlPanel panel2, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
        BrowserPipe browserPipe = panel2.getBrowserPipe();
        if (browserPipe != null) {
            Function1 function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((MermaidBrowserExtension)this.receiver).storeFileEvent(p1);
                }
            };
            browserPipe.subscribe(storeFileEventName, new BrowserPipe.Handler(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void messageReceived(String data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)data), (String)"invoke(...)");
                }

                public Function getFunctionDelegate() {
                    return this.function;
                }

                public boolean equals(Object object) {
                    return object instanceof BrowserPipe.Handler && object instanceof FunctionAdapter && Intrinsics.areEqual((Object)this.function, (Object)((FunctionAdapter)object).getFunctionDelegate());
                }

                public int hashCode() {
                    return this.function.hashCode();
                }
            });
        }
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                block0: {
                    BrowserPipe browserPipe = panel2.getBrowserPipe();
                    if (browserPipe == null) break block0;
                    Function1 function1 = (Function1)new Function1<String, Unit>(this){

                        public final void invoke(@NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            ((MermaidBrowserExtension)this.receiver).storeFileEvent(p1);
                        }
                    };
                    browserPipe.removeSubscription(MermaidBrowserExtension.storeFileEventName, new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
        this.scripts = CollectionsKt.listOf((Object[])new String[]{MAIN_SCRIPT_FILENAME, THEME_DEFINITION_FILENAME, "mermaid/bootstrap.js"});
        this.styles = CollectionsKt.listOf((Object)"mermaid/mermaid.css");
        this.resourceProvider = this;
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownBrowserPreviewExtension.DefaultImpls.getPriority(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MarkdownBrowserPreviewExtension.DefaultImpls.compareTo(this, other);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidBrowserExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithExternalFiles;", "()V", "actualFile", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getActualFile", "()Ljava/io/File;", "description", "", "getDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "downloadFilename", "getDownloadFilename", "downloadLink", "getDownloadLink", "id", "getId", "isAvailable", "", "()Z", "afterDownload", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "isDistributionChecksumValid", "intellij.markdown"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider,
    MarkdownExtensionWithExternalFiles {
        @NotNull
        private final String id;
        @NotNull
        private final String downloadLink;
        @NotNull
        private final String downloadFilename;

        @Override
        @NotNull
        public String getDisplayName() {
            String string = MarkdownBundle.message("markdown.extensions.mermaid.display.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ns.mermaid.display.name\")");
            return string;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = MarkdownBundle.message("markdown.extensions.mermaid.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ons.mermaid.description\")");
            return string;
        }

        @Override
        @NotNull
        public String getDownloadLink() {
            return this.downloadLink;
        }

        @Override
        @NotNull
        public String getDownloadFilename() {
            return this.downloadFilename;
        }

        @Override
        public boolean isAvailable() {
            return this.getActualFile().exists() && this.isDistributionChecksumValid();
        }

        private final File getActualFile() {
            return Paths.get(this.getDirectory().toString(), "mermaid", this.getDownloadFilename()).toFile();
        }

        private final boolean isDistributionChecksumValid() {
            MessageDigest messageDigest = DigestUtil.md5();
            File file = this.getActualFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"actualFile");
            String string = StringUtil.toHexString((byte[])messageDigest.digest(FilesKt.readBytes((File)file)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toHexString(D\u2026(actualFile.readBytes()))");
            String got = string;
            return Intrinsics.areEqual((Object)got, (Object)MermaidBrowserExtension.CHECKSUM);
        }

        @Override
        public boolean afterDownload() {
            File sourceFile = new File(this.getDirectory(), this.getDownloadFilename());
            File file = this.getActualFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"actualFile");
            FilesKt.copyTo$default((File)sourceFile, (File)file, (boolean)true, (int)0, (int)4, null);
            return sourceFile.delete();
        }

        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return this.isEnabled() ? (MarkdownBrowserPreviewExtension)new MermaidBrowserExtension(panel2, this.getDirectory()) : null;
        }

        public Provider() {
            this.id = "MermaidLanguageExtension";
            this.downloadLink = MermaidBrowserExtension.DOWNLOAD_URL;
            this.downloadFilename = "mermaid.js";
        }

        @Override
        public boolean isEnabled() {
            return MarkdownExtensionWithExternalFiles.DefaultImpls.isEnabled(this);
        }

        @Override
        @NotNull
        public String getDirectoryName() {
            return MarkdownExtensionWithExternalFiles.DefaultImpls.getDirectoryName(this);
        }

        @Override
        @NotNull
        public File getDirectory() {
            return MarkdownExtensionWithExternalFiles.DefaultImpls.getDirectory(this);
        }

        @Override
        @NotNull
        public File getFullPath() {
            return MarkdownExtensionWithExternalFiles.DefaultImpls.getFullPath(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidBrowserExtension$Companion;", "", "()V", "CHECKSUM", "", "DOWNLOAD_URL", "MAIN_SCRIPT_FILENAME", "THEME_DEFINITION_FILENAME", "generatingProvider", "Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeGeneratingProviderExtension;", "getGeneratingProvider", "()Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeGeneratingProviderExtension;", "storeFileEventName", "intellij.markdown"})
    public static final class Companion {
        private final MermaidCodeGeneratingProviderExtension getGeneratingProvider() {
            Object v1;
            Object v0;
            block2: {
                Iterable iterable = MarkdownExtension.Companion.getAll();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    MarkdownExtension it = (MarkdownExtension)t;
                    boolean bl3 = false;
                    if (!(it instanceof MermaidCodeGeneratingProviderExtension)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof MermaidCodeGeneratingProviderExtension)) {
                v1 = null;
            }
            return v1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

